#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Draugen
# send your bug reports to contact@dotslashplay.it
###

script_version=20230402.2

GAME_ID='draugen'
GAME_NAME='Draugen'

ARCHIVE_BASE_0='setup_draugen_1.1.0.10_(64bit)_(30252).exe'
ARCHIVE_BASE_0_MD5='5ac0dd08f8d794d61158ef9ffeeebef3'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_draugen_1.1.0.10_(64bit)_(30252)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='aa703a920b67b4201aed1711dd7a14ad'
ARCHIVE_BASE_0_PART2='setup_draugen_1.1.0.10_(64bit)_(30252)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='21e3d5b7c2fd029256762ff8ddf424a9'
ARCHIVE_BASE_0_SIZE='12000000'
ARCHIVE_BASE_0_VERSION='1.1.0.10-gog30252'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/draugen'

UNREALENGINE4_NAME='draugen'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
${UNREALENGINE4_NAME}.exe"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}"

HUGE_FILES_DATA="
${UNREALENGINE4_NAME}/content/paks/${UNREALENGINE4_NAME}-windowsnoeditor.pak"

WINE_DIRECT3D_RENDERER='dxvk'

APP_WINE_LINK_DIRS="
userdata:users/\${USER}/AppData/Local/${UNREALENGINE4_NAME}/Saved"
USER_PERSISTENT_DIRECTORIES='
userdata/Config/WindowsNoEditor
userdata/SaveGames'

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_ARCH='gst-plugins-base gst-plugins-good gst-libav'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-base, gstreamer1.0-plugins-good, gstreamer1.0-libav'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-base media-plugins/gst-plugins-good media-libs/gst-plugins-libav'

# The game will crash before loading the menu if PhysX is unavailable

APP_WINETRICKS="$APP_WINETRICKS physx"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
