#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hitman 1
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220704.1

GAME_ID='hitman'
GAME_NAME='Hitman: Codename 47'

ARCHIVE_BASE_0='setup_hitman_codename_47_b192_(17919).exe'
ARCHIVE_BASE_0_MD5='018d8191bfa45c16995537e3a93f96bd'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='340000'
ARCHIVE_BASE_0_VERSION='1.0b192-gog17919'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/hitman'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_DOC_DATA_FILES='
*.pdf
*.txt'
ARCHIVE_GAME_BIN_FILES='
*.dlc
*.dll
*.exe
*.ini'
ARCHIVE_GAME_DATA_FILES='
repeat.*
intro.zip
optionsscreen.zip
alllevels
c0_*
c1_*
c2_*
c3_*
c4_*
c5_*
cutscenes
music
setup
sounds'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='hitman.exe'
APP_MAIN_ICON='hitman.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

DATA_FILES='*.cfg *.ini *.sav'

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed $sed_options)"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
