#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# CrossCode
# send your bug reports to contact@dotslashplay.it
###

script_version=20230711.1

# Set game-specific variables

GAME_ID='crosscode'
GAME_NAME='CrossCode'

ARCHIVE_BASE_32BIT_0='crosscode-new-linux32.zip'
ARCHIVE_BASE_32BIT_0_MD5='630cfd22cd5e9e168f833dfa3fce9931'
ARCHIVE_BASE_32BIT_0_SIZE='1100000'
ARCHIVE_BASE_32BIT_0_VERSION='1.4.2-itch.2022.04.19'
ARCHIVE_BASE_32BIT_0_URL='https://radicalfishgames.itch.io/crosscode'

ARCHIVE_BASE_64BIT_0='crosscode-new-linux64.zip'
ARCHIVE_BASE_64BIT_0_MD5='2fece5dc78bf6bfdde7e6b3239da73b6'
ARCHIVE_BASE_64BIT_0_SIZE='1100000'
ARCHIVE_BASE_64BIT_0_VERSION='1.4.2-itch.2022.04.19'
ARCHIVE_BASE_64BIT_0_URL='https://radicalfishgames.itch.io/crosscode'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN_FILES='
libffmpeg.so
libnode.so
libnw.so'
CONTENT_LIBS0_BIN_PATH="${CONTENT_PATH_DEFAULT}/swiftshader"
CONTENT_GAME_BIN_FILES='
libEGL.so
libGLESv2.so'
CONTENT_GAME_BIN_FILES='
CrossCode'
CONTENT_GAME_DATA_FILES='
assets
locales
natives_blob.bin
v8_context_snapshot.bin
icudtl.dat
credits.html
package.json
favicon.png
nw_100_percent.pak
nw_200_percent.pak
resources.pak
steam_appid.txt'

APP_MAIN_EXE='CrossCode'
APP_MAIN_ICON='favicon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libasound.so.2
libatk-1.0.so.0
libatspi.so.0
libcairo.so.2
libc.so.6
libcups.so.2
libdbus-1.so.3
libdl.so.2
libexpat.so.1
libgcc_s.so.1
libgdk-3.so.0
libgdk_pixbuf-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-3.so.0
libm.so.6
libnspr4.so
libnss3.so
libnssutil3.so
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpthread.so.0
librt.so.1
libsmime3.so
libuuid.so.1
libX11.so.6
libX11-xcb.so.1
libxcb.so.1
libXcomposite.so.1
libXcursor.so.1
libXdamage.so.1
libXext.so.6
libXfixes.so.3
libXi.so.6
libXrandr.so.2
libXrender.so.1
libXss.so.1
libXtst.so.6'

# Load common functions

target_version='2.24'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
