#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Q.U.B.E.
# send your bug reports to contact@dotslashplay.it
###

script_version=20240607.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='qube-1'
GAME_NAME='Q.U.B.E.'

ARCHIVE_BASE_0_NAME='QUBE-Linux-2015052901.sh'
ARCHIVE_BASE_0_MD5='5da6f592bad4aa71c6e2a469f7435453'
ARCHIVE_BASE_0_VERSION='2.8-humble2015052901'
ARCHIVE_BASE_0_SIZE='1269181'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/qube-directors-cut'

CONTENT_PATH_DEFAULT='data/noarch'
CONTENT_GAME_BIN_FILES='
Engine'
CONTENT_GAME0_BIN_PATH='data/x86'
CONTENT_GAME0_BIN_FILES='
Binaries/Linux/QUBEGame-Linux
Binaries/Linux/lib/libPhysXCooking.so
Binaries/Linux/lib/libPhysXCore.so
Binaries/Linux/lib/libPhysXExtensions.so.1
Binaries/Linux/lib/libPhysXLoader.so.1
Binaries/Linux/lib/libtcmalloc.so.0'
## The game ships a patched SDL2_Mixer that has an additional symbol: MinorityMix_SetPosition,
## the SDL2_Mixer source code has no reference to it (only Mix_SetPosition)
## and online searching only shows similar problems with other Unreal Engine games.
## TODO: It might be possible to fix this using preloading or using an SDL2_Mixer wrapper instead.
##       Analysis of the binary's MinorityMix_SetPosition function is welcome.
CONTENT_GAME1_BIN_PATH='data/x86'
ARCHIVE_GAME1_BIN_FILES='
Binaries/Linux/lib/libSDL2_mixer-2.0.so.0'
## The game binary is linked against libsteam_api.so, so this library can not be dropped.
CONTENT_GAME2_BIN_PATH='data/x86'
CONTENT_GAME2_BIN_FILES='
Binaries/Linux/lib/libsteam_api.so'
CONTENT_GAME_DATA_FILES='
QUBEGame
QUBEIcon.*'
CONTENT_DOC_DATA_FILES='
README.linux
BuildVersion.txt
UpdateLog.txt'

USER_PERSISTENT_FILES='
Binaries/Linux/SaveGame.bin'

APP_MAIN_EXE='Binaries/Linux/QUBEGame-Linux'
APP_MAIN_ICON='QUBEIcon.png'
## Run the game binary from its directory.
APP_MAIN_PRERUN='
# Run the game binary from its directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
