#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes 3: The Awakened
# send your bug reports to contact@dotslashplay.it
###

script_version=20240515.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='sherlock-holmes-3-the-awakened'
GAME_NAME='Sherlock Holmes: The Awakened'

ARCHIVE_BASE_0_NAME='setup_sherlock_holmes_the_awakened_remastered_2.0.0.3.exe'
ARCHIVE_BASE_0_MD5='81f3428e81c91f110d8c7cab609daa4f'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--lowercase --gog'
ARCHIVE_BASE_0_PART1_NAME='setup_sherlock_holmes_the_awakened_remastered_2.0.0.3-1.bin'
ARCHIVE_BASE_0_PART1_MD5='3b87ccb9783fe181e2433f2ea8a31b08'
ARCHIVE_BASE_0_PART1_TYPE='rar'
ARCHIVE_BASE_0_SIZE='3200000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.3'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sherlock_holmes_the_awakened_remastered'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
game.exe
*.dll'
CONTENT_GAME0_BIN_PATH='support/app'
CONTENT_GAME0_BIN_FILES='
game.ini
user.ini'
CONTENT_GAME_DATA_FILES='
000
logo
data.txt
shaders.0050
splash_screen.dds'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Games/sherlock holmes - the awakened - remastered
users/${USER}/AppData/Roaming/Games/sherlock holmes - la nuit des sacrifiés - remasterisée'
## Ensure availability of required library PhysXLoader.dll.
WINE_WINETRICKS_VERBS='physx'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101 --language=1024'
## Set game lang based on current locale.
APP_MAIN_PRERUN="${APP_MAIN_PRERUN:-}"'
# Set game lang based on current locale

game_config="${USER_PERSISTENT_PATH}/game.ini"
case "${LANG%_*}" in
	("de"|"en"|"fr"|"it"|"pl"|"ru")
		sed --in-place "s/\(lang\s*\)= .*/\\1= \"${LANG%_*}\"/" "$game_config"
	;;
	(*)
		sed --in-place "s/\(lang\s*\)= .*/\\1= \"en\"/" "$game_config"
	;;
esac'
USER_PERSISTENT_FILES="${USER_PERSISTENT_FILES:-}"'
game.ini'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
