      SUBROUTINE AO2MO2(ZAO,ZMO,EVEC,SCR,NBAS,NBAST,ISPIN)
C
C TRANSFORMS A TWO-INDEX QUANTITY (I.E. FOCK MATRIX) FROM THE AO
C  TO THE MO BASIS
C
C INPUT:
C       ZAO  - TWO-INDEX QUANTITY IN AO BASIS (LENGTH: NBAST*NBAST)
C       NBAST- NUMBER OF BASIS FUNCTIONS 
C       NBAS - NUMBER OF BASIS FUNCTIONS AFTER TRANSFORMATION
C       ISPIN- 1 FOR ALPHA, 2 FOR BETA
C
C OUTPUT:
C       ZMO  - TWO-INDEX QUANTITY IN MO BASIS (LENGTH: NBAS*NBAS)
C       
C SCRATCH:
C       EVEC - HOLDS EIGENVECTOR MATRIX (LENGTH: NBAS*NBAST)
C       SCR  - HOLDS INTERMEDIATE QUANTITIES (LENGTH: 2*NBAST*NBAST) 
C
CEND
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER*8 LABEL
      DIMENSION EVEC(NBAS*NBAST),ZMO(NBAS*NBAS),ZAO(NBAST*NBAST)
      DIMENSION SCR(2*NBAST*NBAST)
      COMMON /MACHSP/ IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      IF(ISPIN.EQ.1)LABEL='SCFEVCA0'
      IF(ISPIN.EQ.2)LABEL='SCFEVCB0'
      CALL GETREC(20,'JOBARC',LABEL,IINTFP*NBAS*NBAST,EVEC)
      CALL MXM(ZAO,NBAST,EVEC,NBAST,SCR,NBAS)
      CALL TRANSP(EVEC,SCR(NBAST*NBAST+1),NBAS,NBAST)
      CALL MXM(SCR(NBAST*NBAST+1),NBAS,SCR,NBAST,ZMO,NBAS)
      RETURN
      END
