       SUBROUTINE SST003(WIN,WOUT,NSIZIN,NSIZOT,ISCR,SPTYPE,RERDTP)
C
C THIS ROUTINE ACCEPTS A SYMMETRY PACKED FOUR-INDEX LIST AND RETURNS
C   THE SAME LIST BUT WITH AN ALTERNATIVE SCHEME FOR SYMMETRY PACKING.
C
C THE LIST (A<B;I<J) IS PRESUMED TO BE PACKED AB-IJ.  THIS ROUTINE RETURNS
C   THE LIST AS (A,I;B,J) PACKED AS AI-BJ OR AJ-BI (THESE POSSIBILITIES
C   DIFFER BY A SIGN).
C
C *** IMPORTANT *** : THE SPACE ALLOCATED FOR BOTH WIN AND WOUT IN THE
C                     CALLING ROUTINE MUST BE EQUAL TO THE SIZE OF
C                     *WOUT*
C
C INPUT: 
C           WIN  - THE SYMMETRY PACKED AB-IJ LIST.
C         NSIZIN - THE TOTAL SIZE OF THE SYM. PACKED INPUT VECTOR.
C         NSIZOT - THE TOTAL SIZE OF THE SYM. PACKED OUTPUT VECTOR.
C         SPTYPE - THE SPIN TYPE FOR THE INPUT LIST
C
C                        'AAAA' FOR (AB-IJ)
C                        'BBBB' FOR (ab-ij)
C         RERDTP - 'AIBJ' FOR AI-BJ POSITIVE, 'AJBI' FOR AJ-BI POSITIVE.
C OUTPUT: 
C          WOUT  - THE SYMMETRY PACKED AI-bj OR bj-AI LIST.
C       
C SCRATCH:
C         ISCR   - SCRATCH AREA TO HOLD THE SYMMETRY VECTORS AND INVERSE
C                   SYMMETRY VECTORS WHICH ARE NEEDED. 
C                   (SIZE: NVRT*(NVRT-1)/2+NOCC*(NOCC-1)/2+NOCC*NVRT)
C         
CEND
      IMPLICIT INTEGER (A-Z)
      CHARACTER*4 REORTP,SPTYPE,RERDTP
      DOUBLE PRECISION WIN(NSIZIN),WOUT(NSIZOT),ISCR(*)
      COMMON/MACHSP/IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      COMMON/SYMINF/NSTART,NIRREP,IRREP0(255,2),DIRPRD(8,8)
      COMMON/SYMPOP/IRPDPD(8,22),ISYTYP(2,500),ID(18)
      COMMON/SYM/POP(8,2),VRT(8,2),NT(2),NFMI(2),NFEA(2)
C
      IRREPX=1
C
      IF(SPTYPE.EQ.'AAAA')THEN
       ISPIN=1
      ELSEIF(SPTYPE.EQ.'BBBB')THEN
       ISPIN=2
      ELSE
       WRITE(6,1000)SPTYPE
1000   FORMAT(T3,'@SST003-F, Unknown spin type ',A4,' passed in.')
       CALL ERREX
      ENDIF
C
      IF(RERDTP.EQ.'AIBJ')THEN
       REORTP='1324'
      ELSEIF(RERDTP.EQ.'AJBI')THEN
       REORTP='1423'
      ELSE
       WRITE(6,1001)RERDTP
1001   FORMAT(T3,'@SST003-F, Unknown reorder type ',A4,' passed in.')
       CALL ERREX
      ENDIF
C
C EXPAND LIST FROM A<B,I<J TO AB,IJ
C
      IOFFT=1
      IOFFF=1
      DO 10 IRREPR=1,NIRREP
       IRREPL=DIRPRD(IRREPX,IRREPR)
       DISSZT=IRPDPD(IRREPL,ISPIN)
       NUMDST=IRPDPD(IRREPR,2+ISPIN)
       DISSZF=IRPDPD(IRREPL,18+ISPIN)
       NUMDSF=IRPDPD(IRREPR,20+ISPIN)
       CALL SCOPY(NUMDST*DISSZT,WIN(IOFFT),1,WOUT(IOFFF),1)
       CALL SYMEXP (IRREPR,POP(1,ISPIN),DISSZT,WOUT(IOFFF)) 
       CALL SYMEXP2(IRREPL,VRT(1,ISPIN),DISSZF,DISSZT,NUMDSF,
     &              WOUT(IOFFF),WOUT(IOFFF))
       IOFFF=IOFFF+NUMDSF*DISSZF
       IOFFT=IOFFT+NUMDST*DISSZT
10    CONTINUE
      ITOTSZF=IOFFF-1
      CALL SCOPY(ITOTSZF,WOUT,1,WIN,1)
C
      CALL SSTGEN(WIN,WOUT,ITOTSZF,VRT(1,ISPIN),VRT(1,ISPIN),
     &            POP(1,ISPIN),POP(1,ISPIN),ISCR,IRREPX,REORTP)
C
      RETURN
      END
