#ifndef JACKPROCESSOR_H
#define JACKPROCESSOR_H

#include <stdio.h>
#include <stdlib.h>
#include <QtCore/QObject>
#include <QtCore/QMutex>
#include <QtCore/QSemaphore>
#include <QtCore/QWaitCondition>
#include <QtCore/QStringList>
#include <jack/jack.h>
#include "model.h"

class JackProcessor : public QObject
{
  Q_OBJECT
  
  private:
    Model *model;
    jack_client_t *jackHandle;
    jack_port_t *jackOut[2];
    jack_port_t *jackMidiIn, *jackMidiOut;
    bool sustain;
    double last_frame[2];
    
  private:
    static int jack_static_callback(jack_nframes_t nframes, void *arg);
    int jack_callback(jack_nframes_t nframes);

  public:
    JackProcessor(Model *p_model, QObject* parent=0);
    ~JackProcessor();
    int initJack();
    QStringList getConnections();
    void setConnections(QStringList connectionList);

  signals:
    void MIDI_noteOn(int);
    void MIDI_controlEvent(int, unsigned char, unsigned int, int, int);

};
  
#endif
