# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################

import datetime
import gobject

class MetaPackage(object):
	"""
		This class handles all requisitions to maintain and create MetaPackage file.
	"""
	#class constructor
	def __init__(self, filename=""):
		self.fileName = filename
		self.mtPackage = 'aptoncd-metapackage'
		self.mtVersion = datetime.date.today().strftime('%Y%m%d')
		self.mtFileName = self.mtPackage + '_' + self.mtVersion + '.deb'
		self.mtSection = 'base'
		self.mtPriority = 'optional'
		self.mtArch = 'i386'
		self.mtMaintainer = 'APTonCD Auto-Packager <http://aptoncd.sourceforge.net>'
		self.mtSDesc = 'auto-meta-package for APTonCD media packages\n'
		self.mtLDesc = '  Auto-generated meta-package that contains as dependencies all\n  packages in APTonCD media, previously generated by APTonCD\n  .\n  To know more about APTonCD Auto-Packager, visit http://aptoncd.sourceforge.net'
		self.mtDesc = self.mtSDesc + self.mtLDesc
		self.packages = ""
		
	def set_mtPackage(self,sValue):
		self.mtPackage = sValue
		
	def set_mtFileName(self,sValue):
		self.mtFileName = sValue
	
	def get_mtFileName(self):
		return self.mtFileName
		
	def set_mtSection(self,sValue):
		self.mtSection = sValue
	
	def set_mtPriority(self,sValue):
		self.mtPriority = sValue
		
	def set_mtArch(self,sValue):
		self.mtArch = sValue
		
	def set_mtMaintainer(self,sValue):
		self.mtMaintainer = sValue
		
	def set_mtSDesc(self,sValue):
		self.mtSDesc = sValue
		
	def set_mtLDesc(self,sValue):
		self.mtLDesc = sValue
		self.mtDesc = self.mtSDesc + self.mtLDes
	
	def appendPackage(self,package):
		self.packages += (package +", ")
	
	def write(self):
		i= 0
		try:
			mFile = open(self.fileName,"a")
			mFile.write("Package: " + self.mtPackage \
			+ "\nVersion: " + self.mtVersion \
			+ "\nSection: " + self.mtSection \
			+ "\nPriority: " + self.mtPriority \
			+ "\nArchitecture: " + self.mtArch \
			+ "\nMaintainer: " + self.mtMaintainer \
			+ "\nDescription: " + self.mtDesc \
			#+ "\nDepends: " + re.sub(',\s$', '\n', self.packages))
			+ "\nDepends: " + self.packages[:len(self.packages)-2] +"\n")
			return True, ''
		except IOError, e:
			return False, str(e)
