{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
    function GetColorPerVertex: boolean;
    procedure SetColorPerVertex(const Value: boolean);
  public
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);
    property Color: TAbstractColorNode read GetColor write SetColor;
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;
    procedure SetColorIndex(const Value: array of LongInt);
    procedure SetColorIndex(const Value: TLongIntList);
    property ColorPerVertex: boolean read GetColorPerVertex write SetColorPerVertex;
    procedure SetCoordIndex(const Value: array of LongInt);
    procedure SetCoordIndex(const Value: TLongIntList);

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedLineSetNode ----------------------------------------------- }

procedure TIndexedLineSetNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

function TIndexedLineSetNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TIndexedLineSetNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

function TIndexedLineSetNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TIndexedLineSetNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

procedure TIndexedLineSetNode.SetColorIndex(const Value: array of LongInt);
begin
  FdColorIndex.Send(Value);
end;

procedure TIndexedLineSetNode.SetColorIndex(const Value: TLongIntList);
begin
  FdColorIndex.Send(Value);
end;

function TIndexedLineSetNode.GetColorPerVertex: boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TIndexedLineSetNode.SetColorPerVertex(const Value: boolean);
begin
  FdColorPerVertex.Send(Value);
end;

procedure TIndexedLineSetNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TIndexedLineSetNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

{$endif read_implementation}
