#ifndef X86_64_ATOMIC_H
#define X86_64_ATOMIC_H

typedef struct _atomic_t
{
	int counter;
} atomic_t;

inline atomic_t ATOMIC_INIT(volatile long &v)
{
	atomic_t tmp;
	tmp.counter = (int)v;
	return tmp;
}

inline int atomic_inc(volatile atomic_t *ptr)
{
    unsigned char ret;
    asm volatile("lock incl %0\n"
                 "setne %1"
                 : "=m" (ptr->counter), "=qm" (ret)
                 : "m" (ptr->counter)
                 : "memory");
    return static_cast<int>(ret);
}

inline int atomic_dec(volatile atomic_t *ptr)
{
    unsigned char ret;
    asm volatile("lock decl %0\n"
                 "setne %1"
                 : "=m" (ptr->counter), "=qm" (ret)
                 : "m" (ptr->counter)
                 : "memory");
    return static_cast<int>(ret);
}


#endif
