# Changelog

All notable changes to this project will be documented in this file.

## [0.10.1] - 2024-08-08

### Bug Fixes

- Disable failing tests
- Test if directory exists before scanning it

### Miscellaneous Tasks

- Added `term` argument to `_autostart`
The `term` argument is now propagated to the function, responsible to
execute files found in autostart folders, so the command line option
`--term` now also works with the `-a` option and not only when directly
executing a specific desktop file.

- Add support for actions

As specified in the Desktop Entry Specification, one .desktop file
(of type Application) can contain not only the main Desktop Entry
group with its Exec key, but also "Additional applications actions"
with their own Exec key. This commits implements running actions
as well as --property output for their Name and Exec keys.


### Refactor

- Refactor and idiomatize some code


### Styling

- Reindent code

### Autostart

- Use a set to keep track of seen files
- Replace `glob` with `os.scandir`

## [0.9.0] - 2020-06-13

## [0.8.0] - 2017-06-18

### Makefile

- Add clean target to .PHONY
- Add force to clean target
- Always use configured $(NAME) instead of hard-coded name 'dex'

### Miscellaneous Tasks

- Implement -s switch to specify search path

By default dex will look through $XDG_CONFIG_HOME/autostart and
the xdg/autostart/ subdirectories of the $XDG_CONFIG_DIRS.

The -s switch lets you override the built in directory search path with
one of your own.


### Man/conf.py

- Turn utf-8 string into Unicode string literal

## [0.7] - 2013-11-13

### Miscellaneous Tasks

- Implement -t switch to specify a target directory (closes issue #16)

- group main if clause into functions
- group help output
- implement -t switch
- add verbose output if environment is specified


## [0.6] - 2012-10-04

### Bug Fixes

- Fix function to create a Desktop Entry file


## [0.5] - 2012-10-03

## [0.4] - 2012-08-05

### Bug Fixes

- Fix exception when an exception occurred during loading a autostart file

- Fix traceback when accessing the non-initialized variable app. partly fixes issue #7


## [0.3] - 2012-07-12

### Bug Fixes

- Fix help messages

- Fix help message


## [0.2] - 2012-07-12

### Bug Fixes

- Fixed a parameter issue for executing commands in a terminal

- Fix some variable names


<!-- generated by git-cliff -->
