#ifndef DUNE_ALBERTA_PERSISTENTCONTAINER_HH
#define DUNE_ALBERTA_PERSISTENTCONTAINER_HH

#include <dune/grid/utility/persistentcontainer.hh>

#if HAVE_ALBERTA

namespace Dune
{

  // PersistentContainer for AlbertaGrid
  // -----------------------------------

  template< int dim, int dimworld, class Data, class Allocator >
  class PersistentContainer< AlbertaGrid< dim, dimworld >, Data, Allocator >
  : public PersistentContainerVector< AlbertaGrid< dim, dimworld >, typename AlbertaGrid< dim, dimworld >::HierarchicIndexSet, std::vector< Data, Allocator > >
  {
    typedef PersistentContainerVector< AlbertaGrid< dim, dimworld >, typename AlbertaGrid< dim, dimworld >::HierarchicIndexSet, std::vector< Data, Allocator > > Base;

  public:
    typedef AlbertaGrid< dim, dimworld > GridType;

    //! Constructor filling the container with values using the default constructor 
    //! Depending on the implementation this could be achieved without allocating memory
    PersistentContainer ( const GridType &grid, const int codim, const Allocator &allocator = Allocator() )
    : Base( grid, codim, grid.hierarchicIndexSet(), 1.1, allocator )
    {}
  };

} // end namespace Dune

#endif // #if HAVE_ALBERTA

#endif // #ifndef DUNE_ALU_PERSISTENTCONTAINER_HH
