/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.elasticloadbalancing.processors.service.route53;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import com.amazon.webservices.dns.client.impl.Route53ClientImpl;
import com.amazon.webservices.dns.client.util.HttpResponse;
import com.amazon.webservices.dns.v20110505.ChangeAction;
import com.amazon.webservices.dns.v20110505.ChangeResourceRecordSetsRequest;
import com.amazon.webservices.dns.v20110505.RRType;
import com.amazonaws.elasticloadbalancing.processors.service.route53.Route53ServiceResponseHandler;
import java.net.MalformedURLException;
import java.net.URL;

public class Route53ServiceCaller
extends AwsServiceCaller {
    private static final String ROUTE53_URL = "https://route53.amazonaws.com/2011-05-05";
    private static final String ROUTE53_NAMESPACE = "https://route53.amazonaws.com/doc/2011-05-05/";
    private static final String AWS_ACCESS_KEY_ID = "AWSAccessKeyId";
    private static final String AWS_SECRET_KEY = "AWSSecretKey";
    private static final String RESOURCE_RECORD_NAME_PARAM = "ResourceRecordName";
    private static final String HOSTED_ZONE_ID_PARAM = "HostedZoneID";
    private static final String RESOURCE_RECORD_SET_ID_PARAM = "ResourceRecordSetID";
    private static final String WEIGHT_PARAM = "Weight";
    private static final String RESOURCE_RECORD_TYPE_PARAM = "ResourceRecordType";
    private final String elbDomainName;
    private final String elbHostedZoneId;
    private final ChangeAction action;

    public Route53ServiceCaller(String elbDomainName, String elbHostedZoneId, ChangeAction action) {
        this.elbDomainName = elbDomainName;
        this.elbHostedZoneId = elbHostedZoneId;
        this.action = action;
    }

    public void call(Command command) {
        URL serviceUrl;
        String accessId = command.getCurrentCommandConfig().getParameter(AWS_ACCESS_KEY_ID).getValue();
        String secretKey = command.getCurrentCommandConfig().getParameter(AWS_SECRET_KEY).getValue();
        String domainName = command.getCurrentCommandConfig().getParameter(RESOURCE_RECORD_NAME_PARAM).getValue();
        String hostedZoneId = command.getCurrentCommandConfig().getParameter(HOSTED_ZONE_ID_PARAM).getValue();
        String identifier = command.getCurrentCommandConfig().getParameter(RESOURCE_RECORD_SET_ID_PARAM).getValue();
        String weightInput = command.getCurrentCommandConfig().getParameter(WEIGHT_PARAM).getValue();
        String rrTypeInput = command.getCurrentCommandConfig().getParameter(RESOURCE_RECORD_TYPE_PARAM).getValue();
        if (identifier == null || identifier.equals("")) {
            identifier = this.elbDomainName;
        }
        RRType rrType = rrTypeInput == null || rrTypeInput.equals("") ? RRType.A : RRType.valueOf(rrTypeInput.toUpperCase());
        Long weight = Long.parseLong(weightInput);
        try {
            serviceUrl = new URL(ROUTE53_URL);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationErrorException("Malformed Route53 endpoint URL", (Exception)e);
        }
        Route53ClientImpl client = new Route53ClientImpl(serviceUrl, ROUTE53_NAMESPACE, accessId, secretKey);
        ChangeResourceRecordSetsRequest request = client.createAliasResourceRecordRequest(this.action, domainName, rrType, identifier, weight, this.elbHostedZoneId, this.elbDomainName);
        HttpResponse response = client.changeRecordResourceSet(request, hostedZoneId);
        this.responseHandler = new Route53ServiceResponseHandler(client, serviceUrl, request, hostedZoneId, response);
    }

    public String getUrl() {
        return this.responseHandler.getUrl();
    }
}

