/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class TextFieldInt
extends TextFieldSink {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.UK);

    public TextFieldInt() {
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retVal;
    }

    public void setValue(int value) {
        this.setText(this.integerFormatter.format(value));
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i]) || source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                if (source[i] == ',') continue;
                TextFieldInt.this.toolkit.beep();
                System.err.println("invalid character entered: " + source[i]);
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

