/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.TreePanel;
import jalview.bin.JalviewLite;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FontChooser
extends Panel
implements ActionListener,
ItemListener {
    AlignmentPanel ap;
    TreePanel tp;
    Font oldFont;
    boolean init = true;
    Frame frame;
    Label label1 = new Label();
    protected Choice fontSize = new Choice();
    protected Choice fontStyle = new Choice();
    Label label2 = new Label();
    Label label3 = new Label();
    protected Choice fontName = new Choice();
    Button ok = new Button();
    Button cancel = new Button();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    Panel panel3 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel panel4 = new Panel();
    Panel panel5 = new Panel();
    BorderLayout borderLayout4 = new BorderLayout();

    public FontChooser(TreePanel tp) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tp = tp;
        this.oldFont = tp.getTreeFont();
        this.init();
    }

    public FontChooser(AlignmentPanel ap) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ap = ap;
        this.oldFont = ap.av.getFont();
        this.init();
    }

    void init() {
        Frame frame;
        int i;
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (i = 0; i < fonts.length; ++i) {
            this.fontName.addItem(fonts[i]);
        }
        for (i = 1; i < 31; ++i) {
            this.fontSize.addItem(i + "");
        }
        this.fontStyle.addItem("plain");
        this.fontStyle.addItem("bold");
        this.fontStyle.addItem("italic");
        this.fontName.select(this.oldFont.getName());
        this.fontSize.select(this.oldFont.getSize() + "");
        this.fontStyle.select(this.oldFont.getStyle());
        this.frame = frame = new Frame();
        frame.add(this);
        JalviewLite.addFrame(frame, "Change Font", 440, 115);
        this.init = false;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.ok) {
            this.ok_actionPerformed();
        } else if (evt.getSource() == this.cancel) {
            this.cancel_actionPerformed();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.fontName) {
            this.fontName_actionPerformed();
        } else if (evt.getSource() == this.fontSize) {
            this.fontSize_actionPerformed();
        } else if (evt.getSource() == this.fontStyle) {
            this.fontStyle_actionPerformed();
        }
    }

    protected void ok_actionPerformed() {
        this.frame.setVisible(false);
        if (this.ap != null && this.ap.getOverviewPanel() != null) {
            this.ap.getOverviewPanel().updateOverviewImage();
        }
    }

    protected void cancel_actionPerformed() {
        if (this.ap != null) {
            this.ap.av.setFont(this.oldFont);
            this.ap.paintAlignment(true);
        } else if (this.tp != null) {
            this.tp.setTreeFont(this.oldFont);
            this.tp.treeCanvas.repaint();
        }
        this.fontName.select(this.oldFont.getName());
        this.fontSize.select(this.oldFont.getSize() + "");
        this.fontStyle.select(this.oldFont.getStyle());
        this.frame.setVisible(false);
    }

    void changeFont() {
        Font newFont = new Font(this.fontName.getSelectedItem().toString(), this.fontStyle.getSelectedIndex(), Integer.parseInt(this.fontSize.getSelectedItem().toString()));
        if (this.ap != null) {
            this.ap.av.setFont(newFont);
            this.ap.fontChanged();
        } else if (this.tp != null) {
            this.tp.setTreeFont(newFont);
        }
    }

    protected void fontName_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    protected void fontSize_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    protected void fontStyle_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    private void jbInit() throws Exception {
        this.label1.setFont(new Font("Verdana", 0, 11));
        this.label1.setAlignment(2);
        this.label1.setText("Font: ");
        this.setLayout(this.borderLayout4);
        this.fontSize.setFont(new Font("Verdana", 0, 11));
        this.fontSize.addItemListener(this);
        this.fontStyle.setFont(new Font("Verdana", 0, 11));
        this.fontStyle.addItemListener(this);
        this.label2.setAlignment(2);
        this.label2.setFont(new Font("Verdana", 0, 11));
        this.label2.setText("Size: ");
        this.label3.setAlignment(2);
        this.label3.setFont(new Font("Verdana", 0, 11));
        this.label3.setText("Style: ");
        this.fontName.setFont(new Font("Verdana", 0, 11));
        this.fontName.addItemListener(this);
        this.ok.setFont(new Font("Verdana", 0, 11));
        this.ok.setLabel("OK");
        this.ok.addActionListener(this);
        this.cancel.setFont(new Font("Verdana", 0, 11));
        this.cancel.setLabel("Cancel");
        this.cancel.addActionListener(this);
        this.setBackground(Color.white);
        this.panel1.setLayout(this.borderLayout1);
        this.panel2.setLayout(this.borderLayout3);
        this.panel3.setLayout(this.borderLayout2);
        this.panel5.setBackground(Color.white);
        this.panel4.setBackground(Color.white);
        this.panel1.setBackground(Color.white);
        this.panel2.setBackground(Color.white);
        this.panel3.setBackground(Color.white);
        this.panel1.add((Component)this.label1, "West");
        this.panel1.add((Component)this.fontName, "Center");
        this.panel5.add((Component)this.panel1, null);
        this.panel5.add((Component)this.panel3, null);
        this.panel5.add((Component)this.panel2, null);
        this.panel2.add((Component)this.label3, "West");
        this.panel2.add((Component)this.fontStyle, "Center");
        this.panel3.add((Component)this.label2, "West");
        this.panel3.add((Component)this.fontSize, "Center");
        this.add((Component)this.panel4, "South");
        this.panel4.add((Component)this.ok, null);
        this.panel4.add((Component)this.cancel, null);
        this.add((Component)this.panel5, "Center");
    }
}

