/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.analysis.AlignSeq;
import jalview.commands.CommandI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import java.util.Hashtable;

public class EditCommand
implements CommandI {
    public static final int INSERT_GAP = 0;
    public static final int DELETE_GAP = 1;
    public static final int CUT = 2;
    public static final int PASTE = 3;
    public static final int REPLACE = 4;
    Edit[] edits;
    String description;

    public EditCommand() {
    }

    public EditCommand(String description) {
        this.description = description;
    }

    public EditCommand(String description, int command, SequenceI[] seqs, int position, int number, AlignmentI al) {
        this.description = description;
        if (command == 2 || command == 3) {
            this.edits = new Edit[]{new Edit(command, seqs, position, number, al)};
        }
        this.performEdit(0, null);
    }

    public EditCommand(String description, int command, String replace, SequenceI[] seqs, int position, int number, AlignmentI al) {
        this.description = description;
        if (command == 4) {
            this.edits = new Edit[]{new Edit(command, seqs, position, number, al, replace)};
        }
        this.performEdit(0, null);
    }

    public final String getDescription() {
        return this.description;
    }

    public int getSize() {
        return this.edits == null ? 0 : this.edits.length;
    }

    public final AlignmentI getAlignment() {
        return this.edits[0].al;
    }

    public final void appendEdit(int command, SequenceI[] seqs, int position, int number, AlignmentI al, boolean performEdit) {
        this.appendEdit(command, seqs, position, number, al, performEdit, null);
    }

    public final void appendEdit(int command, SequenceI[] seqs, int position, int number, AlignmentI al, boolean performEdit, AlignmentI[] views) {
        Edit edit = new Edit(command, seqs, position, number, al.getGapCharacter());
        if (al.getHeight() == seqs.length) {
            edit.al = al;
            edit.fullAlignmentHeight = true;
        }
        if (this.edits != null) {
            Edit[] temp = new Edit[this.edits.length + 1];
            System.arraycopy(this.edits, 0, temp, 0, this.edits.length);
            this.edits = temp;
            this.edits[this.edits.length - 1] = edit;
        } else {
            this.edits = new Edit[]{edit};
        }
        if (performEdit) {
            this.performEdit(this.edits.length - 1, views);
        }
    }

    final void performEdit(int commandIndex, AlignmentI[] views) {
        int eSize = this.edits.length;
        block7: for (int e = commandIndex; e < eSize; ++e) {
            switch (this.edits[e].command) {
                case 0: {
                    this.insertGap(this.edits[e]);
                    continue block7;
                }
                case 1: {
                    this.deleteGap(this.edits[e]);
                    continue block7;
                }
                case 2: {
                    this.cut(this.edits[e], views);
                    continue block7;
                }
                case 3: {
                    this.paste(this.edits[e], views);
                    continue block7;
                }
                case 4: {
                    this.replace(this.edits[e]);
                }
            }
        }
    }

    public final void doCommand(AlignmentI[] views) {
        this.performEdit(0, views);
    }

    public final void undoCommand(AlignmentI[] views) {
        int e = 0;
        int eSize = this.edits.length;
        block7: for (e = eSize - 1; e > -1; --e) {
            switch (this.edits[e].command) {
                case 0: {
                    this.deleteGap(this.edits[e]);
                    continue block7;
                }
                case 1: {
                    this.insertGap(this.edits[e]);
                    continue block7;
                }
                case 2: {
                    this.paste(this.edits[e], views);
                    continue block7;
                }
                case 3: {
                    this.cut(this.edits[e], views);
                    continue block7;
                }
                case 4: {
                    this.replace(this.edits[e]);
                }
            }
        }
    }

    final void insertGap(Edit command) {
        for (int s = 0; s < command.seqs.length; ++s) {
            command.seqs[s].insertCharAt(command.position, command.number, command.gapChar);
        }
        this.adjustAnnotations(command, true, false, null);
    }

    final void deleteGap(Edit command) {
        for (int s = 0; s < command.seqs.length; ++s) {
            command.seqs[s].deleteChars(command.position, command.position + command.number);
        }
        this.adjustAnnotations(command, false, false, null);
    }

    void cut(Edit command, AlignmentI[] views) {
        boolean seqDeleted = false;
        command.string = new char[command.seqs.length][];
        for (int i = 0; i < command.seqs.length; ++i) {
            if (command.seqs[i].getLength() > command.position) {
                command.string[i] = command.seqs[i].getSequence(command.position, command.position + command.number);
                SequenceI oldds = command.seqs[i].getDatasetSequence();
                if (command.oldds != null && command.oldds[i] != null) {
                    command.seqs[i].setDatasetSequence(null);
                }
                command.seqs[i].deleteChars(command.position, command.position + command.number);
                if (command.oldds != null && command.oldds[i] != null) {
                    command.seqs[i].setDatasetSequence(command.oldds[i]);
                    command.oldds[i] = oldds;
                } else if (oldds != command.seqs[i].getDatasetSequence() || command.seqs[i].getSequenceFeatures() != null) {
                    if (command.oldds == null) {
                        command.oldds = new SequenceI[command.seqs.length];
                    }
                    command.oldds[i] = oldds;
                    this.adjustFeatures(command, i, command.seqs[i].findPosition(command.position), command.seqs[i].findPosition(command.position + command.number), false);
                }
            }
            if (command.seqs[i].getLength() >= 1) continue;
            command.al.deleteSequence(command.seqs[i]);
            seqDeleted = true;
        }
        this.adjustAnnotations(command, false, seqDeleted, views);
    }

    void paste(Edit command, AlignmentI[] views) {
        boolean seqWasDeleted = false;
        int start = 0;
        int end = 0;
        for (int i = 0; i < command.seqs.length; ++i) {
            boolean newDSWasNeeded;
            boolean newDSNeeded = false;
            boolean bl = newDSWasNeeded = command.oldds != null && command.oldds[i] != null;
            if (command.seqs[i].getLength() < 1) {
                if (command.alIndex[i] < command.al.getHeight()) {
                    command.al.getSequences().insertElementAt(command.seqs[i], command.alIndex[i]);
                } else {
                    command.al.addSequence(command.seqs[i]);
                }
                seqWasDeleted = true;
            }
            int newstart = command.seqs[i].getStart();
            int newend = command.seqs[i].getEnd();
            StringBuffer tmp = new StringBuffer();
            tmp.append(command.seqs[i].getSequence());
            if (command.string != null && command.string[i] != null) {
                if (command.position >= tmp.length()) {
                    for (int length = command.position - tmp.length(); length > 0; --length) {
                        tmp.append(command.gapChar);
                    }
                }
                tmp.insert(command.position, command.string[i]);
                for (int s = 0; s < command.string[i].length; ++s) {
                    if (ResidueProperties.aaIndex[command.string[i][s]] == 23) continue;
                    if (!newDSNeeded) {
                        newDSNeeded = true;
                        start = command.seqs[i].findPosition(command.position);
                        end = command.seqs[i].findPosition(command.position + command.number);
                    }
                    if (command.seqs[i].getStart() == start) {
                        --newstart;
                        continue;
                    }
                    ++newend;
                }
                command.string[i] = null;
            }
            command.seqs[i].setSequence(tmp.toString());
            command.seqs[i].setStart(newstart);
            command.seqs[i].setEnd(newend);
            if (!newDSNeeded) continue;
            if (command.seqs[i].getDatasetSequence() != null) {
                SequenceI ds;
                if (newDSWasNeeded) {
                    ds = command.oldds[i];
                } else {
                    ds = new Sequence(command.seqs[i].getName(), AlignSeq.extractGaps(" .-", command.seqs[i].getSequenceAsString()), command.seqs[i].getStart(), command.seqs[i].getEnd());
                    ds.setDescription(command.seqs[i].getDescription());
                }
                if (command.oldds == null) {
                    command.oldds = new SequenceI[command.seqs.length];
                }
                command.oldds[i] = command.seqs[i].getDatasetSequence();
                command.seqs[i].setDatasetSequence(ds);
            }
            this.adjustFeatures(command, i, start, end, true);
        }
        this.adjustAnnotations(command, true, seqWasDeleted, views);
        command.string = null;
    }

    void replace(Edit command) {
        int start = command.position;
        int end = command.number;
        command.number = start + command.string[0].length;
        for (int i = 0; i < command.seqs.length; ++i) {
            String oldstring = command.seqs[i].getSequenceAsString();
            StringBuffer tmp = new StringBuffer(oldstring.substring(0, start));
            tmp.append(command.string[i]);
            tmp.append(oldstring.substring(end));
            command.seqs[i].setSequence(tmp.toString());
            command.string[i] = oldstring.substring(start, end).toCharArray();
            tmp = null;
            oldstring = null;
        }
    }

    final void adjustAnnotations(Edit command, boolean insert, boolean modifyVisibility, AlignmentI[] views) {
        int aSize;
        AlignmentAnnotation[] annotations = null;
        if (modifyVisibility && !insert) {
            command.deletedAnnotationRows = new Hashtable();
        }
        if (command.fullAlignmentHeight) {
            annotations = command.al.getAlignmentAnnotation();
        } else {
            aSize = 0;
            for (int s = 0; s < command.seqs.length; ++s) {
                AlignmentAnnotation[] tmp;
                if (modifyVisibility) {
                    int aa;
                    if (!insert) {
                        tmp = command.seqs[s].getAnnotation();
                        if (tmp == null) continue;
                        int alen = tmp.length;
                        for (int aa2 = 0; aa2 < tmp.length; ++aa2) {
                            if (command.al.deleteAnnotation(tmp[aa2])) continue;
                            tmp[aa2] = null;
                            --alen;
                        }
                        command.seqs[s].setAlignmentAnnotation(null);
                        if (alen != tmp.length) {
                            AlignmentAnnotation[] saved = new AlignmentAnnotation[alen];
                            int aapos = 0;
                            for (int aa3 = 0; aa3 < tmp.length; ++aa3) {
                                if (tmp[aa3] == null) continue;
                                saved[aapos++] = tmp[aa3];
                                tmp[aa3] = null;
                            }
                            tmp = saved;
                            command.deletedAnnotationRows.put(command.seqs[s], saved);
                            for (int alview = 0; views != null && alview < views.length; ++alview) {
                                AlignmentAnnotation[] toremove;
                                if (views[alview] == command.al || (toremove = views[alview].getAlignmentAnnotation()) == null || toremove.length == 0) continue;
                                for (int aa4 = 0; aa4 < toremove.length; ++aa4) {
                                    if (toremove[aa4].sequenceRef != command.seqs[s]) continue;
                                    views[alview].deleteAnnotation(toremove[aa4]);
                                }
                            }
                            continue;
                        }
                        command.deletedAnnotationRows.put(command.seqs[s], tmp);
                        continue;
                    }
                    if (command.deletedAnnotationRows == null || !command.deletedAnnotationRows.containsKey(command.seqs[s])) continue;
                    AlignmentAnnotation[] revealed = (AlignmentAnnotation[])command.deletedAnnotationRows.get(command.seqs[s]);
                    command.seqs[s].setAlignmentAnnotation(revealed);
                    if (revealed == null) continue;
                    for (aa = 0; aa < revealed.length; ++aa) {
                        command.al.addAnnotation(revealed[aa]);
                    }
                    for (aa = 0; aa < revealed.length; ++aa) {
                        command.al.setAnnotationIndex(revealed[aa], aa);
                    }
                    for (int vnum = 0; views != null && vnum < views.length; ++vnum) {
                        if (views[vnum] == command.al) continue;
                        int avwidth = views[vnum].getWidth() + 1;
                        for (int a = 0; a < revealed.length; ++a) {
                            AlignmentAnnotation newann = new AlignmentAnnotation(revealed[a]);
                            command.seqs[s].addAlignmentAnnotation(newann);
                            newann.padAnnotation(avwidth);
                            views[vnum].addAnnotation(newann);
                            views[vnum].setAnnotationIndex(newann, a);
                        }
                    }
                    continue;
                }
                if (command.seqs[s].getAnnotation() == null) continue;
                if (aSize == 0) {
                    annotations = command.seqs[s].getAnnotation();
                } else {
                    tmp = new AlignmentAnnotation[aSize + command.seqs[s].getAnnotation().length];
                    System.arraycopy(annotations, 0, tmp, 0, aSize);
                    System.arraycopy(command.seqs[s].getAnnotation(), 0, tmp, aSize, command.seqs[s].getAnnotation().length);
                    annotations = tmp;
                }
                aSize = annotations.length;
            }
        }
        if (annotations == null) {
            return;
        }
        if (!insert) {
            command.deletedAnnotations = new Hashtable();
        }
        for (int a = 0; a < annotations.length; ++a) {
            Annotation[] deleted;
            Annotation[] temp;
            if (annotations[a].autoCalculated || annotations[a].annotations == null) continue;
            int tSize = 0;
            aSize = annotations[a].annotations.length;
            if (insert) {
                temp = new Annotation[aSize + command.number];
                if (annotations[a].padGaps) {
                    for (int aa = 0; aa < temp.length; ++aa) {
                        temp[aa] = new Annotation(command.gapChar + "", null, ' ', 0.0f);
                    }
                }
            } else {
                tSize = command.position < aSize ? (command.position + command.number >= aSize ? aSize : aSize - command.number) : aSize;
                if (tSize < 0) {
                    tSize = aSize;
                }
                temp = new Annotation[tSize];
            }
            if (insert) {
                if (command.position < annotations[a].annotations.length) {
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, command.position);
                    if (command.deletedAnnotations != null && command.deletedAnnotations.containsKey(annotations[a].annotationId)) {
                        Annotation[] restore = (Annotation[])command.deletedAnnotations.get(annotations[a].annotationId);
                        System.arraycopy(restore, 0, temp, command.position, command.number);
                    }
                    System.arraycopy(annotations[a].annotations, command.position, temp, command.position + command.number, aSize - command.position);
                } else if (command.deletedAnnotations != null && command.deletedAnnotations.containsKey(annotations[a].annotationId)) {
                    Annotation[] restore = (Annotation[])command.deletedAnnotations.get(annotations[a].annotationId);
                    temp = new Annotation[annotations[a].annotations.length + restore.length];
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, annotations[a].annotations.length);
                    System.arraycopy(restore, 0, temp, annotations[a].annotations.length, restore.length);
                } else {
                    temp = annotations[a].annotations;
                }
            } else if (tSize != aSize || command.position < 2) {
                int copylen = Math.min(command.position, annotations[a].annotations.length);
                if (copylen > 0) {
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, copylen);
                }
                deleted = new Annotation[command.number];
                if (copylen >= command.position && (copylen = Math.min(command.number, annotations[a].annotations.length - command.position)) > 0) {
                    System.arraycopy(annotations[a].annotations, command.position, deleted, 0, copylen);
                }
                command.deletedAnnotations.put(annotations[a].annotationId, deleted);
                if (annotations[a].annotations.length > command.position + command.number) {
                    System.arraycopy(annotations[a].annotations, command.position + command.number, temp, command.position, annotations[a].annotations.length - command.position - command.number);
                }
            } else {
                int dSize = aSize - command.position;
                if (dSize > 0) {
                    deleted = new Annotation[command.number];
                    System.arraycopy(annotations[a].annotations, command.position, deleted, 0, dSize);
                    command.deletedAnnotations.put(annotations[a].annotationId, deleted);
                    tSize = Math.min(annotations[a].annotations.length, command.position);
                    temp = new Annotation[tSize];
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, tSize);
                } else {
                    temp = annotations[a].annotations;
                }
            }
            annotations[a].annotations = temp;
        }
    }

    final void adjustFeatures(Edit command, int index, int i, int j, boolean insert) {
        SequenceI seq = command.seqs[index];
        SequenceI sequence = seq.getDatasetSequence();
        if (sequence == null) {
            sequence = seq;
        }
        if (insert) {
            if (command.editedFeatures != null && command.editedFeatures.containsKey(seq)) {
                sequence.setSequenceFeatures((SequenceFeature[])command.editedFeatures.get(seq));
            }
            return;
        }
        SequenceFeature[] sf = sequence.getSequenceFeatures();
        if (sf == null) {
            return;
        }
        SequenceFeature[] oldsf = new SequenceFeature[sf.length];
        int cSize = j - i;
        for (int s = 0; s < sf.length; ++s) {
            SequenceFeature copy;
            oldsf[s] = copy = new SequenceFeature(sf[s]);
            if (sf[s].getEnd() < i) continue;
            if (sf[s].getBegin() > j) {
                sf[s].setBegin(copy.getBegin() - cSize);
                sf[s].setEnd(copy.getEnd() - cSize);
                continue;
            }
            if (sf[s].getBegin() >= i) {
                sf[s].setBegin(i);
            }
            if (sf[s].getEnd() < j) {
                sf[s].setEnd(j - 1);
            }
            sf[s].setEnd(sf[s].getEnd() - cSize);
            if (sf[s].getBegin() <= sf[s].getEnd()) continue;
            sequence.deleteFeature(sf[s]);
        }
        if (command.editedFeatures == null) {
            command.editedFeatures = new Hashtable();
        }
        command.editedFeatures.put(seq, oldsf);
    }

    class Edit {
        public SequenceI[] oldds;
        boolean fullAlignmentHeight = false;
        Hashtable deletedAnnotationRows;
        Hashtable deletedAnnotations;
        Hashtable editedFeatures;
        AlignmentI al;
        int command;
        char[][] string;
        SequenceI[] seqs;
        int[] alIndex;
        int position;
        int number;
        char gapChar;

        Edit(int command, SequenceI[] seqs, int position, int number, char gapChar) {
            this.command = command;
            this.seqs = seqs;
            this.position = position;
            this.number = number;
            this.gapChar = gapChar;
        }

        Edit(int command, SequenceI[] seqs, int position, int number, AlignmentI al) {
            this.gapChar = al.getGapCharacter();
            this.command = command;
            this.seqs = seqs;
            this.position = position;
            this.number = number;
            this.al = al;
            this.alIndex = new int[seqs.length];
            for (int i = 0; i < seqs.length; ++i) {
                this.alIndex[i] = al.findIndex(seqs[i]);
            }
            this.fullAlignmentHeight = al.getHeight() == seqs.length;
        }

        Edit(int command, SequenceI[] seqs, int position, int number, AlignmentI al, String replace) {
            this.command = command;
            this.seqs = seqs;
            this.position = position;
            this.number = number;
            this.al = al;
            this.gapChar = al.getGapCharacter();
            this.string = new char[seqs.length][];
            for (int i = 0; i < seqs.length; ++i) {
                this.string[i] = replace.toCharArray();
            }
            this.fullAlignmentHeight = al.getHeight() == seqs.length;
        }
    }
}

