/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import MCview.PDBfile;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.io.AMSAFile;
import jalview.io.AlignFile;
import jalview.io.BLCFile;
import jalview.io.ClustalFile;
import jalview.io.FastaFile;
import jalview.io.FileParse;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.MSFfile;
import jalview.io.PIRFile;
import jalview.io.PfamFile;
import jalview.io.PileUpfile;
import jalview.io.StockholmFile;
import java.io.File;
import java.io.IOException;

public class AppletFormatAdapter {
    public static final String[] READABLE_FORMATS = new String[]{"BLC", "CLUSTAL", "FASTA", "MSF", "PileUp", "PIR", "PFAM", "STH", "PDB", "JnetFile"};
    public static final String[] WRITEABLE_FORMATS = new String[]{"BLC", "CLUSTAL", "FASTA", "MSF", "PileUp", "PIR", "PFAM", "AMSA"};
    public static final String[] WRITABLE_EXTENSIONS = new String[]{"fa, fasta, fastq", "aln", "pfam", "msf", "pir", "blc", "amsa", "jar"};
    public static final String[] WRITABLE_FNAMES = new String[]{"Fasta", "Clustal", "PFAM", "MSF", "PIR", "BLC", "AMSA", "Jalview"};
    public static final String[] READABLE_EXTENSIONS = new String[]{"fa, fasta, fastq", "aln", "pfam", "msf", "pir", "blc", "amsa", "jar"};
    public static final String[] READABLE_FNAMES = new String[]{"Fasta", "Clustal", "PFAM", "MSF", "PIR", "BLC", "AMSA", "Jalview"};
    public static String INVALID_CHARACTERS = "Contains invalid characters";
    public static String SUPPORTED_FORMATS = "Formats currently supported are\n" + AppletFormatAdapter.prettyPrint(READABLE_FORMATS);
    public static String FILE = "File";
    public static String URL = "URL";
    public static String PASTE = "Paste";
    public static String CLASSLOADER = "ClassLoader";
    AlignFile afile = null;
    String inFile;

    public static String prettyPrint(String[] els) {
        StringBuffer list = new StringBuffer();
        int iSize = els.length - 1;
        for (int i = 0; i < iSize; ++i) {
            list.append(els[i]);
            list.append(",");
        }
        list.append(" and " + els[els.length - 1] + ".");
        return list.toString();
    }

    public static final boolean isValidFormat(String format) {
        return AppletFormatAdapter.isValidFormat(format, false);
    }

    public static final boolean isValidFormat(String format, boolean forwriting) {
        boolean valid = false;
        String[] format_list = forwriting ? WRITEABLE_FORMATS : READABLE_FORMATS;
        for (int i = 0; i < format_list.length; ++i) {
            if (!format_list[i].equalsIgnoreCase(format)) continue;
            return true;
        }
        return valid;
    }

    public Alignment readFile(String inFile, String type, String format) throws IOException {
        this.inFile = inFile;
        try {
            if (format.equals("FASTA")) {
                this.afile = new FastaFile(inFile, type);
            } else if (format.equals("MSF")) {
                this.afile = new MSFfile(inFile, type);
            } else if (format.equals("PileUp")) {
                this.afile = new PileUpfile(inFile, type);
            } else if (format.equals("CLUSTAL")) {
                this.afile = new ClustalFile(inFile, type);
            } else if (format.equals("BLC")) {
                this.afile = new BLCFile(inFile, type);
            } else if (format.equals("PIR")) {
                this.afile = new PIRFile(inFile, type);
            } else if (format.equals("PFAM")) {
                this.afile = new PfamFile(inFile, type);
            } else if (format.equals("JnetFile")) {
                this.afile = new JPredFile(inFile, type);
                ((JPredFile)this.afile).removeNonSequences();
            } else if (format.equals("PDB")) {
                this.afile = new PDBfile(inFile, type);
            } else if (format.equals("STH")) {
                this.afile = new StockholmFile(inFile, type);
            }
            Alignment al = new Alignment(this.afile.getSeqsAsArray());
            this.afile.addAnnotations(al);
            return al;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to read alignment using the '" + format + "' reader.\n" + e);
            if (e.getMessage() != null && e.getMessage().startsWith(INVALID_CHARACTERS)) {
                throw new IOException(e.getMessage());
            }
            if (type.equalsIgnoreCase("Paste")) {
                try {
                    this.afile = new FastaFile(">UNKNOWN\n" + inFile, "Paste");
                    Alignment al = new Alignment(this.afile.getSeqsAsArray());
                    this.afile.addAnnotations(al);
                    return al;
                }
                catch (Exception ex) {
                    if (ex.toString().startsWith(INVALID_CHARACTERS)) {
                        throw new IOException(e.getMessage());
                    }
                    ex.printStackTrace();
                }
            }
            throw new IOException(SUPPORTED_FORMATS);
        }
    }

    public Alignment readFromFile(FileParse source, String format) throws IOException {
        this.inFile = source.getInFile();
        String type = source.type;
        try {
            if (format.equals("FASTA")) {
                this.afile = new FastaFile(source);
            } else if (format.equals("MSF")) {
                this.afile = new MSFfile(source);
            } else if (format.equals("PileUp")) {
                this.afile = new PileUpfile(source);
            } else if (format.equals("CLUSTAL")) {
                this.afile = new ClustalFile(source);
            } else if (format.equals("BLC")) {
                this.afile = new BLCFile(source);
            } else if (format.equals("PIR")) {
                this.afile = new PIRFile(source);
            } else if (format.equals("PFAM")) {
                this.afile = new PfamFile(source);
            } else if (format.equals("JnetFile")) {
                this.afile = new JPredFile(source);
                ((JPredFile)this.afile).removeNonSequences();
            } else if (format.equals("PDB")) {
                this.afile = new PDBfile(source);
            } else if (format.equals("STH")) {
                this.afile = new StockholmFile(source);
            }
            Alignment al = new Alignment(this.afile.getSeqsAsArray());
            this.afile.addAnnotations(al);
            return al;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to read alignment using the '" + format + "' reader.\n" + e);
            if (e.getMessage() != null && e.getMessage().startsWith(INVALID_CHARACTERS)) {
                throw new IOException(e.getMessage());
            }
            if (type.equalsIgnoreCase("Paste")) {
                try {
                    this.afile = new FastaFile(">UNKNOWN\n" + this.inFile, "Paste");
                    Alignment al = new Alignment(this.afile.getSeqsAsArray());
                    this.afile.addAnnotations(al);
                    return al;
                }
                catch (Exception ex) {
                    if (ex.toString().startsWith(INVALID_CHARACTERS)) {
                        throw new IOException(e.getMessage());
                    }
                    ex.printStackTrace();
                }
            }
            throw new IOException(SUPPORTED_FORMATS);
        }
    }

    public String formatSequences(String format, AlignmentI alignment, boolean jvsuffix) {
        try {
            AlignFile afile = null;
            if (format.equalsIgnoreCase("FASTA")) {
                afile = new FastaFile();
            } else if (format.equalsIgnoreCase("MSF")) {
                afile = new MSFfile();
            } else if (format.equalsIgnoreCase("PileUp")) {
                afile = new PileUpfile();
            } else if (format.equalsIgnoreCase("CLUSTAL")) {
                afile = new ClustalFile();
            } else if (format.equalsIgnoreCase("BLC")) {
                afile = new BLCFile();
            } else if (format.equalsIgnoreCase("PIR")) {
                afile = new PIRFile();
            } else if (format.equalsIgnoreCase("PFAM")) {
                afile = new PfamFile();
            } else if (format.equalsIgnoreCase("STH")) {
                afile = new StockholmFile();
            } else if (format.equalsIgnoreCase("AMSA")) {
                afile = new AMSAFile(alignment);
            } else {
                throw new Exception("Implementation error: Unknown file format string");
            }
            afile.addJVSuffix(jvsuffix);
            afile.setSeqs(alignment.getSequencesArray());
            return afile.print();
        }
        catch (Exception e) {
            System.err.println("Failed to write alignment as a '" + format + "' file\n");
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            if (f.exists()) {
                try {
                    System.out.println("Reading file: " + f);
                    AppletFormatAdapter afa = new AppletFormatAdapter();
                    Runtime r = Runtime.getRuntime();
                    System.gc();
                    long memf = -r.totalMemory() + r.freeMemory();
                    long t1 = -System.currentTimeMillis();
                    Alignment al = afa.readFile(args[i], FILE, new IdentifyFile().Identify(args[i], FILE));
                    t1 += System.currentTimeMillis();
                    System.gc();
                    memf += r.totalMemory() - r.freeMemory();
                    if (al != null) {
                        System.out.println("Alignment contains " + al.getHeight() + " sequences and " + al.getWidth() + " columns.");
                    } else {
                        System.out.println("Couldn't read alignment");
                    }
                    System.out.println("Read took " + (double)t1 / 1000.0 + " seconds.");
                    System.out.println("Difference between free memory now and before is " + (double)memf / 1048576.0 * 1.0 + " MB");
                }
                catch (Exception e) {
                    System.err.println("Exception when dealing with " + i + "'th argument: " + args[i] + "\n" + e);
                }
                continue;
            }
            System.err.println("Ignoring argument '" + args[i] + "' (" + i + "'th)- not a readable file.");
        }
    }
}

