using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Google.YouTube;

namespace Google.GData.Tools
{
    /// <summary>
    ///  This is a sample implementation for a login dialog. It returns you the authToken gained
    /// from the Google Client Login Service
    /// </summary>
    public class GoogleClientLogin : System.Windows.Forms.Form
    {
        private System.Windows.Forms.TextBox Password;
        private System.Windows.Forms.Button Login;
        private System.Windows.Forms.Button Cancel;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.TextBox Username;
        private TextBox DeveloperKey;
        private Label label4;

        private string application = null;
        private YouTubeRequestSettings yts = null;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        /// <summary>
        /// allows you to construct the dialog with a given service
        /// </summary>
        /// <param name="serviceToUse">the service object to use</param>
        public GoogleClientLogin(string application, string username)
        {
            if (application == null)
                throw new ArgumentNullException("application was null");
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
            this.application = application;
            this.Username.Text = username;
            this.DeveloperKey.Text = "Your Developer Key here";
        }



        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.Login = new System.Windows.Forms.Button();
            this.Cancel = new System.Windows.Forms.Button();
            this.Username = new System.Windows.Forms.TextBox();
            this.Password = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.DeveloperKey = new System.Windows.Forms.TextBox();
            this.label4 = new System.Windows.Forms.Label();
            this.SuspendLayout();
            // 
            // Login
            // 
            this.Login.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.Login.Location = new System.Drawing.Point(238, 116);
            this.Login.Name = "Login";
            this.Login.Size = new System.Drawing.Size(80, 32);
            this.Login.TabIndex = 5;
            this.Login.Text = "&Login";
            this.Login.Click += new System.EventHandler(this.Login_Click);
            // 
            // Cancel
            // 
            this.Cancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.Cancel.Location = new System.Drawing.Point(142, 116);
            this.Cancel.Name = "Cancel";
            this.Cancel.Size = new System.Drawing.Size(80, 32);
            this.Cancel.TabIndex = 4;
            this.Cancel.Text = "&Cancel";
            this.Cancel.Click += new System.EventHandler(this.Cancel_Click);
            // 
            // Username
            // 
            this.Username.Location = new System.Drawing.Point(112, 16);
            this.Username.Name = "Username";
            this.Username.Size = new System.Drawing.Size(208, 22);
            this.Username.TabIndex = 1;
            // 
            // Password
            // 
            this.Password.Location = new System.Drawing.Point(112, 48);
            this.Password.Name = "Password";
            this.Password.PasswordChar = '*';
            this.Password.Size = new System.Drawing.Size(208, 22);
            this.Password.TabIndex = 2;
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(16, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(88, 32);
            this.label1.TabIndex = 5;
            this.label1.Text = "Username:";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(16, 48);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(88, 32);
            this.label2.TabIndex = 6;
            this.label2.Text = "Password: ";
            // 
            // DeveloperKey
            // 
            this.DeveloperKey.Location = new System.Drawing.Point(112, 76);
            this.DeveloperKey.Name = "DeveloperKey";
            this.DeveloperKey.Size = new System.Drawing.Size(208, 22);
            this.DeveloperKey.TabIndex = 3;
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(12, 76);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(94, 43);
            this.label4.TabIndex = 10;
            this.label4.Text = "Developer Key: ";
            // 
            // GoogleClientLogin
            // 
            this.AcceptButton = this.Login;
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
            this.CancelButton = this.Cancel;
            this.ClientSize = new System.Drawing.Size(348, 168);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.DeveloperKey);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.Password);
            this.Controls.Add(this.Username);
            this.Controls.Add(this.Cancel);
            this.Controls.Add(this.Login);
            this.Name = "GoogleClientLogin";
            this.Text = "GoogleClientLogin";
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion


        /// <summary>
        /// returns the authentication token
        /// </summary>
        public YouTubeRequestSettings Settings
        {
            get
            {
                return this.yts;
            }
        }



        /// <summary>
        /// returns the user name 
        /// </summary>
        public string User
        {
            get
            {
                return this.Username.Text;
            }
        }

        private void Cancel_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }

        private void Login_Click(object sender, System.EventArgs e)
        {
            if (this.User.Length > 0)
            {
                this.yts = new YouTubeRequestSettings(this.application,
                    this.DeveloperKey.Text,
                    this.User,
                    this.Password.Text);
            }
            else
            {
                this.yts = new YouTubeRequestSettings(this.application,
                    this.DeveloperKey.Text);
            }

            this.yts.AutoPaging = true;
            this.Close();
        }
    }
}
