
#include "Meta_Maps.h"

#include <glbinding/gl/extension.h>


using namespace gl;


namespace glbinding { namespace aux
{


const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_0{};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_A =
{
    { "glAccumxOES", { GLextension::GL_OES_fixed_point } },
    { "glAcquireKeyedMutexWin32EXT", { GLextension::GL_EXT_win32_keyed_mutex } },
    { "glActiveProgramEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glActiveShaderProgram", { GLextension::GL_ARB_separate_shader_objects } },
    { "glActiveShaderProgramEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glActiveStencilFaceEXT", { GLextension::GL_EXT_stencil_two_side } },
    { "glActiveTextureARB", { GLextension::GL_ARB_multitexture } },
    { "glActiveVaryingNV", { GLextension::GL_NV_transform_feedback } },
    { "glAlphaFragmentOp1ATI", { GLextension::GL_ATI_fragment_shader } },
    { "glAlphaFragmentOp2ATI", { GLextension::GL_ATI_fragment_shader } },
    { "glAlphaFragmentOp3ATI", { GLextension::GL_ATI_fragment_shader } },
    { "glAlphaFuncxOES", { GLextension::GL_OES_fixed_point } },
    { "glAlphaToCoverageDitherControlNV", { GLextension::GL_NV_alpha_to_coverage_dither_control } },
    { "glApplyFramebufferAttachmentCMAAINTEL", { GLextension::GL_INTEL_framebuffer_CMAA } },
    { "glApplyTextureEXT", { GLextension::GL_EXT_light_texture } },
    { "glAreProgramsResidentNV", { GLextension::GL_NV_vertex_program } },
    { "glAreTexturesResidentEXT", { GLextension::GL_EXT_texture_object } },
    { "glArrayElementEXT", { GLextension::GL_EXT_vertex_array } },
    { "glArrayObjectATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glAsyncCopyBufferSubDataNVX", { GLextension::GL_NVX_gpu_multicast2 } },
    { "glAsyncCopyImageSubDataNVX", { GLextension::GL_NVX_gpu_multicast2 } },
    { "glAsyncMarkerSGIX", { GLextension::GL_SGIX_async } },
    { "glAttachObjectARB", { GLextension::GL_ARB_shader_objects } },
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_B =
{
    { "glBeginConditionalRenderNV", { GLextension::GL_NV_conditional_render } },
    { "glBeginConditionalRenderNVX", { GLextension::GL_NVX_conditional_render } },
    { "glBeginFragmentShaderATI", { GLextension::GL_ATI_fragment_shader } },
    { "glBeginOcclusionQueryNV", { GLextension::GL_NV_occlusion_query } },
    { "glBeginPerfMonitorAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glBeginPerfQueryINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glBeginQueryARB", { GLextension::GL_ARB_occlusion_query } },
    { "glBeginQueryIndexed", { GLextension::GL_ARB_transform_feedback3 } },
    { "glBeginTransformFeedbackEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glBeginTransformFeedbackNV", { GLextension::GL_NV_transform_feedback } },
    { "glBeginVertexShaderEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBeginVideoCaptureNV", { GLextension::GL_NV_video_capture } },
    { "glBindAttribLocationARB", { GLextension::GL_ARB_vertex_shader } },
    { "glBindBufferARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glBindBufferBase", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glBindBufferBaseEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glBindBufferBaseNV", { GLextension::GL_NV_transform_feedback } },
    { "glBindBufferOffsetEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glBindBufferOffsetNV", { GLextension::GL_NV_transform_feedback } },
    { "glBindBufferRange", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glBindBufferRangeEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glBindBufferRangeNV", { GLextension::GL_NV_transform_feedback } },
    { "glBindBuffersBase", { GLextension::GL_ARB_multi_bind } },
    { "glBindBuffersRange", { GLextension::GL_ARB_multi_bind } },
    { "glBindFragDataLocationEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glBindFragDataLocationIndexed", { GLextension::GL_ARB_blend_func_extended } },
    { "glBindFragmentShaderATI", { GLextension::GL_ATI_fragment_shader } },
    { "glBindFramebuffer", { GLextension::GL_ARB_framebuffer_object } },
    { "glBindFramebufferEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glBindImageTexture", { GLextension::GL_ARB_shader_image_load_store } },
    { "glBindImageTextureEXT", { GLextension::GL_EXT_shader_image_load_store } },
    { "glBindImageTextures", { GLextension::GL_ARB_multi_bind } },
    { "glBindLightParameterEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBindMaterialParameterEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBindMultiTextureEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glBindParameterEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBindProgramARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glBindProgramNV", { GLextension::GL_NV_vertex_program } },
    { "glBindProgramPipeline", { GLextension::GL_ARB_separate_shader_objects } },
    { "glBindProgramPipelineEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glBindRenderbuffer", { GLextension::GL_ARB_framebuffer_object } },
    { "glBindRenderbufferEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glBindSampler", { GLextension::GL_ARB_sampler_objects } },
    { "glBindSamplers", { GLextension::GL_ARB_multi_bind } },
    { "glBindShadingRateImageNV", { GLextension::GL_NV_shading_rate_image } },
    { "glBindTexGenParameterEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBindTextureEXT", { GLextension::GL_EXT_texture_object } },
    { "glBindTextureUnit", { GLextension::GL_ARB_direct_state_access } },
    { "glBindTextureUnitParameterEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBindTextures", { GLextension::GL_ARB_multi_bind } },
    { "glBindTransformFeedback", { GLextension::GL_ARB_transform_feedback2 } },
    { "glBindTransformFeedbackNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glBindVertexArray", { GLextension::GL_ARB_vertex_array_object } },
    { "glBindVertexArrayAPPLE", { GLextension::GL_APPLE_vertex_array_object } },
    { "glBindVertexBuffer", { GLextension::GL_ARB_vertex_attrib_binding } },
    { "glBindVertexBuffers", { GLextension::GL_ARB_multi_bind } },
    { "glBindVertexShaderEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glBindVideoCaptureStreamBufferNV", { GLextension::GL_NV_video_capture } },
    { "glBindVideoCaptureStreamTextureNV", { GLextension::GL_NV_video_capture } },
    { "glBinormal3bEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3bvEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3dEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3dvEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3fEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3fvEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3iEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3ivEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3sEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormal3svEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBinormalPointerEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glBitmapxOES", { GLextension::GL_OES_fixed_point } },
    { "glBlendBarrierKHR", { GLextension::GL_KHR_blend_equation_advanced } },
    { "glBlendBarrierNV", { GLextension::GL_NV_blend_equation_advanced } },
    { "glBlendColor", { GLextension::GL_ARB_imaging } },
    { "glBlendColorEXT", { GLextension::GL_EXT_blend_color } },
    { "glBlendColorxOES", { GLextension::GL_OES_fixed_point } },
    { "glBlendEquation", { GLextension::GL_ARB_imaging } },
    { "glBlendEquationEXT", { GLextension::GL_EXT_blend_minmax } },
    { "glBlendEquationIndexedAMD", { GLextension::GL_AMD_draw_buffers_blend } },
    { "glBlendEquationSeparateEXT", { GLextension::GL_EXT_blend_equation_separate } },
    { "glBlendEquationSeparateIndexedAMD", { GLextension::GL_AMD_draw_buffers_blend } },
    { "glBlendEquationSeparateiARB", { GLextension::GL_ARB_draw_buffers_blend } },
    { "glBlendEquationiARB", { GLextension::GL_ARB_draw_buffers_blend } },
    { "glBlendFuncIndexedAMD", { GLextension::GL_AMD_draw_buffers_blend } },
    { "glBlendFuncSeparateEXT", { GLextension::GL_EXT_blend_func_separate } },
    { "glBlendFuncSeparateINGR", { GLextension::GL_INGR_blend_func_separate } },
    { "glBlendFuncSeparateIndexedAMD", { GLextension::GL_AMD_draw_buffers_blend } },
    { "glBlendFuncSeparateiARB", { GLextension::GL_ARB_draw_buffers_blend } },
    { "glBlendFunciARB", { GLextension::GL_ARB_draw_buffers_blend } },
    { "glBlendParameteriNV", { GLextension::GL_NV_blend_equation_advanced } },
    { "glBlitFramebuffer", { GLextension::GL_ARB_framebuffer_object } },
    { "glBlitFramebufferEXT", { GLextension::GL_EXT_framebuffer_blit } },
    { "glBlitNamedFramebuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glBufferAddressRangeNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glBufferAttachMemoryNV", { GLextension::GL_NV_memory_attachment } },
    { "glBufferDataARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glBufferPageCommitmentARB", { GLextension::GL_ARB_sparse_buffer } },
    { "glBufferPageCommitmentMemNV", { GLextension::GL_NV_memory_object_sparse } },
    { "glBufferParameteriAPPLE", { GLextension::GL_APPLE_flush_buffer_range } },
    { "glBufferStorage", { GLextension::GL_ARB_buffer_storage } },
    { "glBufferStorageExternalEXT", { GLextension::GL_EXT_external_buffer } },
    { "glBufferStorageMemEXT", { GLextension::GL_EXT_memory_object } },
    { "glBufferSubDataARB", { GLextension::GL_ARB_vertex_buffer_object } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_C =
{
    { "glCallCommandListNV", { GLextension::GL_NV_command_list } },
    { "glCheckFramebufferStatus", { GLextension::GL_ARB_framebuffer_object } },
    { "glCheckFramebufferStatusEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glCheckNamedFramebufferStatus", { GLextension::GL_ARB_direct_state_access } },
    { "glCheckNamedFramebufferStatusEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glClampColorARB", { GLextension::GL_ARB_color_buffer_float } },
    { "glClearAccumxOES", { GLextension::GL_OES_fixed_point } },
    { "glClearBufferData", { GLextension::GL_ARB_clear_buffer_object } },
    { "glClearBufferSubData", { GLextension::GL_ARB_clear_buffer_object } },
    { "glClearColorIiEXT", { GLextension::GL_EXT_texture_integer } },
    { "glClearColorIuiEXT", { GLextension::GL_EXT_texture_integer } },
    { "glClearColorxOES", { GLextension::GL_OES_fixed_point } },
    { "glClearDepthdNV", { GLextension::GL_NV_depth_buffer_float } },
    { "glClearDepthf", { GLextension::GL_ARB_ES2_compatibility } },
    { "glClearDepthfOES", { GLextension::GL_OES_single_precision } },
    { "glClearDepthxOES", { GLextension::GL_OES_fixed_point } },
    { "glClearNamedBufferData", { GLextension::GL_ARB_direct_state_access } },
    { "glClearNamedBufferDataEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glClearNamedBufferSubData", { GLextension::GL_ARB_direct_state_access } },
    { "glClearNamedBufferSubDataEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glClearNamedFramebufferfi", { GLextension::GL_ARB_direct_state_access } },
    { "glClearNamedFramebufferfv", { GLextension::GL_ARB_direct_state_access } },
    { "glClearNamedFramebufferiv", { GLextension::GL_ARB_direct_state_access } },
    { "glClearNamedFramebufferuiv", { GLextension::GL_ARB_direct_state_access } },
    { "glClearTexImage", { GLextension::GL_ARB_clear_texture } },
    { "glClearTexSubImage", { GLextension::GL_ARB_clear_texture } },
    { "glClientActiveTextureARB", { GLextension::GL_ARB_multitexture } },
    { "glClientActiveVertexStreamATI", { GLextension::GL_ATI_vertex_streams } },
    { "glClientAttribDefaultEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glClientWaitSemaphoreui64NVX", { GLextension::GL_NVX_progress_fence } },
    { "glClientWaitSync", { GLextension::GL_ARB_sync } },
    { "glClipControl", { GLextension::GL_ARB_clip_control } },
    { "glClipPlanefOES", { GLextension::GL_OES_single_precision } },
    { "glClipPlanexOES", { GLextension::GL_OES_fixed_point } },
    { "glColor3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glColor3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glColor3hNV", { GLextension::GL_NV_half_float } },
    { "glColor3hvNV", { GLextension::GL_NV_half_float } },
    { "glColor3xOES", { GLextension::GL_OES_fixed_point } },
    { "glColor3xvOES", { GLextension::GL_OES_fixed_point } },
    { "glColor4fNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glColor4fNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glColor4hNV", { GLextension::GL_NV_half_float } },
    { "glColor4hvNV", { GLextension::GL_NV_half_float } },
    { "glColor4ubVertex2fSUN", { GLextension::GL_SUN_vertex } },
    { "glColor4ubVertex2fvSUN", { GLextension::GL_SUN_vertex } },
    { "glColor4ubVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glColor4ubVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glColor4xOES", { GLextension::GL_OES_fixed_point } },
    { "glColor4xvOES", { GLextension::GL_OES_fixed_point } },
    { "glColorFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glColorFragmentOp1ATI", { GLextension::GL_ATI_fragment_shader } },
    { "glColorFragmentOp2ATI", { GLextension::GL_ATI_fragment_shader } },
    { "glColorFragmentOp3ATI", { GLextension::GL_ATI_fragment_shader } },
    { "glColorMaskIndexedEXT", { GLextension::GL_EXT_draw_buffers2 } },
    { "glColorP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glColorP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glColorP4ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glColorP4uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glColorPointerEXT", { GLextension::GL_EXT_vertex_array } },
    { "glColorPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glColorPointervINTEL", { GLextension::GL_INTEL_parallel_arrays } },
    { "glColorSubTable", { GLextension::GL_ARB_imaging } },
    { "glColorSubTableEXT", { GLextension::GL_EXT_color_subtable } },
    { "glColorTable", { GLextension::GL_ARB_imaging } },
    { "glColorTableEXT", { GLextension::GL_EXT_paletted_texture } },
    { "glColorTableParameterfv", { GLextension::GL_ARB_imaging } },
    { "glColorTableParameterfvSGI", { GLextension::GL_SGI_color_table } },
    { "glColorTableParameteriv", { GLextension::GL_ARB_imaging } },
    { "glColorTableParameterivSGI", { GLextension::GL_SGI_color_table } },
    { "glColorTableSGI", { GLextension::GL_SGI_color_table } },
    { "glCombinerInputNV", { GLextension::GL_NV_register_combiners } },
    { "glCombinerOutputNV", { GLextension::GL_NV_register_combiners } },
    { "glCombinerParameterfNV", { GLextension::GL_NV_register_combiners } },
    { "glCombinerParameterfvNV", { GLextension::GL_NV_register_combiners } },
    { "glCombinerParameteriNV", { GLextension::GL_NV_register_combiners } },
    { "glCombinerParameterivNV", { GLextension::GL_NV_register_combiners } },
    { "glCombinerStageParameterfvNV", { GLextension::GL_NV_register_combiners2 } },
    { "glCommandListSegmentsNV", { GLextension::GL_NV_command_list } },
    { "glCompileCommandListNV", { GLextension::GL_NV_command_list } },
    { "glCompileShaderARB", { GLextension::GL_ARB_shader_objects } },
    { "glCompileShaderIncludeARB", { GLextension::GL_ARB_shading_language_include } },
    { "glCompressedMultiTexImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedMultiTexImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedMultiTexImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedMultiTexSubImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedMultiTexSubImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedMultiTexSubImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedTexImage1DARB", { GLextension::GL_ARB_texture_compression } },
    { "glCompressedTexImage2DARB", { GLextension::GL_ARB_texture_compression } },
    { "glCompressedTexImage3DARB", { GLextension::GL_ARB_texture_compression } },
    { "glCompressedTexSubImage1DARB", { GLextension::GL_ARB_texture_compression } },
    { "glCompressedTexSubImage2DARB", { GLextension::GL_ARB_texture_compression } },
    { "glCompressedTexSubImage3DARB", { GLextension::GL_ARB_texture_compression } },
    { "glCompressedTextureImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedTextureImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedTextureImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedTextureSubImage1D", { GLextension::GL_ARB_direct_state_access } },
    { "glCompressedTextureSubImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedTextureSubImage2D", { GLextension::GL_ARB_direct_state_access } },
    { "glCompressedTextureSubImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCompressedTextureSubImage3D", { GLextension::GL_ARB_direct_state_access } },
    { "glCompressedTextureSubImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glConservativeRasterParameterfNV", { GLextension::GL_NV_conservative_raster_dilate } },
    { "glConservativeRasterParameteriNV", { GLextension::GL_NV_conservative_raster_pre_snap_triangles } },
    { "glConvolutionFilter1D", { GLextension::GL_ARB_imaging } },
    { "glConvolutionFilter1DEXT", { GLextension::GL_EXT_convolution } },
    { "glConvolutionFilter2D", { GLextension::GL_ARB_imaging } },
    { "glConvolutionFilter2DEXT", { GLextension::GL_EXT_convolution } },
    { "glConvolutionParameterf", { GLextension::GL_ARB_imaging } },
    { "glConvolutionParameterfEXT", { GLextension::GL_EXT_convolution } },
    { "glConvolutionParameterfv", { GLextension::GL_ARB_imaging } },
    { "glConvolutionParameterfvEXT", { GLextension::GL_EXT_convolution } },
    { "glConvolutionParameteri", { GLextension::GL_ARB_imaging } },
    { "glConvolutionParameteriEXT", { GLextension::GL_EXT_convolution } },
    { "glConvolutionParameteriv", { GLextension::GL_ARB_imaging } },
    { "glConvolutionParameterivEXT", { GLextension::GL_EXT_convolution } },
    { "glConvolutionParameterxOES", { GLextension::GL_OES_fixed_point } },
    { "glConvolutionParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glCopyBufferSubData", { GLextension::GL_ARB_copy_buffer } },
    { "glCopyColorSubTable", { GLextension::GL_ARB_imaging } },
    { "glCopyColorSubTableEXT", { GLextension::GL_EXT_color_subtable } },
    { "glCopyColorTable", { GLextension::GL_ARB_imaging } },
    { "glCopyColorTableSGI", { GLextension::GL_SGI_color_table } },
    { "glCopyConvolutionFilter1D", { GLextension::GL_ARB_imaging } },
    { "glCopyConvolutionFilter1DEXT", { GLextension::GL_EXT_convolution } },
    { "glCopyConvolutionFilter2D", { GLextension::GL_ARB_imaging } },
    { "glCopyConvolutionFilter2DEXT", { GLextension::GL_EXT_convolution } },
    { "glCopyImageSubData", { GLextension::GL_ARB_copy_image } },
    { "glCopyImageSubDataNV", { GLextension::GL_NV_copy_image } },
    { "glCopyMultiTexImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyMultiTexImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyMultiTexSubImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyMultiTexSubImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyMultiTexSubImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyNamedBufferSubData", { GLextension::GL_ARB_direct_state_access } },
    { "glCopyPathNV", { GLextension::GL_NV_path_rendering } },
    { "glCopyTexImage1DEXT", { GLextension::GL_EXT_copy_texture } },
    { "glCopyTexImage2DEXT", { GLextension::GL_EXT_copy_texture } },
    { "glCopyTexSubImage1DEXT", { GLextension::GL_EXT_copy_texture } },
    { "glCopyTexSubImage2DEXT", { GLextension::GL_EXT_copy_texture } },
    { "glCopyTexSubImage3DEXT", { GLextension::GL_EXT_copy_texture } },
    { "glCopyTextureImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyTextureImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyTextureSubImage1D", { GLextension::GL_ARB_direct_state_access } },
    { "glCopyTextureSubImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyTextureSubImage2D", { GLextension::GL_ARB_direct_state_access } },
    { "glCopyTextureSubImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCopyTextureSubImage3D", { GLextension::GL_ARB_direct_state_access } },
    { "glCopyTextureSubImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glCoverFillPathInstancedNV", { GLextension::GL_NV_path_rendering } },
    { "glCoverFillPathNV", { GLextension::GL_NV_path_rendering } },
    { "glCoverStrokePathInstancedNV", { GLextension::GL_NV_path_rendering } },
    { "glCoverStrokePathNV", { GLextension::GL_NV_path_rendering } },
    { "glCoverageModulationNV", { GLextension::GL_NV_framebuffer_mixed_samples } },
    { "glCoverageModulationTableNV", { GLextension::GL_NV_framebuffer_mixed_samples } },
    { "glCreateBuffers", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateCommandListsNV", { GLextension::GL_NV_command_list } },
    { "glCreateFramebuffers", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateMemoryObjectsEXT", { GLextension::GL_EXT_memory_object } },
    { "glCreatePerfQueryINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glCreateProgramObjectARB", { GLextension::GL_ARB_shader_objects } },
    { "glCreateProgramPipelines", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateProgressFenceNVX", { GLextension::GL_NVX_progress_fence } },
    { "glCreateQueries", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateRenderbuffers", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateSamplers", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateSemaphoresNV", { GLextension::GL_NV_timeline_semaphore } },
    { "glCreateShaderObjectARB", { GLextension::GL_ARB_shader_objects } },
    { "glCreateShaderProgramEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glCreateShaderProgramv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glCreateShaderProgramvEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glCreateStatesNV", { GLextension::GL_NV_command_list } },
    { "glCreateSyncFromCLeventARB", { GLextension::GL_ARB_cl_event } },
    { "glCreateTextures", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateTransformFeedbacks", { GLextension::GL_ARB_direct_state_access } },
    { "glCreateVertexArrays", { GLextension::GL_ARB_direct_state_access } },
    { "glCullParameterdvEXT", { GLextension::GL_EXT_cull_vertex } },
    { "glCullParameterfvEXT", { GLextension::GL_EXT_cull_vertex } },
    { "glCurrentPaletteMatrixARB", { GLextension::GL_ARB_matrix_palette } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_D =
{
    { "glDebugMessageCallback", { GLextension::GL_KHR_debug } },
    { "glDebugMessageCallbackAMD", { GLextension::GL_AMD_debug_output } },
    { "glDebugMessageCallbackARB", { GLextension::GL_ARB_debug_output } },
    { "glDebugMessageCallbackKHR", { GLextension::GL_KHR_debug } },
    { "glDebugMessageControl", { GLextension::GL_KHR_debug } },
    { "glDebugMessageControlARB", { GLextension::GL_ARB_debug_output } },
    { "glDebugMessageControlKHR", { GLextension::GL_KHR_debug } },
    { "glDebugMessageEnableAMD", { GLextension::GL_AMD_debug_output } },
    { "glDebugMessageInsert", { GLextension::GL_KHR_debug } },
    { "glDebugMessageInsertAMD", { GLextension::GL_AMD_debug_output } },
    { "glDebugMessageInsertARB", { GLextension::GL_ARB_debug_output } },
    { "glDebugMessageInsertKHR", { GLextension::GL_KHR_debug } },
    { "glDeformSGIX", { GLextension::GL_SGIX_polynomial_ffd } },
    { "glDeformationMap3dSGIX", { GLextension::GL_SGIX_polynomial_ffd } },
    { "glDeformationMap3fSGIX", { GLextension::GL_SGIX_polynomial_ffd } },
    { "glDeleteAsyncMarkersSGIX", { GLextension::GL_SGIX_async } },
    { "glDeleteBuffersARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glDeleteCommandListsNV", { GLextension::GL_NV_command_list } },
    { "glDeleteFencesAPPLE", { GLextension::GL_APPLE_fence } },
    { "glDeleteFencesNV", { GLextension::GL_NV_fence } },
    { "glDeleteFragmentShaderATI", { GLextension::GL_ATI_fragment_shader } },
    { "glDeleteFramebuffers", { GLextension::GL_ARB_framebuffer_object } },
    { "glDeleteFramebuffersEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glDeleteMemoryObjectsEXT", { GLextension::GL_EXT_memory_object } },
    { "glDeleteNamedStringARB", { GLextension::GL_ARB_shading_language_include } },
    { "glDeleteNamesAMD", { GLextension::GL_AMD_name_gen_delete } },
    { "glDeleteObjectARB", { GLextension::GL_ARB_shader_objects } },
    { "glDeleteOcclusionQueriesNV", { GLextension::GL_NV_occlusion_query } },
    { "glDeletePathsNV", { GLextension::GL_NV_path_rendering } },
    { "glDeletePerfMonitorsAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glDeletePerfQueryINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glDeleteProgramPipelines", { GLextension::GL_ARB_separate_shader_objects } },
    { "glDeleteProgramPipelinesEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glDeleteProgramsARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glDeleteProgramsNV", { GLextension::GL_NV_vertex_program } },
    { "glDeleteQueriesARB", { GLextension::GL_ARB_occlusion_query } },
    { "glDeleteQueryResourceTagNV", { GLextension::GL_NV_query_resource_tag } },
    { "glDeleteRenderbuffers", { GLextension::GL_ARB_framebuffer_object } },
    { "glDeleteRenderbuffersEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glDeleteSamplers", { GLextension::GL_ARB_sampler_objects } },
    { "glDeleteSemaphoresEXT", { GLextension::GL_EXT_semaphore } },
    { "glDeleteStatesNV", { GLextension::GL_NV_command_list } },
    { "glDeleteSync", { GLextension::GL_ARB_sync } },
    { "glDeleteTexturesEXT", { GLextension::GL_EXT_texture_object } },
    { "glDeleteTransformFeedbacks", { GLextension::GL_ARB_transform_feedback2 } },
    { "glDeleteTransformFeedbacksNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glDeleteVertexArrays", { GLextension::GL_ARB_vertex_array_object } },
    { "glDeleteVertexArraysAPPLE", { GLextension::GL_APPLE_vertex_array_object } },
    { "glDeleteVertexShaderEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glDepthBoundsEXT", { GLextension::GL_EXT_depth_bounds_test } },
    { "glDepthBoundsdNV", { GLextension::GL_NV_depth_buffer_float } },
    { "glDepthRangeArraydvNV", { GLextension::GL_ARB_viewport_array } },
    { "glDepthRangeArrayv", { GLextension::GL_ARB_viewport_array } },
    { "glDepthRangeIndexed", { GLextension::GL_ARB_viewport_array } },
    { "glDepthRangeIndexeddNV", { GLextension::GL_ARB_viewport_array } },
    { "glDepthRangedNV", { GLextension::GL_NV_depth_buffer_float } },
    { "glDepthRangef", { GLextension::GL_ARB_ES2_compatibility } },
    { "glDepthRangefOES", { GLextension::GL_OES_single_precision } },
    { "glDepthRangexOES", { GLextension::GL_OES_fixed_point } },
    { "glDetachObjectARB", { GLextension::GL_ARB_shader_objects } },
    { "glDetailTexFuncSGIS", { GLextension::GL_SGIS_detail_texture } },
    { "glDisableClientStateIndexedEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glDisableClientStateiEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glDisableIndexedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_draw_buffers2 } },
    { "glDisableVariantClientStateEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glDisableVertexArrayAttrib", { GLextension::GL_ARB_direct_state_access } },
    { "glDisableVertexArrayAttribEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glDisableVertexArrayEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glDisableVertexAttribAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } },
    { "glDisableVertexAttribArrayARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glDispatchCompute", { GLextension::GL_ARB_compute_shader } },
    { "glDispatchComputeGroupSizeARB", { GLextension::GL_ARB_compute_variable_group_size } },
    { "glDispatchComputeIndirect", { GLextension::GL_ARB_compute_shader } },
    { "glDrawArraysEXT", { GLextension::GL_EXT_vertex_array } },
    { "glDrawArraysIndirect", { GLextension::GL_ARB_draw_indirect } },
    { "glDrawArraysInstancedARB", { GLextension::GL_ARB_draw_instanced } },
    { "glDrawArraysInstancedBaseInstance", { GLextension::GL_ARB_base_instance } },
    { "glDrawArraysInstancedEXT", { GLextension::GL_EXT_draw_instanced } },
    { "glDrawBuffersARB", { GLextension::GL_ARB_draw_buffers } },
    { "glDrawBuffersATI", { GLextension::GL_ATI_draw_buffers } },
    { "glDrawCommandsAddressNV", { GLextension::GL_NV_command_list } },
    { "glDrawCommandsNV", { GLextension::GL_NV_command_list } },
    { "glDrawCommandsStatesAddressNV", { GLextension::GL_NV_command_list } },
    { "glDrawCommandsStatesNV", { GLextension::GL_NV_command_list } },
    { "glDrawElementArrayAPPLE", { GLextension::GL_APPLE_element_array } },
    { "glDrawElementArrayATI", { GLextension::GL_ATI_element_array } },
    { "glDrawElementsBaseVertex", { GLextension::GL_ARB_draw_elements_base_vertex } },
    { "glDrawElementsIndirect", { GLextension::GL_ARB_draw_indirect } },
    { "glDrawElementsInstancedARB", { GLextension::GL_ARB_draw_instanced } },
    { "glDrawElementsInstancedBaseInstance", { GLextension::GL_ARB_base_instance } },
    { "glDrawElementsInstancedBaseVertex", { GLextension::GL_ARB_draw_elements_base_vertex } },
    { "glDrawElementsInstancedBaseVertexBaseInstance", { GLextension::GL_ARB_base_instance } },
    { "glDrawElementsInstancedEXT", { GLextension::GL_EXT_draw_instanced } },
    { "glDrawMeshArraysSUN", { GLextension::GL_SUN_mesh_array } },
    { "glDrawMeshTasksIndirectNV", { GLextension::GL_NV_mesh_shader } },
    { "glDrawMeshTasksNV", { GLextension::GL_NV_mesh_shader } },
    { "glDrawRangeElementArrayAPPLE", { GLextension::GL_APPLE_element_array } },
    { "glDrawRangeElementArrayATI", { GLextension::GL_ATI_element_array } },
    { "glDrawRangeElementsBaseVertex", { GLextension::GL_ARB_draw_elements_base_vertex } },
    { "glDrawRangeElementsEXT", { GLextension::GL_EXT_draw_range_elements } },
    { "glDrawTextureNV", { GLextension::GL_NV_draw_texture } },
    { "glDrawTransformFeedback", { GLextension::GL_ARB_transform_feedback2 } },
    { "glDrawTransformFeedbackInstanced", { GLextension::GL_ARB_transform_feedback_instanced } },
    { "glDrawTransformFeedbackNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glDrawTransformFeedbackStream", { GLextension::GL_ARB_transform_feedback3 } },
    { "glDrawTransformFeedbackStreamInstanced", { GLextension::GL_ARB_transform_feedback_instanced } },
    { "glDrawVkImageNV", { GLextension::GL_NV_draw_vulkan_image } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_E =
{
    { "glEGLImageTargetTexStorageEXT", { GLextension::GL_EXT_EGL_image_storage } },
    { "glEGLImageTargetTextureStorageEXT", { GLextension::GL_EXT_EGL_image_storage } },
    { "glEdgeFlagFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glEdgeFlagPointerEXT", { GLextension::GL_EXT_vertex_array } },
    { "glEdgeFlagPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glElementPointerAPPLE", { GLextension::GL_APPLE_element_array } },
    { "glElementPointerATI", { GLextension::GL_ATI_element_array } },
    { "glEnableClientStateIndexedEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glEnableClientStateiEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glEnableIndexedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_draw_buffers2 } },
    { "glEnableVariantClientStateEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glEnableVertexArrayAttrib", { GLextension::GL_ARB_direct_state_access } },
    { "glEnableVertexArrayAttribEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glEnableVertexArrayEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glEnableVertexAttribAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } },
    { "glEnableVertexAttribArrayARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glEndConditionalRenderNV", { GLextension::GL_NV_conditional_render } },
    { "glEndConditionalRenderNVX", { GLextension::GL_NVX_conditional_render } },
    { "glEndFragmentShaderATI", { GLextension::GL_ATI_fragment_shader } },
    { "glEndOcclusionQueryNV", { GLextension::GL_NV_occlusion_query } },
    { "glEndPerfMonitorAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glEndPerfQueryINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glEndQueryARB", { GLextension::GL_ARB_occlusion_query } },
    { "glEndQueryIndexed", { GLextension::GL_ARB_transform_feedback3 } },
    { "glEndTransformFeedbackEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glEndTransformFeedbackNV", { GLextension::GL_NV_transform_feedback } },
    { "glEndVertexShaderEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glEndVideoCaptureNV", { GLextension::GL_NV_video_capture } },
    { "glEvalCoord1xOES", { GLextension::GL_OES_fixed_point } },
    { "glEvalCoord1xvOES", { GLextension::GL_OES_fixed_point } },
    { "glEvalCoord2xOES", { GLextension::GL_OES_fixed_point } },
    { "glEvalCoord2xvOES", { GLextension::GL_OES_fixed_point } },
    { "glEvalMapsNV", { GLextension::GL_NV_evaluators } },
    { "glEvaluateDepthValuesARB", { GLextension::GL_ARB_sample_locations } },
    { "glExecuteProgramNV", { GLextension::GL_NV_vertex_program } },
    { "glExtractComponentEXT", { GLextension::GL_EXT_vertex_shader } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_F =
{
    { "glFeedbackBufferxOES", { GLextension::GL_OES_fixed_point } },
    { "glFenceSync", { GLextension::GL_ARB_sync } },
    { "glFinalCombinerInputNV", { GLextension::GL_NV_register_combiners } },
    { "glFinishAsyncSGIX", { GLextension::GL_SGIX_async } },
    { "glFinishFenceAPPLE", { GLextension::GL_APPLE_fence } },
    { "glFinishFenceNV", { GLextension::GL_NV_fence } },
    { "glFinishObjectAPPLE", { GLextension::GL_APPLE_fence } },
    { "glFinishTextureSUNX", { GLextension::GL_SUNX_constant_data } },
    { "glFlushMappedBufferRange", { GLextension::GL_ARB_map_buffer_range } },
    { "glFlushMappedBufferRangeAPPLE", { GLextension::GL_APPLE_flush_buffer_range } },
    { "glFlushMappedNamedBufferRange", { GLextension::GL_ARB_direct_state_access } },
    { "glFlushMappedNamedBufferRangeEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glFlushPixelDataRangeNV", { GLextension::GL_NV_pixel_data_range } },
    { "glFlushRasterSGIX", { GLextension::GL_SGIX_flush_raster } },
    { "glFlushStaticDataIBM", { GLextension::GL_IBM_static_data } },
    { "glFlushVertexArrayRangeAPPLE", { GLextension::GL_APPLE_vertex_array_range } },
    { "glFlushVertexArrayRangeNV", { GLextension::GL_NV_vertex_array_range } },
    { "glFogCoordFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glFogCoordPointerEXT", { GLextension::GL_EXT_fog_coord } },
    { "glFogCoordPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glFogCoorddEXT", { GLextension::GL_EXT_fog_coord } },
    { "glFogCoorddvEXT", { GLextension::GL_EXT_fog_coord } },
    { "glFogCoordfEXT", { GLextension::GL_EXT_fog_coord } },
    { "glFogCoordfvEXT", { GLextension::GL_EXT_fog_coord } },
    { "glFogCoordhNV", { GLextension::GL_NV_half_float } },
    { "glFogCoordhvNV", { GLextension::GL_NV_half_float } },
    { "glFogFuncSGIS", { GLextension::GL_SGIS_fog_function } },
    { "glFogxOES", { GLextension::GL_OES_fixed_point } },
    { "glFogxvOES", { GLextension::GL_OES_fixed_point } },
    { "glFragmentColorMaterialSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentCoverageColorNV", { GLextension::GL_NV_fragment_coverage_to_color } },
    { "glFragmentLightModelfSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightModelfvSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightModeliSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightModelivSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightfSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightfvSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightiSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentLightivSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentMaterialfSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentMaterialfvSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentMaterialiSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFragmentMaterialivSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glFrameTerminatorGREMEDY", { GLextension::GL_GREMEDY_frame_terminator } },
    { "glFrameZoomSGIX", { GLextension::GL_SGIX_framezoom } },
    { "glFramebufferDrawBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glFramebufferDrawBuffersEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glFramebufferFetchBarrierEXT", { GLextension::GL_EXT_shader_framebuffer_fetch_non_coherent } },
    { "glFramebufferParameteri", { GLextension::GL_ARB_framebuffer_no_attachments } },
    { "glFramebufferParameteriMESA", { GLextension::GL_MESA_framebuffer_flip_y } },
    { "glFramebufferReadBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glFramebufferRenderbuffer", { GLextension::GL_ARB_framebuffer_object } },
    { "glFramebufferRenderbufferEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glFramebufferSampleLocationsfvARB", { GLextension::GL_ARB_sample_locations } },
    { "glFramebufferSampleLocationsfvNV", { GLextension::GL_NV_sample_locations } },
    { "glFramebufferSamplePositionsfvAMD", { GLextension::GL_AMD_framebuffer_sample_positions } },
    { "glFramebufferTexture1D", { GLextension::GL_ARB_framebuffer_object } },
    { "glFramebufferTexture1DEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glFramebufferTexture2D", { GLextension::GL_ARB_framebuffer_object } },
    { "glFramebufferTexture2DEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glFramebufferTexture3D", { GLextension::GL_ARB_framebuffer_object } },
    { "glFramebufferTexture3DEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glFramebufferTextureARB", { GLextension::GL_ARB_geometry_shader4 } },
    { "glFramebufferTextureEXT", { GLextension::GL_NV_geometry_program4 } },
    { "glFramebufferTextureFaceARB", { GLextension::GL_ARB_geometry_shader4 } },
    { "glFramebufferTextureFaceEXT", { GLextension::GL_NV_geometry_program4 } },
    { "glFramebufferTextureLayer", { GLextension::GL_ARB_framebuffer_object } },
    { "glFramebufferTextureLayerARB", { GLextension::GL_ARB_geometry_shader4 } },
    { "glFramebufferTextureLayerEXT", { GLextension::GL_EXT_texture_array, GLextension::GL_NV_geometry_program4 } },
    { "glFramebufferTextureMultiviewOVR", { GLextension::GL_OVR_multiview } },
    { "glFreeObjectBufferATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glFrustumfOES", { GLextension::GL_OES_single_precision } },
    { "glFrustumxOES", { GLextension::GL_OES_fixed_point } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_G =
{
    { "glGenAsyncMarkersSGIX", { GLextension::GL_SGIX_async } },
    { "glGenBuffersARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glGenFencesAPPLE", { GLextension::GL_APPLE_fence } },
    { "glGenFencesNV", { GLextension::GL_NV_fence } },
    { "glGenFragmentShadersATI", { GLextension::GL_ATI_fragment_shader } },
    { "glGenFramebuffers", { GLextension::GL_ARB_framebuffer_object } },
    { "glGenFramebuffersEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glGenNamesAMD", { GLextension::GL_AMD_name_gen_delete } },
    { "glGenOcclusionQueriesNV", { GLextension::GL_NV_occlusion_query } },
    { "glGenPathsNV", { GLextension::GL_NV_path_rendering } },
    { "glGenPerfMonitorsAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGenProgramPipelines", { GLextension::GL_ARB_separate_shader_objects } },
    { "glGenProgramPipelinesEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glGenProgramsARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGenProgramsNV", { GLextension::GL_NV_vertex_program } },
    { "glGenQueriesARB", { GLextension::GL_ARB_occlusion_query } },
    { "glGenQueryResourceTagNV", { GLextension::GL_NV_query_resource_tag } },
    { "glGenRenderbuffers", { GLextension::GL_ARB_framebuffer_object } },
    { "glGenRenderbuffersEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glGenSamplers", { GLextension::GL_ARB_sampler_objects } },
    { "glGenSemaphoresEXT", { GLextension::GL_EXT_semaphore } },
    { "glGenSymbolsEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGenTexturesEXT", { GLextension::GL_EXT_texture_object } },
    { "glGenTransformFeedbacks", { GLextension::GL_ARB_transform_feedback2 } },
    { "glGenTransformFeedbacksNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glGenVertexArrays", { GLextension::GL_ARB_vertex_array_object } },
    { "glGenVertexArraysAPPLE", { GLextension::GL_APPLE_vertex_array_object } },
    { "glGenVertexShadersEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGenerateMipmap", { GLextension::GL_ARB_framebuffer_object } },
    { "glGenerateMipmapEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glGenerateMultiTexMipmapEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGenerateTextureMipmap", { GLextension::GL_ARB_direct_state_access } },
    { "glGenerateTextureMipmapEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetActiveAtomicCounterBufferiv", { GLextension::GL_ARB_shader_atomic_counters } },
    { "glGetActiveAttribARB", { GLextension::GL_ARB_vertex_shader } },
    { "glGetActiveSubroutineName", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetActiveSubroutineUniformName", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetActiveSubroutineUniformiv", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetActiveUniformARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetActiveUniformBlockName", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetActiveUniformBlockiv", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetActiveUniformName", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetActiveUniformsiv", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetActiveVaryingNV", { GLextension::GL_NV_transform_feedback } },
    { "glGetArrayObjectfvATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glGetArrayObjectivATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glGetAttachedObjectsARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetAttribLocationARB", { GLextension::GL_ARB_vertex_shader } },
    { "glGetBooleanIndexedvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_draw_buffers2 } },
    { "glGetBufferParameterivARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glGetBufferParameterui64vNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glGetBufferPointervARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glGetBufferSubDataARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glGetClipPlanefOES", { GLextension::GL_OES_single_precision } },
    { "glGetClipPlanexOES", { GLextension::GL_OES_fixed_point } },
    { "glGetColorTable", { GLextension::GL_ARB_imaging } },
    { "glGetColorTableEXT", { GLextension::GL_EXT_paletted_texture } },
    { "glGetColorTableParameterfv", { GLextension::GL_ARB_imaging } },
    { "glGetColorTableParameterfvEXT", { GLextension::GL_EXT_paletted_texture } },
    { "glGetColorTableParameterfvSGI", { GLextension::GL_SGI_color_table } },
    { "glGetColorTableParameteriv", { GLextension::GL_ARB_imaging } },
    { "glGetColorTableParameterivEXT", { GLextension::GL_EXT_paletted_texture } },
    { "glGetColorTableParameterivSGI", { GLextension::GL_SGI_color_table } },
    { "glGetColorTableSGI", { GLextension::GL_SGI_color_table } },
    { "glGetCombinerInputParameterfvNV", { GLextension::GL_NV_register_combiners } },
    { "glGetCombinerInputParameterivNV", { GLextension::GL_NV_register_combiners } },
    { "glGetCombinerOutputParameterfvNV", { GLextension::GL_NV_register_combiners } },
    { "glGetCombinerOutputParameterivNV", { GLextension::GL_NV_register_combiners } },
    { "glGetCombinerStageParameterfvNV", { GLextension::GL_NV_register_combiners2 } },
    { "glGetCommandHeaderNV", { GLextension::GL_NV_command_list } },
    { "glGetCompressedMultiTexImageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetCompressedTexImageARB", { GLextension::GL_ARB_texture_compression } },
    { "glGetCompressedTextureImage", { GLextension::GL_ARB_direct_state_access } },
    { "glGetCompressedTextureImageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetCompressedTextureSubImage", { GLextension::GL_ARB_get_texture_sub_image } },
    { "glGetConvolutionFilter", { GLextension::GL_ARB_imaging } },
    { "glGetConvolutionFilterEXT", { GLextension::GL_EXT_convolution } },
    { "glGetConvolutionParameterfv", { GLextension::GL_ARB_imaging } },
    { "glGetConvolutionParameterfvEXT", { GLextension::GL_EXT_convolution } },
    { "glGetConvolutionParameteriv", { GLextension::GL_ARB_imaging } },
    { "glGetConvolutionParameterivEXT", { GLextension::GL_EXT_convolution } },
    { "glGetConvolutionParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetCoverageModulationTableNV", { GLextension::GL_NV_framebuffer_mixed_samples } },
    { "glGetDebugMessageLog", { GLextension::GL_KHR_debug } },
    { "glGetDebugMessageLogAMD", { GLextension::GL_AMD_debug_output } },
    { "glGetDebugMessageLogARB", { GLextension::GL_ARB_debug_output } },
    { "glGetDebugMessageLogKHR", { GLextension::GL_KHR_debug } },
    { "glGetDetailTexFuncSGIS", { GLextension::GL_SGIS_detail_texture } },
    { "glGetDoubleIndexedvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetDoublei_v", { GLextension::GL_ARB_viewport_array } },
    { "glGetDoublei_vEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetFenceivNV", { GLextension::GL_NV_fence } },
    { "glGetFinalCombinerInputParameterfvNV", { GLextension::GL_NV_register_combiners } },
    { "glGetFinalCombinerInputParameterivNV", { GLextension::GL_NV_register_combiners } },
    { "glGetFirstPerfQueryIdINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glGetFixedvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetFloatIndexedvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetFloati_v", { GLextension::GL_ARB_viewport_array } },
    { "glGetFloati_vEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetFogFuncSGIS", { GLextension::GL_SGIS_fog_function } },
    { "glGetFragDataIndex", { GLextension::GL_ARB_blend_func_extended } },
    { "glGetFragDataLocationEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glGetFragmentLightfvSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glGetFragmentLightivSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glGetFragmentMaterialfvSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glGetFragmentMaterialivSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glGetFramebufferAttachmentParameteriv", { GLextension::GL_ARB_framebuffer_object } },
    { "glGetFramebufferAttachmentParameterivEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glGetFramebufferParameterfvAMD", { GLextension::GL_AMD_framebuffer_sample_positions } },
    { "glGetFramebufferParameteriv", { GLextension::GL_ARB_framebuffer_no_attachments } },
    { "glGetFramebufferParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetFramebufferParameterivMESA", { GLextension::GL_MESA_framebuffer_flip_y } },
    { "glGetGraphicsResetStatus", { GLextension::GL_KHR_robustness } },
    { "glGetGraphicsResetStatusARB", { GLextension::GL_ARB_robustness } },
    { "glGetGraphicsResetStatusKHR", { GLextension::GL_KHR_robustness } },
    { "glGetHandleARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetHistogram", { GLextension::GL_ARB_imaging } },
    { "glGetHistogramEXT", { GLextension::GL_EXT_histogram } },
    { "glGetHistogramParameterfv", { GLextension::GL_ARB_imaging } },
    { "glGetHistogramParameterfvEXT", { GLextension::GL_EXT_histogram } },
    { "glGetHistogramParameteriv", { GLextension::GL_ARB_imaging } },
    { "glGetHistogramParameterivEXT", { GLextension::GL_EXT_histogram } },
    { "glGetHistogramParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetImageHandleARB", { GLextension::GL_ARB_bindless_texture } },
    { "glGetImageHandleNV", { GLextension::GL_NV_bindless_texture } },
    { "glGetImageTransformParameterfvHP", { GLextension::GL_HP_image_transform } },
    { "glGetImageTransformParameterivHP", { GLextension::GL_HP_image_transform } },
    { "glGetInfoLogARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetInstrumentsSGIX", { GLextension::GL_SGIX_instruments } },
    { "glGetInteger64v", { GLextension::GL_ARB_sync } },
    { "glGetIntegerIndexedvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_draw_buffers2 } },
    { "glGetIntegeri_v", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetIntegerui64i_vNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glGetIntegerui64vNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glGetInternalformatSampleivNV", { GLextension::GL_NV_internalformat_sample_query } },
    { "glGetInternalformati64v", { GLextension::GL_ARB_internalformat_query2 } },
    { "glGetInternalformativ", { GLextension::GL_ARB_internalformat_query } },
    { "glGetInvariantBooleanvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetInvariantFloatvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetInvariantIntegervEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetLightxOES", { GLextension::GL_OES_fixed_point } },
    { "glGetLightxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetListParameterfvSGIX", { GLextension::GL_SGIX_list_priority } },
    { "glGetListParameterivSGIX", { GLextension::GL_SGIX_list_priority } },
    { "glGetLocalConstantBooleanvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetLocalConstantFloatvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetLocalConstantIntegervEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetMapAttribParameterfvNV", { GLextension::GL_NV_evaluators } },
    { "glGetMapAttribParameterivNV", { GLextension::GL_NV_evaluators } },
    { "glGetMapControlPointsNV", { GLextension::GL_NV_evaluators } },
    { "glGetMapParameterfvNV", { GLextension::GL_NV_evaluators } },
    { "glGetMapParameterivNV", { GLextension::GL_NV_evaluators } },
    { "glGetMapxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetMaterialxOES", { GLextension::GL_OES_fixed_point } },
    { "glGetMaterialxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetMemoryObjectDetachedResourcesuivNV", { GLextension::GL_NV_memory_attachment } },
    { "glGetMemoryObjectParameterivEXT", { GLextension::GL_EXT_memory_object } },
    { "glGetMinmax", { GLextension::GL_ARB_imaging } },
    { "glGetMinmaxEXT", { GLextension::GL_EXT_histogram } },
    { "glGetMinmaxParameterfv", { GLextension::GL_ARB_imaging } },
    { "glGetMinmaxParameterfvEXT", { GLextension::GL_EXT_histogram } },
    { "glGetMinmaxParameteriv", { GLextension::GL_ARB_imaging } },
    { "glGetMinmaxParameterivEXT", { GLextension::GL_EXT_histogram } },
    { "glGetMultiTexEnvfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexEnvivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexGendvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexGenfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexGenivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexImageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexLevelParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexLevelParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexParameterIivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexParameterIuivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultiTexParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetMultisamplefv", { GLextension::GL_ARB_texture_multisample } },
    { "glGetMultisamplefvNV", { GLextension::GL_NV_explicit_multisample } },
    { "glGetNamedBufferParameteri64v", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedBufferParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedBufferParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedBufferParameterui64vNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glGetNamedBufferPointerv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedBufferPointervEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedBufferSubData", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedBufferSubDataEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedFramebufferAttachmentParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedFramebufferAttachmentParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedFramebufferParameterfvAMD", { GLextension::GL_AMD_framebuffer_sample_positions } },
    { "glGetNamedFramebufferParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedFramebufferParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedProgramLocalParameterIivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedProgramLocalParameterIuivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedProgramLocalParameterdvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedProgramLocalParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedProgramStringEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedProgramivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedRenderbufferParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetNamedRenderbufferParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetNamedStringARB", { GLextension::GL_ARB_shading_language_include } },
    { "glGetNamedStringivARB", { GLextension::GL_ARB_shading_language_include } },
    { "glGetNextPerfQueryIdINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glGetObjectBufferfvATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glGetObjectBufferivATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glGetObjectLabel", { GLextension::GL_KHR_debug } },
    { "glGetObjectLabelEXT", { GLextension::GL_EXT_debug_label } },
    { "glGetObjectLabelKHR", { GLextension::GL_KHR_debug } },
    { "glGetObjectParameterfvARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetObjectParameterivAPPLE", { GLextension::GL_APPLE_object_purgeable } },
    { "glGetObjectParameterivARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetObjectPtrLabel", { GLextension::GL_KHR_debug } },
    { "glGetObjectPtrLabelKHR", { GLextension::GL_KHR_debug } },
    { "glGetOcclusionQueryivNV", { GLextension::GL_NV_occlusion_query } },
    { "glGetOcclusionQueryuivNV", { GLextension::GL_NV_occlusion_query } },
    { "glGetPathColorGenfvNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathColorGenivNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathCommandsNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathCoordsNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathDashArrayNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathLengthNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathMetricRangeNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathMetricsNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathParameterfvNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathParameterivNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathSpacingNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathTexGenfvNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPathTexGenivNV", { GLextension::GL_NV_path_rendering } },
    { "glGetPerfCounterInfoINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glGetPerfMonitorCounterDataAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGetPerfMonitorCounterInfoAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGetPerfMonitorCounterStringAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGetPerfMonitorCountersAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGetPerfMonitorGroupStringAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGetPerfMonitorGroupsAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glGetPerfQueryDataINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glGetPerfQueryIdByNameINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glGetPerfQueryInfoINTEL", { GLextension::GL_INTEL_performance_query } },
    { "glGetPixelMapxv", { GLextension::GL_OES_fixed_point } },
    { "glGetPixelTexGenParameterfvSGIS", { GLextension::GL_SGIS_pixel_texture } },
    { "glGetPixelTexGenParameterivSGIS", { GLextension::GL_SGIS_pixel_texture } },
    { "glGetPixelTransformParameterfvEXT", { GLextension::GL_EXT_pixel_transform } },
    { "glGetPixelTransformParameterivEXT", { GLextension::GL_EXT_pixel_transform } },
    { "glGetPointerIndexedvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetPointeri_vEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetPointerv", { GLextension::GL_KHR_debug } },
    { "glGetPointervEXT", { GLextension::GL_EXT_vertex_array } },
    { "glGetPointervKHR", { GLextension::GL_KHR_debug } },
    { "glGetProgramBinary", { GLextension::GL_ARB_get_program_binary } },
    { "glGetProgramEnvParameterIivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glGetProgramEnvParameterIuivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glGetProgramEnvParameterdvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGetProgramEnvParameterfvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGetProgramInterfaceiv", { GLextension::GL_ARB_program_interface_query } },
    { "glGetProgramLocalParameterIivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glGetProgramLocalParameterIuivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glGetProgramLocalParameterdvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGetProgramLocalParameterfvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGetProgramNamedParameterdvNV", { GLextension::GL_NV_fragment_program } },
    { "glGetProgramNamedParameterfvNV", { GLextension::GL_NV_fragment_program } },
    { "glGetProgramParameterdvNV", { GLextension::GL_NV_vertex_program } },
    { "glGetProgramParameterfvNV", { GLextension::GL_NV_vertex_program } },
    { "glGetProgramPipelineInfoLog", { GLextension::GL_ARB_separate_shader_objects } },
    { "glGetProgramPipelineInfoLogEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glGetProgramPipelineiv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glGetProgramPipelineivEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glGetProgramResourceIndex", { GLextension::GL_ARB_program_interface_query } },
    { "glGetProgramResourceLocation", { GLextension::GL_ARB_program_interface_query } },
    { "glGetProgramResourceLocationIndex", { GLextension::GL_ARB_program_interface_query } },
    { "glGetProgramResourceName", { GLextension::GL_ARB_program_interface_query } },
    { "glGetProgramResourcefvNV", { GLextension::GL_NV_path_rendering } },
    { "glGetProgramResourceiv", { GLextension::GL_ARB_program_interface_query } },
    { "glGetProgramStageiv", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetProgramStringARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGetProgramStringNV", { GLextension::GL_NV_vertex_program } },
    { "glGetProgramSubroutineParameteruivNV", { GLextension::GL_NV_gpu_program5 } },
    { "glGetProgramivARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glGetProgramivNV", { GLextension::GL_NV_vertex_program } },
    { "glGetQueryBufferObjecti64v", { GLextension::GL_ARB_direct_state_access } },
    { "glGetQueryBufferObjectiv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetQueryBufferObjectui64v", { GLextension::GL_ARB_direct_state_access } },
    { "glGetQueryBufferObjectuiv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetQueryIndexediv", { GLextension::GL_ARB_transform_feedback3 } },
    { "glGetQueryObjecti64v", { GLextension::GL_ARB_timer_query } },
    { "glGetQueryObjecti64vEXT", { GLextension::GL_EXT_timer_query } },
    { "glGetQueryObjectivARB", { GLextension::GL_ARB_occlusion_query } },
    { "glGetQueryObjectui64v", { GLextension::GL_ARB_timer_query } },
    { "glGetQueryObjectui64vEXT", { GLextension::GL_EXT_timer_query } },
    { "glGetQueryObjectuivARB", { GLextension::GL_ARB_occlusion_query } },
    { "glGetQueryivARB", { GLextension::GL_ARB_occlusion_query } },
    { "glGetRenderbufferParameteriv", { GLextension::GL_ARB_framebuffer_object } },
    { "glGetRenderbufferParameterivEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glGetSamplerParameterIiv", { GLextension::GL_ARB_sampler_objects } },
    { "glGetSamplerParameterIuiv", { GLextension::GL_ARB_sampler_objects } },
    { "glGetSamplerParameterfv", { GLextension::GL_ARB_sampler_objects } },
    { "glGetSamplerParameteriv", { GLextension::GL_ARB_sampler_objects } },
    { "glGetSemaphoreParameterivNV", { GLextension::GL_NV_timeline_semaphore } },
    { "glGetSemaphoreParameterui64vEXT", { GLextension::GL_EXT_semaphore } },
    { "glGetSeparableFilter", { GLextension::GL_ARB_imaging } },
    { "glGetSeparableFilterEXT", { GLextension::GL_EXT_convolution } },
    { "glGetShaderPrecisionFormat", { GLextension::GL_ARB_ES2_compatibility } },
    { "glGetShaderSourceARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetShadingRateImagePaletteNV", { GLextension::GL_NV_shading_rate_image } },
    { "glGetShadingRateSampleLocationivNV", { GLextension::GL_NV_shading_rate_image } },
    { "glGetSharpenTexFuncSGIS", { GLextension::GL_SGIS_sharpen_texture } },
    { "glGetStageIndexNV", { GLextension::GL_NV_command_list } },
    { "glGetSubroutineIndex", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetSubroutineUniformLocation", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetSynciv", { GLextension::GL_ARB_sync } },
    { "glGetTexBumpParameterfvATI", { GLextension::GL_ATI_envmap_bumpmap } },
    { "glGetTexBumpParameterivATI", { GLextension::GL_ATI_envmap_bumpmap } },
    { "glGetTexEnvxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetTexFilterFuncSGIS", { GLextension::GL_SGIS_texture_filter4 } },
    { "glGetTexGenxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetTexLevelParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetTexParameterIivEXT", { GLextension::GL_EXT_texture_integer } },
    { "glGetTexParameterIuivEXT", { GLextension::GL_EXT_texture_integer } },
    { "glGetTexParameterPointervAPPLE", { GLextension::GL_APPLE_texture_range } },
    { "glGetTexParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glGetTextureHandleARB", { GLextension::GL_ARB_bindless_texture } },
    { "glGetTextureHandleNV", { GLextension::GL_NV_bindless_texture } },
    { "glGetTextureImage", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureImageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureLevelParameterfv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureLevelParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureLevelParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureLevelParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureParameterIiv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureParameterIivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureParameterIuiv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureParameterIuivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureParameterfv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTextureParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetTextureSamplerHandleARB", { GLextension::GL_ARB_bindless_texture } },
    { "glGetTextureSamplerHandleNV", { GLextension::GL_NV_bindless_texture } },
    { "glGetTextureSubImage", { GLextension::GL_ARB_get_texture_sub_image } },
    { "glGetTrackMatrixivNV", { GLextension::GL_NV_vertex_program } },
    { "glGetTransformFeedbackVaryingEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glGetTransformFeedbackVaryingNV", { GLextension::GL_NV_transform_feedback } },
    { "glGetTransformFeedbacki64_v", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTransformFeedbacki_v", { GLextension::GL_ARB_direct_state_access } },
    { "glGetTransformFeedbackiv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetUniformBlockIndex", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetUniformBufferSizeEXT", { GLextension::GL_EXT_bindable_uniform } },
    { "glGetUniformIndices", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glGetUniformLocationARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetUniformOffsetEXT", { GLextension::GL_EXT_bindable_uniform } },
    { "glGetUniformSubroutineuiv", { GLextension::GL_ARB_shader_subroutine } },
    { "glGetUniformdv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glGetUniformfvARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetUniformi64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glGetUniformi64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glGetUniformivARB", { GLextension::GL_ARB_shader_objects } },
    { "glGetUniformui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glGetUniformui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_shader_buffer_load } },
    { "glGetUniformuivEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glGetUnsignedBytei_vEXT", { GLextension::GL_EXT_memory_object, GLextension::GL_EXT_semaphore } },
    { "glGetUnsignedBytevEXT", { GLextension::GL_EXT_memory_object, GLextension::GL_EXT_semaphore } },
    { "glGetVariantArrayObjectfvATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glGetVariantArrayObjectivATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glGetVariantBooleanvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetVariantFloatvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetVariantIntegervEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetVariantPointervEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glGetVaryingLocationNV", { GLextension::GL_NV_transform_feedback } },
    { "glGetVertexArrayIndexed64iv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetVertexArrayIndexediv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetVertexArrayIntegeri_vEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetVertexArrayIntegervEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetVertexArrayPointeri_vEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetVertexArrayPointervEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glGetVertexArrayiv", { GLextension::GL_ARB_direct_state_access } },
    { "glGetVertexAttribArrayObjectfvATI", { GLextension::GL_ATI_vertex_attrib_array_object } },
    { "glGetVertexAttribArrayObjectivATI", { GLextension::GL_ATI_vertex_attrib_array_object } },
    { "glGetVertexAttribIivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glGetVertexAttribIuivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glGetVertexAttribLdv", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glGetVertexAttribLdvEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glGetVertexAttribLi64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glGetVertexAttribLui64vARB", { GLextension::GL_ARB_bindless_texture } },
    { "glGetVertexAttribLui64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glGetVertexAttribPointervARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glGetVertexAttribPointervNV", { GLextension::GL_NV_vertex_program } },
    { "glGetVertexAttribdvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glGetVertexAttribdvNV", { GLextension::GL_NV_vertex_program } },
    { "glGetVertexAttribfvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glGetVertexAttribfvNV", { GLextension::GL_NV_vertex_program } },
    { "glGetVertexAttribivARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glGetVertexAttribivNV", { GLextension::GL_NV_vertex_program } },
    { "glGetVideoCaptureStreamdvNV", { GLextension::GL_NV_video_capture } },
    { "glGetVideoCaptureStreamfvNV", { GLextension::GL_NV_video_capture } },
    { "glGetVideoCaptureStreamivNV", { GLextension::GL_NV_video_capture } },
    { "glGetVideoCaptureivNV", { GLextension::GL_NV_video_capture } },
    { "glGetVideoi64vNV", { GLextension::GL_NV_present_video } },
    { "glGetVideoivNV", { GLextension::GL_NV_present_video } },
    { "glGetVideoui64vNV", { GLextension::GL_NV_present_video } },
    { "glGetVideouivNV", { GLextension::GL_NV_present_video } },
    { "glGetVkProcAddrNV", { GLextension::GL_NV_draw_vulkan_image } },
    { "glGetnColorTableARB", { GLextension::GL_ARB_robustness } },
    { "glGetnCompressedTexImageARB", { GLextension::GL_ARB_robustness } },
    { "glGetnConvolutionFilterARB", { GLextension::GL_ARB_robustness } },
    { "glGetnHistogramARB", { GLextension::GL_ARB_robustness } },
    { "glGetnMapdvARB", { GLextension::GL_ARB_robustness } },
    { "glGetnMapfvARB", { GLextension::GL_ARB_robustness } },
    { "glGetnMapivARB", { GLextension::GL_ARB_robustness } },
    { "glGetnMinmaxARB", { GLextension::GL_ARB_robustness } },
    { "glGetnPixelMapfvARB", { GLextension::GL_ARB_robustness } },
    { "glGetnPixelMapuivARB", { GLextension::GL_ARB_robustness } },
    { "glGetnPixelMapusvARB", { GLextension::GL_ARB_robustness } },
    { "glGetnPolygonStippleARB", { GLextension::GL_ARB_robustness } },
    { "glGetnSeparableFilterARB", { GLextension::GL_ARB_robustness } },
    { "glGetnTexImageARB", { GLextension::GL_ARB_robustness } },
    { "glGetnUniformdvARB", { GLextension::GL_ARB_robustness } },
    { "glGetnUniformfv", { GLextension::GL_KHR_robustness } },
    { "glGetnUniformfvARB", { GLextension::GL_ARB_robustness } },
    { "glGetnUniformfvKHR", { GLextension::GL_KHR_robustness } },
    { "glGetnUniformi64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glGetnUniformiv", { GLextension::GL_KHR_robustness } },
    { "glGetnUniformivARB", { GLextension::GL_ARB_robustness } },
    { "glGetnUniformivKHR", { GLextension::GL_KHR_robustness } },
    { "glGetnUniformui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glGetnUniformuiv", { GLextension::GL_KHR_robustness } },
    { "glGetnUniformuivARB", { GLextension::GL_ARB_robustness } },
    { "glGetnUniformuivKHR", { GLextension::GL_KHR_robustness } },
    { "glGlobalAlphaFactorbSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactordSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactorfSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactoriSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactorsSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactorubSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactoruiSUN", { GLextension::GL_SUN_global_alpha } },
    { "glGlobalAlphaFactorusSUN", { GLextension::GL_SUN_global_alpha } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_H =
{
    { "glHintPGI", { GLextension::GL_PGI_misc_hints } },
    { "glHistogram", { GLextension::GL_ARB_imaging } },
    { "glHistogramEXT", { GLextension::GL_EXT_histogram } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_I =
{
    { "glIglooInterfaceSGIX", { GLextension::GL_SGIX_igloo_interface } },
    { "glImageTransformParameterfHP", { GLextension::GL_HP_image_transform } },
    { "glImageTransformParameterfvHP", { GLextension::GL_HP_image_transform } },
    { "glImageTransformParameteriHP", { GLextension::GL_HP_image_transform } },
    { "glImageTransformParameterivHP", { GLextension::GL_HP_image_transform } },
    { "glImportMemoryFdEXT", { GLextension::GL_EXT_memory_object_fd } },
    { "glImportMemoryWin32HandleEXT", { GLextension::GL_EXT_memory_object_win32 } },
    { "glImportMemoryWin32NameEXT", { GLextension::GL_EXT_memory_object_win32 } },
    { "glImportSemaphoreFdEXT", { GLextension::GL_EXT_semaphore_fd } },
    { "glImportSemaphoreWin32HandleEXT", { GLextension::GL_EXT_semaphore_win32 } },
    { "glImportSemaphoreWin32NameEXT", { GLextension::GL_EXT_semaphore_win32 } },
    { "glImportSyncEXT", { GLextension::GL_EXT_x11_sync_object } },
    { "glIndexFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glIndexFuncEXT", { GLextension::GL_EXT_index_func } },
    { "glIndexMaterialEXT", { GLextension::GL_EXT_index_material } },
    { "glIndexPointerEXT", { GLextension::GL_EXT_vertex_array } },
    { "glIndexPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glIndexxOES", { GLextension::GL_OES_fixed_point } },
    { "glIndexxvOES", { GLextension::GL_OES_fixed_point } },
    { "glInsertComponentEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glInsertEventMarkerEXT", { GLextension::GL_EXT_debug_marker } },
    { "glInstrumentsBufferSGIX", { GLextension::GL_SGIX_instruments } },
    { "glInterpolatePathsNV", { GLextension::GL_NV_path_rendering } },
    { "glInvalidateBufferData", { GLextension::GL_ARB_invalidate_subdata } },
    { "glInvalidateBufferSubData", { GLextension::GL_ARB_invalidate_subdata } },
    { "glInvalidateFramebuffer", { GLextension::GL_ARB_invalidate_subdata } },
    { "glInvalidateNamedFramebufferData", { GLextension::GL_ARB_direct_state_access } },
    { "glInvalidateNamedFramebufferSubData", { GLextension::GL_ARB_direct_state_access } },
    { "glInvalidateSubFramebuffer", { GLextension::GL_ARB_invalidate_subdata } },
    { "glInvalidateTexImage", { GLextension::GL_ARB_invalidate_subdata } },
    { "glInvalidateTexSubImage", { GLextension::GL_ARB_invalidate_subdata } },
    { "glIsAsyncMarkerSGIX", { GLextension::GL_SGIX_async } },
    { "glIsBufferARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glIsBufferResidentNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glIsCommandListNV", { GLextension::GL_NV_command_list } },
    { "glIsEnabledIndexedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_draw_buffers2 } },
    { "glIsFenceAPPLE", { GLextension::GL_APPLE_fence } },
    { "glIsFenceNV", { GLextension::GL_NV_fence } },
    { "glIsFramebuffer", { GLextension::GL_ARB_framebuffer_object } },
    { "glIsFramebufferEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glIsImageHandleResidentARB", { GLextension::GL_ARB_bindless_texture } },
    { "glIsImageHandleResidentNV", { GLextension::GL_NV_bindless_texture } },
    { "glIsMemoryObjectEXT", { GLextension::GL_EXT_memory_object } },
    { "glIsNameAMD", { GLextension::GL_AMD_name_gen_delete } },
    { "glIsNamedBufferResidentNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glIsNamedStringARB", { GLextension::GL_ARB_shading_language_include } },
    { "glIsObjectBufferATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glIsOcclusionQueryNV", { GLextension::GL_NV_occlusion_query } },
    { "glIsPathNV", { GLextension::GL_NV_path_rendering } },
    { "glIsPointInFillPathNV", { GLextension::GL_NV_path_rendering } },
    { "glIsPointInStrokePathNV", { GLextension::GL_NV_path_rendering } },
    { "glIsProgramARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glIsProgramNV", { GLextension::GL_NV_vertex_program } },
    { "glIsProgramPipeline", { GLextension::GL_ARB_separate_shader_objects } },
    { "glIsProgramPipelineEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glIsQueryARB", { GLextension::GL_ARB_occlusion_query } },
    { "glIsRenderbuffer", { GLextension::GL_ARB_framebuffer_object } },
    { "glIsRenderbufferEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glIsSampler", { GLextension::GL_ARB_sampler_objects } },
    { "glIsSemaphoreEXT", { GLextension::GL_EXT_semaphore } },
    { "glIsStateNV", { GLextension::GL_NV_command_list } },
    { "glIsSync", { GLextension::GL_ARB_sync } },
    { "glIsTextureEXT", { GLextension::GL_EXT_texture_object } },
    { "glIsTextureHandleResidentARB", { GLextension::GL_ARB_bindless_texture } },
    { "glIsTextureHandleResidentNV", { GLextension::GL_NV_bindless_texture } },
    { "glIsTransformFeedback", { GLextension::GL_ARB_transform_feedback2 } },
    { "glIsTransformFeedbackNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glIsVariantEnabledEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glIsVertexArray", { GLextension::GL_ARB_vertex_array_object } },
    { "glIsVertexArrayAPPLE", { GLextension::GL_APPLE_vertex_array_object } },
    { "glIsVertexAttribEnabledAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_J{};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_K{};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_L =
{
    { "glLGPUCopyImageSubDataNVX", { GLextension::GL_NVX_linked_gpu_multicast } },
    { "glLGPUInterlockNVX", { GLextension::GL_NVX_linked_gpu_multicast } },
    { "glLGPUNamedBufferSubDataNVX", { GLextension::GL_NVX_linked_gpu_multicast } },
    { "glLabelObjectEXT", { GLextension::GL_EXT_debug_label } },
    { "glLightEnviSGIX", { GLextension::GL_SGIX_fragment_lighting } },
    { "glLightModelxOES", { GLextension::GL_OES_fixed_point } },
    { "glLightModelxvOES", { GLextension::GL_OES_fixed_point } },
    { "glLightxOES", { GLextension::GL_OES_fixed_point } },
    { "glLightxvOES", { GLextension::GL_OES_fixed_point } },
    { "glLineWidthxOES", { GLextension::GL_OES_fixed_point } },
    { "glLinkProgramARB", { GLextension::GL_ARB_shader_objects } },
    { "glListDrawCommandsStatesClientNV", { GLextension::GL_NV_command_list } },
    { "glListParameterfSGIX", { GLextension::GL_SGIX_list_priority } },
    { "glListParameterfvSGIX", { GLextension::GL_SGIX_list_priority } },
    { "glListParameteriSGIX", { GLextension::GL_SGIX_list_priority } },
    { "glListParameterivSGIX", { GLextension::GL_SGIX_list_priority } },
    { "glLoadIdentityDeformationMapSGIX", { GLextension::GL_SGIX_polynomial_ffd } },
    { "glLoadMatrixxOES", { GLextension::GL_OES_fixed_point } },
    { "glLoadProgramNV", { GLextension::GL_NV_vertex_program } },
    { "glLoadTransposeMatrixdARB", { GLextension::GL_ARB_transpose_matrix } },
    { "glLoadTransposeMatrixfARB", { GLextension::GL_ARB_transpose_matrix } },
    { "glLoadTransposeMatrixxOES", { GLextension::GL_OES_fixed_point } },
    { "glLockArraysEXT", { GLextension::GL_EXT_compiled_vertex_array } },
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_M =
{
    { "glMakeBufferNonResidentNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glMakeBufferResidentNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glMakeImageHandleNonResidentARB", { GLextension::GL_ARB_bindless_texture } },
    { "glMakeImageHandleNonResidentNV", { GLextension::GL_NV_bindless_texture } },
    { "glMakeImageHandleResidentARB", { GLextension::GL_ARB_bindless_texture } },
    { "glMakeImageHandleResidentNV", { GLextension::GL_NV_bindless_texture } },
    { "glMakeNamedBufferNonResidentNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glMakeNamedBufferResidentNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glMakeTextureHandleNonResidentARB", { GLextension::GL_ARB_bindless_texture } },
    { "glMakeTextureHandleNonResidentNV", { GLextension::GL_NV_bindless_texture } },
    { "glMakeTextureHandleResidentARB", { GLextension::GL_ARB_bindless_texture } },
    { "glMakeTextureHandleResidentNV", { GLextension::GL_NV_bindless_texture } },
    { "glMap1xOES", { GLextension::GL_OES_fixed_point } },
    { "glMap2xOES", { GLextension::GL_OES_fixed_point } },
    { "glMapBufferARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glMapBufferRange", { GLextension::GL_ARB_map_buffer_range } },
    { "glMapControlPointsNV", { GLextension::GL_NV_evaluators } },
    { "glMapGrid1xOES", { GLextension::GL_OES_fixed_point } },
    { "glMapGrid2xOES", { GLextension::GL_OES_fixed_point } },
    { "glMapNamedBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glMapNamedBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMapNamedBufferRange", { GLextension::GL_ARB_direct_state_access } },
    { "glMapNamedBufferRangeEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMapObjectBufferATI", { GLextension::GL_ATI_map_object_buffer } },
    { "glMapParameterfvNV", { GLextension::GL_NV_evaluators } },
    { "glMapParameterivNV", { GLextension::GL_NV_evaluators } },
    { "glMapTexture2DINTEL", { GLextension::GL_INTEL_map_texture } },
    { "glMapVertexAttrib1dAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } },
    { "glMapVertexAttrib1fAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } },
    { "glMapVertexAttrib2dAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } },
    { "glMapVertexAttrib2fAPPLE", { GLextension::GL_APPLE_vertex_program_evaluators } },
    { "glMaterialxOES", { GLextension::GL_OES_fixed_point } },
    { "glMaterialxvOES", { GLextension::GL_OES_fixed_point } },
    { "glMatrixFrustumEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixIndexPointerARB", { GLextension::GL_ARB_matrix_palette } },
    { "glMatrixIndexubvARB", { GLextension::GL_ARB_matrix_palette } },
    { "glMatrixIndexuivARB", { GLextension::GL_ARB_matrix_palette } },
    { "glMatrixIndexusvARB", { GLextension::GL_ARB_matrix_palette } },
    { "glMatrixLoad3x2fNV", { GLextension::GL_NV_path_rendering } },
    { "glMatrixLoad3x3fNV", { GLextension::GL_NV_path_rendering } },
    { "glMatrixLoadIdentityEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixLoadTranspose3x3fNV", { GLextension::GL_NV_path_rendering } },
    { "glMatrixLoadTransposedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixLoadTransposefEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixLoaddEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixLoadfEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixMult3x2fNV", { GLextension::GL_NV_path_rendering } },
    { "glMatrixMult3x3fNV", { GLextension::GL_NV_path_rendering } },
    { "glMatrixMultTranspose3x3fNV", { GLextension::GL_NV_path_rendering } },
    { "glMatrixMultTransposedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixMultTransposefEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixMultdEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixMultfEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixOrthoEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixPopEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixPushEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixRotatedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixRotatefEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixScaledEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixScalefEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixTranslatedEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMatrixTranslatefEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_NV_path_rendering } },
    { "glMaxShaderCompilerThreadsARB", { GLextension::GL_ARB_parallel_shader_compile } },
    { "glMaxShaderCompilerThreadsKHR", { GLextension::GL_KHR_parallel_shader_compile } },
    { "glMemoryBarrier", { GLextension::GL_ARB_shader_image_load_store } },
    { "glMemoryBarrierByRegion", { GLextension::GL_ARB_ES3_1_compatibility } },
    { "glMemoryBarrierEXT", { GLextension::GL_EXT_shader_image_load_store } },
    { "glMemoryObjectParameterivEXT", { GLextension::GL_EXT_memory_object } },
    { "glMinSampleShadingARB", { GLextension::GL_ARB_sample_shading } },
    { "glMinmax", { GLextension::GL_ARB_imaging } },
    { "glMinmaxEXT", { GLextension::GL_EXT_histogram } },
    { "glMultMatrixxOES", { GLextension::GL_OES_fixed_point } },
    { "glMultTransposeMatrixdARB", { GLextension::GL_ARB_transpose_matrix } },
    { "glMultTransposeMatrixfARB", { GLextension::GL_ARB_transpose_matrix } },
    { "glMultTransposeMatrixxOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiDrawArraysEXT", { GLextension::GL_EXT_multi_draw_arrays } },
    { "glMultiDrawArraysIndirect", { GLextension::GL_ARB_multi_draw_indirect } },
    { "glMultiDrawArraysIndirectAMD", { GLextension::GL_AMD_multi_draw_indirect } },
    { "glMultiDrawArraysIndirectBindlessCountNV", { GLextension::GL_NV_bindless_multi_draw_indirect_count } },
    { "glMultiDrawArraysIndirectBindlessNV", { GLextension::GL_NV_bindless_multi_draw_indirect } },
    { "glMultiDrawArraysIndirectCountARB", { GLextension::GL_ARB_indirect_parameters } },
    { "glMultiDrawElementArrayAPPLE", { GLextension::GL_APPLE_element_array } },
    { "glMultiDrawElementsBaseVertex", { GLextension::GL_ARB_draw_elements_base_vertex } },
    { "glMultiDrawElementsEXT", { GLextension::GL_EXT_multi_draw_arrays } },
    { "glMultiDrawElementsIndirect", { GLextension::GL_ARB_multi_draw_indirect } },
    { "glMultiDrawElementsIndirectAMD", { GLextension::GL_AMD_multi_draw_indirect } },
    { "glMultiDrawElementsIndirectBindlessCountNV", { GLextension::GL_NV_bindless_multi_draw_indirect_count } },
    { "glMultiDrawElementsIndirectBindlessNV", { GLextension::GL_NV_bindless_multi_draw_indirect } },
    { "glMultiDrawElementsIndirectCountARB", { GLextension::GL_ARB_indirect_parameters } },
    { "glMultiDrawMeshTasksIndirectCountNV", { GLextension::GL_NV_mesh_shader } },
    { "glMultiDrawMeshTasksIndirectNV", { GLextension::GL_NV_mesh_shader } },
    { "glMultiDrawRangeElementArrayAPPLE", { GLextension::GL_APPLE_element_array } },
    { "glMultiModeDrawArraysIBM", { GLextension::GL_IBM_multimode_draw_arrays } },
    { "glMultiModeDrawElementsIBM", { GLextension::GL_IBM_multimode_draw_arrays } },
    { "glMultiTexBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexCoord1bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord1bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord1dARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1dvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1fARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1fvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1hNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord1hvNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord1iARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1ivARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1sARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1svARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord1xOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord1xvOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord2bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord2bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord2dARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2dvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2fARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2fvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2hNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord2hvNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord2iARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2ivARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2sARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2svARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord2xOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord2xvOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord3bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord3bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord3dARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3dvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3fARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3fvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3hNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord3hvNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord3iARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3ivARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3sARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3svARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord3xOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord3xvOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord4bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord4bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glMultiTexCoord4dARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4dvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4fARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4fvARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4hNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord4hvNV", { GLextension::GL_NV_half_float } },
    { "glMultiTexCoord4iARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4ivARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4sARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4svARB", { GLextension::GL_ARB_multitexture } },
    { "glMultiTexCoord4xOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoord4xvOES", { GLextension::GL_OES_fixed_point } },
    { "glMultiTexCoordP1ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP1uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP2ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP2uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP4ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordP4uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glMultiTexCoordPointerEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexEnvfEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexEnvfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexEnviEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexEnvivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexGendEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexGendvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexGenfEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexGenfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexGeniEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexGenivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexParameterIivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexParameterIuivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexParameterfEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexParameteriEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexRenderbufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexSubImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexSubImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMultiTexSubImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glMulticastBarrierNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastBlitFramebufferNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastBufferSubDataNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastCopyBufferSubDataNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastCopyImageSubDataNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastFramebufferSampleLocationsfvNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastGetQueryObjecti64vNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastGetQueryObjectivNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastGetQueryObjectui64vNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastGetQueryObjectuivNV", { GLextension::GL_NV_gpu_multicast } },
    { "glMulticastScissorArrayvNVX", { GLextension::GL_NVX_gpu_multicast2 } },
    { "glMulticastViewportArrayvNVX", { GLextension::GL_NVX_gpu_multicast2 } },
    { "glMulticastViewportPositionWScaleNVX", { GLextension::GL_NVX_gpu_multicast2 } },
    { "glMulticastWaitSyncNV", { GLextension::GL_NV_gpu_multicast } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_N =
{
    { "glNamedBufferAttachMemoryNV", { GLextension::GL_NV_memory_attachment } },
    { "glNamedBufferData", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedBufferDataEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedBufferPageCommitmentARB", { GLextension::GL_ARB_sparse_buffer } },
    { "glNamedBufferPageCommitmentEXT", { GLextension::GL_ARB_sparse_buffer } },
    { "glNamedBufferPageCommitmentMemNV", { GLextension::GL_NV_memory_object_sparse } },
    { "glNamedBufferStorage", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedBufferStorageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedBufferStorageExternalEXT", { GLextension::GL_EXT_external_buffer } },
    { "glNamedBufferStorageMemEXT", { GLextension::GL_EXT_memory_object } },
    { "glNamedBufferSubData", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedBufferSubDataEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedCopyBufferSubDataEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferDrawBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferDrawBuffers", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferParameteri", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferParameteriEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferReadBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferRenderbuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferRenderbufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferSampleLocationsfvARB", { GLextension::GL_ARB_sample_locations } },
    { "glNamedFramebufferSampleLocationsfvNV", { GLextension::GL_NV_sample_locations } },
    { "glNamedFramebufferSamplePositionsfvAMD", { GLextension::GL_AMD_framebuffer_sample_positions } },
    { "glNamedFramebufferTexture", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferTexture1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferTexture2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferTexture3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferTextureEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferTextureFaceEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedFramebufferTextureLayer", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedFramebufferTextureLayerEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameter4dEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameter4dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameter4fEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameter4fvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameterI4iEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameterI4ivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameterI4uiEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameterI4uivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParameters4fvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParametersI4ivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramLocalParametersI4uivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedProgramStringEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedRenderbufferStorage", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedRenderbufferStorageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedRenderbufferStorageMultisample", { GLextension::GL_ARB_direct_state_access } },
    { "glNamedRenderbufferStorageMultisampleAdvancedAMD", { GLextension::GL_AMD_framebuffer_multisample_advanced } },
    { "glNamedRenderbufferStorageMultisampleCoverageEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedRenderbufferStorageMultisampleEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glNamedStringARB", { GLextension::GL_ARB_shading_language_include } },
    { "glNewObjectBufferATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glNormal3hNV", { GLextension::GL_NV_half_float } },
    { "glNormal3hvNV", { GLextension::GL_NV_half_float } },
    { "glNormal3xOES", { GLextension::GL_OES_fixed_point } },
    { "glNormal3xvOES", { GLextension::GL_OES_fixed_point } },
    { "glNormalFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glNormalP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glNormalP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glNormalPointerEXT", { GLextension::GL_EXT_vertex_array } },
    { "glNormalPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glNormalPointervINTEL", { GLextension::GL_INTEL_parallel_arrays } },
    { "glNormalStream3bATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3bvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3dATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3dvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3fATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3fvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3iATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3ivATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3sATI", { GLextension::GL_ATI_vertex_streams } },
    { "glNormalStream3svATI", { GLextension::GL_ATI_vertex_streams } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_O =
{
    { "glObjectLabel", { GLextension::GL_KHR_debug } },
    { "glObjectLabelKHR", { GLextension::GL_KHR_debug } },
    { "glObjectPtrLabel", { GLextension::GL_KHR_debug } },
    { "glObjectPtrLabelKHR", { GLextension::GL_KHR_debug } },
    { "glObjectPurgeableAPPLE", { GLextension::GL_APPLE_object_purgeable } },
    { "glObjectUnpurgeableAPPLE", { GLextension::GL_APPLE_object_purgeable } },
    { "glOrthofOES", { GLextension::GL_OES_single_precision } },
    { "glOrthoxOES", { GLextension::GL_OES_fixed_point } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_P =
{
    { "glPNTrianglesfATI", { GLextension::GL_ATI_pn_triangles } },
    { "glPNTrianglesiATI", { GLextension::GL_ATI_pn_triangles } },
    { "glPassTexCoordATI", { GLextension::GL_ATI_fragment_shader } },
    { "glPassThroughxOES", { GLextension::GL_OES_fixed_point } },
    { "glPatchParameterfv", { GLextension::GL_ARB_tessellation_shader } },
    { "glPatchParameteri", { GLextension::GL_ARB_tessellation_shader } },
    { "glPathColorGenNV", { GLextension::GL_NV_path_rendering } },
    { "glPathCommandsNV", { GLextension::GL_NV_path_rendering } },
    { "glPathCoordsNV", { GLextension::GL_NV_path_rendering } },
    { "glPathCoverDepthFuncNV", { GLextension::GL_NV_path_rendering } },
    { "glPathDashArrayNV", { GLextension::GL_NV_path_rendering } },
    { "glPathFogGenNV", { GLextension::GL_NV_path_rendering } },
    { "glPathGlyphIndexArrayNV", { GLextension::GL_NV_path_rendering } },
    { "glPathGlyphIndexRangeNV", { GLextension::GL_NV_path_rendering } },
    { "glPathGlyphRangeNV", { GLextension::GL_NV_path_rendering } },
    { "glPathGlyphsNV", { GLextension::GL_NV_path_rendering } },
    { "glPathMemoryGlyphIndexArrayNV", { GLextension::GL_NV_path_rendering } },
    { "glPathParameterfNV", { GLextension::GL_NV_path_rendering } },
    { "glPathParameterfvNV", { GLextension::GL_NV_path_rendering } },
    { "glPathParameteriNV", { GLextension::GL_NV_path_rendering } },
    { "glPathParameterivNV", { GLextension::GL_NV_path_rendering } },
    { "glPathStencilDepthOffsetNV", { GLextension::GL_NV_path_rendering } },
    { "glPathStencilFuncNV", { GLextension::GL_NV_path_rendering } },
    { "glPathStringNV", { GLextension::GL_NV_path_rendering } },
    { "glPathSubCommandsNV", { GLextension::GL_NV_path_rendering } },
    { "glPathSubCoordsNV", { GLextension::GL_NV_path_rendering } },
    { "glPathTexGenNV", { GLextension::GL_NV_path_rendering } },
    { "glPauseTransformFeedback", { GLextension::GL_ARB_transform_feedback2 } },
    { "glPauseTransformFeedbackNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glPixelDataRangeNV", { GLextension::GL_NV_pixel_data_range } },
    { "glPixelMapx", { GLextension::GL_OES_fixed_point } },
    { "glPixelStorex", { GLextension::GL_OES_fixed_point } },
    { "glPixelTexGenParameterfSGIS", { GLextension::GL_SGIS_pixel_texture } },
    { "glPixelTexGenParameterfvSGIS", { GLextension::GL_SGIS_pixel_texture } },
    { "glPixelTexGenParameteriSGIS", { GLextension::GL_SGIS_pixel_texture } },
    { "glPixelTexGenParameterivSGIS", { GLextension::GL_SGIS_pixel_texture } },
    { "glPixelTexGenSGIX", { GLextension::GL_SGIX_pixel_texture } },
    { "glPixelTransferxOES", { GLextension::GL_OES_fixed_point } },
    { "glPixelTransformParameterfEXT", { GLextension::GL_EXT_pixel_transform } },
    { "glPixelTransformParameterfvEXT", { GLextension::GL_EXT_pixel_transform } },
    { "glPixelTransformParameteriEXT", { GLextension::GL_EXT_pixel_transform } },
    { "glPixelTransformParameterivEXT", { GLextension::GL_EXT_pixel_transform } },
    { "glPixelZoomxOES", { GLextension::GL_OES_fixed_point } },
    { "glPointAlongPathNV", { GLextension::GL_NV_path_rendering } },
    { "glPointParameterfARB", { GLextension::GL_ARB_point_parameters } },
    { "glPointParameterfEXT", { GLextension::GL_EXT_point_parameters } },
    { "glPointParameterfSGIS", { GLextension::GL_SGIS_point_parameters } },
    { "glPointParameterfvARB", { GLextension::GL_ARB_point_parameters } },
    { "glPointParameterfvEXT", { GLextension::GL_EXT_point_parameters } },
    { "glPointParameterfvSGIS", { GLextension::GL_SGIS_point_parameters } },
    { "glPointParameteriNV", { GLextension::GL_NV_point_sprite } },
    { "glPointParameterivNV", { GLextension::GL_NV_point_sprite } },
    { "glPointParameterxOES", { GLextension::GL_OES_fixed_point } },
    { "glPointParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glPointSizexOES", { GLextension::GL_OES_fixed_point } },
    { "glPollAsyncSGIX", { GLextension::GL_SGIX_async } },
    { "glPollInstrumentsSGIX", { GLextension::GL_SGIX_instruments } },
    { "glPolygonOffsetClamp", { GLextension::GL_ARB_polygon_offset_clamp } },
    { "glPolygonOffsetClampEXT", { GLextension::GL_EXT_polygon_offset_clamp } },
    { "glPolygonOffsetEXT", { GLextension::GL_EXT_polygon_offset } },
    { "glPolygonOffsetxOES", { GLextension::GL_OES_fixed_point } },
    { "glPopDebugGroup", { GLextension::GL_KHR_debug } },
    { "glPopDebugGroupKHR", { GLextension::GL_KHR_debug } },
    { "glPopGroupMarkerEXT", { GLextension::GL_EXT_debug_marker } },
    { "glPresentFrameDualFillNV", { GLextension::GL_NV_present_video } },
    { "glPresentFrameKeyedNV", { GLextension::GL_NV_present_video } },
    { "glPrimitiveBoundingBoxARB", { GLextension::GL_ARB_ES3_2_compatibility } },
    { "glPrimitiveRestartIndexNV", { GLextension::GL_NV_primitive_restart } },
    { "glPrimitiveRestartNV", { GLextension::GL_NV_primitive_restart } },
    { "glPrioritizeTexturesEXT", { GLextension::GL_EXT_texture_object } },
    { "glPrioritizeTexturesxOES", { GLextension::GL_OES_fixed_point } },
    { "glProgramBinary", { GLextension::GL_ARB_get_program_binary } },
    { "glProgramBufferParametersIivNV", { GLextension::GL_NV_parameter_buffer_object } },
    { "glProgramBufferParametersIuivNV", { GLextension::GL_NV_parameter_buffer_object } },
    { "glProgramBufferParametersfvNV", { GLextension::GL_NV_parameter_buffer_object } },
    { "glProgramEnvParameter4dARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramEnvParameter4dvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramEnvParameter4fARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramEnvParameter4fvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramEnvParameterI4iNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramEnvParameterI4ivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramEnvParameterI4uiNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramEnvParameterI4uivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramEnvParameters4fvEXT", { GLextension::GL_EXT_gpu_program_parameters } },
    { "glProgramEnvParametersI4ivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramEnvParametersI4uivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramLocalParameter4dARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramLocalParameter4dvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramLocalParameter4fARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramLocalParameter4fvARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramLocalParameterI4iNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramLocalParameterI4ivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramLocalParameterI4uiNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramLocalParameterI4uivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramLocalParameters4fvEXT", { GLextension::GL_EXT_gpu_program_parameters } },
    { "glProgramLocalParametersI4ivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramLocalParametersI4uivNV", { GLextension::GL_NV_gpu_program4 } },
    { "glProgramNamedParameter4dNV", { GLextension::GL_NV_fragment_program } },
    { "glProgramNamedParameter4dvNV", { GLextension::GL_NV_fragment_program } },
    { "glProgramNamedParameter4fNV", { GLextension::GL_NV_fragment_program } },
    { "glProgramNamedParameter4fvNV", { GLextension::GL_NV_fragment_program } },
    { "glProgramParameter4dNV", { GLextension::GL_NV_vertex_program } },
    { "glProgramParameter4dvNV", { GLextension::GL_NV_vertex_program } },
    { "glProgramParameter4fNV", { GLextension::GL_NV_vertex_program } },
    { "glProgramParameter4fvNV", { GLextension::GL_NV_vertex_program } },
    { "glProgramParameteri", { GLextension::GL_ARB_get_program_binary, GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramParameteriARB", { GLextension::GL_ARB_geometry_shader4 } },
    { "glProgramParameteriEXT", { GLextension::GL_EXT_geometry_shader4, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramParameters4dvNV", { GLextension::GL_NV_vertex_program } },
    { "glProgramParameters4fvNV", { GLextension::GL_NV_vertex_program } },
    { "glProgramPathFragmentInputGenNV", { GLextension::GL_NV_path_rendering } },
    { "glProgramStringARB", { GLextension::GL_ARB_fragment_program, GLextension::GL_ARB_vertex_program } },
    { "glProgramSubroutineParametersuivNV", { GLextension::GL_NV_gpu_program5 } },
    { "glProgramUniform1d", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1dEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform1dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform1f", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1fEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform1fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform1i", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform1i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform1i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform1i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform1iEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform1iv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1ivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform1ui", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform1ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform1ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform1ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform1uiEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform1uiv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform1uivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform2d", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2dEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform2dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform2f", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2fEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform2fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform2i", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform2i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform2i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform2i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform2iEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform2iv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2ivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform2ui", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform2ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform2ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform2ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform2uiEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform2uiv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform2uivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform3d", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3dEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform3dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform3f", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3fEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform3fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform3i", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform3i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform3i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform3i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform3iEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform3iv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3ivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform3ui", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform3ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform3ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform3ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform3uiEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform3uiv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform3uivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform4d", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4dEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform4dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniform4f", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4fEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform4fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform4i", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform4i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform4i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform4i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform4iEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform4iv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4ivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform4ui", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform4ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform4ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glProgramUniform4ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glProgramUniform4uiEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniform4uiv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniform4uivEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformHandleui64ARB", { GLextension::GL_ARB_bindless_texture } },
    { "glProgramUniformHandleui64NV", { GLextension::GL_NV_bindless_texture } },
    { "glProgramUniformHandleui64vARB", { GLextension::GL_ARB_bindless_texture } },
    { "glProgramUniformHandleui64vNV", { GLextension::GL_NV_bindless_texture } },
    { "glProgramUniformMatrix2dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix2dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix2fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix2fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix2x3dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix2x3dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix2x3fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix2x3fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix2x4dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix2x4dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix2x4fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix2x4fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix3dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix3dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix3fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix3fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix3x2dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix3x2dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix3x2fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix3x2fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix3x4dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix3x4dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix3x4fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix3x4fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix4dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix4dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix4fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix4fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix4x2dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix4x2dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix4x2fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix4x2fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformMatrix4x3dv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix4x3dvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glProgramUniformMatrix4x3fv", { GLextension::GL_ARB_separate_shader_objects } },
    { "glProgramUniformMatrix4x3fvEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_separate_shader_objects } },
    { "glProgramUniformui64NV", { GLextension::GL_NV_shader_buffer_load } },
    { "glProgramUniformui64vNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glProgramVertexLimitNV", { GLextension::GL_NV_geometry_program4 } },
    { "glProvokingVertex", { GLextension::GL_ARB_provoking_vertex } },
    { "glProvokingVertexEXT", { GLextension::GL_EXT_provoking_vertex } },
    { "glPushClientAttribDefaultEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glPushDebugGroup", { GLextension::GL_KHR_debug } },
    { "glPushDebugGroupKHR", { GLextension::GL_KHR_debug } },
    { "glPushGroupMarkerEXT", { GLextension::GL_EXT_debug_marker } },
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_Q =
{
    { "glQueryCounter", { GLextension::GL_ARB_timer_query } },
    { "glQueryMatrixxOES", { GLextension::GL_OES_query_matrix } },
    { "glQueryObjectParameteruiAMD", { GLextension::GL_AMD_occlusion_query_event } },
    { "glQueryResourceNV", { GLextension::GL_NV_query_resource } },
    { "glQueryResourceTagNV", { GLextension::GL_NV_query_resource_tag } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_R =
{
    { "glRasterPos2xOES", { GLextension::GL_OES_fixed_point } },
    { "glRasterPos2xvOES", { GLextension::GL_OES_fixed_point } },
    { "glRasterPos3xOES", { GLextension::GL_OES_fixed_point } },
    { "glRasterPos3xvOES", { GLextension::GL_OES_fixed_point } },
    { "glRasterPos4xOES", { GLextension::GL_OES_fixed_point } },
    { "glRasterPos4xvOES", { GLextension::GL_OES_fixed_point } },
    { "glRasterSamplesEXT", { GLextension::GL_EXT_raster_multisample, GLextension::GL_NV_framebuffer_mixed_samples } },
    { "glReadInstrumentsSGIX", { GLextension::GL_SGIX_instruments } },
    { "glReadnPixels", { GLextension::GL_KHR_robustness } },
    { "glReadnPixelsARB", { GLextension::GL_ARB_robustness } },
    { "glReadnPixelsKHR", { GLextension::GL_KHR_robustness } },
    { "glRectxOES", { GLextension::GL_OES_fixed_point } },
    { "glRectxvOES", { GLextension::GL_OES_fixed_point } },
    { "glReferencePlaneSGIX", { GLextension::GL_SGIX_reference_plane } },
    { "glReleaseKeyedMutexWin32EXT", { GLextension::GL_EXT_win32_keyed_mutex } },
    { "glReleaseShaderCompiler", { GLextension::GL_ARB_ES2_compatibility } },
    { "glRenderGpuMaskNV", { GLextension::GL_NV_gpu_multicast } },
    { "glRenderbufferStorage", { GLextension::GL_ARB_framebuffer_object } },
    { "glRenderbufferStorageEXT", { GLextension::GL_EXT_framebuffer_object } },
    { "glRenderbufferStorageMultisample", { GLextension::GL_ARB_framebuffer_object } },
    { "glRenderbufferStorageMultisampleAdvancedAMD", { GLextension::GL_AMD_framebuffer_multisample_advanced } },
    { "glRenderbufferStorageMultisampleCoverageNV", { GLextension::GL_NV_framebuffer_multisample_coverage } },
    { "glRenderbufferStorageMultisampleEXT", { GLextension::GL_EXT_framebuffer_multisample } },
    { "glReplacementCodePointerSUN", { GLextension::GL_SUN_triangle_list } },
    { "glReplacementCodeubSUN", { GLextension::GL_SUN_triangle_list } },
    { "glReplacementCodeubvSUN", { GLextension::GL_SUN_triangle_list } },
    { "glReplacementCodeuiColor3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiColor3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiColor4fNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiColor4fNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiColor4ubVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiColor4ubVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiSUN", { GLextension::GL_SUN_triangle_list } },
    { "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiTexCoord2fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiTexCoord2fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuiVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glReplacementCodeuivSUN", { GLextension::GL_SUN_triangle_list } },
    { "glReplacementCodeusSUN", { GLextension::GL_SUN_triangle_list } },
    { "glReplacementCodeusvSUN", { GLextension::GL_SUN_triangle_list } },
    { "glRequestResidentProgramsNV", { GLextension::GL_NV_vertex_program } },
    { "glResetHistogram", { GLextension::GL_ARB_imaging } },
    { "glResetHistogramEXT", { GLextension::GL_EXT_histogram } },
    { "glResetMemoryObjectParameterNV", { GLextension::GL_NV_memory_attachment } },
    { "glResetMinmax", { GLextension::GL_ARB_imaging } },
    { "glResetMinmaxEXT", { GLextension::GL_EXT_histogram } },
    { "glResizeBuffersMESA", { GLextension::GL_MESA_resize_buffers } },
    { "glResolveDepthValuesNV", { GLextension::GL_NV_sample_locations } },
    { "glResumeTransformFeedback", { GLextension::GL_ARB_transform_feedback2 } },
    { "glResumeTransformFeedbackNV", { GLextension::GL_NV_transform_feedback2 } },
    { "glRotatexOES", { GLextension::GL_OES_fixed_point } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_S =
{
    { "glSampleCoverageARB", { GLextension::GL_ARB_multisample } },
    { "glSampleCoveragexOES", { GLextension::GL_OES_fixed_point } },
    { "glSampleMapATI", { GLextension::GL_ATI_fragment_shader } },
    { "glSampleMaskEXT", { GLextension::GL_EXT_multisample } },
    { "glSampleMaskIndexedNV", { GLextension::GL_NV_explicit_multisample } },
    { "glSampleMaskSGIS", { GLextension::GL_SGIS_multisample } },
    { "glSampleMaski", { GLextension::GL_ARB_texture_multisample } },
    { "glSamplePatternEXT", { GLextension::GL_EXT_multisample } },
    { "glSamplePatternSGIS", { GLextension::GL_SGIS_multisample } },
    { "glSamplerParameterIiv", { GLextension::GL_ARB_sampler_objects } },
    { "glSamplerParameterIuiv", { GLextension::GL_ARB_sampler_objects } },
    { "glSamplerParameterf", { GLextension::GL_ARB_sampler_objects } },
    { "glSamplerParameterfv", { GLextension::GL_ARB_sampler_objects } },
    { "glSamplerParameteri", { GLextension::GL_ARB_sampler_objects } },
    { "glSamplerParameteriv", { GLextension::GL_ARB_sampler_objects } },
    { "glScalexOES", { GLextension::GL_OES_fixed_point } },
    { "glScissorArrayv", { GLextension::GL_ARB_viewport_array } },
    { "glScissorExclusiveArrayvNV", { GLextension::GL_NV_scissor_exclusive } },
    { "glScissorExclusiveNV", { GLextension::GL_NV_scissor_exclusive } },
    { "glScissorIndexed", { GLextension::GL_ARB_viewport_array } },
    { "glScissorIndexedv", { GLextension::GL_ARB_viewport_array } },
    { "glSecondaryColor3bEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3bvEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3dEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3dvEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3fEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3fvEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3hNV", { GLextension::GL_NV_half_float } },
    { "glSecondaryColor3hvNV", { GLextension::GL_NV_half_float } },
    { "glSecondaryColor3iEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3ivEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3sEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3svEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3ubEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3ubvEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3uiEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3uivEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3usEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColor3usvEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColorFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glSecondaryColorP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glSecondaryColorP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glSecondaryColorPointerEXT", { GLextension::GL_EXT_secondary_color } },
    { "glSecondaryColorPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glSelectPerfMonitorCountersAMD", { GLextension::GL_AMD_performance_monitor } },
    { "glSemaphoreParameterivNV", { GLextension::GL_NV_timeline_semaphore } },
    { "glSemaphoreParameterui64vEXT", { GLextension::GL_EXT_semaphore } },
    { "glSeparableFilter2D", { GLextension::GL_ARB_imaging } },
    { "glSeparableFilter2DEXT", { GLextension::GL_EXT_convolution } },
    { "glSetFenceAPPLE", { GLextension::GL_APPLE_fence } },
    { "glSetFenceNV", { GLextension::GL_NV_fence } },
    { "glSetFragmentShaderConstantATI", { GLextension::GL_ATI_fragment_shader } },
    { "glSetInvariantEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glSetLocalConstantEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glSetMultisamplefvAMD", { GLextension::GL_AMD_sample_positions } },
    { "glShaderBinary", { GLextension::GL_ARB_ES2_compatibility } },
    { "glShaderOp1EXT", { GLextension::GL_EXT_vertex_shader } },
    { "glShaderOp2EXT", { GLextension::GL_EXT_vertex_shader } },
    { "glShaderOp3EXT", { GLextension::GL_EXT_vertex_shader } },
    { "glShaderSourceARB", { GLextension::GL_ARB_shader_objects } },
    { "glShaderStorageBlockBinding", { GLextension::GL_ARB_shader_storage_buffer_object } },
    { "glShadingRateImageBarrierNV", { GLextension::GL_NV_shading_rate_image } },
    { "glShadingRateImagePaletteNV", { GLextension::GL_NV_shading_rate_image } },
    { "glShadingRateSampleOrderCustomNV", { GLextension::GL_NV_shading_rate_image } },
    { "glShadingRateSampleOrderNV", { GLextension::GL_NV_shading_rate_image } },
    { "glSharpenTexFuncSGIS", { GLextension::GL_SGIS_sharpen_texture } },
    { "glSignalSemaphoreEXT", { GLextension::GL_EXT_semaphore } },
    { "glSignalSemaphoreui64NVX", { GLextension::GL_NVX_progress_fence } },
    { "glSignalVkFenceNV", { GLextension::GL_NV_draw_vulkan_image } },
    { "glSignalVkSemaphoreNV", { GLextension::GL_NV_draw_vulkan_image } },
    { "glSpecializeShaderARB", { GLextension::GL_ARB_gl_spirv } },
    { "glSpriteParameterfSGIX", { GLextension::GL_SGIX_sprite } },
    { "glSpriteParameterfvSGIX", { GLextension::GL_SGIX_sprite } },
    { "glSpriteParameteriSGIX", { GLextension::GL_SGIX_sprite } },
    { "glSpriteParameterivSGIX", { GLextension::GL_SGIX_sprite } },
    { "glStartInstrumentsSGIX", { GLextension::GL_SGIX_instruments } },
    { "glStateCaptureNV", { GLextension::GL_NV_command_list } },
    { "glStencilClearTagEXT", { GLextension::GL_EXT_stencil_clear_tag } },
    { "glStencilFillPathInstancedNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilFillPathNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilFuncSeparateATI", { GLextension::GL_ATI_separate_stencil } },
    { "glStencilOpSeparateATI", { GLextension::GL_ATI_separate_stencil } },
    { "glStencilOpValueAMD", { GLextension::GL_AMD_stencil_operation_extended } },
    { "glStencilStrokePathInstancedNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilStrokePathNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilThenCoverFillPathInstancedNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilThenCoverFillPathNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilThenCoverStrokePathInstancedNV", { GLextension::GL_NV_path_rendering } },
    { "glStencilThenCoverStrokePathNV", { GLextension::GL_NV_path_rendering } },
    { "glStopInstrumentsSGIX", { GLextension::GL_SGIX_instruments } },
    { "glStringMarkerGREMEDY", { GLextension::GL_GREMEDY_string_marker } },
    { "glSubpixelPrecisionBiasNV", { GLextension::GL_NV_conservative_raster } },
    { "glSwizzleEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glSyncTextureINTEL", { GLextension::GL_INTEL_map_texture } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_T =
{
    { "glTagSampleBufferSGIX", { GLextension::GL_SGIX_tag_sample_buffer } },
    { "glTangent3bEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3bvEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3dEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3dvEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3fEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3fvEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3iEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3ivEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3sEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangent3svEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTangentPointerEXT", { GLextension::GL_EXT_coordinate_frame } },
    { "glTbufferMask3DFX", { GLextension::GL_3DFX_tbuffer } },
    { "glTessellationFactorAMD", { GLextension::GL_AMD_vertex_shader_tessellator } },
    { "glTessellationModeAMD", { GLextension::GL_AMD_vertex_shader_tessellator } },
    { "glTestFenceAPPLE", { GLextension::GL_APPLE_fence } },
    { "glTestFenceNV", { GLextension::GL_NV_fence } },
    { "glTestObjectAPPLE", { GLextension::GL_APPLE_fence } },
    { "glTexAttachMemoryNV", { GLextension::GL_NV_memory_attachment } },
    { "glTexBufferARB", { GLextension::GL_ARB_texture_buffer_object } },
    { "glTexBufferEXT", { GLextension::GL_EXT_texture_buffer_object } },
    { "glTexBufferRange", { GLextension::GL_ARB_texture_buffer_range } },
    { "glTexBumpParameterfvATI", { GLextension::GL_ATI_envmap_bumpmap } },
    { "glTexBumpParameterivATI", { GLextension::GL_ATI_envmap_bumpmap } },
    { "glTexCoord1bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord1bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord1hNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord1hvNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord1xOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord1xvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord2bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord2bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord2fColor3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fColor3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fColor4fNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fColor4fNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fColor4ubVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fColor4ubVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fNormal3fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fNormal3fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fVertex3fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2fVertex3fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord2hNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord2hvNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord2xOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord2xvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord3bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord3bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord3hNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord3hvNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord3xOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord3xvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord4bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord4bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glTexCoord4fColor4fNormal3fVertex4fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord4fColor4fNormal3fVertex4fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord4fVertex4fSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord4fVertex4fvSUN", { GLextension::GL_SUN_vertex } },
    { "glTexCoord4hNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord4hvNV", { GLextension::GL_NV_half_float } },
    { "glTexCoord4xOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoord4xvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexCoordFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glTexCoordP1ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP1uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP2ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP2uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP4ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordP4uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glTexCoordPointerEXT", { GLextension::GL_EXT_vertex_array } },
    { "glTexCoordPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glTexCoordPointervINTEL", { GLextension::GL_INTEL_parallel_arrays } },
    { "glTexEnvxOES", { GLextension::GL_OES_fixed_point } },
    { "glTexEnvxvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexFilterFuncSGIS", { GLextension::GL_SGIS_texture_filter4 } },
    { "glTexGenxOES", { GLextension::GL_OES_fixed_point } },
    { "glTexGenxvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexImage2DMultisample", { GLextension::GL_ARB_texture_multisample } },
    { "glTexImage2DMultisampleCoverageNV", { GLextension::GL_NV_texture_multisample } },
    { "glTexImage3DEXT", { GLextension::GL_EXT_texture3D } },
    { "glTexImage3DMultisample", { GLextension::GL_ARB_texture_multisample } },
    { "glTexImage3DMultisampleCoverageNV", { GLextension::GL_NV_texture_multisample } },
    { "glTexImage4DSGIS", { GLextension::GL_SGIS_texture4D } },
    { "glTexPageCommitmentARB", { GLextension::GL_ARB_sparse_texture } },
    { "glTexPageCommitmentMemNV", { GLextension::GL_NV_memory_object_sparse } },
    { "glTexParameterIivEXT", { GLextension::GL_EXT_texture_integer } },
    { "glTexParameterIuivEXT", { GLextension::GL_EXT_texture_integer } },
    { "glTexParameterxOES", { GLextension::GL_OES_fixed_point } },
    { "glTexParameterxvOES", { GLextension::GL_OES_fixed_point } },
    { "glTexRenderbufferNV", { GLextension::GL_NV_explicit_multisample } },
    { "glTexStorage1D", { GLextension::GL_ARB_texture_storage } },
    { "glTexStorage1DEXT", { GLextension::GL_EXT_texture_storage } },
    { "glTexStorage2D", { GLextension::GL_ARB_texture_storage } },
    { "glTexStorage2DEXT", { GLextension::GL_EXT_texture_storage } },
    { "glTexStorage2DMultisample", { GLextension::GL_ARB_texture_storage_multisample } },
    { "glTexStorage3D", { GLextension::GL_ARB_texture_storage } },
    { "glTexStorage3DEXT", { GLextension::GL_EXT_texture_storage } },
    { "glTexStorage3DMultisample", { GLextension::GL_ARB_texture_storage_multisample } },
    { "glTexStorageMem1DEXT", { GLextension::GL_EXT_memory_object } },
    { "glTexStorageMem2DEXT", { GLextension::GL_EXT_memory_object } },
    { "glTexStorageMem2DMultisampleEXT", { GLextension::GL_EXT_memory_object } },
    { "glTexStorageMem3DEXT", { GLextension::GL_EXT_memory_object } },
    { "glTexStorageMem3DMultisampleEXT", { GLextension::GL_EXT_memory_object } },
    { "glTexStorageSparseAMD", { GLextension::GL_AMD_sparse_texture } },
    { "glTexSubImage1DEXT", { GLextension::GL_EXT_subtexture } },
    { "glTexSubImage2DEXT", { GLextension::GL_EXT_subtexture } },
    { "glTexSubImage3DEXT", { GLextension::GL_EXT_texture3D } },
    { "glTexSubImage4DSGIS", { GLextension::GL_SGIS_texture4D } },
    { "glTextureAttachMemoryNV", { GLextension::GL_NV_memory_attachment } },
    { "glTextureBarrier", { GLextension::GL_ARB_texture_barrier } },
    { "glTextureBarrierNV", { GLextension::GL_NV_texture_barrier } },
    { "glTextureBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureBufferRange", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureBufferRangeEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureColorMaskSGIS", { GLextension::GL_SGIS_texture_color_mask } },
    { "glTextureImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureImage2DMultisampleCoverageNV", { GLextension::GL_NV_texture_multisample } },
    { "glTextureImage2DMultisampleNV", { GLextension::GL_NV_texture_multisample } },
    { "glTextureImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureImage3DMultisampleCoverageNV", { GLextension::GL_NV_texture_multisample } },
    { "glTextureImage3DMultisampleNV", { GLextension::GL_NV_texture_multisample } },
    { "glTextureLightEXT", { GLextension::GL_EXT_light_texture } },
    { "glTextureMaterialEXT", { GLextension::GL_EXT_light_texture } },
    { "glTextureNormalEXT", { GLextension::GL_EXT_texture_perturb_normal } },
    { "glTexturePageCommitmentEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTexturePageCommitmentMemNV", { GLextension::GL_NV_memory_object_sparse } },
    { "glTextureParameterIiv", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureParameterIivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureParameterIuiv", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureParameterIuivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureParameterf", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureParameterfEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureParameterfv", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureParameterfvEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureParameteri", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureParameteriEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureParameteriv", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureParameterivEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureRangeAPPLE", { GLextension::GL_APPLE_texture_range } },
    { "glTextureRenderbufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureStorage1D", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureStorage1DEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_texture_storage } },
    { "glTextureStorage2D", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureStorage2DEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_texture_storage } },
    { "glTextureStorage2DMultisample", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureStorage2DMultisampleEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureStorage3D", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureStorage3DEXT", { GLextension::GL_EXT_direct_state_access, GLextension::GL_EXT_texture_storage } },
    { "glTextureStorage3DMultisample", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureStorage3DMultisampleEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureStorageMem1DEXT", { GLextension::GL_EXT_memory_object } },
    { "glTextureStorageMem2DEXT", { GLextension::GL_EXT_memory_object } },
    { "glTextureStorageMem2DMultisampleEXT", { GLextension::GL_EXT_memory_object } },
    { "glTextureStorageMem3DEXT", { GLextension::GL_EXT_memory_object } },
    { "glTextureStorageMem3DMultisampleEXT", { GLextension::GL_EXT_memory_object } },
    { "glTextureStorageSparseAMD", { GLextension::GL_AMD_sparse_texture } },
    { "glTextureSubImage1D", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureSubImage1DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureSubImage2D", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureSubImage2DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureSubImage3D", { GLextension::GL_ARB_direct_state_access } },
    { "glTextureSubImage3DEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glTextureView", { GLextension::GL_ARB_texture_view } },
    { "glTrackMatrixNV", { GLextension::GL_NV_vertex_program } },
    { "glTransformFeedbackAttribsNV", { GLextension::GL_NV_transform_feedback } },
    { "glTransformFeedbackBufferBase", { GLextension::GL_ARB_direct_state_access } },
    { "glTransformFeedbackBufferRange", { GLextension::GL_ARB_direct_state_access } },
    { "glTransformFeedbackStreamAttribsNV", { GLextension::GL_NV_transform_feedback } },
    { "glTransformFeedbackVaryingsEXT", { GLextension::GL_EXT_transform_feedback } },
    { "glTransformFeedbackVaryingsNV", { GLextension::GL_NV_transform_feedback } },
    { "glTransformPathNV", { GLextension::GL_NV_path_rendering } },
    { "glTranslatexOES", { GLextension::GL_OES_fixed_point } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_U =
{
    { "glUniform1d", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform1dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform1fARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform1fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform1i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform1i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform1i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform1i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform1iARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform1ivARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform1ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform1ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform1ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform1ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform1uiEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform1uivEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform2d", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform2dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform2fARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform2fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform2i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform2i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform2i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform2i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform2iARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform2ivARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform2ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform2ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform2ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform2ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform2uiEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform2uivEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform3d", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform3dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform3fARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform3fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform3i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform3i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform3i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform3i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform3iARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform3ivARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform3ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform3ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform3ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform3ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform3uiEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform3uivEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform4d", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform4dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniform4fARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform4fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform4i64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform4i64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform4i64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform4i64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform4iARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform4ivARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniform4ui64ARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform4ui64NV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform4ui64vARB", { GLextension::GL_ARB_gpu_shader_int64 } },
    { "glUniform4ui64vNV", { GLextension::GL_AMD_gpu_shader_int64, GLextension::GL_NV_gpu_shader5 } },
    { "glUniform4uiEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniform4uivEXT", { GLextension::GL_EXT_gpu_shader4 } },
    { "glUniformBlockBinding", { GLextension::GL_ARB_uniform_buffer_object } },
    { "glUniformBufferEXT", { GLextension::GL_EXT_bindable_uniform } },
    { "glUniformHandleui64ARB", { GLextension::GL_ARB_bindless_texture } },
    { "glUniformHandleui64NV", { GLextension::GL_NV_bindless_texture } },
    { "glUniformHandleui64vARB", { GLextension::GL_ARB_bindless_texture } },
    { "glUniformHandleui64vNV", { GLextension::GL_NV_bindless_texture } },
    { "glUniformMatrix2dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix2fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniformMatrix2x3dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix2x4dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix3dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix3fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniformMatrix3x2dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix3x4dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix4dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix4fvARB", { GLextension::GL_ARB_shader_objects } },
    { "glUniformMatrix4x2dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformMatrix4x3dv", { GLextension::GL_ARB_gpu_shader_fp64 } },
    { "glUniformSubroutinesuiv", { GLextension::GL_ARB_shader_subroutine } },
    { "glUniformui64NV", { GLextension::GL_NV_shader_buffer_load } },
    { "glUniformui64vNV", { GLextension::GL_NV_shader_buffer_load } },
    { "glUnlockArraysEXT", { GLextension::GL_EXT_compiled_vertex_array } },
    { "glUnmapBufferARB", { GLextension::GL_ARB_vertex_buffer_object } },
    { "glUnmapNamedBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glUnmapNamedBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glUnmapObjectBufferATI", { GLextension::GL_ATI_map_object_buffer } },
    { "glUnmapTexture2DINTEL", { GLextension::GL_INTEL_map_texture } },
    { "glUpdateObjectBufferATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glUploadGpuMaskNVX", { GLextension::GL_NVX_gpu_multicast2 } },
    { "glUseProgramObjectARB", { GLextension::GL_ARB_shader_objects } },
    { "glUseProgramStages", { GLextension::GL_ARB_separate_shader_objects } },
    { "glUseProgramStagesEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glUseShaderProgramEXT", { GLextension::GL_EXT_separate_shader_objects } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_V =
{
    { "glVDPAUFiniNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAUGetSurfaceivNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAUInitNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAUIsSurfaceNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAUMapSurfacesNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAURegisterOutputSurfaceNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAURegisterVideoSurfaceNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAURegisterVideoSurfaceWithPictureStructureNV", { GLextension::GL_NV_vdpau_interop2 } },
    { "glVDPAUSurfaceAccessNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAUUnmapSurfacesNV", { GLextension::GL_NV_vdpau_interop } },
    { "glVDPAUUnregisterSurfaceNV", { GLextension::GL_NV_vdpau_interop } },
    { "glValidateProgramARB", { GLextension::GL_ARB_shader_objects } },
    { "glValidateProgramPipeline", { GLextension::GL_ARB_separate_shader_objects } },
    { "glValidateProgramPipelineEXT", { GLextension::GL_EXT_separate_shader_objects } },
    { "glVariantArrayObjectATI", { GLextension::GL_ATI_vertex_array_object } },
    { "glVariantPointerEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantbvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantdvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantfvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantivEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantsvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantubvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantuivEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVariantusvEXT", { GLextension::GL_EXT_vertex_shader } },
    { "glVertex2bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glVertex2bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glVertex2hNV", { GLextension::GL_NV_half_float } },
    { "glVertex2hvNV", { GLextension::GL_NV_half_float } },
    { "glVertex2xOES", { GLextension::GL_OES_fixed_point } },
    { "glVertex2xvOES", { GLextension::GL_OES_fixed_point } },
    { "glVertex3bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glVertex3bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glVertex3hNV", { GLextension::GL_NV_half_float } },
    { "glVertex3hvNV", { GLextension::GL_NV_half_float } },
    { "glVertex3xOES", { GLextension::GL_OES_fixed_point } },
    { "glVertex3xvOES", { GLextension::GL_OES_fixed_point } },
    { "glVertex4bOES", { GLextension::GL_OES_byte_coordinates } },
    { "glVertex4bvOES", { GLextension::GL_OES_byte_coordinates } },
    { "glVertex4hNV", { GLextension::GL_NV_half_float } },
    { "glVertex4hvNV", { GLextension::GL_NV_half_float } },
    { "glVertex4xOES", { GLextension::GL_OES_fixed_point } },
    { "glVertex4xvOES", { GLextension::GL_OES_fixed_point } },
    { "glVertexArrayAttribBinding", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayAttribFormat", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayAttribIFormat", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayAttribLFormat", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayBindVertexBufferEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayBindingDivisor", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayColorOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayEdgeFlagOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayElementBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayFogCoordOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayIndexOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayMultiTexCoordOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayNormalOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayParameteriAPPLE", { GLextension::GL_APPLE_vertex_array_range } },
    { "glVertexArrayRangeAPPLE", { GLextension::GL_APPLE_vertex_array_range } },
    { "glVertexArrayRangeNV", { GLextension::GL_NV_vertex_array_range } },
    { "glVertexArraySecondaryColorOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayTexCoordOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribBindingEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribDivisorEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribFormatEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribIFormatEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribIOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribLFormatEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribLOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexAttribOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexBindingDivisorEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexArrayVertexBuffer", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayVertexBuffers", { GLextension::GL_ARB_direct_state_access } },
    { "glVertexArrayVertexOffsetEXT", { GLextension::GL_EXT_direct_state_access } },
    { "glVertexAttrib1dARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib1dNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib1dvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib1dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib1fARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib1fNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib1fvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib1fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib1hNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib1hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib1sARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib1sNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib1svARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib1svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib2dARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib2dNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib2dvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib2dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib2fARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib2fNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib2fvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib2fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib2hNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib2hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib2sARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib2sNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib2svARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib2svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib3dARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib3dNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib3dvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib3dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib3fARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib3fNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib3fvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib3fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib3hNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib3hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib3sARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib3sNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib3svARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib3svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4NbvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4NivARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4NsvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4NubARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4NubvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4NuivARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4NusvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4bvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4dARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4dNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4dvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4fARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4fNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4fvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4hNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib4hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttrib4ivARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4sARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4sNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4svARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4ubNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4ubvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4ubvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttrib4uivARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttrib4usvARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttribArrayObjectATI", { GLextension::GL_ATI_vertex_attrib_array_object } },
    { "glVertexAttribBinding", { GLextension::GL_ARB_vertex_attrib_binding } },
    { "glVertexAttribDivisorARB", { GLextension::GL_ARB_instanced_arrays } },
    { "glVertexAttribFormat", { GLextension::GL_ARB_vertex_attrib_binding } },
    { "glVertexAttribFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glVertexAttribI1iEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI1ivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI1uiEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI1uivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI2iEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI2ivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI2uiEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI2uivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI3iEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI3ivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI3uiEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI3uivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4bvEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4iEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4ivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4svEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4ubvEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4uiEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4uivEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribI4usvEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribIFormat", { GLextension::GL_ARB_vertex_attrib_binding } },
    { "glVertexAttribIFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glVertexAttribIPointerEXT", { GLextension::GL_EXT_gpu_shader4, GLextension::GL_NV_vertex_program4 } },
    { "glVertexAttribL1d", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL1dEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL1dv", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL1dvEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL1i64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL1i64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL1ui64ARB", { GLextension::GL_ARB_bindless_texture } },
    { "glVertexAttribL1ui64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL1ui64vARB", { GLextension::GL_ARB_bindless_texture } },
    { "glVertexAttribL1ui64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL2d", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL2dEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL2dv", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL2dvEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL2i64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL2i64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL2ui64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL2ui64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL3d", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL3dEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL3dv", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL3dvEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL3i64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL3i64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL3ui64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL3ui64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL4d", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL4dEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL4dv", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribL4dvEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribL4i64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL4i64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL4ui64NV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribL4ui64vNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribLFormat", { GLextension::GL_ARB_vertex_attrib_binding } },
    { "glVertexAttribLFormatNV", { GLextension::GL_NV_vertex_attrib_integer_64bit } },
    { "glVertexAttribLPointer", { GLextension::GL_ARB_vertex_attrib_64bit } },
    { "glVertexAttribLPointerEXT", { GLextension::GL_EXT_vertex_attrib_64bit } },
    { "glVertexAttribP1ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP1uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP2ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP2uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP4ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribP4uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexAttribParameteriAMD", { GLextension::GL_AMD_interleaved_elements } },
    { "glVertexAttribPointerARB", { GLextension::GL_ARB_vertex_program, GLextension::GL_ARB_vertex_shader } },
    { "glVertexAttribPointerNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs1dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs1fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs1hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttribs1svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs2dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs2fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs2hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttribs2svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs3dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs3fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs3hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttribs3svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs4dvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs4fvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs4hvNV", { GLextension::GL_NV_half_float } },
    { "glVertexAttribs4svNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexAttribs4ubvNV", { GLextension::GL_NV_vertex_program } },
    { "glVertexBindingDivisor", { GLextension::GL_ARB_vertex_attrib_binding } },
    { "glVertexBlendARB", { GLextension::GL_ARB_vertex_blend } },
    { "glVertexBlendEnvfATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexBlendEnviATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexFormatNV", { GLextension::GL_NV_vertex_buffer_unified_memory } },
    { "glVertexP2ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexP2uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexP3ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexP3uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexP4ui", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexP4uiv", { GLextension::GL_ARB_vertex_type_2_10_10_10_rev } },
    { "glVertexPointerEXT", { GLextension::GL_EXT_vertex_array } },
    { "glVertexPointerListIBM", { GLextension::GL_IBM_vertex_array_lists } },
    { "glVertexPointervINTEL", { GLextension::GL_INTEL_parallel_arrays } },
    { "glVertexStream1dATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1dvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1fATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1fvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1iATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1ivATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1sATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream1svATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2dATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2dvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2fATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2fvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2iATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2ivATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2sATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream2svATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3dATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3dvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3fATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3fvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3iATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3ivATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3sATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream3svATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4dATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4dvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4fATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4fvATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4iATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4ivATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4sATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexStream4svATI", { GLextension::GL_ATI_vertex_streams } },
    { "glVertexWeightPointerEXT", { GLextension::GL_EXT_vertex_weighting } },
    { "glVertexWeightfEXT", { GLextension::GL_EXT_vertex_weighting } },
    { "glVertexWeightfvEXT", { GLextension::GL_EXT_vertex_weighting } },
    { "glVertexWeighthNV", { GLextension::GL_NV_half_float } },
    { "glVertexWeighthvNV", { GLextension::GL_NV_half_float } },
    { "glVideoCaptureNV", { GLextension::GL_NV_video_capture } },
    { "glVideoCaptureStreamParameterdvNV", { GLextension::GL_NV_video_capture } },
    { "glVideoCaptureStreamParameterfvNV", { GLextension::GL_NV_video_capture } },
    { "glVideoCaptureStreamParameterivNV", { GLextension::GL_NV_video_capture } },
    { "glViewportArrayv", { GLextension::GL_ARB_viewport_array } },
    { "glViewportIndexedf", { GLextension::GL_ARB_viewport_array } },
    { "glViewportIndexedfv", { GLextension::GL_ARB_viewport_array } },
    { "glViewportPositionWScaleNV", { GLextension::GL_NV_clip_space_w_scaling } },
    { "glViewportSwizzleNV", { GLextension::GL_NV_viewport_swizzle } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_W =
{
    { "glWaitSemaphoreEXT", { GLextension::GL_EXT_semaphore } },
    { "glWaitSemaphoreui64NVX", { GLextension::GL_NVX_progress_fence } },
    { "glWaitSync", { GLextension::GL_ARB_sync } },
    { "glWaitVkSemaphoreNV", { GLextension::GL_NV_draw_vulkan_image } },
    { "glWeightPathsNV", { GLextension::GL_NV_path_rendering } },
    { "glWeightPointerARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightbvARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightdvARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightfvARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightivARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightsvARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightubvARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightuivARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWeightusvARB", { GLextension::GL_ARB_vertex_blend } },
    { "glWindowPos2dARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2dMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2dvARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2dvMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2fARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2fMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2fvARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2fvMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2iARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2iMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2ivARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2ivMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2sARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2sMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos2svARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos2svMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3dARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3dMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3dvARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3dvMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3fARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3fMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3fvARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3fvMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3iARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3iMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3ivARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3ivMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3sARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3sMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos3svARB", { GLextension::GL_ARB_window_pos } },
    { "glWindowPos3svMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4dMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4dvMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4fMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4fvMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4iMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4ivMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4sMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowPos4svMESA", { GLextension::GL_MESA_window_pos } },
    { "glWindowRectanglesEXT", { GLextension::GL_EXT_window_rectangles } },
    { "glWriteMaskEXT", { GLextension::GL_EXT_vertex_shader } }
};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_X{};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_Y{};
const std::unordered_map<std::string, std::set<GLextension>> Meta_ExtensionsByFunctionString_Z{};

const std::array<std::unordered_map<std::string, std::set<gl::GLextension>>, 27> Meta_ExtensionsByFunctionStringMaps =
{ {
    Meta_ExtensionsByFunctionString_0,
    Meta_ExtensionsByFunctionString_A,
    Meta_ExtensionsByFunctionString_B,
    Meta_ExtensionsByFunctionString_C,
    Meta_ExtensionsByFunctionString_D,
    Meta_ExtensionsByFunctionString_E,
    Meta_ExtensionsByFunctionString_F,
    Meta_ExtensionsByFunctionString_G,
    Meta_ExtensionsByFunctionString_H,
    Meta_ExtensionsByFunctionString_I,
    Meta_ExtensionsByFunctionString_J,
    Meta_ExtensionsByFunctionString_K,
    Meta_ExtensionsByFunctionString_L,
    Meta_ExtensionsByFunctionString_M,
    Meta_ExtensionsByFunctionString_N,
    Meta_ExtensionsByFunctionString_O,
    Meta_ExtensionsByFunctionString_P,
    Meta_ExtensionsByFunctionString_Q,
    Meta_ExtensionsByFunctionString_R,
    Meta_ExtensionsByFunctionString_S,
    Meta_ExtensionsByFunctionString_T,
    Meta_ExtensionsByFunctionString_U,
    Meta_ExtensionsByFunctionString_V,
    Meta_ExtensionsByFunctionString_W,
    Meta_ExtensionsByFunctionString_X,
    Meta_ExtensionsByFunctionString_Y,
    Meta_ExtensionsByFunctionString_Z
} };


} } // namespace glbinding::aux