------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2007 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: ddef.adb,v 1.6 2007/10/22 14:02:27 vagul Exp $

--  Example of Logon and statement execution.

with
   Ada.Text_IO,
   OCI.Thick.Connections,
   OCI.Thick.Statements,
   OCI.Thick.Strings;

procedure DDef is
   use OCI.Thick;
   use Ada.Text_IO;

   Connect : Connections.Connection := Connections.Logon
     (Server_Name => "",
      User        => "scott",
      Password    => "tiger");
   --  Using the OCI.Thick.Connections package.
   --  Logon to the database and creating database connection

   Stmt : Statements.Statement := Statements.Prepare
                                    ("select 'one' from dual union all "
                                   & "select 'two' from dual union all "
                                   & "select 'three' from dual");

   Column : Strings.Variable;             --  Unlimited length string.

begin
   --  We can see the server version information.

   Put_Line (Connections.Server_Version (Connect));
   New_Line;

   --  Statements prepeared with connection should be executed
   --  without connection.

   Statements.Execute (Connect, Stmt);

   Strings.Define (Stmt, Column, 1);

   while Statements.Fetch (Stmt) loop
      Put_Line (Strings.Value (Column) & ';');
   end loop;
end DDef;
