GOPHIAN-MAKE(1)

# NAME

gophian-make - Prepare a Go module for packaging in Debian

# SYNOPSIS

*gophian make* <IMPORTPATH> [OPTIONS]

# DESCRIPTION

This subcommand prepares a Debian package for Go software, producing a DEP-14
and Go team compliant Git repository that has the latest appropriate upstream
source imported, and initial packaging files that have been filled out
intelligently as best as possible.

Before starting, Gophian will check if the *IMPORTPATH* passed has already been
packaged for Debian. This makes use of the same functionality used by
_gophian-show_(1) and _gophian-search_(1), which makes use of the
*XS-Go-Import-Path* field specified in Debian source packages. If found, Gophian
will warn you, and unless the *--no-warn-packaged* option was passed, the
program will exit.

If Gophian finds binary programs (files that start with "package 'main'") in the
upstream code, it will prompt you to choose what type of package you intend to
create. The prompt can be skipped ahead of time by setting the *--type* option.

- *Library only* - Package is only intended to be imported by other programs.
  The source package will be named after the library. This is most Go packages
  depended on by other projects.

- *Library and accompanying binaries* - Package is intended to be imported by
  other programs, with a helper or side program(s), usually meant to be used
  alongside the library. The source package will be named after the library. For
  example, the main purpose of github.com/go-git/go-git is to be used by other
  code, but also includes a proof-of-concept CLI called go-git.

- *Binaries and accompanying library* - Package is intended to be used by the
  end user as a program, but also supplies a library to programs that want to
  consume it. The source package will be named after the binary. For example,
  Docker is mainly used as a CLI, but is also intentionally developed by
  upstream in such a way that it is reusable to other projects, and so is also
  available as a library.

- *Binary only* - Package is only intended to be used as a program by the end
  user, and no library package should be created. The source package will be
  named after the binary. This is most end-user programs written in Go.

If no binary packages are found, the "**Library only**" package type is chosen
automatically without prompting you.

If you selected one of the package types that include one or more binaries, you
will then be prompted to select which binaries you'd like to include in the
generated d/control template. You should use this opportunity to check for and
exclude any example programs that are not intended to be built.

If you selected one of the package types "*Binaries and accompanying library*"
or "*Binary only*", you will be prompted to choose which binary to name the
source package after. This should usually be the name of the primary program
intended to be used by the end user, which is often also the name of the
upstream project itself.

Following this, Gophian will check for any existing Salsa repos under the Go
team with this name of source package, and warn you if one has been found. The
program will then exit unless the *--no-warn-salsa* flag was passed.

Gophian will also check for any open Intent to Package (ITP) or Request for
Package (RFP) bugs matching the source package name and warn you. If found, this
will be filled in the generated d/changelog for you.

Gophian will now prepare the packaging Git repository, importing the latest
upstream source and generating the initial packaging files. It will also check
for any unpackaged dependencies and test dependencies and warn you about them.

Once this is complete, it is strongly recommended you review all the Debian
packaging files generated by Gophian and ensure all information is correct, and
then fill in any missing information and complete any additional packaging work
required.

# ARGUMENTS

*IMPORTPATH* - The import path of the Go package being Debianized.

# OPTIONS

*--type* [l|l+b|b+l|b] - Select the type of software being packaged. Can be one
of "*Library only*", "*Library and accompanying binaries*", "*Binaries and
accompanying library*", or "*Binaries only*", denoted by "l", "l+b", "b+l", or
"b" respectively.

*--name* <NAME> - Name of package maintainer. Uses _DEBFULLNAME_ environment variable
by default. (required)

*--email* <EMAIL> - Email of package maintainer. Uses _DEBEMAIL_ environment variable
by default. (required)

*--[no-]quiet* - Don't print warnings.

*--[no-]warn-packaged* - Warn if the given Go package has already been
packaged for Debian. (default: true)

*--[no-]warn-salsa* - Warn if the package already has a repo under the Go team
namespace on Salsa. (default: true)

*--[no-]itp* - Generate an ITP template as well. (default: false)

*--[no-]todo* - Generate a debian/TODO file. (default: false)

*--[no-]pristine-tar* - Create a pristine-tar branch and delta file.
(default: false)

*--[no-]gpg-sign* - GPG sign the commit that merges the upstream tarball into
the packaging branch. If not passed to Gophian, then it will not be passed to
git nor gbp and they will use their configured defaults.

*--[no-]include-upstream-history* - Include upstream git history. Upstream will
be tracked with the 'upstreamvcs' remote, and commits that import new package
versions will include the upstream commit or tag as a parent. (default: false)

*--git-remote* [ssh|https] - Protocol to use when setting Git remote.
(default: ssh)

*--help* - Show help message and exit.

# ENVIRONMENT

_DEBFULLNAME_ - Used for *--name*.

_DEBEMAIL_ - Used for *--email*.

_GOPHIAN_ITP_ - Used for *--[no-]itp*.

_GOPHIAN_TODO_ - Used for *--[no-]todo*.

_GOPHIAN_PRISTINE_TAR_ - Used for *--[no-]pristine-tar*.

_GOPHIAN_REMOTE_ - Used for *--git-remote*.

_GOPHIAN_GPG_SIGN_ - Used for *--[no-]gpg-sign*.

# SEE ALSO

_gophian_(1), _gophian-license-text_(1)
