/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _POCKET_H_
#define _POCKET_H_

#include <list>

#include <gtk/gtk.h>

#include "ball.h"
#include "element.h"
#include "icons.h"

class Pocket : public Element {
protected:
   GtkWidget*	_table;
   Element*	_element;
   Ball* 	_ball;
 
   GtkWidget*  	_pixmapwid;   

   bool Contains(Ball::Color color);

   virtual const gchar* GetRedPixmap() = 0;
   virtual const gchar* GetGreenPixmap() = 0;
   virtual const gchar* GetBluePixmap() = 0;
   virtual const gchar* GetYellowPixmap() = 0;
public:
   Pocket(GtkWidget* table, int row, int col);
   virtual void ConnectLeft(Element* element) {}
   virtual void ConnectTop(Element* element) {}
   virtual void ConnectRight(Element* element) {}
   virtual void ConnectBottom(Element* element) {}
   void PutBall(Ball* ball);
   virtual void MoveBall(Ball* ball) = 0;
   virtual void Eject() = 0;
   virtual bool HasRightBall() = 0;
};

class SetOffPockets {
   std::list<Pocket*> _set;
public:
   SetOffPockets() {}
   void Add(Pocket* pocket) {_set.push_back(pocket);}
   void MakeEmpty() {_set.erase(_set.begin(), _set.end());}
   void Eject();
   bool HasRightBalls();
};

class LeftPocket : public Pocket {
protected:
   const gchar* GetRedPixmap() {return GROUNDHOG_STOCK_LEFT_RED;}
   const gchar* GetGreenPixmap() {return GROUNDHOG_STOCK_LEFT_GREEN;}
   const gchar* GetBluePixmap() {return GROUNDHOG_STOCK_LEFT_BLUE;}
   const gchar* GetYellowPixmap() {return GROUNDHOG_STOCK_LEFT_YELLOW;}
public:
   LeftPocket(GtkWidget* table, int row, int col) : Pocket(table, row, col) {}
   void ConnectRight(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Red);}
   void MoveBall(Ball* ball);
};

class UpperPocket : public Pocket {
protected:
   const gchar* GetRedPixmap() {return GROUNDHOG_STOCK_UPPER_RED;}
   const gchar* GetGreenPixmap() {return GROUNDHOG_STOCK_UPPER_GREEN;}
   const gchar* GetBluePixmap() {return GROUNDHOG_STOCK_UPPER_BLUE;}
   const gchar* GetYellowPixmap() {return GROUNDHOG_STOCK_UPPER_YELLOW;}
public:
   UpperPocket(GtkWidget* table, int row, int col) : Pocket(table, row, col) {}
   void ConnectBottom(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Green);}
   void MoveBall(Ball* ball);
};

class RightPocket : public Pocket {
protected:
   const gchar* GetRedPixmap() {return GROUNDHOG_STOCK_RIGHT_RED;}
   const gchar* GetGreenPixmap() {return GROUNDHOG_STOCK_RIGHT_GREEN;}
   const gchar* GetBluePixmap() {return GROUNDHOG_STOCK_RIGHT_BLUE;}
   const gchar* GetYellowPixmap() {return GROUNDHOG_STOCK_RIGHT_YELLOW;}
public:
   RightPocket(GtkWidget* table, int row, int col) : Pocket(table, row, col) {}
   void ConnectLeft(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Blue);}
   void MoveBall(Ball* ball);
};

class LowerPocket : public Pocket {
protected:
   const gchar* GetRedPixmap() {return GROUNDHOG_STOCK_LOWER_RED;}
   const gchar* GetGreenPixmap() {return GROUNDHOG_STOCK_LOWER_GREEN;}
   const gchar* GetBluePixmap() {return GROUNDHOG_STOCK_LOWER_BLUE;}
   const gchar* GetYellowPixmap() {return GROUNDHOG_STOCK_LOWER_YELLOW;}
public:
   LowerPocket(GtkWidget* table, int row, int col) : Pocket(table, row, col) {}
   void ConnectTop(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Yellow);}
   void MoveBall(Ball* ball);
};

#endif // _POCKET_H_
