/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.ClassInfoVisitor;
import org.osjava.jardiff.DOMDiffHandler;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.DiffHandler;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;
import org.osjava.jardiff.SimpleDiffCriteria;

public class JarDiff {
    protected Map depClassInfo = new HashMap();
    protected Map oldClassInfo = new HashMap();
    protected Map newClassInfo = new HashMap();
    private URL[] deps;
    private URLClassLoader depLoader;
    private String oldVersion;
    private String newVersion;
    private ClassInfoVisitor infoVisitor = new ClassInfoVisitor();
    private static final Set FORMATS = new HashSet();
    static /* synthetic */ Class class$org$osjava$jardiff$JarDiff;

    private static void showHelp(Options options, String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("JarDiff -f <from jar> -t <to jar> [-F <from name>] [-T <to name>] [[-o <xml|html|xhtml|text>]|[-x <xsl file>]] [-O <file>]", options);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        try {
            void var6_9;
            Transformer ot;
            Options options = new Options();
            Option tmp = new Option("f", "from", true, "from jar file");
            options.addOption(tmp);
            tmp = new Option("t", "to", true, "to jar file");
            options.addOption(tmp);
            tmp = new Option("F", "from-name", true, "from name");
            options.addOption(tmp);
            tmp = new Option("T", "to-name", true, "to name");
            options.addOption(tmp);
            tmp = new Option("o", "output-format", true, "output format, xml or html");
            options.addOption(tmp);
            tmp = new Option("O", "out", true, "output file");
            options.addOption(tmp);
            tmp = new Option("h", "help", false, "print help on command line arguments");
            options.addOption(tmp);
            tmp = new Option("x", "xsl", true, "custom xsl sheet to format output with");
            options.addOption(tmp);
            GnuParser parser = new GnuParser();
            CommandLine cli = null;
            try {
                cli = parser.parse(options, args);
            }
            catch (ParseException pe) {
                JarDiff.showHelp(options, pe.getMessage());
                return;
            }
            args = cli.getArgs();
            if (cli.hasOption('h')) {
                JarDiff.showHelp(options, null);
                return;
            }
            if (args.length > 0) {
                JarDiff.showHelp(options, "Additional arguments specified");
                return;
            }
            if (!cli.hasOption('f')) {
                JarDiff.showHelp(options, "Missing required argument: -f");
                return;
            }
            if (!cli.hasOption('t')) {
                JarDiff.showHelp(options, "Missing required argument: -t");
                return;
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setErrorListener(new ErrorListener(){

                public void warning(TransformerException te) {
                    System.err.println("xslt warning: " + te.getMessageAndLocation());
                }

                public void error(TransformerException te) {
                    System.err.println("xslt error: " + te.getMessageAndLocation());
                }

                public void fatalError(TransformerException te) {
                    System.err.println("xslt fatal error: " + te.getMessageAndLocation());
                }
            });
            if (cli.hasOption('o')) {
                if (cli.hasOption('x')) {
                    JarDiff.showHelp(options, "Cannot use both -x and -o");
                    return;
                }
                String val = cli.getOptionValue('o');
                if ("xml".equals(val)) {
                    ot = tf.newTransformer();
                } else {
                    if (!FORMATS.contains(val)) {
                        JarDiff.showHelp(options, "Invalid output format: " + val);
                        return;
                    }
                    URL url = (class$org$osjava$jardiff$JarDiff == null ? (class$org$osjava$jardiff$JarDiff = JarDiff.class$("org.osjava.jardiff.JarDiff")) : class$org$osjava$jardiff$JarDiff).getClassLoader().getResource("style/jardiff-" + val + ".xsl");
                    ot = tf.newTransformer(new StreamSource(url.toString()));
                }
            } else if (cli.hasOption('x')) {
                File xsl = new File(cli.getOptionValue('x'));
                ot = tf.newTransformer(new StreamSource(xsl));
            } else {
                ot = tf.newTransformer();
            }
            OutputStream out = cli.hasOption('O') ? new FileOutputStream(cli.getOptionValue('O')) : System.out;
            JarDiff jd = new JarDiff();
            File oldFile = new File(cli.getOptionValue('f'));
            File newFile = new File(cli.getOptionValue('t'));
            if (cli.hasOption('F')) {
                jd.setOldVersion(cli.getOptionValue('F'));
            } else {
                jd.setOldVersion(oldFile.getName());
            }
            if (cli.hasOption('T')) {
                jd.setNewVersion(cli.getOptionValue('T'));
            } else {
                jd.setNewVersion(newFile.getName());
            }
            jd.loadOldClasses(oldFile);
            jd.loadNewClasses(newFile);
            jd.diff(new DOMDiffHandler((Transformer)var6_9, new StreamResult(out)), new SimpleDiffCriteria());
            out.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setDependencies(URL[] deps) {
        this.deps = deps;
    }

    public URL[] getDependencies() {
        return this.deps;
    }

    private synchronized ClassInfo loadClassInfo(ClassReader reader) throws IOException {
        this.infoVisitor.reset();
        reader.accept((ClassVisitor)this.infoVisitor, false);
        return this.infoVisitor.getClassInfo();
    }

    private void loadClasses(Map infoMap, URL path) throws DiffException {
        try {
            File jarFile = null;
            if (!"file".equals(path.getProtocol()) || path.getHost() != null) {
                int i;
                jarFile = File.createTempFile("jardiff", "jar");
                jarFile.deleteOnExit();
                InputStream in = path.openStream();
                FileOutputStream out = new FileOutputStream(jarFile);
                byte[] buffer = new byte[4096];
                while ((i = in.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)out).write(buffer, 0, i);
                }
                in.close();
                ((OutputStream)out).close();
            } else {
                jarFile = new File(path.getPath());
            }
            this.loadClasses(infoMap, jarFile);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    private void loadClasses(Map infoMap, File file) throws DiffException {
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".class")) continue;
                ClassReader reader = new ClassReader(jar.getInputStream(entry));
                ClassInfo ci = this.loadClassInfo(reader);
                infoMap.put(ci.getName(), ci);
            }
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    public void loadOldClasses(URL loc) throws DiffException {
        this.loadClasses(this.oldClassInfo, loc);
    }

    public void loadNewClasses(URL loc) throws DiffException {
        this.loadClasses(this.newClassInfo, loc);
    }

    public void loadOldClasses(File file) throws DiffException {
        this.loadClasses(this.oldClassInfo, file);
    }

    public void loadNewClasses(File file) throws DiffException {
        this.loadClasses(this.newClassInfo, file);
    }

    public void diff(DiffHandler handler, DiffCriteria criteria) throws DiffException {
        ClassInfo ci;
        String s;
        TreeSet onlyOld = new TreeSet(this.oldClassInfo.keySet());
        TreeSet onlyNew = new TreeSet(this.newClassInfo.keySet());
        TreeSet both = new TreeSet(this.oldClassInfo.keySet());
        onlyOld.removeAll(this.newClassInfo.keySet());
        onlyNew.removeAll(this.oldClassInfo.keySet());
        both.retainAll(this.newClassInfo.keySet());
        handler.startDiff(this.oldVersion, this.newVersion);
        handler.startRemoved();
        Iterator i = onlyOld.iterator();
        while (i.hasNext()) {
            s = (String)i.next();
            ci = (ClassInfo)this.oldClassInfo.get(s);
            if (!criteria.validClass(ci)) continue;
            handler.classRemoved(ci);
        }
        handler.endRemoved();
        handler.startAdded();
        i = onlyNew.iterator();
        while (i.hasNext()) {
            s = (String)i.next();
            ci = (ClassInfo)this.newClassInfo.get(s);
            if (!criteria.validClass(ci)) continue;
            handler.classAdded(ci);
        }
        handler.endAdded();
        TreeSet removedMethods = new TreeSet();
        TreeSet removedFields = new TreeSet();
        TreeSet addedMethods = new TreeSet();
        TreeSet addedFields = new TreeSet();
        TreeSet changedMethods = new TreeSet();
        TreeSet changedFields = new TreeSet();
        handler.startChanged();
        i = both.iterator();
        while (i.hasNext()) {
            Map.Entry tmp;
            AbstractInfo newInfo;
            AbstractInfo oldInfo;
            String desc;
            Map.Entry entry;
            String s2 = (String)i.next();
            ClassInfo oci = (ClassInfo)this.oldClassInfo.get(s2);
            ClassInfo nci = (ClassInfo)this.newClassInfo.get(s2);
            if (!criteria.validClass(oci) && !criteria.validClass(nci)) continue;
            Map oldMethods = oci.getMethodMap();
            Map oldFields = oci.getFieldMap();
            Map newMethods = nci.getMethodMap();
            Map newFields = nci.getFieldMap();
            Iterator j = oldMethods.entrySet().iterator();
            while (j.hasNext()) {
                entry = j.next();
                if (!criteria.validMethod((MethodInfo)entry.getValue())) continue;
                removedMethods.add(entry.getKey());
            }
            j = oldFields.entrySet().iterator();
            while (j.hasNext()) {
                entry = j.next();
                if (!criteria.validField((FieldInfo)entry.getValue())) continue;
                removedFields.add(entry.getKey());
            }
            j = newMethods.entrySet().iterator();
            while (j.hasNext()) {
                entry = j.next();
                if (!criteria.validMethod((MethodInfo)entry.getValue())) continue;
                addedMethods.add(entry.getKey());
            }
            j = newFields.entrySet().iterator();
            while (j.hasNext()) {
                entry = j.next();
                if (!criteria.validField((FieldInfo)entry.getValue())) continue;
                addedFields.add(entry.getKey());
            }
            changedMethods.addAll(removedMethods);
            changedMethods.retainAll(addedMethods);
            removedMethods.removeAll(changedMethods);
            addedMethods.removeAll(changedMethods);
            changedFields.addAll(removedFields);
            changedFields.retainAll(addedFields);
            removedFields.removeAll(changedFields);
            addedFields.removeAll(changedFields);
            j = changedMethods.iterator();
            while (j.hasNext()) {
                desc = (String)((Object)j.next());
                oldInfo = (MethodInfo)oldMethods.get(desc);
                if (criteria.differs((MethodInfo)oldInfo, (MethodInfo)(newInfo = (MethodInfo)newMethods.get(desc)))) continue;
                j.remove();
            }
            j = changedFields.iterator();
            while (j.hasNext()) {
                desc = (String)((Object)j.next());
                oldInfo = (FieldInfo)oldFields.get(desc);
                if (criteria.differs((FieldInfo)oldInfo, (FieldInfo)(newInfo = (FieldInfo)newFields.get(desc)))) continue;
                j.remove();
            }
            boolean classchanged = criteria.differs(oci, nci);
            if (!classchanged && removedMethods.isEmpty() && removedFields.isEmpty() && addedMethods.isEmpty() && addedFields.isEmpty() && changedMethods.isEmpty() && changedFields.isEmpty()) continue;
            handler.startClassChanged(s2);
            handler.startRemoved();
            j = removedFields.iterator();
            while (j.hasNext()) {
                handler.fieldRemoved((FieldInfo)oldFields.get(j.next()));
            }
            j = removedMethods.iterator();
            while (j.hasNext()) {
                handler.methodRemoved((MethodInfo)oldMethods.get(j.next()));
            }
            handler.endRemoved();
            handler.startAdded();
            j = addedFields.iterator();
            while (j.hasNext()) {
                handler.fieldAdded((FieldInfo)newFields.get(j.next()));
            }
            j = addedMethods.iterator();
            while (j.hasNext()) {
                handler.methodAdded((MethodInfo)newMethods.get(j.next()));
            }
            handler.endAdded();
            handler.startChanged();
            if (classchanged) {
                handler.classChanged(oci, nci);
            }
            j = changedFields.iterator();
            while (j.hasNext()) {
                tmp = j.next();
                handler.fieldChanged((FieldInfo)oldFields.get(tmp), (FieldInfo)newFields.get(tmp));
            }
            j = changedMethods.iterator();
            while (j.hasNext()) {
                tmp = j.next();
                handler.methodChanged((MethodInfo)oldMethods.get(tmp), (MethodInfo)newMethods.get(tmp));
            }
            handler.endChanged();
            handler.endClassChanged();
            removedMethods.clear();
            removedFields.clear();
            addedMethods.clear();
            addedFields.clear();
            changedMethods.clear();
            changedFields.clear();
        }
        handler.endChanged();
        handler.endDiff();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FORMATS.add("html");
        FORMATS.add("xhtml");
        FORMATS.add("text");
    }
}

