/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.osjava.jardiff.ant.JDXSLTLiaison3;

public class JDXSLTProcess
extends MatchingTask
implements XSLTLogger {
    private File destDir = null;
    private File baseDir = null;
    private String xslFile = null;
    private String targetExtension = ".html";
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private String processor;
    private Path classpath = null;
    private String styleurl = null;
    private XSLTLiaison liaison;
    private boolean stylesheetLoaded = false;
    private boolean force = false;
    private FileUtils fileUtils;
    private Vector outputProperties = new Vector();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final String TRAX_LIAISON_CLASS = "org.osjava.jardiff.ant.JDTraXLiaison";
    private static final String XSLP_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.XslpLiaison";
    private static final String XALAN_LIAISON_CLASS = "org.apache.tools.ant.taskdefs.optional.XalanLiaison";
    private boolean performDirectoryScan = true;
    private Factory factory = null;
    private boolean reuseLoadedStylesheet = true;
    private AntClassLoader loader = null;
    private Mapper mapperElement = null;

    public JDXSLTProcess() {
        this.fileUtils = FileUtils.newFileUtils();
    }

    public void setScanIncludedDirectories(boolean b) {
        this.performDirectoryScan = b;
    }

    public void setReloadStylesheet(boolean b) {
        this.reuseLoadedStylesheet = !b;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File savedBaseDir;
        block21: {
            block19: {
                block20: {
                    savedBaseDir = this.baseDir;
                    if (this.xslFile != null && this.styleurl != null) {
                        throw new BuildException("cannot specify both styleurl and xslfile", this.getLocation());
                    }
                    if (this.xslFile == null && this.styleurl == null) {
                        throw new BuildException("no stylesheet specified", this.getLocation());
                    }
                    if (this.inFile != null && !this.inFile.exists()) {
                        throw new BuildException("input file " + this.inFile.toString() + " does not exist", this.getLocation());
                    }
                    try {
                        Object styleob;
                        if (this.baseDir == null) {
                            this.baseDir = this.getProject().resolveFile(".");
                        }
                        this.liaison = this.getLiaison();
                        if (!(this.liaison instanceof JDXSLTLiaison3) && this.styleurl != null) {
                            throw new BuildException("processor does not support style urls", this.getLocation());
                        }
                        if (this.liaison instanceof XSLTLoggerAware) {
                            ((XSLTLoggerAware)this.liaison).setLogger((XSLTLogger)this);
                        }
                        this.log("Using " + this.liaison.getClass().toString(), 3);
                        if (this.styleurl != null) {
                            styleob = this.styleurl;
                        } else {
                            File stylesheet = this.getProject().resolveFile(this.xslFile);
                            if (!stylesheet.exists() && (stylesheet = this.fileUtils.resolveFile(this.baseDir, this.xslFile)).exists()) {
                                this.log("DEPRECATED - the style attribute should be relative to the project's");
                                this.log("             basedir, not the tasks's basedir.");
                            }
                            styleob = stylesheet;
                        }
                        if (this.inFile != null && this.outFile != null) {
                            this.process(this.inFile, this.outFile, styleob);
                            Object var9_5 = null;
                            if (this.loader == null) break block19;
                            break block20;
                        }
                        if (this.destDir == null) {
                            String msg = "destdir attributes must be set!";
                            throw new BuildException(msg);
                        }
                        DirectoryScanner scanner = this.getDirectoryScanner(this.baseDir);
                        this.log("Transforming into " + this.destDir, 2);
                        String[] list = scanner.getIncludedFiles();
                        for (int i = 0; i < list.length; ++i) {
                            this.process(this.baseDir, list[i], this.destDir, styleob);
                        }
                        if (this.performDirectoryScan) {
                            String[] dirs = scanner.getIncludedDirectories();
                            for (int j = 0; j < dirs.length; ++j) {
                                list = new File(this.baseDir, dirs[j]).list();
                                for (int i = 0; i < list.length; ++i) {
                                    this.process(this.baseDir, dirs[j] + File.separator + list[i], this.destDir, styleob);
                                }
                            }
                        }
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        if (this.loader != null) {
                            this.loader.resetThreadContextLoader();
                            this.loader = null;
                        }
                        this.liaison = null;
                        this.stylesheetLoaded = false;
                        this.baseDir = savedBaseDir;
                        throw throwable;
                    }
                }
                this.loader.resetThreadContextLoader();
                this.loader = null;
            }
            this.liaison = null;
            this.stylesheetLoaded = false;
            this.baseDir = savedBaseDir;
            return;
        }
        Object var9_6 = null;
        if (this.loader != null) {
            this.loader.resetThreadContextLoader();
            this.loader = null;
        }
        this.liaison = null;
        this.stylesheetLoaded = false;
        this.baseDir = savedBaseDir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setExtension(String name) {
        this.targetExtension = name;
    }

    public void setStyle(String xslFile) {
        this.xslFile = xslFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void setStyleurl(String styleurl) {
        this.styleurl = styleurl;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    private void resolveProcessor(String proc) throws Exception {
        if (proc.equals("trax")) {
            Class clazz = this.loadClass(TRAX_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (proc.equals("xslp")) {
            this.log("DEPRECATED - xslp processor is deprecated. Use trax instead.");
            Class clazz = this.loadClass(XSLP_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (proc.equals("xalan")) {
            this.log("DEPRECATED - xalan processor is deprecated. Use trax instead.");
            Class clazz = this.loadClass(XALAN_LIAISON_CLASS);
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else {
            this.liaison = (XSLTLiaison)this.loadClass(proc).newInstance();
        }
    }

    private Class loadClass(String classname) throws Exception {
        if (this.classpath == null) {
            return Class.forName(classname);
        }
        this.loader = this.getProject().createClassLoader(this.classpath);
        this.loader.setThreadContextLoader();
        Class<?> c = Class.forName(classname, true, (ClassLoader)this.loader);
        return c;
    }

    public void setOut(File outFile) {
        this.outFile = outFile;
    }

    public void setIn(File inFile) {
        this.inFile = inFile;
    }

    private void process(File baseDir, String xmlFile, File destDir, Object stylesheet) throws BuildException {
        File outFile = null;
        File inFile = null;
        try {
            long styleSheetLastModified = 0L;
            if (stylesheet instanceof File) {
                styleSheetLastModified = ((File)stylesheet).lastModified();
            }
            if ((inFile = new File(baseDir, xmlFile)).isDirectory()) {
                this.log("Skipping " + inFile + " it is a directory.", 3);
                return;
            }
            Object mapper = null;
            mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : new StyleMapper();
            String[] outFileName = mapper.mapFileName(xmlFile);
            if (outFileName == null || outFileName.length == 0) {
                this.log("Skipping " + inFile + " it cannot get mapped to output.", 3);
                return;
            }
            if (outFileName == null || outFileName.length > 1) {
                this.log("Skipping " + inFile + " its mapping is ambiguos.", 3);
                return;
            }
            outFile = new File(destDir, outFileName[0]);
            if (this.force || inFile.lastModified() > outFile.lastModified() || styleSheetLastModified > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile);
                this.configureLiaison(stylesheet);
                this.liaison.transform(inFile, outFile);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void process(File inFile, File outFile, Object stylesheet) throws BuildException {
        try {
            long styleSheetLastModified = 0L;
            if (stylesheet instanceof File) {
                styleSheetLastModified = ((File)stylesheet).lastModified();
            }
            this.log("In file " + inFile + " time: " + inFile.lastModified(), 4);
            this.log("Out file " + outFile + " time: " + outFile.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + styleSheetLastModified, 4);
            if (this.force || inFile.lastModified() >= outFile.lastModified() || styleSheetLastModified >= outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile, 2);
                this.configureLiaison(stylesheet);
                this.liaison.transform(inFile, outFile);
            } else {
                this.log("Skipping input file " + inFile + " because it is older than output file " + outFile + " and so is the stylesheet " + stylesheet, 4);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = this.fileUtils.getParentFile(targetFile);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    public Factory getFactory() {
        return this.factory;
    }

    public XMLCatalog getXMLCatalog() {
        return this.xmlCatalog;
    }

    public Enumeration getOutputProperties() {
        return this.outputProperties.elements();
    }

    protected XSLTLiaison getLiaison() {
        if (this.liaison == null) {
            if (this.processor != null) {
                try {
                    this.resolveProcessor(this.processor);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            try {
                this.resolveProcessor("trax");
            }
            catch (Throwable e1) {
                try {
                    this.resolveProcessor("xalan");
                }
                catch (Throwable e2) {
                    try {
                        this.resolveProcessor("xslp");
                    }
                    catch (Throwable e3) {
                        e3.printStackTrace();
                        e2.printStackTrace();
                        throw new BuildException(e1);
                    }
                }
            }
        }
        return this.liaison;
    }

    public Param createParam() {
        Param p = new Param();
        this.params.addElement(p);
        return p;
    }

    public OutputProperty createOutputProperty() {
        OutputProperty p = new OutputProperty();
        this.outputProperties.addElement(p);
        return p;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected void configureLiaison(Object stylesheet) throws BuildException {
        if (this.stylesheetLoaded && this.reuseLoadedStylesheet) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            this.log("Loading stylesheet " + stylesheet, 2);
            if (stylesheet instanceof File) {
                this.liaison.setStylesheet((File)stylesheet);
            } else if (this.liaison instanceof JDXSLTLiaison3) {
                ((JDXSLTLiaison3)this.liaison).setStylesheet((String)stylesheet);
            } else {
                String msg = "liaison does not support stylesheet urls";
                throw new BuildException(msg, this.getLocation());
            }
            Enumeration e = this.params.elements();
            while (e.hasMoreElements()) {
                Param p = (Param)e.nextElement();
                if (!p.shouldUse()) continue;
                this.liaison.addParam(p.getName(), p.getExpression());
            }
            if (this.liaison instanceof JDXSLTLiaison3) {
                ((JDXSLTLiaison3)this.liaison).configure(this);
            }
        }
        catch (Exception ex) {
            this.log("Failed to transform using stylesheet " + stylesheet, 2);
            throw new BuildException((Throwable)ex);
        }
    }

    public Factory createFactory() throws BuildException {
        if (this.factory != null) {
            throw new BuildException("'factory' element must be unique");
        }
        this.factory = new Factory();
        return this.factory;
    }

    private class StyleMapper
    implements FileNameMapper {
        private StyleMapper() {
        }

        public void setFrom(String from) {
        }

        public void setTo(String to) {
        }

        public String[] mapFileName(String xmlFile) {
            int dotPos = xmlFile.lastIndexOf(46);
            if (dotPos > 0) {
                xmlFile = xmlFile.substring(0, dotPos);
            }
            return new String[]{xmlFile + JDXSLTProcess.this.targetExtension};
        }
    }

    public static class Factory {
        private String name;
        private Vector attributes = new Vector();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addAttribute(Attribute attr) {
            this.attributes.addElement(attr);
        }

        public Enumeration getAttributes() {
            return this.attributes.elements();
        }

        public static class Attribute
        implements DynamicConfigurator {
            private String name;
            private Object value;

            public String getName() {
                return this.name;
            }

            public Object getValue() {
                return this.value;
            }

            public Object createDynamicElement(String name) throws BuildException {
                return null;
            }

            public void setDynamicAttribute(String name, String value) throws BuildException {
                if ("name".equalsIgnoreCase(name)) {
                    this.name = value;
                } else if ("value".equalsIgnoreCase(name)) {
                    if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                        this.value = new Boolean(value);
                    } else {
                        try {
                            this.value = new Integer(value);
                        }
                        catch (NumberFormatException e) {
                            this.value = value;
                        }
                    }
                } else {
                    throw new BuildException("Unsupported attribute: " + name);
                }
            }
        }
    }

    public static class OutputProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Param {
        private String name = null;
        private String expression = null;
        private String ifProperty;
        private String unlessProperty;
        private Project project;

        public void setProject(Project project) {
            this.project = project;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }

        public void setIf(String ifProperty) {
            this.ifProperty = ifProperty;
        }

        public void setUnless(String unlessProperty) {
            this.unlessProperty = unlessProperty;
        }

        public boolean shouldUse() {
            if (this.ifProperty != null && this.project.getProperty(this.ifProperty) == null) {
                return false;
            }
            return this.unlessProperty == null || this.project.getProperty(this.unlessProperty) == null;
        }
    }
}

