#---------------------------------------------------------------------------------------
# Bundle: KLayoutHomebrew-H.app
#
# Descriptions:
#  This script invokes "klayout.app" that shares the OS-bundled Ruby installed in
#  the standard location.
#  The MacPorts Qt5 and Python packages from Homebrew are embedded in "klayout.app".
#---------------------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Localizing the language
# Workaround discussed in https://github.com/KLayout/klayout/issues/1213
#--------------------------------------------------------------------------
export LANG=$(defaults read -g AppleLocale).UTF-8

#--------------------------------------------------------------------------
# Your setups
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Export the 'KLAYOUT_GIT_HTTP_PROXY' environment variable if you need to
# use the git-based Salt Package Manager through a proxy server.
#--------------------------------------------------------------------------
#export KLAYOUT_GIT_HTTP_PROXY="http://111.222.333.444:5678"

#--------------------------------------------------------------------------
# Downloading data from the package server might time out (default=10 sec).
# If so, set the 'KLAYOUT_HTTP_TIMEOUT' environment variable.
# For example, to make a timeout of 20 seconds,
#--------------------------------------------------------------------------
#export KLAYOUT_HTTP_TIMEOUT=20.0

#--------------------------------------------------------------------------
# Export the 'PYTHONHOME' environment variable if required
#--------------------------------------------------------------------------
#export PYTHONHOME=

#--------------------------------------------------------------------------
# Export the 'KLAYOUT_PYTHONPATH' environment variable if required
# Ref. https://www.klayout.de/forum/discussion/2557/
#--------------------------------------------------------------------------
#export VIRTUAL_ENV=$HOME/opt/HBPy311
#export KLAYOUT_PYTHONPATH=$VIRTUAL_ENV/lib/python3.11/site-packages

#--------------------------------------------------------------------------
# With "-n" option, you can invoke multiple instances
#--------------------------------------------------------------------------
myklayout=/Applications/klayout.app
myconfig=$HOME/.klayout/klayoutrc

open -n -a $myklayout --args -e -c $myconfig -style=fusion $@
