/* accounts.c generated by valac, the Vala compiler
 * generated from accounts.vala, do not modify */

/* accounts.vala
 *
 * Copyright (C) 2009-2010  troorl
 * Copyright (C) 2010 Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	troorl <troorl@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <stdio.h>


#define AUTH_TYPE_ACCOUNT (auth_account_get_type ())
#define AUTH_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUTH_TYPE_ACCOUNT, AuthAccount))
#define AUTH_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUTH_TYPE_ACCOUNT, AuthAccountClass))
#define AUTH_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUTH_TYPE_ACCOUNT))
#define AUTH_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUTH_TYPE_ACCOUNT))
#define AUTH_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUTH_TYPE_ACCOUNT, AuthAccountClass))

typedef struct _AuthAccount AuthAccount;
typedef struct _AuthAccountClass AuthAccountClass;
typedef struct _AuthAccountPrivate AuthAccountPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUTH_TYPE_ACCOUNTS (auth_accounts_get_type ())
#define AUTH_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUTH_TYPE_ACCOUNTS, AuthAccounts))
#define AUTH_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUTH_TYPE_ACCOUNTS, AuthAccountsClass))
#define AUTH_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUTH_TYPE_ACCOUNTS))
#define AUTH_IS_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUTH_TYPE_ACCOUNTS))
#define AUTH_ACCOUNTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUTH_TYPE_ACCOUNTS, AuthAccountsClass))

typedef struct _AuthAccounts AuthAccounts;
typedef struct _AuthAccountsClass AuthAccountsClass;
typedef struct _AuthAccountsPrivate AuthAccountsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _AuthAccount {
	GObject parent_instance;
	AuthAccountPrivate * priv;
};

struct _AuthAccountClass {
	GObjectClass parent_class;
};

struct _AuthAccountPrivate {
	char* _login;
	char* _password;
	char* _service;
	char* _proxy;
	gboolean _active;
};

struct _AuthAccounts {
	GObject parent_instance;
	AuthAccountsPrivate * priv;
	gboolean is_new;
};

struct _AuthAccountsClass {
	GObjectClass parent_class;
};

struct _AuthAccountsPrivate {
	GeeArrayList* acc_lst;
	char* acc_file_path;
};


static gpointer auth_account_parent_class = NULL;
static gpointer auth_accounts_parent_class = NULL;

GType auth_account_get_type (void);
#define AUTH_ACCOUNT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AUTH_TYPE_ACCOUNT, AuthAccountPrivate))
enum  {
	AUTH_ACCOUNT_DUMMY_PROPERTY,
	AUTH_ACCOUNT_LOGIN,
	AUTH_ACCOUNT_PASSWORD,
	AUTH_ACCOUNT_SERVICE,
	AUTH_ACCOUNT_PROXY,
	AUTH_ACCOUNT_ACTIVE
};
AuthAccount* auth_account_new_with_data (const char* __login, const char* __password, const char* __service, gboolean __active);
AuthAccount* auth_account_construct_with_data (GType object_type, const char* __login, const char* __password, const char* __service, gboolean __active);
AuthAccount* auth_account_new (void);
AuthAccount* auth_account_construct (GType object_type);
const char* auth_account_get_login (AuthAccount* self);
void auth_account_set_login (AuthAccount* self, const char* value);
const char* auth_account_get_password (AuthAccount* self);
void auth_account_set_password (AuthAccount* self, const char* value);
const char* auth_account_get_service (AuthAccount* self);
void auth_account_set_service (AuthAccount* self, const char* value);
const char* auth_account_get_proxy (AuthAccount* self);
void auth_account_set_proxy (AuthAccount* self, const char* value);
gboolean auth_account_get_active (AuthAccount* self);
void auth_account_set_active (AuthAccount* self, gboolean value);
static void auth_account_finalize (GObject* obj);
static void auth_account_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void auth_account_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType auth_accounts_get_type (void);
#define AUTH_ACCOUNTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AUTH_TYPE_ACCOUNTS, AuthAccountsPrivate))
enum  {
	AUTH_ACCOUNTS_DUMMY_PROPERTY,
	AUTH_ACCOUNTS_ACCOUNTS
};
static void auth_accounts_load (AuthAccounts* self);
AuthAccounts* auth_accounts_new (void);
AuthAccounts* auth_accounts_construct (GType object_type);
static void auth_accounts_parse (AuthAccounts* self, const char* data);
void auth_accounts_write (AuthAccounts* self);
AuthAccount* auth_accounts_get_current_account (AuthAccounts* self);
void auth_accounts_add_account (AuthAccounts* self, AuthAccount* acc);
AuthAccount* auth_accounts_get_by_hash (AuthAccounts* self, const char* hash);
void auth_accounts_delete_account (AuthAccounts* self, const char* hash);
void auth_accounts_set_active_account (AuthAccounts* self, const char* hash);
void auth_accounts_change_account (AuthAccounts* self, gint index, AuthAccount* acc);
GeeArrayList* auth_accounts_get_accounts (AuthAccounts* self);
static void auth_accounts_finalize (GObject* obj);
static void auth_accounts_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



AuthAccount* auth_account_construct_with_data (GType object_type, const char* __login, const char* __password, const char* __service, gboolean __active) {
	AuthAccount * self;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_val_if_fail (__login != NULL, NULL);
	g_return_val_if_fail (__password != NULL, NULL);
	g_return_val_if_fail (__service != NULL, NULL);
	self = (AuthAccount*) g_object_new (object_type, NULL);
	self->priv->_login = (_tmp0_ = g_strdup (__login), _g_free0 (self->priv->_login), _tmp0_);
	self->priv->_password = (_tmp1_ = g_strdup (__password), _g_free0 (self->priv->_password), _tmp1_);
	self->priv->_service = (_tmp2_ = g_strdup (__service), _g_free0 (self->priv->_service), _tmp2_);
	self->priv->_active = __active;
	return self;
}


AuthAccount* auth_account_new_with_data (const char* __login, const char* __password, const char* __service, gboolean __active) {
	return auth_account_construct_with_data (AUTH_TYPE_ACCOUNT, __login, __password, __service, __active);
}


AuthAccount* auth_account_construct (GType object_type) {
	AuthAccount * self;
	self = (AuthAccount*) g_object_new (object_type, NULL);
	return self;
}


AuthAccount* auth_account_new (void) {
	return auth_account_construct (AUTH_TYPE_ACCOUNT);
}


const char* auth_account_get_login (AuthAccount* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_login;
	return result;
}


void auth_account_set_login (AuthAccount* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_login = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_login), _tmp0_);
	g_object_notify ((GObject *) self, "login");
}


const char* auth_account_get_password (AuthAccount* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_password;
	return result;
}


void auth_account_set_password (AuthAccount* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_password = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_password), _tmp0_);
	g_object_notify ((GObject *) self, "password");
}


const char* auth_account_get_service (AuthAccount* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


void auth_account_set_service (AuthAccount* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_service = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_service), _tmp0_);
	g_object_notify ((GObject *) self, "service");
}


const char* auth_account_get_proxy (AuthAccount* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_proxy;
	return result;
}


void auth_account_set_proxy (AuthAccount* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_proxy = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_proxy), _tmp0_);
	g_object_notify ((GObject *) self, "proxy");
}


gboolean auth_account_get_active (AuthAccount* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void auth_account_set_active (AuthAccount* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void auth_account_class_init (AuthAccountClass * klass) {
	auth_account_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AuthAccountPrivate));
	G_OBJECT_CLASS (klass)->get_property = auth_account_get_property;
	G_OBJECT_CLASS (klass)->set_property = auth_account_set_property;
	G_OBJECT_CLASS (klass)->finalize = auth_account_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUTH_ACCOUNT_LOGIN, g_param_spec_string ("login", "login", "login", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUTH_ACCOUNT_PASSWORD, g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUTH_ACCOUNT_SERVICE, g_param_spec_string ("service", "service", "service", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUTH_ACCOUNT_PROXY, g_param_spec_string ("proxy", "proxy", "proxy", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUTH_ACCOUNT_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void auth_account_instance_init (AuthAccount * self) {
	self->priv = AUTH_ACCOUNT_GET_PRIVATE (self);
	self->priv->_proxy = g_strdup ("");
}


static void auth_account_finalize (GObject* obj) {
	AuthAccount * self;
	self = AUTH_ACCOUNT (obj);
	_g_free0 (self->priv->_login);
	_g_free0 (self->priv->_password);
	_g_free0 (self->priv->_service);
	_g_free0 (self->priv->_proxy);
	G_OBJECT_CLASS (auth_account_parent_class)->finalize (obj);
}


GType auth_account_get_type (void) {
	static volatile gsize auth_account_type_id__volatile = 0;
	if (g_once_init_enter (&auth_account_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AuthAccountClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) auth_account_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AuthAccount), 0, (GInstanceInitFunc) auth_account_instance_init, NULL };
		GType auth_account_type_id;
		auth_account_type_id = g_type_register_static (G_TYPE_OBJECT, "AuthAccount", &g_define_type_info, 0);
		g_once_init_leave (&auth_account_type_id__volatile, auth_account_type_id);
	}
	return auth_account_type_id__volatile;
}


static void auth_account_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AuthAccount * self;
	self = AUTH_ACCOUNT (object);
	switch (property_id) {
		case AUTH_ACCOUNT_LOGIN:
		g_value_set_string (value, auth_account_get_login (self));
		break;
		case AUTH_ACCOUNT_PASSWORD:
		g_value_set_string (value, auth_account_get_password (self));
		break;
		case AUTH_ACCOUNT_SERVICE:
		g_value_set_string (value, auth_account_get_service (self));
		break;
		case AUTH_ACCOUNT_PROXY:
		g_value_set_string (value, auth_account_get_proxy (self));
		break;
		case AUTH_ACCOUNT_ACTIVE:
		g_value_set_boolean (value, auth_account_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void auth_account_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AuthAccount * self;
	self = AUTH_ACCOUNT (object);
	switch (property_id) {
		case AUTH_ACCOUNT_LOGIN:
		auth_account_set_login (self, g_value_get_string (value));
		break;
		case AUTH_ACCOUNT_PASSWORD:
		auth_account_set_password (self, g_value_get_string (value));
		break;
		case AUTH_ACCOUNT_SERVICE:
		auth_account_set_service (self, g_value_get_string (value));
		break;
		case AUTH_ACCOUNT_PROXY:
		auth_account_set_proxy (self, g_value_get_string (value));
		break;
		case AUTH_ACCOUNT_ACTIVE:
		auth_account_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


AuthAccounts* auth_accounts_construct (GType object_type) {
	AuthAccounts * self;
	GeeArrayList* _tmp0_;
	self = (AuthAccounts*) g_object_new (object_type, NULL);
	self->priv->acc_lst = (_tmp0_ = gee_array_list_new (AUTH_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->acc_lst), _tmp0_);
	auth_accounts_load (self);
	return self;
}


AuthAccounts* auth_accounts_new (void) {
	return auth_accounts_construct (AUTH_TYPE_ACCOUNTS);
}


static void auth_accounts_load (AuthAccounts* self) {
	GError * _inner_error_;
	char* pino_dir;
	GFile* dir;
	GFile* _tmp0_;
	char* _tmp1_;
	GFile* acc_file;
	char* content;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	pino_dir = g_strconcat (g_get_user_config_dir (), "/lekhonee-gnome", NULL);
	dir = g_file_new_for_path (pino_dir);
	if (!g_file_query_exists (dir, NULL)) {
		g_file_make_directory (dir, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (pino_dir);
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dir = (_tmp0_ = NULL, _g_object_unref0 (dir), _tmp0_);
	self->priv->acc_file_path = (_tmp1_ = g_strconcat (pino_dir, "/accounts.xml", NULL), _g_free0 (self->priv->acc_file_path), _tmp1_);
	acc_file = g_file_new_for_path (self->priv->acc_file_path);
	if (!g_file_query_exists (acc_file, NULL)) {
		self->is_new = TRUE;
		_g_free0 (pino_dir);
		_g_object_unref0 (dir);
		_g_object_unref0 (acc_file);
		return;
	}
	content = NULL;
	{
		GFileInputStream* _tmp2_;
		GFileInputStream* _tmp3_;
		GDataInputStream* _tmp4_;
		GDataInputStream* stream;
		char* _tmp5_;
		char* _tmp6_;
		_tmp2_ = g_file_read (acc_file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (pino_dir);
			_g_object_unref0 (dir);
			_g_object_unref0 (acc_file);
			_g_free0 (content);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		stream = (_tmp4_ = g_data_input_stream_new ((GInputStream*) (_tmp3_ = _tmp2_)), _g_object_unref0 (_tmp3_), _tmp4_);
		_tmp5_ = g_data_input_stream_read_until (stream, "", NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_free0 (pino_dir);
			_g_object_unref0 (dir);
			_g_object_unref0 (acc_file);
			_g_free0 (content);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		content = (_tmp6_ = _tmp5_, _g_free0 (content), _tmp6_);
		_g_object_unref0 (stream);
	}
	auth_accounts_parse (self, content);
	_g_free0 (pino_dir);
	_g_object_unref0 (dir);
	_g_object_unref0 (acc_file);
	_g_free0 (content);
}


static gboolean string_to_bool (const char* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (_vala_strcmp0 (self, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void auth_accounts_parse (AuthAccounts* self, const char* data) {
	xmlDoc* xmlDoc;
	xmlNode* rootNode;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	xmlDoc = xmlParseMemory (data, (gint) strlen (data));
	rootNode = xmlDocGetRootElement (xmlDoc);
	{
		xmlNode* iter;
		iter = rootNode->children;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					iter = iter->next;
				}
				_tmp0_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				if (_vala_strcmp0 (iter->name, "account") == 0) {
					if (iter->children != NULL) {
						AuthAccount* acc;
						xmlNode* iter_in = NULL;
						acc = auth_account_new ();
						{
							gboolean _tmp1_;
							iter_in = iter->children;
							_tmp1_ = TRUE;
							while (TRUE) {
								if (!_tmp1_) {
									iter_in = iter_in->next;
								}
								_tmp1_ = FALSE;
								if (!(iter_in != NULL)) {
									break;
								}
								if (xmlNodeIsText (iter_in) != 1) {
									GQuark _tmp8_;
									const char* _tmp7_;
									static GQuark _tmp8__label0 = 0;
									static GQuark _tmp8__label1 = 0;
									static GQuark _tmp8__label2 = 0;
									static GQuark _tmp8__label3 = 0;
									static GQuark _tmp8__label4 = 0;
									_tmp7_ = iter_in->name;
									_tmp8_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
									if (_tmp8_ == ((0 != _tmp8__label0) ? _tmp8__label0 : (_tmp8__label0 = g_quark_from_static_string ("login"))))
									switch (0) {
										default:
										{
											char* _tmp2_;
											auth_account_set_login (acc, _tmp2_ = xmlNodeGetContent (iter_in));
											_g_free0 (_tmp2_);
											break;
										}
									} else if (_tmp8_ == ((0 != _tmp8__label1) ? _tmp8__label1 : (_tmp8__label1 = g_quark_from_static_string ("password"))))
									switch (0) {
										default:
										{
											char* _tmp3_;
											auth_account_set_password (acc, _tmp3_ = xmlNodeGetContent (iter_in));
											_g_free0 (_tmp3_);
											break;
										}
									} else if (_tmp8_ == ((0 != _tmp8__label2) ? _tmp8__label2 : (_tmp8__label2 = g_quark_from_static_string ("service"))))
									switch (0) {
										default:
										{
											char* _tmp4_;
											auth_account_set_service (acc, _tmp4_ = xmlNodeGetContent (iter_in));
											_g_free0 (_tmp4_);
											break;
										}
									} else if (_tmp8_ == ((0 != _tmp8__label3) ? _tmp8__label3 : (_tmp8__label3 = g_quark_from_static_string ("proxy"))))
									switch (0) {
										default:
										{
											char* _tmp5_;
											auth_account_set_proxy (acc, _tmp5_ = xmlNodeGetContent (iter_in));
											_g_free0 (_tmp5_);
											break;
										}
									} else if (_tmp8_ == ((0 != _tmp8__label4) ? _tmp8__label4 : (_tmp8__label4 = g_quark_from_static_string ("active"))))
									switch (0) {
										default:
										{
											char* _tmp6_;
											auth_account_set_active (acc, string_to_bool (_tmp6_ = xmlNodeGetContent (iter_in)));
											_g_free0 (_tmp6_);
											break;
										}
									}
								}
							}
						}
						xmlFreeNode (iter_in);
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->acc_lst, acc);
						_g_object_unref0 (acc);
					}
				}
			}
		}
	}
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


void auth_accounts_write (AuthAccounts* self) {
	xmlDoc* xmldoc;
	xmlNs* ns;
	xmlNode* root;
	FILE* stream;
	g_return_if_fail (self != NULL);
	xmldoc = xmlNewDoc ("1.0");
	ns = xmlNewNs (NULL, NULL, NULL);
	ns->type = XML_ELEMENT_NODE;
	root = xmlNewNode (ns, "accounts");
	xmlDocSetRootElement (xmldoc, root);
	xmlNodeAddContent (root, "\n");
	{
		GeeIterator* _acc_it;
		_acc_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->acc_lst);
		while (TRUE) {
			AuthAccount* acc;
			xmlNode* iter = NULL;
			char* _tmp0_;
			if (!gee_iterator_next (_acc_it)) {
				break;
			}
			acc = (AuthAccount*) gee_iterator_get (_acc_it);
			iter = xmlNewChild (root, ns, "account", NULL);
			xmlNodeAddContent (iter, "\n\t");
			xmlNewTextChild (iter, ns, "login", auth_account_get_login (acc));
			xmlNodeAddContent (iter, "\n\t");
			xmlNewTextChild (iter, ns, "password", auth_account_get_password (acc));
			xmlNodeAddContent (iter, "\n\t");
			xmlNewTextChild (iter, ns, "service", auth_account_get_service (acc));
			xmlNodeAddContent (iter, "\n\t");
			xmlNewTextChild (iter, ns, "proxy", auth_account_get_proxy (acc));
			xmlNodeAddContent (iter, "\n\t");
			xmlNewTextChild (iter, ns, "active", _tmp0_ = bool_to_string (auth_account_get_active (acc)));
			_g_free0 (_tmp0_);
			xmlNodeAddContent (iter, "\n");
			xmlNodeAddContent (root, "\n");
			_g_object_unref0 (acc);
		}
		_g_object_unref0 (_acc_it);
	}
	stream = fopen (self->priv->acc_file_path, "w");
	xmlDocDump (stream, xmldoc);
	_fclose0 (stream);
}


AuthAccount* auth_accounts_get_current_account (AuthAccounts* self) {
	AuthAccount* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeIterator* _acc_it;
		_acc_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->acc_lst);
		while (TRUE) {
			AuthAccount* acc;
			if (!gee_iterator_next (_acc_it)) {
				break;
			}
			acc = (AuthAccount*) gee_iterator_get (_acc_it);
			if (auth_account_get_active (acc)) {
				result = acc;
				_g_object_unref0 (_acc_it);
				return result;
			}
			_g_object_unref0 (acc);
		}
		_g_object_unref0 (_acc_it);
	}
	if (gee_collection_get_size ((GeeCollection*) self->priv->acc_lst) > 0) {
		AuthAccount* acc;
		acc = (AuthAccount*) gee_abstract_list_get ((GeeAbstractList*) self->priv->acc_lst, 0);
		auth_account_set_active (acc, TRUE);
		auth_accounts_write (self);
		result = acc;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


void auth_accounts_add_account (AuthAccounts* self, AuthAccount* acc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (acc != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->acc_lst, acc);
}


void auth_accounts_delete_account (AuthAccounts* self, const char* hash) {
	AuthAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hash != NULL);
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->acc_lst, _tmp0_ = auth_accounts_get_by_hash (self, hash));
	_g_object_unref0 (_tmp0_);
}


void auth_accounts_set_active_account (AuthAccounts* self, const char* hash) {
	AuthAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hash != NULL);
	{
		GeeIterator* _acc_it;
		_acc_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->acc_lst);
		while (TRUE) {
			AuthAccount* acc;
			if (!gee_iterator_next (_acc_it)) {
				break;
			}
			acc = (AuthAccount*) gee_iterator_get (_acc_it);
			auth_account_set_active (acc, FALSE);
			_g_object_unref0 (acc);
		}
		_g_object_unref0 (_acc_it);
	}
	auth_account_set_active (_tmp0_ = auth_accounts_get_by_hash (self, hash), TRUE);
	_g_object_unref0 (_tmp0_);
	g_signal_emit_by_name (self, "active-changed");
}


void auth_accounts_change_account (AuthAccounts* self, gint index, AuthAccount* acc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (acc != NULL);
	gee_abstract_list_set ((GeeAbstractList*) self->priv->acc_lst, index, acc);
}


AuthAccount* auth_accounts_get_by_hash (AuthAccounts* self, const char* hash) {
	AuthAccount* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash != NULL, NULL);
	{
		GeeIterator* _acc_it;
		_acc_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->acc_lst);
		while (TRUE) {
			AuthAccount* acc;
			char* _tmp1_;
			char* _tmp0_;
			gboolean _tmp2_;
			if (!gee_iterator_next (_acc_it)) {
				break;
			}
			acc = (AuthAccount*) gee_iterator_get (_acc_it);
			if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (auth_account_get_login (acc), auth_account_get_service (acc), NULL), auth_account_get_proxy (acc), NULL), hash) == 0, _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_)) {
				result = acc;
				_g_object_unref0 (_acc_it);
				return result;
			}
			_g_object_unref0 (acc);
		}
		_g_object_unref0 (_acc_it);
	}
	result = NULL;
	return result;
}


GeeArrayList* auth_accounts_get_accounts (AuthAccounts* self) {
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->acc_lst;
	return result;
}


static void auth_accounts_class_init (AuthAccountsClass * klass) {
	auth_accounts_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AuthAccountsPrivate));
	G_OBJECT_CLASS (klass)->get_property = auth_accounts_get_property;
	G_OBJECT_CLASS (klass)->finalize = auth_accounts_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUTH_ACCOUNTS_ACCOUNTS, g_param_spec_object ("accounts", "accounts", "accounts", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", AUTH_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("active_changed", AUTH_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void auth_accounts_instance_init (AuthAccounts * self) {
	self->priv = AUTH_ACCOUNTS_GET_PRIVATE (self);
}


static void auth_accounts_finalize (GObject* obj) {
	AuthAccounts * self;
	self = AUTH_ACCOUNTS (obj);
	_g_object_unref0 (self->priv->acc_lst);
	_g_free0 (self->priv->acc_file_path);
	G_OBJECT_CLASS (auth_accounts_parent_class)->finalize (obj);
}


GType auth_accounts_get_type (void) {
	static volatile gsize auth_accounts_type_id__volatile = 0;
	if (g_once_init_enter (&auth_accounts_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AuthAccountsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) auth_accounts_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AuthAccounts), 0, (GInstanceInitFunc) auth_accounts_instance_init, NULL };
		GType auth_accounts_type_id;
		auth_accounts_type_id = g_type_register_static (G_TYPE_OBJECT, "AuthAccounts", &g_define_type_info, 0);
		g_once_init_leave (&auth_accounts_type_id__volatile, auth_accounts_type_id);
	}
	return auth_accounts_type_id__volatile;
}


static void auth_accounts_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AuthAccounts * self;
	self = AUTH_ACCOUNTS (object);
	switch (property_id) {
		case AUTH_ACCOUNTS_ACCOUNTS:
		g_value_set_object (value, auth_accounts_get_accounts (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




