; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT

declare float @llvm.canonicalize.f32(float)

define float @ret_canonicalize(float %arg0) {
; CHECK-LABEL: define nofpclass(snan) float @ret_canonicalize
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12:[0-9]+]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_noinf(float nofpclass(inf) %arg0) {
; CHECK-LABEL: define nofpclass(snan inf) float @ret_canonicalize_noinf
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_dynamic_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define nofpclass(snan inf) float @ret_canonicalize_dynamic_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_daz_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="dynamic,preserve-sign" {
; CHECK-LABEL: define nofpclass(snan inf sub) float @ret_canonicalize_daz_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf sub) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_dapz_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="dynamic,positive-zero" {
; CHECK-LABEL: define nofpclass(snan inf nzero sub) float @ret_canonicalize_dapz_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf nzero sub) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_ftpz_dapz_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="positive-zero,preserve-sign" {
; CHECK-LABEL: define nofpclass(snan inf sub) float @ret_canonicalize_ftpz_dapz_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf sub) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_ftpz_ieee_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="positive-zero,ieee" {
; CHECK-LABEL: define nofpclass(snan inf nzero sub) float @ret_canonicalize_ftpz_ieee_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf nzero sub) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_ftpz_dynamic_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="positive-zero,dynamic" {
; CHECK-LABEL: define nofpclass(snan inf sub) float @ret_canonicalize_ftpz_dynamic_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR7:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf sub) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_ftz_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="preserve-sign,dynamic" {
; CHECK-LABEL: define nofpclass(snan inf sub) float @ret_canonicalize_ftz_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR8:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf sub) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_ieee_denormal(float nofpclass(inf) %arg0) "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define nofpclass(snan inf) float @ret_canonicalize_ieee_denormal
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR9:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(snan inf) float @llvm.canonicalize.f32(float [[ARG0]]) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float %arg0)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_pos_denormal() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan inf zero nsub norm) float @ret_canonicalize_ieee_constant_pos_denormal
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf zero nsub norm) float @llvm.canonicalize.f32(float noundef 0x36A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x36A0000000000000)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_neg_denormal() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan inf zero psub norm) float @ret_canonicalize_ieee_constant_neg_denormal
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf zero psub norm) float @llvm.canonicalize.f32(float noundef 0xB6A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xb6A0000000000000)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_pos_zero() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub norm) float @ret_canonicalize_ieee_constant_pos_zero
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0.0)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_neg_zero() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan inf pzero sub norm) float @ret_canonicalize_ieee_constant_neg_zero
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf pzero sub norm) float @llvm.canonicalize.f32(float noundef -0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -0.0)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_pos_normal() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan inf zero sub nnorm) float @ret_canonicalize_ieee_constant_pos_normal
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf zero sub nnorm) float @llvm.canonicalize.f32(float noundef 8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 8.0)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_neg_normal() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan inf zero sub pnorm) float @ret_canonicalize_ieee_constant_neg_normal
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf zero sub pnorm) float @llvm.canonicalize.f32(float noundef -8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -8.0)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_pos_inf() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan ninf zero sub norm) float @ret_canonicalize_ieee_constant_pos_inf
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan ninf zero sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF0000000000000)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_neg_inf() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(nan pinf zero sub norm) float @ret_canonicalize_ieee_constant_neg_inf
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan pinf zero sub norm) float @llvm.canonicalize.f32(float noundef 0xFFF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xFFF0000000000000)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_qnan() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(snan inf zero sub norm) float @ret_canonicalize_ieee_constant_qnan
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf zero sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF8000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF8000000000000)
  ret float %call
}

define float @ret_canonicalize_ieee_constant_snan() "denormal-fp-math"="ieee,ieee" {
; CHECK-LABEL: define noundef nofpclass(snan inf zero sub norm) float @ret_canonicalize_ieee_constant_snan
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf zero sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF1000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF1000000000000)
  ret float %call
}

define float @ret_canonicalize_daz_constant_pos_denormal() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub norm) float @ret_canonicalize_daz_constant_pos_denormal
; CHECK-SAME: () #[[ATTR10:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub norm) float @llvm.canonicalize.f32(float noundef 0x36A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x36A0000000000000)
  ret float %call
}

define float @ret_canonicalize_daz_constant_neg_denormal() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub norm) float @ret_canonicalize_daz_constant_neg_denormal
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub norm) float @llvm.canonicalize.f32(float noundef 0xB6A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xb6A0000000000000)
  ret float %call
}

define float @ret_canonicalize_daz_constant_pos_zero() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub norm) float @ret_canonicalize_daz_constant_pos_zero
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub norm) float @llvm.canonicalize.f32(float noundef 0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0.0)
  ret float %call
}

define float @ret_canonicalize_daz_constant_neg_zero() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub norm) float @ret_canonicalize_daz_constant_neg_zero
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub norm) float @llvm.canonicalize.f32(float noundef -0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -0.0)
  ret float %call
}

define float @ret_canonicalize_daz_constant_pos_normal() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub nnorm) float @ret_canonicalize_daz_constant_pos_normal
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub nnorm) float @llvm.canonicalize.f32(float noundef 8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 8.0)
  ret float %call
}

define float @ret_canonicalize_daz_constant_neg_normal() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub pnorm) float @ret_canonicalize_daz_constant_neg_normal
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub pnorm) float @llvm.canonicalize.f32(float noundef -8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -8.0)
  ret float %call
}

define float @ret_canonicalize_daz_constant_pos_inf() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan ninf sub norm) float @ret_canonicalize_daz_constant_pos_inf
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan ninf sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF0000000000000)
  ret float %call
}

define float @ret_canonicalize_daz_constant_neg_inf() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(nan pinf sub norm) float @ret_canonicalize_daz_constant_neg_inf
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan pinf sub norm) float @llvm.canonicalize.f32(float noundef 0xFFF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xFFF0000000000000)
  ret float %call
}

define float @ret_canonicalize_daz_constant_qnan() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(snan inf sub norm) float @ret_canonicalize_daz_constant_qnan
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF8000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF8000000000000)
  ret float %call
}

define float @ret_canonicalize_daz_constant_snan() "denormal-fp-math"="preserve-sign,preserve-sign" {
; CHECK-LABEL: define noundef nofpclass(snan inf sub norm) float @ret_canonicalize_daz_constant_snan
; CHECK-SAME: () #[[ATTR10]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF1000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF1000000000000)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_pos_denormal() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub norm) float @ret_canonicalize_dapz_constant_pos_denormal
; CHECK-SAME: () #[[ATTR11:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0x36A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x36A0000000000000)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_neg_denormal() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub norm) float @ret_canonicalize_dapz_constant_neg_denormal
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0xB6A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xb6A0000000000000)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_pos_zero() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub norm) float @ret_canonicalize_dapz_constant_pos_zero
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0.0)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_neg_zero() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub norm) float @ret_canonicalize_dapz_constant_neg_zero
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef -0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -0.0)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_pos_normal() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub nnorm) float @ret_canonicalize_dapz_constant_pos_normal
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub nnorm) float @llvm.canonicalize.f32(float noundef 8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 8.0)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_neg_normal() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan inf nzero sub pnorm) float @ret_canonicalize_dapz_constant_neg_normal
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nzero sub pnorm) float @llvm.canonicalize.f32(float noundef -8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -8.0)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_pos_inf() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan ninf nzero sub norm) float @ret_canonicalize_dapz_constant_pos_inf
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan ninf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF0000000000000)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_neg_inf() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(nan pinf nzero sub norm) float @ret_canonicalize_dapz_constant_neg_inf
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan pinf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0xFFF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xFFF0000000000000)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_qnan() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(snan inf nzero sub norm) float @ret_canonicalize_dapz_constant_qnan
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF8000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF8000000000000)
  ret float %call
}

define float @ret_canonicalize_dapz_constant_snan() "denormal-fp-math"="positive-zero,positive-zero" {
; CHECK-LABEL: define noundef nofpclass(snan inf nzero sub norm) float @ret_canonicalize_dapz_constant_snan
; CHECK-SAME: () #[[ATTR11]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf nzero sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF1000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF1000000000000)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_pos_denormal() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan inf nsub norm) float @ret_canonicalize_dynamic_constant_pos_denormal
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf nsub norm) float @llvm.canonicalize.f32(float noundef 0x36A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x36A0000000000000)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_neg_denormal() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan inf psub norm) float @ret_canonicalize_dynamic_constant_neg_denormal
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf psub norm) float @llvm.canonicalize.f32(float noundef 0xB6A0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xb6A0000000000000)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_pos_zero() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub norm) float @ret_canonicalize_dynamic_constant_pos_zero
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub norm) float @llvm.canonicalize.f32(float noundef 0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0.0)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_neg_zero() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub norm) float @ret_canonicalize_dynamic_constant_neg_zero
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub norm) float @llvm.canonicalize.f32(float noundef -0.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -0.0)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_pos_normal() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub nnorm) float @ret_canonicalize_dynamic_constant_pos_normal
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub nnorm) float @llvm.canonicalize.f32(float noundef 8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 8.0)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_neg_normal() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan inf sub pnorm) float @ret_canonicalize_dynamic_constant_neg_normal
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan inf sub pnorm) float @llvm.canonicalize.f32(float noundef -8.000000e+00) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float -8.0)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_pos_inf() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan ninf sub norm) float @ret_canonicalize_dynamic_constant_pos_inf
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan ninf sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF0000000000000)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_neg_inf() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(nan pinf sub norm) float @ret_canonicalize_dynamic_constant_neg_inf
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(nan pinf sub norm) float @llvm.canonicalize.f32(float noundef 0xFFF0000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0xFFF0000000000000)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_qnan() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(snan inf sub norm) float @ret_canonicalize_dynamic_constant_qnan
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF8000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF8000000000000)
  ret float %call
}

define float @ret_canonicalize_dynamic_constant_snan() "denormal-fp-math"="dynamic,dynamic" {
; CHECK-LABEL: define noundef nofpclass(snan inf sub norm) float @ret_canonicalize_dynamic_constant_snan
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call noundef nofpclass(snan inf sub norm) float @llvm.canonicalize.f32(float noundef 0x7FF1000000000000) #[[ATTR12]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.canonicalize.f32(float 0x7FF1000000000000)
  ret float %call
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; TUNIT: {{.*}}
