/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__EDIT_HPP)
#include <Edit.hpp>
#endif

#if   !defined(__EVENTS_HPP)
#include <Events.hpp>
#endif

#if   !defined(__MEMENTOS_HPP)
#include <Mementos.hpp>
#endif

#include <iostream>

// Buffer space for cin.getline

static   char     gBuffer[1024];

using namespace corelinux;
using namespace std;

// Constructor

Edit::Edit( void )
   :
   SubjectObserver( )
{
   ;  // do nothing
}

// Copy constructor 

Edit::Edit( EditCref aEdit ) throw ( Assertion )
   :
   SubjectObserver( aEdit )
{
   NEVER_GET_HERE;
}

// Destructor

Edit::~Edit( void )
{
   ;  // do nothing
}

// Assignment

EditRef  Edit::operator=( EditCref ) throw ( Assertion )
{
   NEVER_GET_HERE;
   return ( *this );
}

// Equality

bool Edit::operator==( EditCref aEdit ) const
{
   return ( this == &aEdit );
}

// Called when a event comes my way

void  Edit::event( Event<Identifier> *aEvent )  throw ( CORELINUX(NullPointerException) )
{
   //
   // We deal with the selection and get the edit
   //

   SelectionMementoRef   aChange = 
      dynamic_cast<SelectionMementoRef>
         (
            dynamic_cast<ListEventPtr>(aEvent)->getMemento()
         );

   string   & originalText( aChange.getSelected() );

   cout << "Enter the change for [" << originalText << "] : ";

   cin.getline( gBuffer, sizeof(gBuffer) );
   
   string   changedText(gBuffer);


   //
   // Then let colleagues know the new Edit 
   //

   ListEvent  aEv( EditedEntry, new EditSelectionMemento( originalText, changedText ) );
   Subject::notifyObservers( (Event<Identifier>*)&aEv );

}

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/



