/* Copyright (C) 2016 D. V. Wiebe
 *
 ***************************************************************************
 *
 * This file is part of the GetData project.
 *
 * GetData is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * GetData is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GetData; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "test.h"

int main(void)
{
  const char *filedir = "dirfile";
  const char *format = "dirfile/format";
  const char *data = "dirfile/data";
  const char *c[8];
  int e1, e2, r = 0;
  size_t n1, n2;
  DIRFILE *D;

  rmdirfile();
  mkdir(filedir, 0700);

  MAKEFORMATFILE(format,
    "sindir1 SINDIR missing sarray\n"
    "sindir2 SINDIR data missing\n"
    "sarray SARRAY a b c d e f g h i j k l m n o\n"
    "data RAW UINT8 8\n");
  MAKEDATAFILE(data, uint8_t, i, 256);

  D = gd_open(filedir, GD_RDONLY);
  n1 = gd_getdata(D, "sindir1", 0, 1, 0, 1, GD_STRING, c);
  CHECKU(n1, 0);
  e1 = gd_error(D);
  CHECKI(e1, GD_E_BAD_CODE);

  n2 = gd_getdata(D, "sindir2", 0, 1, 0, 1, GD_STRING, c);
  CHECKU(n2, 0);
  e2 = gd_error(D);
  CHECKI(e2, GD_E_BAD_CODE);

  gd_discard(D);

  unlink(data);
  unlink(format);
  rmdir(filedir);

  return r;
}
