/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Format;

public class FieldPosition {
    int field = 0;
    int endIndex = 0;
    int beginIndex = 0;
    private Format.Field attribute;

    public FieldPosition(int n) {
        this.field = n;
    }

    public FieldPosition(Format.Field field) {
        this(field, -1);
    }

    public FieldPosition(Format.Field field, int n) {
        this.attribute = field;
        this.field = n;
    }

    public Format.Field getFieldAttribute() {
        return this.attribute;
    }

    public int getField() {
        return this.field;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setBeginIndex(int n) {
        this.beginIndex = n;
    }

    public void setEndIndex(int n) {
        this.endIndex = n;
    }

    Format.FieldDelegate getFieldDelegate() {
        return new Delegate();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FieldPosition)) {
            return false;
        }
        FieldPosition fieldPosition = (FieldPosition)object;
        if (this.attribute == null ? fieldPosition.attribute != null : !this.attribute.equals(fieldPosition.attribute)) {
            return false;
        }
        return this.beginIndex == fieldPosition.beginIndex && this.endIndex == fieldPosition.endIndex && this.field == fieldPosition.field;
    }

    public int hashCode() {
        return this.field << 24 | this.beginIndex << 16 | this.endIndex;
    }

    public String toString() {
        return this.getClass().getName() + "[field=" + this.field + ",attribute=" + this.attribute + ",beginIndex=" + this.beginIndex + ",endIndex=" + this.endIndex + ']';
    }

    private boolean matchesField(Format.Field field) {
        if (this.attribute != null) {
            return this.attribute.equals(field);
        }
        return false;
    }

    private boolean matchesField(Format.Field field, int n) {
        if (this.attribute != null) {
            return this.attribute.equals(field);
        }
        return n == this.field;
    }

    private class Delegate
    implements Format.FieldDelegate {
        private boolean encounteredField;

        private Delegate() {
        }

        public void formatted(Format.Field field, Object object, int n, int n2, StringBuffer stringBuffer) {
            if (!this.encounteredField && FieldPosition.this.matchesField(field)) {
                FieldPosition.this.setBeginIndex(n);
                FieldPosition.this.setEndIndex(n2);
                this.encounteredField = n != n2;
            }
        }

        public void formatted(int n, Format.Field field, Object object, int n2, int n3, StringBuffer stringBuffer) {
            if (!this.encounteredField && FieldPosition.this.matchesField(field, n)) {
                FieldPosition.this.setBeginIndex(n2);
                FieldPosition.this.setEndIndex(n3);
                this.encounteredField = n2 != n3;
            }
        }
    }
}

