*
* $Id: fxgsof.F,v 1.1.1.3 1996/11/15 17:32:47 cernlib Exp $
*
* $Log: fxgsof.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:47  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:07:10  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:19  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXGSOF(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.1154E-01,0.1220E-01,0.1290E-01,0.1363E-01,0.1441E-01,0.1523E-01,
     +0.1610E-01,0.1702E-01,0.1799E-01,0.1901E-01,0.2010E-01,0.2124E-01,
     +0.2245E-01,0.2373E-01,0.2509E-01,0.2652E-01,0.2803E-01,0.2962E-01,
     +0.3131E-01,0.3309E-01,0.3498E-01,0.3697E-01,0.3908E-01,0.4130E-01,
     +0.4365E-01,0.4613E-01,0.4876E-01,0.5153E-01,0.5445E-01,0.5755E-01,
     +0.6082E-01,0.6427E-01,0.6791E-01,0.7176E-01,0.7583E-01,0.8012E-01,
     +0.8465E-01,0.8943E-01,0.9448E-01,0.9981E-01,0.1054E+00,0.1114E+00,
     +0.1176E+00,0.1242E+00,0.1311E+00,0.1385E+00,0.1462E+00,0.1543E+00,
     +0.1628E+00,0.1718E+00,0.1812E+00,0.1912E+00,0.2016E+00,0.2125E+00,
     +0.2239E+00,0.2359E+00,0.2484E+00,0.2615E+00,0.2751E+00,0.2893E+00,
     +0.3040E+00,0.3193E+00,0.3350E+00,0.3513E+00,0.3679E+00,0.3850E+00,
     +0.4023E+00,0.4198E+00,0.4373E+00,0.4548E+00,0.4719E+00,0.4886E+00,
     +0.5045E+00,0.5193E+00,0.5326E+00,0.5440E+00,0.5530E+00,0.5591E+00,
     +0.5617E+00,0.5601E+00,0.5538E+00,0.5421E+00,0.5243E+00,0.5002E+00,
     +0.4693E+00,0.4318E+00,0.3881E+00,0.3390E+00,0.2860E+00,0.2312E+00,
     +0.1982E+00,0.1679E+00,0.1404E+00,0.1157E+00,0.9371E-01,0.7442E-01,
     +0.5769E-01,0.4337E-01,0.3133E-01,0.2144E-01,0.1357E-01,0.7621E-02,
     +0.3496E-02,0.1057E-02/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.6591E-02,0.6967E-02,0.7364E-02,0.7784E-02,0.8228E-02,0.8697E-02,
     +0.9193E-02,0.9717E-02,0.1027E-01,0.1086E-01,0.1147E-01,0.1213E-01,
     +0.1282E-01,0.1355E-01,0.1432E-01,0.1514E-01,0.1600E-01,0.1691E-01,
     +0.1787E-01,0.1889E-01,0.1997E-01,0.2110E-01,0.2230E-01,0.2357E-01,
     +0.2491E-01,0.2632E-01,0.2782E-01,0.2940E-01,0.3107E-01,0.3283E-01,
     +0.3469E-01,0.3665E-01,0.3872E-01,0.4091E-01,0.4322E-01,0.4566E-01,
     +0.4823E-01,0.5095E-01,0.5381E-01,0.5683E-01,0.6001E-01,0.6336E-01,
     +0.6689E-01,0.7061E-01,0.7453E-01,0.7864E-01,0.8297E-01,0.8752E-01,
     +0.9230E-01,0.9732E-01,0.1026E+00,0.1081E+00,0.1138E+00,0.1199E+00,
     +0.1262E+00,0.1327E+00,0.1395E+00,0.1466E+00,0.1539E+00,0.1615E+00,
     +0.1693E+00,0.1773E+00,0.1855E+00,0.1938E+00,0.2022E+00,0.2106E+00,
     +0.2191E+00,0.2274E+00,0.2355E+00,0.2433E+00,0.2506E+00,0.2573E+00,
     +0.2633E+00,0.2682E+00,0.2719E+00,0.2741E+00,0.2746E+00,0.2731E+00,
     +0.2694E+00,0.2630E+00,0.2539E+00,0.2419E+00,0.2269E+00,0.2088E+00,
     +0.1881E+00,0.1651E+00,0.1404E+00,0.1149E+00,0.8969E-01,0.6600E-01,
     +0.5296E-01,0.4178E-01,0.3235E-01,0.2453E-01,0.1816E-01,0.1305E-01,
     +0.9059E-02,0.6015E-02,0.3770E-02,0.2186E-02,0.1134E-02,0.4973E-03,
     +0.1640E-03,0.3020E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.1823E+02,0.1779E+02,0.1737E+02,0.1696E+02,0.1656E+02,0.1617E+02,
     +0.1578E+02,0.1541E+02,0.1505E+02,0.1469E+02,0.1434E+02,0.1401E+02,
     +0.1368E+02,0.1336E+02,0.1305E+02,0.1274E+02,0.1244E+02,0.1215E+02,
     +0.1187E+02,0.1160E+02,0.1133E+02,0.1107E+02,0.1081E+02,0.1057E+02,
     +0.1032E+02,0.1009E+02,0.9860E+01,0.9637E+01,0.9420E+01,0.9209E+01,
     +0.9003E+01,0.8802E+01,0.8606E+01,0.8416E+01,0.8230E+01,0.8050E+01,
     +0.7873E+01,0.7701E+01,0.7533E+01,0.7369E+01,0.7209E+01,0.7052E+01,
     +0.6898E+01,0.6747E+01,0.6599E+01,0.6453E+01,0.6309E+01,0.6167E+01,
     +0.6027E+01,0.5887E+01,0.5748E+01,0.5609E+01,0.5470E+01,0.5330E+01,
     +0.5189E+01,0.5047E+01,0.4902E+01,0.4755E+01,0.4606E+01,0.4453E+01,
     +0.4296E+01,0.4135E+01,0.3970E+01,0.3801E+01,0.3627E+01,0.3448E+01,
     +0.3265E+01,0.3077E+01,0.2886E+01,0.2691E+01,0.2493E+01,0.2293E+01,
     +0.2093E+01,0.1893E+01,0.1695E+01,0.1501E+01,0.1313E+01,0.1132E+01,
     +0.9605E+00,0.8001E+00,0.6527E+00,0.5197E+00,0.4024E+00,0.3015E+00,
     +0.2174E+00,0.1497E+00,0.9743E-01,0.5922E-01,0.3301E-01,0.1646E-01,
     +0.1010E-01,0.6013E-02,0.3453E-02,0.1900E-02,0.9945E-03,0.4897E-03,
     +0.2237E-03,0.9300E-04,0.3423E-04,0.1070E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6996E+00,0.6995E+00,0.6994E+00,0.6994E+00,0.6994E+00,0.6993E+00,
     +0.6992E+00,0.6991E+00,0.6990E+00,0.6989E+00,0.6988E+00,0.6987E+00,
     +0.6985E+00,0.6983E+00,0.6981E+00,0.6980E+00,0.6977E+00,0.6974E+00,
     +0.6972E+00,0.6969E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6911E+00,
     +0.6902E+00,0.6891E+00,0.6879E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6818E+00,0.6799E+00,0.6777E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5134E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3374E-04,0.1183E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2914E+00,
     +0.2913E+00,0.2913E+00,0.2912E+00,0.2912E+00,0.2912E+00,0.2911E+00,
     +0.2910E+00,0.2910E+00,0.2909E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2904E+00,0.2902E+00,0.2901E+00,0.2899E+00,0.2897E+00,
     +0.2895E+00,0.2892E+00,0.2890E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1670E-02,
     +0.1016E-02,0.5893E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1406E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1165E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1295E-03,0.6681E-04,0.3207E-04,0.1414E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.1277E-01,0.1350E-01,0.1427E-01,0.1508E-01,0.1593E-01,0.1684E-01,
     +0.1780E-01,0.1881E-01,0.1987E-01,0.2100E-01,0.2219E-01,0.2345E-01,
     +0.2478E-01,0.2618E-01,0.2766E-01,0.2923E-01,0.3088E-01,0.3263E-01,
     +0.3448E-01,0.3642E-01,0.3848E-01,0.4065E-01,0.4295E-01,0.4537E-01,
     +0.4793E-01,0.5062E-01,0.5347E-01,0.5648E-01,0.5965E-01,0.6300E-01,
     +0.6653E-01,0.7025E-01,0.7418E-01,0.7833E-01,0.8270E-01,0.8730E-01,
     +0.9216E-01,0.9727E-01,0.1027E+00,0.1083E+00,0.1143E+00,0.1206E+00,
     +0.1272E+00,0.1342E+00,0.1415E+00,0.1492E+00,0.1573E+00,0.1658E+00,
     +0.1747E+00,0.1840E+00,0.1938E+00,0.2041E+00,0.2148E+00,0.2260E+00,
     +0.2377E+00,0.2498E+00,0.2625E+00,0.2757E+00,0.2893E+00,0.3035E+00,
     +0.3180E+00,0.3331E+00,0.3485E+00,0.3642E+00,0.3802E+00,0.3965E+00,
     +0.4128E+00,0.4291E+00,0.4453E+00,0.4611E+00,0.4764E+00,0.4908E+00,
     +0.5043E+00,0.5163E+00,0.5266E+00,0.5347E+00,0.5402E+00,0.5426E+00,
     +0.5413E+00,0.5358E+00,0.5255E+00,0.5101E+00,0.4890E+00,0.4620E+00,
     +0.4291E+00,0.3905E+00,0.3468E+00,0.2991E+00,0.2488E+00,0.1980E+00,
     +0.1681E+00,0.1409E+00,0.1165E+00,0.9488E-01,0.7593E-01,0.5950E-01,
     +0.4546E-01,0.3363E-01,0.2385E-01,0.1597E-01,0.9851E-02,0.5362E-02,
     +0.2361E-02,0.6710E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.7290E-02,0.7704E-02,0.8141E-02,0.8604E-02,0.9092E-02,0.9608E-02,
     +0.1015E-01,0.1073E-01,0.1134E-01,0.1198E-01,0.1266E-01,0.1337E-01,
     +0.1413E-01,0.1493E-01,0.1578E-01,0.1667E-01,0.1761E-01,0.1860E-01,
     +0.1965E-01,0.2076E-01,0.2193E-01,0.2317E-01,0.2447E-01,0.2585E-01,
     +0.2730E-01,0.2884E-01,0.3046E-01,0.3216E-01,0.3396E-01,0.3586E-01,
     +0.3786E-01,0.3998E-01,0.4220E-01,0.4455E-01,0.4702E-01,0.4962E-01,
     +0.5237E-01,0.5525E-01,0.5829E-01,0.6149E-01,0.6485E-01,0.6839E-01,
     +0.7210E-01,0.7601E-01,0.8010E-01,0.8440E-01,0.8891E-01,0.9363E-01,
     +0.9857E-01,0.1037E+00,0.1091E+00,0.1148E+00,0.1206E+00,0.1267E+00,
     +0.1331E+00,0.1397E+00,0.1465E+00,0.1535E+00,0.1607E+00,0.1681E+00,
     +0.1757E+00,0.1834E+00,0.1913E+00,0.1992E+00,0.2070E+00,0.2149E+00,
     +0.2226E+00,0.2301E+00,0.2372E+00,0.2439E+00,0.2500E+00,0.2554E+00,
     +0.2599E+00,0.2632E+00,0.2652E+00,0.2657E+00,0.2644E+00,0.2611E+00,
     +0.2555E+00,0.2475E+00,0.2369E+00,0.2236E+00,0.2077E+00,0.1893E+00,
     +0.1686E+00,0.1462E+00,0.1228E+00,0.9910E-01,0.7622E-01,0.5515E-01,
     +0.4377E-01,0.3414E-01,0.2613E-01,0.1957E-01,0.1430E-01,0.1014E-01,
     +0.6929E-02,0.4523E-02,0.2782E-02,0.1578E-02,0.7980E-03,0.3389E-03,
     +0.1072E-03,0.1858E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.3428E+02,0.3333E+02,0.3240E+02,0.3149E+02,0.3061E+02,0.2975E+02,
     +0.2892E+02,0.2810E+02,0.2730E+02,0.2653E+02,0.2577E+02,0.2504E+02,
     +0.2432E+02,0.2362E+02,0.2294E+02,0.2227E+02,0.2162E+02,0.2099E+02,
     +0.2038E+02,0.1978E+02,0.1920E+02,0.1863E+02,0.1807E+02,0.1753E+02,
     +0.1701E+02,0.1650E+02,0.1600E+02,0.1551E+02,0.1504E+02,0.1458E+02,
     +0.1413E+02,0.1370E+02,0.1327E+02,0.1286E+02,0.1245E+02,0.1206E+02,
     +0.1168E+02,0.1131E+02,0.1094E+02,0.1059E+02,0.1024E+02,0.9907E+01,
     +0.9579E+01,0.9258E+01,0.8946E+01,0.8640E+01,0.8341E+01,0.8049E+01,
     +0.7763E+01,0.7482E+01,0.7207E+01,0.6937E+01,0.6671E+01,0.6409E+01,
     +0.6151E+01,0.5896E+01,0.5645E+01,0.5395E+01,0.5149E+01,0.4904E+01,
     +0.4661E+01,0.4419E+01,0.4179E+01,0.3940E+01,0.3703E+01,0.3466E+01,
     +0.3232E+01,0.3000E+01,0.2769E+01,0.2542E+01,0.2319E+01,0.2100E+01,
     +0.1887E+01,0.1680E+01,0.1481E+01,0.1291E+01,0.1111E+01,0.9426E+00,
     +0.7870E+00,0.6451E+00,0.5178E+00,0.4058E+00,0.3094E+00,0.2284E+00,
     +0.1624E+00,0.1105E+00,0.7132E-01,0.4323E-01,0.2428E-01,0.1242E-01,
     +0.7863E-02,0.4901E-02,0.3006E-02,0.1813E-02,0.1075E-02,0.6258E-03,
     +0.3568E-03,0.1979E-03,0.1056E-03,0.5302E-04,0.2416E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.1982E+01,0.1948E+01,0.1915E+01,0.1882E+01,0.1851E+01,0.1820E+01,
     +0.1790E+01,0.1761E+01,0.1732E+01,0.1704E+01,0.1677E+01,0.1651E+01,
     +0.1625E+01,0.1599E+01,0.1575E+01,0.1551E+01,0.1527E+01,0.1504E+01,
     +0.1481E+01,0.1459E+01,0.1438E+01,0.1417E+01,0.1396E+01,0.1376E+01,
     +0.1356E+01,0.1337E+01,0.1317E+01,0.1299E+01,0.1280E+01,0.1262E+01,
     +0.1244E+01,0.1226E+01,0.1209E+01,0.1192E+01,0.1175E+01,0.1157E+01,
     +0.1141E+01,0.1124E+01,0.1107E+01,0.1090E+01,0.1073E+01,0.1056E+01,
     +0.1039E+01,0.1022E+01,0.1004E+01,0.9863E+00,0.9682E+00,0.9497E+00,
     +0.9308E+00,0.9115E+00,0.8916E+00,0.8712E+00,0.8502E+00,0.8285E+00,
     +0.8061E+00,0.7829E+00,0.7589E+00,0.7342E+00,0.7085E+00,0.6820E+00,
     +0.6547E+00,0.6265E+00,0.5974E+00,0.5676E+00,0.5370E+00,0.5058E+00,
     +0.4742E+00,0.4421E+00,0.4099E+00,0.3778E+00,0.3459E+00,0.3144E+00,
     +0.2838E+00,0.2541E+00,0.2258E+00,0.1989E+00,0.1737E+00,0.1503E+00,
     +0.1287E+00,0.1091E+00,0.9125E-01,0.7516E-01,0.6071E-01,0.4779E-01,
     +0.3637E-01,0.2646E-01,0.1813E-01,0.1148E-01,0.6542E-02,0.3238E-02,
     +0.1939E-02,0.1108E-02,0.5996E-03,0.3052E-03,0.1447E-03,0.6311E-04,
     +0.2493E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.5824E+00,0.5747E+00,0.5672E+00,0.5599E+00,0.5528E+00,0.5458E+00,
     +0.5390E+00,0.5324E+00,0.5259E+00,0.5196E+00,0.5134E+00,0.5074E+00,
     +0.5015E+00,0.4957E+00,0.4901E+00,0.4846E+00,0.4792E+00,0.4739E+00,
     +0.4688E+00,0.4637E+00,0.4587E+00,0.4539E+00,0.4491E+00,0.4444E+00,
     +0.4398E+00,0.4352E+00,0.4308E+00,0.4264E+00,0.4220E+00,0.4177E+00,
     +0.4134E+00,0.4091E+00,0.4049E+00,0.4007E+00,0.3965E+00,0.3922E+00,
     +0.3880E+00,0.3837E+00,0.3794E+00,0.3751E+00,0.3706E+00,0.3661E+00,
     +0.3615E+00,0.3568E+00,0.3520E+00,0.3470E+00,0.3419E+00,0.3365E+00,
     +0.3310E+00,0.3253E+00,0.3193E+00,0.3131E+00,0.3066E+00,0.2998E+00,
     +0.2927E+00,0.2852E+00,0.2774E+00,0.2692E+00,0.2607E+00,0.2517E+00,
     +0.2424E+00,0.2327E+00,0.2226E+00,0.2121E+00,0.2013E+00,0.1902E+00,
     +0.1788E+00,0.1672E+00,0.1555E+00,0.1438E+00,0.1320E+00,0.1204E+00,
     +0.1090E+00,0.9793E-01,0.8730E-01,0.7719E-01,0.6767E-01,0.5879E-01,
     +0.5059E-01,0.4307E-01,0.3621E-01,0.2998E-01,0.2434E-01,0.1925E-01,
     +0.1472E-01,0.1075E-01,0.7393E-02,0.4695E-02,0.2682E-02,0.1329E-02,
     +0.7966E-03,0.4551E-03,0.2463E-03,0.1253E-03,0.5928E-04,0.2579E-04,
     +0.1014E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.4076E+00,0.3999E+00,0.3924E+00,0.3851E+00,0.3780E+00,0.3711E+00,
     +0.3643E+00,0.3577E+00,0.3513E+00,0.3450E+00,0.3389E+00,0.3329E+00,
     +0.3270E+00,0.3213E+00,0.3158E+00,0.3103E+00,0.3050E+00,0.2998E+00,
     +0.2947E+00,0.2898E+00,0.2850E+00,0.2802E+00,0.2756E+00,0.2710E+00,
     +0.2666E+00,0.2622E+00,0.2580E+00,0.2538E+00,0.2497E+00,0.2456E+00,
     +0.2416E+00,0.2377E+00,0.2338E+00,0.2300E+00,0.2262E+00,0.2225E+00,
     +0.2188E+00,0.2151E+00,0.2114E+00,0.2078E+00,0.2041E+00,0.2005E+00,
     +0.1968E+00,0.1931E+00,0.1894E+00,0.1857E+00,0.1819E+00,0.1780E+00,
     +0.1741E+00,0.1702E+00,0.1661E+00,0.1620E+00,0.1577E+00,0.1534E+00,
     +0.1489E+00,0.1443E+00,0.1396E+00,0.1348E+00,0.1298E+00,0.1247E+00,
     +0.1194E+00,0.1141E+00,0.1085E+00,0.1029E+00,0.9717E-01,0.9135E-01,
     +0.8545E-01,0.7952E-01,0.7357E-01,0.6766E-01,0.6181E-01,0.5607E-01,
     +0.5049E-01,0.4511E-01,0.3997E-01,0.3511E-01,0.3057E-01,0.2637E-01,
     +0.2251E-01,0.1900E-01,0.1584E-01,0.1299E-01,0.1045E-01,0.8196E-02,
     +0.6214E-02,0.4505E-02,0.3078E-02,0.1944E-02,0.1106E-02,0.5464E-03,
     +0.3271E-03,0.1868E-03,0.1011E-03,0.5149E-04,0.2443E-04,0.1068E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.2910E+00,0.2833E+00,0.2759E+00,0.2686E+00,0.2615E+00,0.2546E+00,
     +0.2479E+00,0.2413E+00,0.2349E+00,0.2286E+00,0.2225E+00,0.2166E+00,
     +0.2107E+00,0.2051E+00,0.1995E+00,0.1942E+00,0.1889E+00,0.1838E+00,
     +0.1788E+00,0.1739E+00,0.1691E+00,0.1644E+00,0.1599E+00,0.1555E+00,
     +0.1511E+00,0.1469E+00,0.1428E+00,0.1387E+00,0.1348E+00,0.1309E+00,
     +0.1271E+00,0.1234E+00,0.1198E+00,0.1162E+00,0.1128E+00,0.1093E+00,
     +0.1060E+00,0.1027E+00,0.9946E-01,0.9628E-01,0.9315E-01,0.9006E-01,
     +0.8702E-01,0.8403E-01,0.8106E-01,0.7814E-01,0.7525E-01,0.7239E-01,
     +0.6955E-01,0.6675E-01,0.6397E-01,0.6121E-01,0.5848E-01,0.5576E-01,
     +0.5308E-01,0.5041E-01,0.4777E-01,0.4515E-01,0.4256E-01,0.3999E-01,
     +0.3746E-01,0.3497E-01,0.3252E-01,0.3011E-01,0.2775E-01,0.2544E-01,
     +0.2320E-01,0.2103E-01,0.1894E-01,0.1693E-01,0.1501E-01,0.1320E-01,
     +0.1149E-01,0.9890E-02,0.8414E-02,0.7062E-02,0.5839E-02,0.4747E-02,
     +0.3787E-02,0.2956E-02,0.2252E-02,0.1668E-02,0.1196E-02,0.8260E-03,
     +0.5458E-03,0.3424E-03,0.2018E-03,0.1103E-03,0.5500E-04,0.2444E-04,
     +0.1403E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.1184E+00,0.1151E+00,0.1119E+00,0.1088E+00,0.1058E+00,0.1028E+00,
     +0.9994E-01,0.9713E-01,0.9437E-01,0.9170E-01,0.8909E-01,0.8654E-01,
     +0.8406E-01,0.8164E-01,0.7928E-01,0.7698E-01,0.7474E-01,0.7255E-01,
     +0.7042E-01,0.6834E-01,0.6631E-01,0.6434E-01,0.6241E-01,0.6053E-01,
     +0.5869E-01,0.5690E-01,0.5516E-01,0.5345E-01,0.5179E-01,0.5016E-01,
     +0.4857E-01,0.4702E-01,0.4551E-01,0.4403E-01,0.4258E-01,0.4116E-01,
     +0.3977E-01,0.3841E-01,0.3708E-01,0.3578E-01,0.3450E-01,0.3325E-01,
     +0.3202E-01,0.3081E-01,0.2962E-01,0.2845E-01,0.2731E-01,0.2618E-01,
     +0.2506E-01,0.2397E-01,0.2289E-01,0.2183E-01,0.2078E-01,0.1975E-01,
     +0.1873E-01,0.1772E-01,0.1674E-01,0.1577E-01,0.1481E-01,0.1387E-01,
     +0.1295E-01,0.1205E-01,0.1116E-01,0.1030E-01,0.9465E-02,0.8651E-02,
     +0.7864E-02,0.7106E-02,0.6379E-02,0.5685E-02,0.5026E-02,0.4405E-02,
     +0.3823E-02,0.3282E-02,0.2784E-02,0.2331E-02,0.1922E-02,0.1559E-02,
     +0.1240E-02,0.9663E-03,0.7347E-03,0.5433E-03,0.3892E-03,0.2687E-03,
     +0.1777E-03,0.1117E-03,0.6615E-04,0.3645E-04,0.1841E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.1402E-01,0.1481E-01,0.1565E-01,0.1654E-01,0.1747E-01,0.1846E-01,
     +0.1950E-01,0.2060E-01,0.2177E-01,0.2299E-01,0.2429E-01,0.2566E-01,
     +0.2710E-01,0.2863E-01,0.3024E-01,0.3194E-01,0.3373E-01,0.3563E-01,
     +0.3762E-01,0.3973E-01,0.4196E-01,0.4431E-01,0.4678E-01,0.4939E-01,
     +0.5215E-01,0.5505E-01,0.5812E-01,0.6134E-01,0.6475E-01,0.6833E-01,
     +0.7211E-01,0.7610E-01,0.8029E-01,0.8471E-01,0.8936E-01,0.9426E-01,
     +0.9941E-01,0.1048E+00,0.1105E+00,0.1165E+00,0.1228E+00,0.1294E+00,
     +0.1364E+00,0.1437E+00,0.1513E+00,0.1593E+00,0.1678E+00,0.1766E+00,
     +0.1858E+00,0.1954E+00,0.2054E+00,0.2159E+00,0.2269E+00,0.2382E+00,
     +0.2501E+00,0.2624E+00,0.2751E+00,0.2883E+00,0.3018E+00,0.3158E+00,
     +0.3301E+00,0.3448E+00,0.3598E+00,0.3749E+00,0.3902E+00,0.4056E+00,
     +0.4208E+00,0.4359E+00,0.4506E+00,0.4648E+00,0.4782E+00,0.4906E+00,
     +0.5017E+00,0.5112E+00,0.5187E+00,0.5238E+00,0.5262E+00,0.5252E+00,
     +0.5206E+00,0.5118E+00,0.4983E+00,0.4799E+00,0.4563E+00,0.4273E+00,
     +0.3932E+00,0.3542E+00,0.3111E+00,0.2652E+00,0.2178E+00,0.1708E+00,
     +0.1436E+00,0.1192E+00,0.9757E-01,0.7862E-01,0.6219E-01,0.4814E-01,
     +0.3628E-01,0.2643E-01,0.1842E-01,0.1209E-01,0.7286E-02,0.3852E-02,
     +0.1632E-02,0.4382E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.7995E-02,0.8447E-02,0.8924E-02,0.9429E-02,0.9961E-02,0.1052E-01,
     +0.1112E-01,0.1174E-01,0.1241E-01,0.1310E-01,0.1384E-01,0.1462E-01,
     +0.1544E-01,0.1631E-01,0.1723E-01,0.1819E-01,0.1921E-01,0.2029E-01,
     +0.2142E-01,0.2262E-01,0.2388E-01,0.2521E-01,0.2662E-01,0.2810E-01,
     +0.2966E-01,0.3130E-01,0.3304E-01,0.3487E-01,0.3679E-01,0.3882E-01,
     +0.4095E-01,0.4320E-01,0.4557E-01,0.4806E-01,0.5068E-01,0.5343E-01,
     +0.5633E-01,0.5937E-01,0.6257E-01,0.6593E-01,0.6945E-01,0.7315E-01,
     +0.7702E-01,0.8108E-01,0.8533E-01,0.8978E-01,0.9443E-01,0.9928E-01,
     +0.1043E+00,0.1096E+00,0.1151E+00,0.1208E+00,0.1268E+00,0.1329E+00,
     +0.1392E+00,0.1458E+00,0.1525E+00,0.1595E+00,0.1665E+00,0.1738E+00,
     +0.1811E+00,0.1885E+00,0.1959E+00,0.2034E+00,0.2107E+00,0.2179E+00,
     +0.2249E+00,0.2315E+00,0.2377E+00,0.2434E+00,0.2484E+00,0.2525E+00,
     +0.2556E+00,0.2575E+00,0.2581E+00,0.2570E+00,0.2541E+00,0.2493E+00,
     +0.2423E+00,0.2329E+00,0.2212E+00,0.2071E+00,0.1906E+00,0.1721E+00,
     +0.1517E+00,0.1302E+00,0.1080E+00,0.8609E-01,0.6530E-01,0.4653E-01,
     +0.3655E-01,0.2821E-01,0.2136E-01,0.1582E-01,0.1141E-01,0.7987E-02,
     +0.5383E-02,0.3460E-02,0.2090E-02,0.1162E-02,0.5736E-03,0.2365E-03,
     +0.7197E-04,0.1179E-04/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.5430E+02,0.5258E+02,0.5091E+02,0.4928E+02,0.4769E+02,0.4615E+02,
     +0.4466E+02,0.4320E+02,0.4179E+02,0.4042E+02,0.3908E+02,0.3778E+02,
     +0.3652E+02,0.3530E+02,0.3411E+02,0.3295E+02,0.3183E+02,0.3074E+02,
     +0.2968E+02,0.2866E+02,0.2766E+02,0.2669E+02,0.2575E+02,0.2484E+02,
     +0.2395E+02,0.2309E+02,0.2226E+02,0.2145E+02,0.2066E+02,0.1990E+02,
     +0.1916E+02,0.1844E+02,0.1775E+02,0.1707E+02,0.1642E+02,0.1578E+02,
     +0.1517E+02,0.1457E+02,0.1400E+02,0.1344E+02,0.1289E+02,0.1237E+02,
     +0.1186E+02,0.1136E+02,0.1088E+02,0.1041E+02,0.9961E+01,0.9522E+01,
     +0.9096E+01,0.8682E+01,0.8280E+01,0.7889E+01,0.7509E+01,0.7139E+01,
     +0.6779E+01,0.6429E+01,0.6087E+01,0.5754E+01,0.5429E+01,0.5112E+01,
     +0.4803E+01,0.4501E+01,0.4206E+01,0.3918E+01,0.3638E+01,0.3365E+01,
     +0.3099E+01,0.2840E+01,0.2590E+01,0.2347E+01,0.2114E+01,0.1890E+01,
     +0.1676E+01,0.1473E+01,0.1282E+01,0.1103E+01,0.9365E+00,0.7841E+00,
     +0.6461E+00,0.5227E+00,0.4143E+00,0.3206E+00,0.2415E+00,0.1764E+00,
     +0.1243E+00,0.8395E-01,0.5401E-01,0.3282E-01,0.1864E-01,0.9780E-02,
     +0.6346E-02,0.4081E-02,0.2599E-02,0.1637E-02,0.1017E-02,0.6205E-03,
     +0.3694E-03,0.2123E-03,0.1159E-03,0.5867E-04,0.2650E-04,0.1000E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.4162E+01,0.4061E+01,0.3961E+01,0.3865E+01,0.3771E+01,0.3680E+01,
     +0.3591E+01,0.3504E+01,0.3420E+01,0.3337E+01,0.3257E+01,0.3179E+01,
     +0.3103E+01,0.3029E+01,0.2957E+01,0.2887E+01,0.2818E+01,0.2752E+01,
     +0.2687E+01,0.2623E+01,0.2562E+01,0.2502E+01,0.2443E+01,0.2386E+01,
     +0.2330E+01,0.2276E+01,0.2222E+01,0.2170E+01,0.2120E+01,0.2070E+01,
     +0.2022E+01,0.1974E+01,0.1928E+01,0.1882E+01,0.1838E+01,0.1794E+01,
     +0.1751E+01,0.1709E+01,0.1667E+01,0.1626E+01,0.1585E+01,0.1545E+01,
     +0.1506E+01,0.1466E+01,0.1428E+01,0.1389E+01,0.1350E+01,0.1312E+01,
     +0.1273E+01,0.1235E+01,0.1196E+01,0.1158E+01,0.1119E+01,0.1080E+01,
     +0.1041E+01,0.1001E+01,0.9611E+00,0.9208E+00,0.8801E+00,0.8390E+00,
     +0.7976E+00,0.7559E+00,0.7139E+00,0.6717E+00,0.6294E+00,0.5871E+00,
     +0.5450E+00,0.5033E+00,0.4620E+00,0.4216E+00,0.3821E+00,0.3439E+00,
     +0.3072E+00,0.2722E+00,0.2392E+00,0.2083E+00,0.1798E+00,0.1536E+00,
     +0.1298E+00,0.1084E+00,0.8934E-01,0.7240E-01,0.5747E-01,0.4442E-01,
     +0.3316E-01,0.2365E-01,0.1588E-01,0.9847E-02,0.5494E-02,0.2662E-02,
     +0.1574E-02,0.8887E-03,0.4762E-03,0.2404E-03,0.1134E-03,0.4950E-04,
     +0.1975E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.1018E+01,0.9964E+00,0.9757E+00,0.9556E+00,0.9360E+00,0.9169E+00,
     +0.8984E+00,0.8802E+00,0.8626E+00,0.8454E+00,0.8286E+00,0.8123E+00,
     +0.7964E+00,0.7809E+00,0.7658E+00,0.7511E+00,0.7367E+00,0.7227E+00,
     +0.7090E+00,0.6957E+00,0.6827E+00,0.6700E+00,0.6576E+00,0.6455E+00,
     +0.6337E+00,0.6221E+00,0.6108E+00,0.5997E+00,0.5889E+00,0.5782E+00,
     +0.5678E+00,0.5575E+00,0.5475E+00,0.5375E+00,0.5278E+00,0.5181E+00,
     +0.5086E+00,0.4991E+00,0.4898E+00,0.4805E+00,0.4712E+00,0.4620E+00,
     +0.4528E+00,0.4436E+00,0.4344E+00,0.4251E+00,0.4157E+00,0.4062E+00,
     +0.3967E+00,0.3870E+00,0.3771E+00,0.3671E+00,0.3569E+00,0.3465E+00,
     +0.3358E+00,0.3249E+00,0.3137E+00,0.3023E+00,0.2906E+00,0.2786E+00,
     +0.2664E+00,0.2539E+00,0.2411E+00,0.2281E+00,0.2149E+00,0.2016E+00,
     +0.1881E+00,0.1747E+00,0.1613E+00,0.1479E+00,0.1349E+00,0.1221E+00,
     +0.1097E+00,0.9779E-01,0.8649E-01,0.7584E-01,0.6592E-01,0.5676E-01,
     +0.4838E-01,0.4076E-01,0.3389E-01,0.2772E-01,0.2221E-01,0.1732E-01,
     +0.1304E-01,0.9367E-02,0.6330E-02,0.3946E-02,0.2210E-02,0.1073E-02,
     +0.6348E-03,0.3581E-03,0.1915E-03,0.9630E-04,0.4514E-04,0.1949E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.8429E+00,0.8217E+00,0.8010E+00,0.7810E+00,0.7614E+00,0.7423E+00,
     +0.7238E+00,0.7057E+00,0.6881E+00,0.6709E+00,0.6542E+00,0.6380E+00,
     +0.6221E+00,0.6067E+00,0.5917E+00,0.5770E+00,0.5628E+00,0.5489E+00,
     +0.5353E+00,0.5221E+00,0.5093E+00,0.4967E+00,0.4845E+00,0.4726E+00,
     +0.4610E+00,0.4496E+00,0.4386E+00,0.4278E+00,0.4172E+00,0.4069E+00,
     +0.3968E+00,0.3870E+00,0.3774E+00,0.3679E+00,0.3587E+00,0.3496E+00,
     +0.3407E+00,0.3319E+00,0.3233E+00,0.3148E+00,0.3065E+00,0.2982E+00,
     +0.2901E+00,0.2820E+00,0.2741E+00,0.2662E+00,0.2583E+00,0.2505E+00,
     +0.2427E+00,0.2349E+00,0.2272E+00,0.2194E+00,0.2116E+00,0.2039E+00,
     +0.1960E+00,0.1882E+00,0.1803E+00,0.1724E+00,0.1644E+00,0.1564E+00,
     +0.1484E+00,0.1403E+00,0.1323E+00,0.1242E+00,0.1161E+00,0.1081E+00,
     +0.1001E+00,0.9223E-01,0.8448E-01,0.7691E-01,0.6954E-01,0.6243E-01,
     +0.5562E-01,0.4915E-01,0.4306E-01,0.3738E-01,0.3214E-01,0.2736E-01,
     +0.2303E-01,0.1915E-01,0.1571E-01,0.1267E-01,0.1000E-01,0.7696E-02,
     +0.5719E-02,0.4061E-02,0.2717E-02,0.1679E-02,0.9347E-03,0.4520E-03,
     +0.2672E-03,0.1509E-03,0.8091E-04,0.4092E-04,0.1936E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.7263E+00,0.7052E+00,0.6846E+00,0.6645E+00,0.6450E+00,0.6259E+00,
     +0.6074E+00,0.5893E+00,0.5718E+00,0.5546E+00,0.5380E+00,0.5218E+00,
     +0.5060E+00,0.4906E+00,0.4756E+00,0.4610E+00,0.4468E+00,0.4330E+00,
     +0.4195E+00,0.4064E+00,0.3937E+00,0.3812E+00,0.3691E+00,0.3573E+00,
     +0.3459E+00,0.3347E+00,0.3238E+00,0.3132E+00,0.3028E+00,0.2927E+00,
     +0.2829E+00,0.2733E+00,0.2639E+00,0.2548E+00,0.2459E+00,0.2372E+00,
     +0.2287E+00,0.2204E+00,0.2123E+00,0.2044E+00,0.1966E+00,0.1890E+00,
     +0.1816E+00,0.1743E+00,0.1672E+00,0.1602E+00,0.1534E+00,0.1466E+00,
     +0.1400E+00,0.1336E+00,0.1272E+00,0.1209E+00,0.1148E+00,0.1088E+00,
     +0.1029E+00,0.9707E-01,0.9138E-01,0.8580E-01,0.8033E-01,0.7499E-01,
     +0.6977E-01,0.6467E-01,0.5972E-01,0.5490E-01,0.5024E-01,0.4574E-01,
     +0.4141E-01,0.3726E-01,0.3330E-01,0.2954E-01,0.2600E-01,0.2267E-01,
     +0.1958E-01,0.1672E-01,0.1411E-01,0.1174E-01,0.9626E-02,0.7758E-02,
     +0.6134E-02,0.4747E-02,0.3584E-02,0.2631E-02,0.1870E-02,0.1281E-02,
     +0.8401E-03,0.5237E-03,0.3074E-03,0.1680E-03,0.8420E-04,0.3802E-04,
     +0.2219E-04,0.1275E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.5578E+00,0.5409E+00,0.5245E+00,0.5085E+00,0.4929E+00,0.4777E+00,
     +0.4630E+00,0.4486E+00,0.4346E+00,0.4210E+00,0.4078E+00,0.3949E+00,
     +0.3823E+00,0.3701E+00,0.3583E+00,0.3467E+00,0.3355E+00,0.3245E+00,
     +0.3139E+00,0.3035E+00,0.2934E+00,0.2836E+00,0.2741E+00,0.2648E+00,
     +0.2558E+00,0.2470E+00,0.2384E+00,0.2301E+00,0.2220E+00,0.2141E+00,
     +0.2065E+00,0.1990E+00,0.1917E+00,0.1846E+00,0.1777E+00,0.1710E+00,
     +0.1644E+00,0.1580E+00,0.1518E+00,0.1457E+00,0.1398E+00,0.1340E+00,
     +0.1284E+00,0.1229E+00,0.1175E+00,0.1123E+00,0.1072E+00,0.1021E+00,
     +0.9725E-01,0.9247E-01,0.8779E-01,0.8322E-01,0.7875E-01,0.7439E-01,
     +0.7012E-01,0.6596E-01,0.6189E-01,0.5793E-01,0.5407E-01,0.5032E-01,
     +0.4667E-01,0.4313E-01,0.3970E-01,0.3639E-01,0.3320E-01,0.3013E-01,
     +0.2720E-01,0.2440E-01,0.2174E-01,0.1923E-01,0.1688E-01,0.1467E-01,
     +0.1264E-01,0.1076E-01,0.9056E-02,0.7518E-02,0.6148E-02,0.4944E-02,
     +0.3901E-02,0.3012E-02,0.2271E-02,0.1665E-02,0.1183E-02,0.8101E-03,
     +0.5319E-03,0.3325E-03,0.1962E-03,0.1081E-03,0.5497E-04,0.2536E-04,
     +0.1508E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1617E-01,0.1708E-01,0.1804E-01,0.1905E-01,0.2012E-01,0.2124E-01,
     +0.2243E-01,0.2369E-01,0.2501E-01,0.2641E-01,0.2788E-01,0.2943E-01,
     +0.3107E-01,0.3280E-01,0.3462E-01,0.3654E-01,0.3857E-01,0.4070E-01,
     +0.4295E-01,0.4533E-01,0.4782E-01,0.5046E-01,0.5323E-01,0.5615E-01,
     +0.5922E-01,0.6246E-01,0.6586E-01,0.6945E-01,0.7322E-01,0.7719E-01,
     +0.8136E-01,0.8574E-01,0.9035E-01,0.9519E-01,0.1003E+00,0.1056E+00,
     +0.1112E+00,0.1171E+00,0.1233E+00,0.1297E+00,0.1365E+00,0.1436E+00,
     +0.1510E+00,0.1588E+00,0.1669E+00,0.1753E+00,0.1842E+00,0.1934E+00,
     +0.2030E+00,0.2130E+00,0.2233E+00,0.2341E+00,0.2452E+00,0.2568E+00,
     +0.2687E+00,0.2810E+00,0.2936E+00,0.3066E+00,0.3198E+00,0.3333E+00,
     +0.3471E+00,0.3610E+00,0.3750E+00,0.3890E+00,0.4029E+00,0.4166E+00,
     +0.4300E+00,0.4429E+00,0.4552E+00,0.4666E+00,0.4770E+00,0.4860E+00,
     +0.4935E+00,0.4990E+00,0.5023E+00,0.5029E+00,0.5007E+00,0.4951E+00,
     +0.4858E+00,0.4725E+00,0.4549E+00,0.4329E+00,0.4063E+00,0.3754E+00,
     +0.3404E+00,0.3019E+00,0.2607E+00,0.2182E+00,0.1756E+00,0.1347E+00,
     +0.1115E+00,0.9116E-01,0.7343E-01,0.5817E-01,0.4520E-01,0.3431E-01,
     +0.2531E-01,0.1800E-01,0.1221E-01,0.7771E-02,0.4511E-02,0.2278E-02,
     +0.9087E-03,0.2233E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.9211E-02,0.9727E-02,0.1027E-01,0.1085E-01,0.1145E-01,0.1209E-01,
     +0.1277E-01,0.1348E-01,0.1423E-01,0.1503E-01,0.1586E-01,0.1674E-01,
     +0.1767E-01,0.1865E-01,0.1968E-01,0.2077E-01,0.2192E-01,0.2313E-01,
     +0.2440E-01,0.2574E-01,0.2715E-01,0.2864E-01,0.3020E-01,0.3185E-01,
     +0.3359E-01,0.3541E-01,0.3733E-01,0.3935E-01,0.4147E-01,0.4370E-01,
     +0.4604E-01,0.4850E-01,0.5108E-01,0.5379E-01,0.5663E-01,0.5962E-01,
     +0.6274E-01,0.6601E-01,0.6944E-01,0.7303E-01,0.7678E-01,0.8070E-01,
     +0.8480E-01,0.8907E-01,0.9352E-01,0.9816E-01,0.1030E+00,0.1080E+00,
     +0.1132E+00,0.1186E+00,0.1242E+00,0.1299E+00,0.1359E+00,0.1420E+00,
     +0.1483E+00,0.1547E+00,0.1613E+00,0.1679E+00,0.1747E+00,0.1815E+00,
     +0.1883E+00,0.1951E+00,0.2018E+00,0.2084E+00,0.2147E+00,0.2208E+00,
     +0.2266E+00,0.2319E+00,0.2366E+00,0.2406E+00,0.2438E+00,0.2460E+00,
     +0.2471E+00,0.2469E+00,0.2452E+00,0.2420E+00,0.2370E+00,0.2301E+00,
     +0.2212E+00,0.2103E+00,0.1973E+00,0.1823E+00,0.1655E+00,0.1472E+00,
     +0.1278E+00,0.1078E+00,0.8786E-01,0.6866E-01,0.5096E-01,0.3545E-01,
     +0.2740E-01,0.2081E-01,0.1549E-01,0.1126E-01,0.7977E-02,0.5470E-02,
     +0.3605E-02,0.2261E-02,0.1329E-02,0.7153E-03,0.3401E-03,0.1339E-03,
     +0.3836E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.9634E+02,0.9271E+02,0.8920E+02,0.8581E+02,0.8253E+02,0.7935E+02,
     +0.7628E+02,0.7332E+02,0.7045E+02,0.6768E+02,0.6500E+02,0.6241E+02,
     +0.5992E+02,0.5750E+02,0.5517E+02,0.5292E+02,0.5075E+02,0.4865E+02,
     +0.4662E+02,0.4467E+02,0.4278E+02,0.4096E+02,0.3921E+02,0.3752E+02,
     +0.3589E+02,0.3431E+02,0.3280E+02,0.3134E+02,0.2993E+02,0.2858E+02,
     +0.2727E+02,0.2602E+02,0.2481E+02,0.2364E+02,0.2252E+02,0.2144E+02,
     +0.2041E+02,0.1941E+02,0.1845E+02,0.1753E+02,0.1665E+02,0.1579E+02,
     +0.1498E+02,0.1419E+02,0.1344E+02,0.1271E+02,0.1202E+02,0.1135E+02,
     +0.1071E+02,0.1010E+02,0.9506E+01,0.8941E+01,0.8398E+01,0.7877E+01,
     +0.7378E+01,0.6899E+01,0.6440E+01,0.6000E+01,0.5578E+01,0.5174E+01,
     +0.4788E+01,0.4418E+01,0.4064E+01,0.3726E+01,0.3404E+01,0.3097E+01,
     +0.2805E+01,0.2528E+01,0.2267E+01,0.2020E+01,0.1788E+01,0.1571E+01,
     +0.1369E+01,0.1182E+01,0.1010E+01,0.8537E+00,0.7124E+00,0.5862E+00,
     +0.4748E+00,0.3777E+00,0.2946E+00,0.2246E+00,0.1669E+00,0.1205E+00,
     +0.8413E-01,0.5657E-01,0.3644E-01,0.2234E-01,0.1293E-01,0.7000E-02,
     +0.4658E-02,0.3078E-02,0.2015E-02,0.1303E-02,0.8270E-03,0.5125E-03,
     +0.3072E-03,0.1760E-03,0.9474E-04,0.4672E-04,0.2029E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.9575E+01,0.9274E+01,0.8982E+01,0.8698E+01,0.8423E+01,0.8156E+01,
     +0.7897E+01,0.7646E+01,0.7402E+01,0.7166E+01,0.6937E+01,0.6715E+01,
     +0.6499E+01,0.6290E+01,0.6087E+01,0.5891E+01,0.5700E+01,0.5515E+01,
     +0.5336E+01,0.5162E+01,0.4994E+01,0.4830E+01,0.4672E+01,0.4519E+01,
     +0.4370E+01,0.4225E+01,0.4085E+01,0.3949E+01,0.3818E+01,0.3690E+01,
     +0.3566E+01,0.3445E+01,0.3328E+01,0.3215E+01,0.3105E+01,0.2997E+01,
     +0.2893E+01,0.2792E+01,0.2693E+01,0.2597E+01,0.2503E+01,0.2412E+01,
     +0.2323E+01,0.2236E+01,0.2151E+01,0.2068E+01,0.1987E+01,0.1907E+01,
     +0.1829E+01,0.1753E+01,0.1678E+01,0.1604E+01,0.1531E+01,0.1459E+01,
     +0.1389E+01,0.1320E+01,0.1251E+01,0.1184E+01,0.1117E+01,0.1052E+01,
     +0.9874E+00,0.9239E+00,0.8614E+00,0.8002E+00,0.7402E+00,0.6816E+00,
     +0.6246E+00,0.5692E+00,0.5158E+00,0.4644E+00,0.4153E+00,0.3687E+00,
     +0.3248E+00,0.2838E+00,0.2458E+00,0.2109E+00,0.1791E+00,0.1506E+00,
     +0.1251E+00,0.1026E+00,0.8284E-01,0.6573E-01,0.5101E-01,0.3849E-01,
     +0.2801E-01,0.1945E-01,0.1271E-01,0.7656E-02,0.4149E-02,0.1953E-02,
     +0.1136E-02,0.6321E-03,0.3349E-03,0.1679E-03,0.7918E-04,0.3490E-04,
     +0.1429E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.2099E+01,0.2038E+01,0.1978E+01,0.1921E+01,0.1865E+01,0.1811E+01,
     +0.1758E+01,0.1707E+01,0.1658E+01,0.1610E+01,0.1563E+01,0.1518E+01,
     +0.1474E+01,0.1432E+01,0.1391E+01,0.1351E+01,0.1312E+01,0.1274E+01,
     +0.1238E+01,0.1202E+01,0.1168E+01,0.1134E+01,0.1102E+01,0.1071E+01,
     +0.1040E+01,0.1010E+01,0.9817E+00,0.9538E+00,0.9267E+00,0.9003E+00,
     +0.8747E+00,0.8497E+00,0.8254E+00,0.8018E+00,0.7788E+00,0.7563E+00,
     +0.7344E+00,0.7131E+00,0.6922E+00,0.6717E+00,0.6517E+00,0.6320E+00,
     +0.6128E+00,0.5939E+00,0.5752E+00,0.5569E+00,0.5388E+00,0.5209E+00,
     +0.5031E+00,0.4856E+00,0.4682E+00,0.4509E+00,0.4337E+00,0.4165E+00,
     +0.3994E+00,0.3823E+00,0.3653E+00,0.3482E+00,0.3312E+00,0.3142E+00,
     +0.2971E+00,0.2802E+00,0.2632E+00,0.2464E+00,0.2297E+00,0.2131E+00,
     +0.1968E+00,0.1807E+00,0.1650E+00,0.1498E+00,0.1350E+00,0.1209E+00,
     +0.1074E+00,0.9470E-01,0.8279E-01,0.7175E-01,0.6160E-01,0.5236E-01,
     +0.4402E-01,0.3655E-01,0.2991E-01,0.2404E-01,0.1890E-01,0.1445E-01,
     +0.1064E-01,0.7465E-02,0.4919E-02,0.2984E-02,0.1625E-02,0.7653E-03,
     +0.4444E-03,0.2463E-03,0.1296E-03,0.6426E-04,0.2980E-04,0.1280E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.1924E+01,0.1863E+01,0.1804E+01,0.1746E+01,0.1691E+01,0.1637E+01,
     +0.1584E+01,0.1533E+01,0.1484E+01,0.1436E+01,0.1389E+01,0.1344E+01,
     +0.1300E+01,0.1258E+01,0.1217E+01,0.1177E+01,0.1138E+01,0.1101E+01,
     +0.1064E+01,0.1029E+01,0.9950E+00,0.9618E+00,0.9297E+00,0.8985E+00,
     +0.8683E+00,0.8390E+00,0.8106E+00,0.7830E+00,0.7563E+00,0.7304E+00,
     +0.7052E+00,0.6808E+00,0.6571E+00,0.6340E+00,0.6117E+00,0.5899E+00,
     +0.5688E+00,0.5483E+00,0.5283E+00,0.5088E+00,0.4899E+00,0.4714E+00,
     +0.4534E+00,0.4359E+00,0.4188E+00,0.4020E+00,0.3857E+00,0.3697E+00,
     +0.3540E+00,0.3386E+00,0.3236E+00,0.3088E+00,0.2943E+00,0.2801E+00,
     +0.2661E+00,0.2523E+00,0.2388E+00,0.2255E+00,0.2125E+00,0.1996E+00,
     +0.1870E+00,0.1746E+00,0.1625E+00,0.1506E+00,0.1390E+00,0.1277E+00,
     +0.1168E+00,0.1062E+00,0.9596E-01,0.8619E-01,0.7688E-01,0.6808E-01,
     +0.5980E-01,0.5209E-01,0.4496E-01,0.3844E-01,0.3253E-01,0.2722E-01,
     +0.2251E-01,0.1837E-01,0.1476E-01,0.1164E-01,0.8985E-02,0.6743E-02,
     +0.4882E-02,0.3374E-02,0.2194E-02,0.1318E-02,0.7124E-03,0.3349E-03,
     +0.1948E-03,0.1086E-03,0.5765E-04,0.2902E-04,0.1377E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1808E+01,0.1747E+01,0.1688E+01,0.1630E+01,0.1574E+01,0.1520E+01,
     +0.1468E+01,0.1417E+01,0.1367E+01,0.1320E+01,0.1273E+01,0.1228E+01,
     +0.1184E+01,0.1142E+01,0.1101E+01,0.1061E+01,0.1023E+01,0.9853E+00,
     +0.9490E+00,0.9139E+00,0.8798E+00,0.8468E+00,0.8149E+00,0.7839E+00,
     +0.7538E+00,0.7247E+00,0.6965E+00,0.6692E+00,0.6427E+00,0.6171E+00,
     +0.5922E+00,0.5681E+00,0.5448E+00,0.5222E+00,0.5002E+00,0.4790E+00,
     +0.4584E+00,0.4384E+00,0.4190E+00,0.4002E+00,0.3820E+00,0.3644E+00,
     +0.3472E+00,0.3306E+00,0.3145E+00,0.2988E+00,0.2836E+00,0.2689E+00,
     +0.2546E+00,0.2407E+00,0.2272E+00,0.2141E+00,0.2014E+00,0.1892E+00,
     +0.1772E+00,0.1657E+00,0.1545E+00,0.1437E+00,0.1333E+00,0.1232E+00,
     +0.1135E+00,0.1042E+00,0.9527E-01,0.8671E-01,0.7854E-01,0.7077E-01,
     +0.6340E-01,0.5644E-01,0.4990E-01,0.4379E-01,0.3811E-01,0.3286E-01,
     +0.2805E-01,0.2368E-01,0.1974E-01,0.1623E-01,0.1315E-01,0.1047E-01,
     +0.8173E-02,0.6246E-02,0.4658E-02,0.3378E-02,0.2373E-02,0.1607E-02,
     +0.1044E-02,0.6458E-03,0.3774E-03,0.2063E-03,0.1042E-03,0.4794E-04,
     +0.2849E-04,0.1673E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1645E+01,0.1589E+01,0.1533E+01,0.1480E+01,0.1428E+01,0.1378E+01,
     +0.1329E+01,0.1281E+01,0.1235E+01,0.1191E+01,0.1148E+01,0.1106E+01,
     +0.1066E+01,0.1026E+01,0.9882E+00,0.9513E+00,0.9156E+00,0.8810E+00,
     +0.8474E+00,0.8150E+00,0.7835E+00,0.7531E+00,0.7236E+00,0.6950E+00,
     +0.6674E+00,0.6406E+00,0.6147E+00,0.5896E+00,0.5653E+00,0.5418E+00,
     +0.5190E+00,0.4970E+00,0.4757E+00,0.4550E+00,0.4351E+00,0.4157E+00,
     +0.3970E+00,0.3789E+00,0.3614E+00,0.3445E+00,0.3280E+00,0.3122E+00,
     +0.2968E+00,0.2819E+00,0.2675E+00,0.2536E+00,0.2401E+00,0.2270E+00,
     +0.2144E+00,0.2022E+00,0.1903E+00,0.1789E+00,0.1679E+00,0.1572E+00,
     +0.1469E+00,0.1370E+00,0.1274E+00,0.1181E+00,0.1093E+00,0.1007E+00,
     +0.9255E-01,0.8471E-01,0.7723E-01,0.7009E-01,0.6331E-01,0.5689E-01,
     +0.5082E-01,0.4512E-01,0.3978E-01,0.3481E-01,0.3021E-01,0.2598E-01,
     +0.2212E-01,0.1863E-01,0.1549E-01,0.1271E-01,0.1027E-01,0.8159E-02,
     +0.6360E-02,0.4852E-02,0.3614E-02,0.2619E-02,0.1840E-02,0.1247E-02,
     +0.8115E-03,0.5038E-03,0.2962E-03,0.1634E-03,0.8372E-04,0.3926E-04,
     +0.2369E-04,0.1414E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1809E-01,0.1910E-01,0.2017E-01,0.2129E-01,0.2247E-01,0.2372E-01,
     +0.2504E-01,0.2642E-01,0.2789E-01,0.2943E-01,0.3105E-01,0.3277E-01,
     +0.3457E-01,0.3647E-01,0.3847E-01,0.4058E-01,0.4280E-01,0.4514E-01,
     +0.4761E-01,0.5020E-01,0.5292E-01,0.5579E-01,0.5881E-01,0.6199E-01,
     +0.6532E-01,0.6883E-01,0.7252E-01,0.7639E-01,0.8046E-01,0.8473E-01,
     +0.8922E-01,0.9392E-01,0.9886E-01,0.1040E+00,0.1095E+00,0.1151E+00,
     +0.1211E+00,0.1273E+00,0.1338E+00,0.1406E+00,0.1478E+00,0.1552E+00,
     +0.1629E+00,0.1710E+00,0.1795E+00,0.1882E+00,0.1973E+00,0.2068E+00,
     +0.2166E+00,0.2268E+00,0.2373E+00,0.2482E+00,0.2594E+00,0.2709E+00,
     +0.2828E+00,0.2949E+00,0.3073E+00,0.3199E+00,0.3328E+00,0.3457E+00,
     +0.3588E+00,0.3719E+00,0.3849E+00,0.3978E+00,0.4104E+00,0.4227E+00,
     +0.4344E+00,0.4454E+00,0.4556E+00,0.4647E+00,0.4726E+00,0.4789E+00,
     +0.4834E+00,0.4858E+00,0.4859E+00,0.4833E+00,0.4777E+00,0.4688E+00,
     +0.4563E+00,0.4401E+00,0.4199E+00,0.3958E+00,0.3677E+00,0.3361E+00,
     +0.3012E+00,0.2638E+00,0.2248E+00,0.1854E+00,0.1468E+00,0.1106E+00,
     +0.9048E-01,0.7304E-01,0.5807E-01,0.4538E-01,0.3474E-01,0.2596E-01,
     +0.1882E-01,0.1313E-01,0.8717E-02,0.5408E-02,0.3047E-02,0.1483E-02,
     +0.5636E-03,0.1290E-03/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.1029E-01,0.1087E-01,0.1147E-01,0.1211E-01,0.1278E-01,0.1349E-01,
     +0.1423E-01,0.1502E-01,0.1585E-01,0.1672E-01,0.1764E-01,0.1861E-01,
     +0.1963E-01,0.2070E-01,0.2183E-01,0.2302E-01,0.2428E-01,0.2560E-01,
     +0.2698E-01,0.2844E-01,0.2998E-01,0.3160E-01,0.3329E-01,0.3508E-01,
     +0.3695E-01,0.3892E-01,0.4099E-01,0.4316E-01,0.4543E-01,0.4782E-01,
     +0.5033E-01,0.5295E-01,0.5570E-01,0.5858E-01,0.6160E-01,0.6475E-01,
     +0.6805E-01,0.7149E-01,0.7509E-01,0.7884E-01,0.8275E-01,0.8683E-01,
     +0.9107E-01,0.9548E-01,0.1001E+00,0.1048E+00,0.1097E+00,0.1148E+00,
     +0.1201E+00,0.1255E+00,0.1311E+00,0.1369E+00,0.1428E+00,0.1488E+00,
     +0.1549E+00,0.1612E+00,0.1675E+00,0.1738E+00,0.1802E+00,0.1866E+00,
     +0.1929E+00,0.1991E+00,0.2052E+00,0.2110E+00,0.2165E+00,0.2217E+00,
     +0.2264E+00,0.2305E+00,0.2340E+00,0.2367E+00,0.2384E+00,0.2392E+00,
     +0.2387E+00,0.2370E+00,0.2338E+00,0.2290E+00,0.2225E+00,0.2143E+00,
     +0.2043E+00,0.1924E+00,0.1788E+00,0.1635E+00,0.1469E+00,0.1291E+00,
     +0.1107E+00,0.9214E-01,0.7401E-01,0.5693E-01,0.4154E-01,0.2834E-01,
     +0.2163E-01,0.1621E-01,0.1190E-01,0.8531E-02,0.5949E-02,0.4013E-02,
     +0.2598E-02,0.1597E-02,0.9179E-03,0.4817E-03,0.2222E-03,0.8429E-04,
     +0.2300E-04,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.1386E+03,0.1328E+03,0.1272E+03,0.1218E+03,0.1165E+03,0.1115E+03,
     +0.1067E+03,0.1021E+03,0.9759E+02,0.9329E+02,0.8915E+02,0.8517E+02,
     +0.8135E+02,0.7767E+02,0.7414E+02,0.7074E+02,0.6747E+02,0.6434E+02,
     +0.6133E+02,0.5843E+02,0.5566E+02,0.5299E+02,0.5044E+02,0.4798E+02,
     +0.4563E+02,0.4338E+02,0.4121E+02,0.3914E+02,0.3716E+02,0.3526E+02,
     +0.3344E+02,0.3169E+02,0.3002E+02,0.2843E+02,0.2690E+02,0.2544E+02,
     +0.2405E+02,0.2271E+02,0.2144E+02,0.2022E+02,0.1906E+02,0.1795E+02,
     +0.1689E+02,0.1589E+02,0.1492E+02,0.1401E+02,0.1313E+02,0.1230E+02,
     +0.1151E+02,0.1076E+02,0.1004E+02,0.9360E+01,0.8712E+01,0.8097E+01,
     +0.7513E+01,0.6958E+01,0.6432E+01,0.5933E+01,0.5460E+01,0.5013E+01,
     +0.4590E+01,0.4190E+01,0.3813E+01,0.3458E+01,0.3124E+01,0.2810E+01,
     +0.2516E+01,0.2242E+01,0.1986E+01,0.1749E+01,0.1529E+01,0.1328E+01,
     +0.1143E+01,0.9751E+00,0.8236E+00,0.6878E+00,0.5674E+00,0.4615E+00,
     +0.3697E+00,0.2911E+00,0.2249E+00,0.1700E+00,0.1254E+00,0.9002E-01,
     +0.6267E-01,0.4213E-01,0.2723E-01,0.1681E-01,0.9843E-02,0.5406E-02,
     +0.3630E-02,0.2417E-02,0.1591E-02,0.1031E-02,0.6533E-03,0.4025E-03,
     +0.2387E-03,0.1346E-03,0.7094E-04,0.3405E-04,0.1429E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1666E+02,0.1606E+02,0.1548E+02,0.1491E+02,0.1437E+02,0.1384E+02,
     +0.1333E+02,0.1284E+02,0.1237E+02,0.1191E+02,0.1146E+02,0.1103E+02,
     +0.1062E+02,0.1022E+02,0.9834E+01,0.9461E+01,0.9101E+01,0.8753E+01,
     +0.8417E+01,0.8093E+01,0.7780E+01,0.7479E+01,0.7187E+01,0.6906E+01,
     +0.6635E+01,0.6373E+01,0.6120E+01,0.5877E+01,0.5641E+01,0.5414E+01,
     +0.5195E+01,0.4984E+01,0.4780E+01,0.4583E+01,0.4393E+01,0.4210E+01,
     +0.4033E+01,0.3861E+01,0.3696E+01,0.3536E+01,0.3382E+01,0.3233E+01,
     +0.3088E+01,0.2949E+01,0.2813E+01,0.2682E+01,0.2556E+01,0.2433E+01,
     +0.2313E+01,0.2198E+01,0.2085E+01,0.1976E+01,0.1870E+01,0.1767E+01,
     +0.1667E+01,0.1570E+01,0.1475E+01,0.1383E+01,0.1294E+01,0.1207E+01,
     +0.1122E+01,0.1040E+01,0.9612E+00,0.8845E+00,0.8105E+00,0.7394E+00,
     +0.6710E+00,0.6057E+00,0.5436E+00,0.4847E+00,0.4292E+00,0.3773E+00,
     +0.3291E+00,0.2846E+00,0.2439E+00,0.2070E+00,0.1739E+00,0.1444E+00,
     +0.1185E+00,0.9590E-01,0.7639E-01,0.5971E-01,0.4560E-01,0.3383E-01,
     +0.2418E-01,0.1648E-01,0.1055E-01,0.6227E-02,0.3306E-02,0.1525E-02,
     +0.8770E-03,0.4837E-03,0.2547E-03,0.1275E-03,0.6034E-04,0.2691E-04,
     +0.1128E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.3388E+01,0.3272E+01,0.3160E+01,0.3052E+01,0.2947E+01,0.2846E+01,
     +0.2748E+01,0.2653E+01,0.2561E+01,0.2472E+01,0.2387E+01,0.2304E+01,
     +0.2224E+01,0.2147E+01,0.2072E+01,0.2000E+01,0.1930E+01,0.1863E+01,
     +0.1798E+01,0.1735E+01,0.1674E+01,0.1616E+01,0.1559E+01,0.1504E+01,
     +0.1452E+01,0.1400E+01,0.1351E+01,0.1303E+01,0.1257E+01,0.1213E+01,
     +0.1170E+01,0.1128E+01,0.1088E+01,0.1049E+01,0.1011E+01,0.9750E+00,
     +0.9396E+00,0.9054E+00,0.8722E+00,0.8400E+00,0.8088E+00,0.7784E+00,
     +0.7489E+00,0.7201E+00,0.6921E+00,0.6649E+00,0.6382E+00,0.6122E+00,
     +0.5868E+00,0.5619E+00,0.5375E+00,0.5136E+00,0.4901E+00,0.4671E+00,
     +0.4444E+00,0.4220E+00,0.4000E+00,0.3783E+00,0.3570E+00,0.3359E+00,
     +0.3152E+00,0.2949E+00,0.2748E+00,0.2552E+00,0.2360E+00,0.2172E+00,
     +0.1990E+00,0.1813E+00,0.1642E+00,0.1478E+00,0.1322E+00,0.1174E+00,
     +0.1034E+00,0.9040E-01,0.7835E-01,0.6730E-01,0.5726E-01,0.4820E-01,
     +0.4012E-01,0.3295E-01,0.2665E-01,0.2116E-01,0.1641E-01,0.1235E-01,
     +0.8947E-02,0.6169E-02,0.3988E-02,0.2371E-02,0.1263E-02,0.5818E-03,
     +0.3332E-03,0.1823E-03,0.9482E-04,0.4659E-04,0.2147E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.3214E+01,0.3098E+01,0.2986E+01,0.2878E+01,0.2773E+01,0.2671E+01,
     +0.2573E+01,0.2479E+01,0.2387E+01,0.2299E+01,0.2213E+01,0.2130E+01,
     +0.2051E+01,0.1973E+01,0.1899E+01,0.1827E+01,0.1757E+01,0.1690E+01,
     +0.1625E+01,0.1563E+01,0.1502E+01,0.1444E+01,0.1388E+01,0.1333E+01,
     +0.1281E+01,0.1230E+01,0.1181E+01,0.1134E+01,0.1088E+01,0.1044E+01,
     +0.1002E+01,0.9608E+00,0.9212E+00,0.8830E+00,0.8461E+00,0.8105E+00,
     +0.7760E+00,0.7428E+00,0.7107E+00,0.6796E+00,0.6496E+00,0.6206E+00,
     +0.5925E+00,0.5653E+00,0.5390E+00,0.5136E+00,0.4889E+00,0.4650E+00,
     +0.4418E+00,0.4193E+00,0.3975E+00,0.3763E+00,0.3557E+00,0.3358E+00,
     +0.3164E+00,0.2975E+00,0.2792E+00,0.2615E+00,0.2442E+00,0.2275E+00,
     +0.2113E+00,0.1956E+00,0.1804E+00,0.1657E+00,0.1516E+00,0.1380E+00,
     +0.1251E+00,0.1127E+00,0.1009E+00,0.8979E-01,0.7934E-01,0.6958E-01,
     +0.6052E-01,0.5219E-01,0.4460E-01,0.3773E-01,0.3158E-01,0.2612E-01,
     +0.2134E-01,0.1719E-01,0.1363E-01,0.1059E-01,0.8048E-02,0.5939E-02,
     +0.4224E-02,0.2864E-02,0.1826E-02,0.1075E-02,0.5694E-03,0.2625E-03,
     +0.1511E-03,0.8348E-04,0.4409E-04,0.2217E-04,0.1057E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.3098E+01,0.2982E+01,0.2870E+01,0.2761E+01,0.2657E+01,0.2555E+01,
     +0.2457E+01,0.2363E+01,0.2271E+01,0.2183E+01,0.2097E+01,0.2015E+01,
     +0.1935E+01,0.1858E+01,0.1783E+01,0.1712E+01,0.1642E+01,0.1575E+01,
     +0.1510E+01,0.1448E+01,0.1388E+01,0.1329E+01,0.1273E+01,0.1219E+01,
     +0.1167E+01,0.1116E+01,0.1068E+01,0.1021E+01,0.9755E+00,0.9318E+00,
     +0.8897E+00,0.8491E+00,0.8100E+00,0.7722E+00,0.7359E+00,0.7008E+00,
     +0.6670E+00,0.6344E+00,0.6030E+00,0.5727E+00,0.5435E+00,0.5154E+00,
     +0.4882E+00,0.4621E+00,0.4369E+00,0.4127E+00,0.3893E+00,0.3668E+00,
     +0.3451E+00,0.3242E+00,0.3041E+00,0.2848E+00,0.2661E+00,0.2483E+00,
     +0.2311E+00,0.2146E+00,0.1987E+00,0.1836E+00,0.1691E+00,0.1552E+00,
     +0.1420E+00,0.1294E+00,0.1174E+00,0.1061E+00,0.9535E-01,0.8526E-01,
     +0.7580E-01,0.6695E-01,0.5872E-01,0.5111E-01,0.4412E-01,0.3772E-01,
     +0.3193E-01,0.2672E-01,0.2209E-01,0.1801E-01,0.1445E-01,0.1140E-01,
     +0.8826E-02,0.6685E-02,0.4941E-02,0.3553E-02,0.2476E-02,0.1665E-02,
     +0.1074E-02,0.6612E-03,0.3853E-03,0.2107E-03,0.1069E-03,0.4960E-04,
     +0.2970E-04,0.1759E-04,0.1027E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.2940E+01,0.2828E+01,0.2720E+01,0.2616E+01,0.2515E+01,0.2417E+01,
     +0.2322E+01,0.2231E+01,0.2143E+01,0.2058E+01,0.1976E+01,0.1896E+01,
     +0.1820E+01,0.1745E+01,0.1674E+01,0.1605E+01,0.1538E+01,0.1474E+01,
     +0.1412E+01,0.1352E+01,0.1294E+01,0.1239E+01,0.1185E+01,0.1133E+01,
     +0.1083E+01,0.1035E+01,0.9885E+00,0.9438E+00,0.9006E+00,0.8591E+00,
     +0.8191E+00,0.7805E+00,0.7433E+00,0.7076E+00,0.6731E+00,0.6399E+00,
     +0.6080E+00,0.5772E+00,0.5476E+00,0.5192E+00,0.4918E+00,0.4654E+00,
     +0.4400E+00,0.4156E+00,0.3921E+00,0.3696E+00,0.3479E+00,0.3270E+00,
     +0.3070E+00,0.2877E+00,0.2693E+00,0.2515E+00,0.2345E+00,0.2182E+00,
     +0.2026E+00,0.1877E+00,0.1734E+00,0.1598E+00,0.1467E+00,0.1344E+00,
     +0.1226E+00,0.1114E+00,0.1009E+00,0.9087E-01,0.8148E-01,0.7266E-01,
     +0.6443E-01,0.5676E-01,0.4965E-01,0.4311E-01,0.3711E-01,0.3166E-01,
     +0.2673E-01,0.2232E-01,0.1840E-01,0.1497E-01,0.1199E-01,0.9444E-02,
     +0.7297E-02,0.5520E-02,0.4076E-02,0.2930E-02,0.2042E-02,0.1375E-02,
     +0.8895E-03,0.5498E-03,0.3225E-03,0.1780E-03,0.9150E-04,0.4321E-04,
     +0.2620E-04,0.1572E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.6340E+00,0.6068E+00,0.5805E+00,0.5552E+00,0.5309E+00,0.5075E+00,
     +0.4849E+00,0.4633E+00,0.4424E+00,0.4224E+00,0.4031E+00,0.3846E+00,
     +0.3668E+00,0.3497E+00,0.3333E+00,0.3175E+00,0.3023E+00,0.2878E+00,
     +0.2738E+00,0.2605E+00,0.2476E+00,0.2353E+00,0.2235E+00,0.2122E+00,
     +0.2013E+00,0.1909E+00,0.1810E+00,0.1714E+00,0.1623E+00,0.1536E+00,
     +0.1452E+00,0.1372E+00,0.1296E+00,0.1223E+00,0.1153E+00,0.1087E+00,
     +0.1023E+00,0.9627E-01,0.9048E-01,0.8497E-01,0.7971E-01,0.7470E-01,
     +0.6993E-01,0.6539E-01,0.6107E-01,0.5696E-01,0.5306E-01,0.4935E-01,
     +0.4583E-01,0.4249E-01,0.3933E-01,0.3633E-01,0.3350E-01,0.3082E-01,
     +0.2829E-01,0.2591E-01,0.2366E-01,0.2155E-01,0.1957E-01,0.1771E-01,
     +0.1597E-01,0.1434E-01,0.1283E-01,0.1143E-01,0.1013E-01,0.8930E-02,
     +0.7828E-02,0.6819E-02,0.5900E-02,0.5066E-02,0.4315E-02,0.3643E-02,
     +0.3046E-02,0.2519E-02,0.2059E-02,0.1662E-02,0.1321E-02,0.1034E-02,
     +0.7955E-03,0.6000E-03,0.4427E-03,0.3188E-03,0.2234E-03,0.1518E-03,
     +0.9969E-04,0.6294E-04,0.3800E-04,0.2177E-04,0.1173E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1986E-01,0.2096E-01,0.2212E-01,0.2334E-01,0.2463E-01,0.2599E-01,
     +0.2742E-01,0.2892E-01,0.3051E-01,0.3218E-01,0.3394E-01,0.3579E-01,
     +0.3774E-01,0.3980E-01,0.4196E-01,0.4423E-01,0.4663E-01,0.4914E-01,
     +0.5179E-01,0.5457E-01,0.5750E-01,0.6057E-01,0.6380E-01,0.6720E-01,
     +0.7076E-01,0.7450E-01,0.7842E-01,0.8254E-01,0.8686E-01,0.9139E-01,
     +0.9613E-01,0.1011E+00,0.1063E+00,0.1118E+00,0.1175E+00,0.1234E+00,
     +0.1296E+00,0.1362E+00,0.1429E+00,0.1500E+00,0.1574E+00,0.1651E+00,
     +0.1731E+00,0.1814E+00,0.1901E+00,0.1990E+00,0.2083E+00,0.2179E+00,
     +0.2279E+00,0.2381E+00,0.2487E+00,0.2596E+00,0.2708E+00,0.2822E+00,
     +0.2939E+00,0.3058E+00,0.3179E+00,0.3302E+00,0.3425E+00,0.3549E+00,
     +0.3673E+00,0.3796E+00,0.3917E+00,0.4035E+00,0.4149E+00,0.4258E+00,
     +0.4360E+00,0.4454E+00,0.4538E+00,0.4609E+00,0.4666E+00,0.4707E+00,
     +0.4728E+00,0.4728E+00,0.4703E+00,0.4651E+00,0.4569E+00,0.4456E+00,
     +0.4308E+00,0.4126E+00,0.3907E+00,0.3653E+00,0.3365E+00,0.3047E+00,
     +0.2704E+00,0.2344E+00,0.1975E+00,0.1609E+00,0.1257E+00,0.9324E-01,
     +0.7551E-01,0.6031E-01,0.4743E-01,0.3663E-01,0.2770E-01,0.2042E-01,
     +0.1459E-01,0.1001E-01,0.6525E-02,0.3963E-02,0.2177E-02,0.1027E-02,
     +0.3747E-03,0.8079E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1129E-01,0.1191E-01,0.1257E-01,0.1326E-01,0.1399E-01,0.1475E-01,
     +0.1556E-01,0.1641E-01,0.1731E-01,0.1826E-01,0.1925E-01,0.2029E-01,
     +0.2140E-01,0.2255E-01,0.2377E-01,0.2505E-01,0.2640E-01,0.2781E-01,
     +0.2930E-01,0.3086E-01,0.3251E-01,0.3423E-01,0.3604E-01,0.3794E-01,
     +0.3993E-01,0.4202E-01,0.4422E-01,0.4651E-01,0.4892E-01,0.5144E-01,
     +0.5408E-01,0.5684E-01,0.5972E-01,0.6274E-01,0.6589E-01,0.6918E-01,
     +0.7261E-01,0.7619E-01,0.7991E-01,0.8379E-01,0.8782E-01,0.9201E-01,
     +0.9635E-01,0.1009E+00,0.1055E+00,0.1103E+00,0.1153E+00,0.1205E+00,
     +0.1257E+00,0.1312E+00,0.1367E+00,0.1424E+00,0.1482E+00,0.1541E+00,
     +0.1601E+00,0.1661E+00,0.1721E+00,0.1782E+00,0.1842E+00,0.1902E+00,
     +0.1960E+00,0.2017E+00,0.2071E+00,0.2123E+00,0.2170E+00,0.2214E+00,
     +0.2252E+00,0.2283E+00,0.2308E+00,0.2323E+00,0.2330E+00,0.2325E+00,
     +0.2309E+00,0.2279E+00,0.2235E+00,0.2176E+00,0.2101E+00,0.2010E+00,
     +0.1902E+00,0.1777E+00,0.1638E+00,0.1485E+00,0.1322E+00,0.1151E+00,
     +0.9766E-01,0.8037E-01,0.6378E-01,0.4842E-01,0.3481E-01,0.2337E-01,
     +0.1764E-01,0.1307E-01,0.9487E-02,0.6720E-02,0.4626E-02,0.3077E-02,
     +0.1962E-02,0.1186E-02,0.6690E-03,0.3436E-03,0.1545E-03,0.5679E-04,
     +0.1487E-04,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1789E+03,0.1708E+03,0.1630E+03,0.1554E+03,0.1482E+03,0.1413E+03,
     +0.1347E+03,0.1283E+03,0.1222E+03,0.1164E+03,0.1108E+03,0.1054E+03,
     +0.1003E+03,0.9536E+02,0.9065E+02,0.8613E+02,0.8182E+02,0.7768E+02,
     +0.7373E+02,0.6995E+02,0.6634E+02,0.6288E+02,0.5958E+02,0.5643E+02,
     +0.5342E+02,0.5055E+02,0.4780E+02,0.4519E+02,0.4269E+02,0.4031E+02,
     +0.3804E+02,0.3588E+02,0.3382E+02,0.3186E+02,0.2999E+02,0.2822E+02,
     +0.2653E+02,0.2492E+02,0.2339E+02,0.2194E+02,0.2057E+02,0.1926E+02,
     +0.1802E+02,0.1684E+02,0.1573E+02,0.1467E+02,0.1367E+02,0.1273E+02,
     +0.1183E+02,0.1098E+02,0.1018E+02,0.9429E+01,0.8716E+01,0.8043E+01,
     +0.7409E+01,0.6812E+01,0.6250E+01,0.5722E+01,0.5225E+01,0.4760E+01,
     +0.4323E+01,0.3915E+01,0.3534E+01,0.3178E+01,0.2846E+01,0.2539E+01,
     +0.2254E+01,0.1990E+01,0.1748E+01,0.1525E+01,0.1322E+01,0.1138E+01,
     +0.9709E+00,0.8211E+00,0.6875E+00,0.5693E+00,0.4657E+00,0.3759E+00,
     +0.2989E+00,0.2338E+00,0.1795E+00,0.1349E+00,0.9916E-01,0.7101E-01,
     +0.4938E-01,0.3323E-01,0.2153E-01,0.1335E-01,0.7863E-02,0.4340E-02,
     +0.2920E-02,0.1945E-02,0.1277E-02,0.8238E-03,0.5186E-03,0.3164E-03,
     +0.1853E-03,0.1028E-03,0.5315E-04,0.2492E-04,0.1017E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.2517E+02,0.2417E+02,0.2321E+02,0.2228E+02,0.2138E+02,0.2052E+02,
     +0.1969E+02,0.1888E+02,0.1811E+02,0.1737E+02,0.1665E+02,0.1596E+02,
     +0.1530E+02,0.1466E+02,0.1405E+02,0.1345E+02,0.1288E+02,0.1234E+02,
     +0.1181E+02,0.1130E+02,0.1081E+02,0.1035E+02,0.9895E+01,0.9462E+01,
     +0.9046E+01,0.8646E+01,0.8261E+01,0.7892E+01,0.7536E+01,0.7195E+01,
     +0.6868E+01,0.6553E+01,0.6250E+01,0.5960E+01,0.5681E+01,0.5413E+01,
     +0.5155E+01,0.4908E+01,0.4670E+01,0.4442E+01,0.4222E+01,0.4012E+01,
     +0.3809E+01,0.3614E+01,0.3427E+01,0.3246E+01,0.3073E+01,0.2906E+01,
     +0.2745E+01,0.2591E+01,0.2442E+01,0.2299E+01,0.2161E+01,0.2028E+01,
     +0.1900E+01,0.1776E+01,0.1658E+01,0.1543E+01,0.1433E+01,0.1327E+01,
     +0.1226E+01,0.1128E+01,0.1034E+01,0.9448E+00,0.8594E+00,0.7781E+00,
     +0.7009E+00,0.6279E+00,0.5591E+00,0.4947E+00,0.4347E+00,0.3791E+00,
     +0.3280E+00,0.2813E+00,0.2391E+00,0.2012E+00,0.1675E+00,0.1379E+00,
     +0.1120E+00,0.8975E-01,0.7072E-01,0.5464E-01,0.4121E-01,0.3017E-01,
     +0.2126E-01,0.1427E-01,0.8994E-02,0.5225E-02,0.2729E-02,0.1240E-02,
     +0.7074E-03,0.3878E-03,0.2035E-03,0.1018E-03,0.4842E-04,0.2182E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.4792E+01,0.4610E+01,0.4435E+01,0.4266E+01,0.4103E+01,0.3945E+01,
     +0.3794E+01,0.3648E+01,0.3507E+01,0.3371E+01,0.3241E+01,0.3115E+01,
     +0.2994E+01,0.2877E+01,0.2764E+01,0.2656E+01,0.2552E+01,0.2451E+01,
     +0.2354E+01,0.2261E+01,0.2172E+01,0.2085E+01,0.2002E+01,0.1923E+01,
     +0.1846E+01,0.1772E+01,0.1701E+01,0.1632E+01,0.1566E+01,0.1503E+01,
     +0.1442E+01,0.1383E+01,0.1326E+01,0.1272E+01,0.1220E+01,0.1169E+01,
     +0.1120E+01,0.1073E+01,0.1028E+01,0.9846E+00,0.9425E+00,0.9018E+00,
     +0.8626E+00,0.8246E+00,0.7879E+00,0.7524E+00,0.7180E+00,0.6846E+00,
     +0.6522E+00,0.6208E+00,0.5903E+00,0.5606E+00,0.5317E+00,0.5036E+00,
     +0.4762E+00,0.4495E+00,0.4234E+00,0.3980E+00,0.3732E+00,0.3491E+00,
     +0.3255E+00,0.3026E+00,0.2803E+00,0.2586E+00,0.2376E+00,0.2174E+00,
     +0.1978E+00,0.1791E+00,0.1612E+00,0.1442E+00,0.1281E+00,0.1130E+00,
     +0.9891E-01,0.8588E-01,0.7394E-01,0.6307E-01,0.5327E-01,0.4451E-01,
     +0.3675E-01,0.2993E-01,0.2398E-01,0.1885E-01,0.1445E-01,0.1075E-01,
     +0.7687E-02,0.5225E-02,0.3326E-02,0.1945E-02,0.1018E-02,0.4606E-03,
     +0.2608E-03,0.1413E-03,0.7284E-04,0.3553E-04,0.1631E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.4618E+01,0.4436E+01,0.4261E+01,0.4092E+01,0.3929E+01,0.3771E+01,
     +0.3620E+01,0.3474E+01,0.3333E+01,0.3198E+01,0.3067E+01,0.2942E+01,
     +0.2820E+01,0.2704E+01,0.2591E+01,0.2483E+01,0.2379E+01,0.2279E+01,
     +0.2182E+01,0.2090E+01,0.2000E+01,0.1914E+01,0.1832E+01,0.1752E+01,
     +0.1676E+01,0.1602E+01,0.1532E+01,0.1464E+01,0.1398E+01,0.1335E+01,
     +0.1275E+01,0.1217E+01,0.1161E+01,0.1107E+01,0.1056E+01,0.1006E+01,
     +0.9586E+00,0.9128E+00,0.8688E+00,0.8264E+00,0.7857E+00,0.7466E+00,
     +0.7089E+00,0.6726E+00,0.6378E+00,0.6042E+00,0.5719E+00,0.5408E+00,
     +0.5108E+00,0.4820E+00,0.4542E+00,0.4274E+00,0.4016E+00,0.3768E+00,
     +0.3528E+00,0.3297E+00,0.3075E+00,0.2861E+00,0.2655E+00,0.2457E+00,
     +0.2267E+00,0.2085E+00,0.1910E+00,0.1743E+00,0.1584E+00,0.1432E+00,
     +0.1289E+00,0.1153E+00,0.1025E+00,0.9059E-01,0.7946E-01,0.6918E-01,
     +0.5973E-01,0.5112E-01,0.4334E-01,0.3637E-01,0.3019E-01,0.2476E-01,
     +0.2005E-01,0.1600E-01,0.1255E-01,0.9650E-02,0.7244E-02,0.5278E-02,
     +0.3703E-02,0.2475E-02,0.1554E-02,0.9004E-03,0.4695E-03,0.2132E-03,
     +0.1217E-03,0.6683E-04,0.3516E-04,0.1767E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.4501E+01,0.4320E+01,0.4144E+01,0.3975E+01,0.3813E+01,0.3655E+01,
     +0.3504E+01,0.3358E+01,0.3218E+01,0.3082E+01,0.2952E+01,0.2826E+01,
     +0.2705E+01,0.2588E+01,0.2476E+01,0.2368E+01,0.2264E+01,0.2164E+01,
     +0.2068E+01,0.1975E+01,0.1886E+01,0.1800E+01,0.1718E+01,0.1639E+01,
     +0.1562E+01,0.1489E+01,0.1419E+01,0.1351E+01,0.1286E+01,0.1224E+01,
     +0.1164E+01,0.1106E+01,0.1051E+01,0.9977E+00,0.9468E+00,0.8978E+00,
     +0.8508E+00,0.8058E+00,0.7625E+00,0.7210E+00,0.6812E+00,0.6430E+00,
     +0.6064E+00,0.5713E+00,0.5377E+00,0.5054E+00,0.4745E+00,0.4449E+00,
     +0.4166E+00,0.3894E+00,0.3634E+00,0.3386E+00,0.3149E+00,0.2922E+00,
     +0.2705E+00,0.2499E+00,0.2302E+00,0.2115E+00,0.1937E+00,0.1769E+00,
     +0.1609E+00,0.1458E+00,0.1315E+00,0.1181E+00,0.1056E+00,0.9383E-01,
     +0.8291E-01,0.7278E-01,0.6344E-01,0.5487E-01,0.4705E-01,0.3997E-01,
     +0.3361E-01,0.2794E-01,0.2294E-01,0.1857E-01,0.1481E-01,0.1160E-01,
     +0.8917E-02,0.6708E-02,0.4925E-02,0.3518E-02,0.2437E-02,0.1629E-02,
     +0.1046E-02,0.6415E-03,0.3729E-03,0.2038E-03,0.1036E-03,0.4822E-04,
     +0.2895E-04,0.1718E-04,0.1004E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.4348E+01,0.4170E+01,0.3999E+01,0.3833E+01,0.3674E+01,0.3521E+01,
     +0.3373E+01,0.3230E+01,0.3093E+01,0.2961E+01,0.2833E+01,0.2711E+01,
     +0.2593E+01,0.2479E+01,0.2370E+01,0.2264E+01,0.2163E+01,0.2066E+01,
     +0.1972E+01,0.1882E+01,0.1795E+01,0.1712E+01,0.1632E+01,0.1555E+01,
     +0.1481E+01,0.1410E+01,0.1342E+01,0.1276E+01,0.1214E+01,0.1153E+01,
     +0.1095E+01,0.1040E+01,0.9863E+00,0.9351E+00,0.8860E+00,0.8389E+00,
     +0.7938E+00,0.7506E+00,0.7091E+00,0.6694E+00,0.6313E+00,0.5949E+00,
     +0.5600E+00,0.5266E+00,0.4946E+00,0.4641E+00,0.4348E+00,0.4069E+00,
     +0.3801E+00,0.3546E+00,0.3303E+00,0.3070E+00,0.2848E+00,0.2637E+00,
     +0.2436E+00,0.2245E+00,0.2063E+00,0.1891E+00,0.1728E+00,0.1574E+00,
     +0.1428E+00,0.1291E+00,0.1162E+00,0.1041E+00,0.9277E-01,0.8225E-01,
     +0.7249E-01,0.6348E-01,0.5519E-01,0.4762E-01,0.4073E-01,0.3452E-01,
     +0.2896E-01,0.2402E-01,0.1968E-01,0.1590E-01,0.1265E-01,0.9897E-02,
     +0.7596E-02,0.5708E-02,0.4188E-02,0.2992E-02,0.2073E-02,0.1389E-02,
     +0.8943E-03,0.5509E-03,0.3224E-03,0.1779E-03,0.9151E-04,0.4330E-04,
     +0.2628E-04,0.1577E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.2123E+01,0.2027E+01,0.1935E+01,0.1846E+01,0.1761E+01,0.1680E+01,
     +0.1602E+01,0.1526E+01,0.1454E+01,0.1385E+01,0.1319E+01,0.1255E+01,
     +0.1194E+01,0.1136E+01,0.1080E+01,0.1026E+01,0.9744E+00,0.9252E+00,
     +0.8780E+00,0.8329E+00,0.7897E+00,0.7484E+00,0.7089E+00,0.6711E+00,
     +0.6350E+00,0.6006E+00,0.5676E+00,0.5362E+00,0.5062E+00,0.4775E+00,
     +0.4502E+00,0.4242E+00,0.3993E+00,0.3757E+00,0.3532E+00,0.3317E+00,
     +0.3113E+00,0.2919E+00,0.2734E+00,0.2559E+00,0.2392E+00,0.2234E+00,
     +0.2084E+00,0.1941E+00,0.1806E+00,0.1679E+00,0.1558E+00,0.1443E+00,
     +0.1335E+00,0.1233E+00,0.1136E+00,0.1045E+00,0.9599E-01,0.8793E-01,
     +0.8036E-01,0.7326E-01,0.6661E-01,0.6038E-01,0.5456E-01,0.4914E-01,
     +0.4410E-01,0.3942E-01,0.3509E-01,0.3109E-01,0.2741E-01,0.2403E-01,
     +0.2095E-01,0.1815E-01,0.1562E-01,0.1333E-01,0.1129E-01,0.9479E-02,
     +0.7878E-02,0.6478E-02,0.5264E-02,0.4222E-02,0.3338E-02,0.2598E-02,
     +0.1987E-02,0.1490E-02,0.1094E-02,0.7841E-03,0.5471E-03,0.3704E-03,
     +0.2424E-03,0.1526E-03,0.9193E-04,0.5258E-04,0.2824E-04,0.1402E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.2150E-01,0.2269E-01,0.2393E-01,0.2524E-01,0.2663E-01,0.2808E-01,
     +0.2962E-01,0.3123E-01,0.3293E-01,0.3472E-01,0.3660E-01,0.3858E-01,
     +0.4066E-01,0.4285E-01,0.4516E-01,0.4758E-01,0.5012E-01,0.5280E-01,
     +0.5561E-01,0.5856E-01,0.6166E-01,0.6492E-01,0.6833E-01,0.7192E-01,
     +0.7567E-01,0.7962E-01,0.8375E-01,0.8808E-01,0.9261E-01,0.9736E-01,
     +0.1023E+00,0.1075E+00,0.1130E+00,0.1186E+00,0.1246E+00,0.1307E+00,
     +0.1372E+00,0.1439E+00,0.1509E+00,0.1582E+00,0.1658E+00,0.1737E+00,
     +0.1819E+00,0.1904E+00,0.1992E+00,0.2083E+00,0.2177E+00,0.2274E+00,
     +0.2374E+00,0.2477E+00,0.2583E+00,0.2691E+00,0.2802E+00,0.2915E+00,
     +0.3030E+00,0.3146E+00,0.3264E+00,0.3382E+00,0.3501E+00,0.3619E+00,
     +0.3736E+00,0.3851E+00,0.3964E+00,0.4072E+00,0.4175E+00,0.4271E+00,
     +0.4360E+00,0.4439E+00,0.4507E+00,0.4561E+00,0.4600E+00,0.4621E+00,
     +0.4622E+00,0.4602E+00,0.4556E+00,0.4484E+00,0.4382E+00,0.4250E+00,
     +0.4085E+00,0.3888E+00,0.3658E+00,0.3397E+00,0.3106E+00,0.2791E+00,
     +0.2456E+00,0.2109E+00,0.1760E+00,0.1418E+00,0.1095E+00,0.8017E-01,
     +0.6435E-01,0.5092E-01,0.3966E-01,0.3033E-01,0.2269E-01,0.1653E-01,
     +0.1166E-01,0.7889E-02,0.5059E-02,0.3016E-02,0.1621E-02,0.7440E-03,
     +0.2620E-03,0.5364E-04/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1221E-01,0.1288E-01,0.1358E-01,0.1432E-01,0.1511E-01,0.1593E-01,
     +0.1679E-01,0.1770E-01,0.1866E-01,0.1967E-01,0.2073E-01,0.2184E-01,
     +0.2302E-01,0.2425E-01,0.2554E-01,0.2690E-01,0.2833E-01,0.2983E-01,
     +0.3141E-01,0.3306E-01,0.3480E-01,0.3662E-01,0.3852E-01,0.4052E-01,
     +0.4262E-01,0.4482E-01,0.4711E-01,0.4952E-01,0.5204E-01,0.5467E-01,
     +0.5742E-01,0.6029E-01,0.6329E-01,0.6642E-01,0.6968E-01,0.7307E-01,
     +0.7661E-01,0.8029E-01,0.8411E-01,0.8808E-01,0.9220E-01,0.9647E-01,
     +0.1009E+00,0.1055E+00,0.1102E+00,0.1150E+00,0.1200E+00,0.1252E+00,
     +0.1304E+00,0.1358E+00,0.1413E+00,0.1469E+00,0.1526E+00,0.1583E+00,
     +0.1641E+00,0.1699E+00,0.1757E+00,0.1815E+00,0.1872E+00,0.1927E+00,
     +0.1981E+00,0.2033E+00,0.2081E+00,0.2127E+00,0.2168E+00,0.2204E+00,
     +0.2234E+00,0.2257E+00,0.2272E+00,0.2279E+00,0.2276E+00,0.2261E+00,
     +0.2235E+00,0.2196E+00,0.2143E+00,0.2075E+00,0.1992E+00,0.1894E+00,
     +0.1781E+00,0.1654E+00,0.1514E+00,0.1363E+00,0.1203E+00,0.1039E+00,
     +0.8734E-01,0.7119E-01,0.5590E-01,0.4196E-01,0.2979E-01,0.1972E-01,
     +0.1475E-01,0.1082E-01,0.7775E-02,0.5449E-02,0.3709E-02,0.2438E-02,
     +0.1534E-02,0.9140E-03,0.5071E-03,0.2556E-03,0.1124E-03,0.4020E-04,
     +0.1016E-04,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.2175E+03,0.2070E+03,0.1969E+03,0.1872E+03,0.1780E+03,0.1692E+03,
     +0.1607E+03,0.1526E+03,0.1449E+03,0.1376E+03,0.1305E+03,0.1238E+03,
     +0.1174E+03,0.1112E+03,0.1054E+03,0.9978E+02,0.9445E+02,0.8937E+02,
     +0.8452E+02,0.7990E+02,0.7551E+02,0.7132E+02,0.6733E+02,0.6353E+02,
     +0.5991E+02,0.5648E+02,0.5321E+02,0.5010E+02,0.4715E+02,0.4434E+02,
     +0.4168E+02,0.3915E+02,0.3675E+02,0.3448E+02,0.3232E+02,0.3028E+02,
     +0.2834E+02,0.2651E+02,0.2478E+02,0.2314E+02,0.2158E+02,0.2012E+02,
     +0.1873E+02,0.1743E+02,0.1620E+02,0.1503E+02,0.1394E+02,0.1291E+02,
     +0.1194E+02,0.1102E+02,0.1017E+02,0.9361E+01,0.8605E+01,0.7896E+01,
     +0.7232E+01,0.6610E+01,0.6029E+01,0.5486E+01,0.4979E+01,0.4507E+01,
     +0.4068E+01,0.3660E+01,0.3282E+01,0.2932E+01,0.2609E+01,0.2311E+01,
     +0.2038E+01,0.1787E+01,0.1559E+01,0.1351E+01,0.1163E+01,0.9941E+00,
     +0.8426E+00,0.7078E+00,0.5888E+00,0.4846E+00,0.3941E+00,0.3163E+00,
     +0.2502E+00,0.1947E+00,0.1489E+00,0.1116E+00,0.8182E-01,0.5850E-01,
     +0.4067E-01,0.2739E-01,0.1777E-01,0.1104E-01,0.6513E-02,0.3595E-02,
     +0.2414E-02,0.1603E-02,0.1048E-02,0.6717E-03,0.4194E-03,0.2532E-03,
     +0.1465E-03,0.8014E-04,0.4073E-04,0.1872E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.3401E+02,0.3257E+02,0.3118E+02,0.2984E+02,0.2855E+02,0.2732E+02,
     +0.2613E+02,0.2499E+02,0.2390E+02,0.2284E+02,0.2183E+02,0.2086E+02,
     +0.1993E+02,0.1903E+02,0.1818E+02,0.1735E+02,0.1656E+02,0.1580E+02,
     +0.1508E+02,0.1438E+02,0.1371E+02,0.1307E+02,0.1245E+02,0.1187E+02,
     +0.1130E+02,0.1076E+02,0.1024E+02,0.9747E+01,0.9272E+01,0.8817E+01,
     +0.8382E+01,0.7965E+01,0.7566E+01,0.7185E+01,0.6819E+01,0.6470E+01,
     +0.6135E+01,0.5815E+01,0.5509E+01,0.5216E+01,0.4936E+01,0.4668E+01,
     +0.4411E+01,0.4166E+01,0.3931E+01,0.3706E+01,0.3491E+01,0.3285E+01,
     +0.3088E+01,0.2900E+01,0.2719E+01,0.2547E+01,0.2381E+01,0.2223E+01,
     +0.2072E+01,0.1927E+01,0.1788E+01,0.1656E+01,0.1529E+01,0.1408E+01,
     +0.1293E+01,0.1183E+01,0.1079E+01,0.9798E+00,0.8861E+00,0.7975E+00,
     +0.7141E+00,0.6360E+00,0.5629E+00,0.4951E+00,0.4323E+00,0.3747E+00,
     +0.3221E+00,0.2745E+00,0.2318E+00,0.1937E+00,0.1602E+00,0.1309E+00,
     +0.1056E+00,0.8388E-01,0.6552E-01,0.5016E-01,0.3746E-01,0.2713E-01,
     +0.1890E-01,0.1253E-01,0.7800E-02,0.4473E-02,0.2306E-02,0.1034E-02,
     +0.5863E-03,0.3198E-03,0.1673E-03,0.8372E-04,0.3993E-04,0.1812E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.6252E+01,0.5997E+01,0.5751E+01,0.5514E+01,0.5287E+01,0.5068E+01,
     +0.4858E+01,0.4655E+01,0.4461E+01,0.4274E+01,0.4095E+01,0.3922E+01,
     +0.3756E+01,0.3597E+01,0.3444E+01,0.3298E+01,0.3157E+01,0.3021E+01,
     +0.2891E+01,0.2767E+01,0.2647E+01,0.2532E+01,0.2422E+01,0.2316E+01,
     +0.2215E+01,0.2118E+01,0.2025E+01,0.1935E+01,0.1849E+01,0.1767E+01,
     +0.1688E+01,0.1613E+01,0.1540E+01,0.1470E+01,0.1404E+01,0.1340E+01,
     +0.1278E+01,0.1219E+01,0.1163E+01,0.1108E+01,0.1056E+01,0.1006E+01,
     +0.9575E+00,0.9111E+00,0.8664E+00,0.8234E+00,0.7820E+00,0.7421E+00,
     +0.7037E+00,0.6665E+00,0.6307E+00,0.5960E+00,0.5626E+00,0.5302E+00,
     +0.4989E+00,0.4685E+00,0.4392E+00,0.4108E+00,0.3833E+00,0.3566E+00,
     +0.3309E+00,0.3060E+00,0.2820E+00,0.2589E+00,0.2367E+00,0.2153E+00,
     +0.1950E+00,0.1756E+00,0.1572E+00,0.1399E+00,0.1236E+00,0.1085E+00,
     +0.9443E-01,0.8155E-01,0.6981E-01,0.5921E-01,0.4971E-01,0.4128E-01,
     +0.3386E-01,0.2738E-01,0.2177E-01,0.1697E-01,0.1289E-01,0.9494E-02,
     +0.6714E-02,0.4509E-02,0.2834E-02,0.1634E-02,0.8431E-03,0.3755E-03,
     +0.2107E-03,0.1132E-03,0.5792E-04,0.2810E-04,0.1285E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.6078E+01,0.5823E+01,0.5577E+01,0.5340E+01,0.5113E+01,0.4894E+01,
     +0.4684E+01,0.4482E+01,0.4288E+01,0.4101E+01,0.3922E+01,0.3749E+01,
     +0.3584E+01,0.3425E+01,0.3272E+01,0.3125E+01,0.2985E+01,0.2850E+01,
     +0.2720E+01,0.2596E+01,0.2476E+01,0.2362E+01,0.2252E+01,0.2147E+01,
     +0.2046E+01,0.1949E+01,0.1856E+01,0.1768E+01,0.1682E+01,0.1601E+01,
     +0.1523E+01,0.1448E+01,0.1376E+01,0.1307E+01,0.1242E+01,0.1179E+01,
     +0.1118E+01,0.1060E+01,0.1005E+01,0.9521E+00,0.9014E+00,0.8528E+00,
     +0.8062E+00,0.7617E+00,0.7190E+00,0.6781E+00,0.6389E+00,0.6014E+00,
     +0.5655E+00,0.5311E+00,0.4981E+00,0.4665E+00,0.4362E+00,0.4072E+00,
     +0.3795E+00,0.3529E+00,0.3275E+00,0.3031E+00,0.2799E+00,0.2577E+00,
     +0.2365E+00,0.2164E+00,0.1972E+00,0.1790E+00,0.1617E+00,0.1455E+00,
     +0.1301E+00,0.1158E+00,0.1024E+00,0.8994E-01,0.7844E-01,0.6789E-01,
     +0.5826E-01,0.4956E-01,0.4176E-01,0.3482E-01,0.2871E-01,0.2339E-01,
     +0.1880E-01,0.1489E-01,0.1158E-01,0.8828E-02,0.6565E-02,0.4734E-02,
     +0.3285E-02,0.2170E-02,0.1346E-02,0.7698E-03,0.3962E-03,0.1777E-03,
     +0.1008E-03,0.5505E-04,0.2887E-04,0.1450E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.5962E+01,0.5706E+01,0.5461E+01,0.5224E+01,0.4997E+01,0.4778E+01,
     +0.4568E+01,0.4366E+01,0.4172E+01,0.3985E+01,0.3806E+01,0.3634E+01,
     +0.3468E+01,0.3310E+01,0.3157E+01,0.3011E+01,0.2870E+01,0.2735E+01,
     +0.2606E+01,0.2482E+01,0.2362E+01,0.2248E+01,0.2139E+01,0.2034E+01,
     +0.1933E+01,0.1837E+01,0.1744E+01,0.1656E+01,0.1571E+01,0.1490E+01,
     +0.1412E+01,0.1338E+01,0.1267E+01,0.1199E+01,0.1133E+01,0.1071E+01,
     +0.1012E+01,0.9546E+00,0.9001E+00,0.8481E+00,0.7983E+00,0.7508E+00,
     +0.7054E+00,0.6621E+00,0.6207E+00,0.5812E+00,0.5435E+00,0.5076E+00,
     +0.4734E+00,0.4408E+00,0.4097E+00,0.3801E+00,0.3520E+00,0.3253E+00,
     +0.2999E+00,0.2758E+00,0.2530E+00,0.2314E+00,0.2110E+00,0.1917E+00,
     +0.1736E+00,0.1566E+00,0.1406E+00,0.1257E+00,0.1118E+00,0.9888E-01,
     +0.8693E-01,0.7593E-01,0.6584E-01,0.5665E-01,0.4833E-01,0.4084E-01,
     +0.3416E-01,0.2824E-01,0.2306E-01,0.1856E-01,0.1472E-01,0.1147E-01,
     +0.8765E-02,0.6557E-02,0.4788E-02,0.3403E-02,0.2345E-02,0.1561E-02,
     +0.9985E-03,0.6103E-03,0.3540E-03,0.1932E-03,0.9817E-04,0.4574E-04,
     +0.2746E-04,0.1629E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.5812E+01,0.5560E+01,0.5318E+01,0.5085E+01,0.4862E+01,0.4647E+01,
     +0.4440E+01,0.4241E+01,0.4050E+01,0.3867E+01,0.3690E+01,0.3521E+01,
     +0.3359E+01,0.3203E+01,0.3053E+01,0.2909E+01,0.2771E+01,0.2639E+01,
     +0.2512E+01,0.2391E+01,0.2274E+01,0.2162E+01,0.2055E+01,0.1952E+01,
     +0.1854E+01,0.1760E+01,0.1669E+01,0.1583E+01,0.1500E+01,0.1421E+01,
     +0.1346E+01,0.1273E+01,0.1204E+01,0.1138E+01,0.1074E+01,0.1014E+01,
     +0.9562E+00,0.9010E+00,0.8483E+00,0.7980E+00,0.7500E+00,0.7042E+00,
     +0.6605E+00,0.6189E+00,0.5792E+00,0.5414E+00,0.5053E+00,0.4710E+00,
     +0.4384E+00,0.4074E+00,0.3779E+00,0.3499E+00,0.3233E+00,0.2981E+00,
     +0.2743E+00,0.2517E+00,0.2303E+00,0.2102E+00,0.1912E+00,0.1734E+00,
     +0.1566E+00,0.1409E+00,0.1262E+00,0.1126E+00,0.9987E-01,0.8812E-01,
     +0.7729E-01,0.6734E-01,0.5826E-01,0.5001E-01,0.4256E-01,0.3588E-01,
     +0.2994E-01,0.2470E-01,0.2013E-01,0.1618E-01,0.1280E-01,0.9959E-02,
     +0.7603E-02,0.5683E-02,0.4149E-02,0.2949E-02,0.2034E-02,0.1357E-02,
     +0.8706E-03,0.5347E-03,0.3123E-03,0.1720E-03,0.8845E-04,0.4182E-04,
     +0.2536E-04,0.1519E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.3655E+01,0.3483E+01,0.3318E+01,0.3160E+01,0.3009E+01,0.2864E+01,
     +0.2725E+01,0.2591E+01,0.2464E+01,0.2342E+01,0.2225E+01,0.2113E+01,
     +0.2006E+01,0.1903E+01,0.1805E+01,0.1712E+01,0.1622E+01,0.1537E+01,
     +0.1455E+01,0.1377E+01,0.1303E+01,0.1232E+01,0.1164E+01,0.1099E+01,
     +0.1038E+01,0.9791E+00,0.9231E+00,0.8698E+00,0.8191E+00,0.7708E+00,
     +0.7248E+00,0.6811E+00,0.6395E+00,0.6000E+00,0.5625E+00,0.5269E+00,
     +0.4931E+00,0.4611E+00,0.4307E+00,0.4019E+00,0.3746E+00,0.3488E+00,
     +0.3244E+00,0.3013E+00,0.2795E+00,0.2589E+00,0.2394E+00,0.2211E+00,
     +0.2039E+00,0.1876E+00,0.1724E+00,0.1580E+00,0.1446E+00,0.1320E+00,
     +0.1202E+00,0.1091E+00,0.9886E-01,0.8927E-01,0.8036E-01,0.7208E-01,
     +0.6442E-01,0.5735E-01,0.5083E-01,0.4485E-01,0.3937E-01,0.3437E-01,
     +0.2983E-01,0.2573E-01,0.2203E-01,0.1873E-01,0.1579E-01,0.1319E-01,
     +0.1091E-01,0.8927E-02,0.7220E-02,0.5764E-02,0.4536E-02,0.3514E-02,
     +0.2676E-02,0.1998E-02,0.1461E-02,0.1043E-02,0.7252E-03,0.4894E-03,
     +0.3194E-03,0.2006E-03,0.1205E-03,0.6872E-04,0.3677E-04,0.1816E-04,
     +0.1130E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.2304E-01,0.2430E-01,0.2563E-01,0.2702E-01,0.2849E-01,0.3004E-01,
     +0.3167E-01,0.3338E-01,0.3518E-01,0.3708E-01,0.3907E-01,0.4116E-01,
     +0.4337E-01,0.4568E-01,0.4811E-01,0.5067E-01,0.5335E-01,0.5617E-01,
     +0.5913E-01,0.6223E-01,0.6549E-01,0.6890E-01,0.7248E-01,0.7623E-01,
     +0.8017E-01,0.8428E-01,0.8860E-01,0.9311E-01,0.9783E-01,0.1028E+00,
     +0.1079E+00,0.1133E+00,0.1189E+00,0.1248E+00,0.1309E+00,0.1373E+00,
     +0.1439E+00,0.1509E+00,0.1580E+00,0.1655E+00,0.1733E+00,0.1813E+00,
     +0.1896E+00,0.1983E+00,0.2072E+00,0.2164E+00,0.2258E+00,0.2356E+00,
     +0.2456E+00,0.2559E+00,0.2664E+00,0.2772E+00,0.2881E+00,0.2992E+00,
     +0.3105E+00,0.3218E+00,0.3333E+00,0.3447E+00,0.3561E+00,0.3673E+00,
     +0.3784E+00,0.3891E+00,0.3995E+00,0.4094E+00,0.4187E+00,0.4272E+00,
     +0.4349E+00,0.4415E+00,0.4468E+00,0.4507E+00,0.4530E+00,0.4535E+00,
     +0.4520E+00,0.4482E+00,0.4419E+00,0.4330E+00,0.4213E+00,0.4066E+00,
     +0.3888E+00,0.3681E+00,0.3443E+00,0.3178E+00,0.2887E+00,0.2576E+00,
     +0.2250E+00,0.1917E+00,0.1586E+00,0.1266E+00,0.9675E-01,0.7000E-01,
     +0.5575E-01,0.4376E-01,0.3380E-01,0.2561E-01,0.1897E-01,0.1368E-01,
     +0.9541E-02,0.6376E-02,0.4030E-02,0.2363E-02,0.1246E-02,0.5583E-03,
     +0.1906E-03,0.3727E-04/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.1307E-01,0.1378E-01,0.1453E-01,0.1532E-01,0.1615E-01,0.1702E-01,
     +0.1794E-01,0.1890E-01,0.1991E-01,0.2098E-01,0.2210E-01,0.2328E-01,
     +0.2451E-01,0.2581E-01,0.2718E-01,0.2861E-01,0.3011E-01,0.3169E-01,
     +0.3334E-01,0.3507E-01,0.3689E-01,0.3880E-01,0.4079E-01,0.4288E-01,
     +0.4507E-01,0.4735E-01,0.4974E-01,0.5224E-01,0.5485E-01,0.5758E-01,
     +0.6042E-01,0.6339E-01,0.6648E-01,0.6970E-01,0.7306E-01,0.7654E-01,
     +0.8017E-01,0.8393E-01,0.8783E-01,0.9187E-01,0.9605E-01,0.1004E+00,
     +0.1048E+00,0.1095E+00,0.1142E+00,0.1191E+00,0.1241E+00,0.1292E+00,
     +0.1344E+00,0.1398E+00,0.1452E+00,0.1507E+00,0.1562E+00,0.1618E+00,
     +0.1674E+00,0.1730E+00,0.1785E+00,0.1840E+00,0.1893E+00,0.1945E+00,
     +0.1995E+00,0.2042E+00,0.2085E+00,0.2125E+00,0.2160E+00,0.2189E+00,
     +0.2213E+00,0.2228E+00,0.2236E+00,0.2235E+00,0.2224E+00,0.2201E+00,
     +0.2167E+00,0.2120E+00,0.2060E+00,0.1985E+00,0.1897E+00,0.1794E+00,
     +0.1678E+00,0.1549E+00,0.1409E+00,0.1260E+00,0.1105E+00,0.9467E-01,
     +0.7898E-01,0.6383E-01,0.4966E-01,0.3690E-01,0.2591E-01,0.1694E-01,
     +0.1256E-01,0.9142E-02,0.6509E-02,0.4520E-02,0.3046E-02,0.1981E-02,
     +0.1232E-02,0.7246E-03,0.3962E-03,0.1964E-03,0.8468E-04,0.2957E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.2539E+03,0.2410E+03,0.2286E+03,0.2169E+03,0.2056E+03,0.1949E+03,
     +0.1847E+03,0.1750E+03,0.1657E+03,0.1568E+03,0.1484E+03,0.1403E+03,
     +0.1327E+03,0.1254E+03,0.1184E+03,0.1118E+03,0.1055E+03,0.9958E+02,
     +0.9390E+02,0.8851E+02,0.8338E+02,0.7851E+02,0.7389E+02,0.6951E+02,
     +0.6535E+02,0.6140E+02,0.5766E+02,0.5412E+02,0.5076E+02,0.4758E+02,
     +0.4457E+02,0.4173E+02,0.3904E+02,0.3649E+02,0.3409E+02,0.3182E+02,
     +0.2968E+02,0.2766E+02,0.2575E+02,0.2396E+02,0.2226E+02,0.2067E+02,
     +0.1917E+02,0.1777E+02,0.1644E+02,0.1520E+02,0.1403E+02,0.1294E+02,
     +0.1192E+02,0.1096E+02,0.1006E+02,0.9220E+01,0.8437E+01,0.7705E+01,
     +0.7024E+01,0.6389E+01,0.5798E+01,0.5250E+01,0.4741E+01,0.4270E+01,
     +0.3834E+01,0.3431E+01,0.3060E+01,0.2719E+01,0.2407E+01,0.2120E+01,
     +0.1859E+01,0.1622E+01,0.1407E+01,0.1213E+01,0.1038E+01,0.8825E+00,
     +0.7440E+00,0.6219E+00,0.5147E+00,0.4216E+00,0.3413E+00,0.2728E+00,
     +0.2150E+00,0.1668E+00,0.1272E+00,0.9510E-01,0.6960E-01,0.4972E-01,
     +0.3456E-01,0.2327E-01,0.1511E-01,0.9388E-02,0.5530E-02,0.3044E-02,
     +0.2038E-02,0.1347E-02,0.8761E-03,0.5575E-03,0.3452E-03,0.2064E-03,
     +0.1181E-03,0.6377E-04,0.3193E-04,0.1442E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.4296E+02,0.4104E+02,0.3919E+02,0.3742E+02,0.3572E+02,0.3409E+02,
     +0.3253E+02,0.3103E+02,0.2960E+02,0.2822E+02,0.2690E+02,0.2564E+02,
     +0.2443E+02,0.2327E+02,0.2216E+02,0.2110E+02,0.2008E+02,0.1911E+02,
     +0.1818E+02,0.1729E+02,0.1644E+02,0.1562E+02,0.1485E+02,0.1410E+02,
     +0.1339E+02,0.1271E+02,0.1206E+02,0.1144E+02,0.1085E+02,0.1029E+02,
     +0.9746E+01,0.9232E+01,0.8740E+01,0.8272E+01,0.7824E+01,0.7398E+01,
     +0.6991E+01,0.6603E+01,0.6233E+01,0.5880E+01,0.5544E+01,0.5224E+01,
     +0.4918E+01,0.4627E+01,0.4349E+01,0.4085E+01,0.3833E+01,0.3592E+01,
     +0.3363E+01,0.3145E+01,0.2937E+01,0.2739E+01,0.2551E+01,0.2371E+01,
     +0.2200E+01,0.2037E+01,0.1882E+01,0.1735E+01,0.1595E+01,0.1463E+01,
     +0.1337E+01,0.1218E+01,0.1105E+01,0.9989E+00,0.8990E+00,0.8053E+00,
     +0.7176E+00,0.6359E+00,0.5601E+00,0.4902E+00,0.4259E+00,0.3672E+00,
     +0.3141E+00,0.2663E+00,0.2236E+00,0.1859E+00,0.1528E+00,0.1241E+00,
     +0.9946E-01,0.7851E-01,0.6090E-01,0.4626E-01,0.3426E-01,0.2460E-01,
     +0.1697E-01,0.1114E-01,0.6860E-02,0.3890E-02,0.1983E-02,0.8805E-03,
     +0.4963E-03,0.2696E-03,0.1407E-03,0.7033E-04,0.3362E-04,0.1532E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.7733E+01,0.7398E+01,0.7076E+01,0.6768E+01,0.6472E+01,0.6188E+01,
     +0.5915E+01,0.5653E+01,0.5403E+01,0.5162E+01,0.4932E+01,0.4711E+01,
     +0.4499E+01,0.4296E+01,0.4101E+01,0.3915E+01,0.3737E+01,0.3566E+01,
     +0.3402E+01,0.3246E+01,0.3096E+01,0.2952E+01,0.2815E+01,0.2683E+01,
     +0.2558E+01,0.2437E+01,0.2322E+01,0.2212E+01,0.2107E+01,0.2007E+01,
     +0.1911E+01,0.1819E+01,0.1731E+01,0.1647E+01,0.1566E+01,0.1489E+01,
     +0.1416E+01,0.1346E+01,0.1278E+01,0.1214E+01,0.1152E+01,0.1093E+01,
     +0.1037E+01,0.9829E+00,0.9311E+00,0.8815E+00,0.8339E+00,0.7882E+00,
     +0.7444E+00,0.7023E+00,0.6618E+00,0.6230E+00,0.5856E+00,0.5496E+00,
     +0.5150E+00,0.4817E+00,0.4497E+00,0.4188E+00,0.3891E+00,0.3606E+00,
     +0.3331E+00,0.3068E+00,0.2815E+00,0.2573E+00,0.2342E+00,0.2122E+00,
     +0.1913E+00,0.1715E+00,0.1529E+00,0.1354E+00,0.1191E+00,0.1041E+00,
     +0.9018E-01,0.7752E-01,0.6605E-01,0.5575E-01,0.4657E-01,0.3847E-01,
     +0.3137E-01,0.2522E-01,0.1992E-01,0.1541E-01,0.1162E-01,0.8484E-02,
     +0.5943E-02,0.3951E-02,0.2455E-02,0.1399E-02,0.7126E-03,0.3133E-03,
     +0.1744E-03,0.9301E-04,0.4730E-04,0.2283E-04,0.1041E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.7559E+01,0.7224E+01,0.6902E+01,0.6594E+01,0.6298E+01,0.6014E+01,
     +0.5741E+01,0.5480E+01,0.5230E+01,0.4989E+01,0.4759E+01,0.4538E+01,
     +0.4326E+01,0.4124E+01,0.3929E+01,0.3743E+01,0.3565E+01,0.3395E+01,
     +0.3231E+01,0.3075E+01,0.2925E+01,0.2782E+01,0.2645E+01,0.2515E+01,
     +0.2389E+01,0.2270E+01,0.2155E+01,0.2046E+01,0.1941E+01,0.1841E+01,
     +0.1746E+01,0.1655E+01,0.1568E+01,0.1485E+01,0.1406E+01,0.1330E+01,
     +0.1258E+01,0.1189E+01,0.1123E+01,0.1060E+01,0.9998E+00,0.9426E+00,
     +0.8880E+00,0.8359E+00,0.7862E+00,0.7387E+00,0.6935E+00,0.6503E+00,
     +0.6092E+00,0.5699E+00,0.5324E+00,0.4967E+00,0.4626E+00,0.4301E+00,
     +0.3992E+00,0.3697E+00,0.3417E+00,0.3150E+00,0.2896E+00,0.2655E+00,
     +0.2426E+00,0.2210E+00,0.2005E+00,0.1812E+00,0.1630E+00,0.1459E+00,
     +0.1300E+00,0.1151E+00,0.1013E+00,0.8855E-01,0.7685E-01,0.6619E-01,
     +0.5653E-01,0.4784E-01,0.4010E-01,0.3326E-01,0.2728E-01,0.2210E-01,
     +0.1765E-01,0.1389E-01,0.1073E-01,0.8121E-02,0.5991E-02,0.4284E-02,
     +0.2945E-02,0.1926E-02,0.1182E-02,0.6688E-03,0.3405E-03,0.1511E-03,
     +0.8521E-04,0.4635E-04,0.2424E-04,0.1216E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.7443E+01,0.7108E+01,0.6787E+01,0.6478E+01,0.6182E+01,0.5898E+01,
     +0.5626E+01,0.5365E+01,0.5114E+01,0.4874E+01,0.4644E+01,0.4423E+01,
     +0.4211E+01,0.4009E+01,0.3815E+01,0.3629E+01,0.3451E+01,0.3280E+01,
     +0.3117E+01,0.2961E+01,0.2812E+01,0.2669E+01,0.2533E+01,0.2402E+01,
     +0.2277E+01,0.2158E+01,0.2044E+01,0.1935E+01,0.1831E+01,0.1731E+01,
     +0.1636E+01,0.1546E+01,0.1460E+01,0.1377E+01,0.1298E+01,0.1223E+01,
     +0.1152E+01,0.1084E+01,0.1019E+01,0.9571E+00,0.8982E+00,0.8421E+00,
     +0.7887E+00,0.7379E+00,0.6895E+00,0.6436E+00,0.5999E+00,0.5584E+00,
     +0.5190E+00,0.4816E+00,0.4461E+00,0.4125E+00,0.3806E+00,0.3505E+00,
     +0.3220E+00,0.2950E+00,0.2696E+00,0.2457E+00,0.2232E+00,0.2021E+00,
     +0.1823E+00,0.1637E+00,0.1465E+00,0.1304E+00,0.1155E+00,0.1017E+00,
     +0.8907E-01,0.7747E-01,0.6689E-01,0.5731E-01,0.4867E-01,0.4095E-01,
     +0.3409E-01,0.2806E-01,0.2280E-01,0.1827E-01,0.1442E-01,0.1118E-01,
     +0.8509E-02,0.6336E-02,0.4607E-02,0.3260E-02,0.2237E-02,0.1483E-02,
     +0.9457E-03,0.5764E-03,0.3336E-03,0.1818E-03,0.9226E-04,0.4294E-04,
     +0.2575E-04,0.1524E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.7296E+01,0.6965E+01,0.6647E+01,0.6342E+01,0.6050E+01,0.5769E+01,
     +0.5500E+01,0.5242E+01,0.4995E+01,0.4757E+01,0.4530E+01,0.4312E+01,
     +0.4104E+01,0.3904E+01,0.3713E+01,0.3530E+01,0.3354E+01,0.3186E+01,
     +0.3026E+01,0.2872E+01,0.2725E+01,0.2585E+01,0.2450E+01,0.2322E+01,
     +0.2199E+01,0.2082E+01,0.1970E+01,0.1864E+01,0.1762E+01,0.1664E+01,
     +0.1571E+01,0.1483E+01,0.1398E+01,0.1318E+01,0.1241E+01,0.1168E+01,
     +0.1098E+01,0.1032E+01,0.9686E+00,0.9085E+00,0.8513E+00,0.7969E+00,
     +0.7452E+00,0.6960E+00,0.6494E+00,0.6050E+00,0.5630E+00,0.5231E+00,
     +0.4853E+00,0.4494E+00,0.4155E+00,0.3834E+00,0.3531E+00,0.3245E+00,
     +0.2975E+00,0.2720E+00,0.2480E+00,0.2255E+00,0.2044E+00,0.1846E+00,
     +0.1662E+00,0.1489E+00,0.1329E+00,0.1181E+00,0.1043E+00,0.9167E-01,
     +0.8007E-01,0.6948E-01,0.5986E-01,0.5116E-01,0.4335E-01,0.3639E-01,
     +0.3023E-01,0.2483E-01,0.2014E-01,0.1611E-01,0.1269E-01,0.9832E-02,
     +0.7473E-02,0.5561E-02,0.4042E-02,0.2862E-02,0.1966E-02,0.1307E-02,
     +0.8359E-03,0.5120E-03,0.2984E-03,0.1641E-03,0.8423E-04,0.3973E-04,
     +0.2404E-04,0.1435E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.5197E+01,0.4944E+01,0.4702E+01,0.4470E+01,0.4248E+01,0.4036E+01,
     +0.3833E+01,0.3639E+01,0.3453E+01,0.3276E+01,0.3107E+01,0.2945E+01,
     +0.2790E+01,0.2643E+01,0.2502E+01,0.2368E+01,0.2239E+01,0.2117E+01,
     +0.2001E+01,0.1890E+01,0.1784E+01,0.1683E+01,0.1587E+01,0.1496E+01,
     +0.1409E+01,0.1327E+01,0.1248E+01,0.1174E+01,0.1103E+01,0.1035E+01,
     +0.9714E+00,0.9107E+00,0.8532E+00,0.7986E+00,0.7470E+00,0.6980E+00,
     +0.6517E+00,0.6078E+00,0.5664E+00,0.5272E+00,0.4902E+00,0.4552E+00,
     +0.4222E+00,0.3911E+00,0.3619E+00,0.3343E+00,0.3083E+00,0.2840E+00,
     +0.2611E+00,0.2396E+00,0.2194E+00,0.2006E+00,0.1830E+00,0.1665E+00,
     +0.1511E+00,0.1368E+00,0.1235E+00,0.1112E+00,0.9976E-01,0.8919E-01,
     +0.7944E-01,0.7047E-01,0.6224E-01,0.5472E-01,0.4786E-01,0.4163E-01,
     +0.3600E-01,0.3093E-01,0.2638E-01,0.2234E-01,0.1876E-01,0.1561E-01,
     +0.1286E-01,0.1048E-01,0.8445E-02,0.6716E-02,0.5265E-02,0.4064E-02,
     +0.3083E-02,0.2294E-02,0.1672E-02,0.1190E-02,0.8246E-03,0.5550E-03,
     +0.3612E-03,0.2262E-03,0.1356E-03,0.7704E-04,0.4105E-04,0.2015E-04,
     +0.1248E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.2449E-01,0.2582E-01,0.2722E-01,0.2870E-01,0.3025E-01,0.3188E-01,
     +0.3359E-01,0.3539E-01,0.3729E-01,0.3928E-01,0.4138E-01,0.4358E-01,
     +0.4589E-01,0.4832E-01,0.5087E-01,0.5354E-01,0.5635E-01,0.5930E-01,
     +0.6239E-01,0.6563E-01,0.6902E-01,0.7258E-01,0.7631E-01,0.8021E-01,
     +0.8430E-01,0.8858E-01,0.9305E-01,0.9772E-01,0.1026E+00,0.1077E+00,
     +0.1130E+00,0.1186E+00,0.1244E+00,0.1304E+00,0.1367E+00,0.1432E+00,
     +0.1500E+00,0.1571E+00,0.1644E+00,0.1720E+00,0.1799E+00,0.1881E+00,
     +0.1965E+00,0.2052E+00,0.2142E+00,0.2235E+00,0.2330E+00,0.2427E+00,
     +0.2528E+00,0.2630E+00,0.2734E+00,0.2841E+00,0.2948E+00,0.3058E+00,
     +0.3168E+00,0.3278E+00,0.3389E+00,0.3499E+00,0.3608E+00,0.3715E+00,
     +0.3819E+00,0.3920E+00,0.4016E+00,0.4106E+00,0.4190E+00,0.4265E+00,
     +0.4330E+00,0.4384E+00,0.4425E+00,0.4451E+00,0.4460E+00,0.4451E+00,
     +0.4421E+00,0.4368E+00,0.4291E+00,0.4189E+00,0.4059E+00,0.3900E+00,
     +0.3713E+00,0.3498E+00,0.3255E+00,0.2988E+00,0.2699E+00,0.2393E+00,
     +0.2077E+00,0.1757E+00,0.1442E+00,0.1142E+00,0.8644E-01,0.6189E-01,
     +0.4894E-01,0.3814E-01,0.2923E-01,0.2197E-01,0.1614E-01,0.1153E-01,
     +0.7959E-02,0.5258E-02,0.3282E-02,0.1896E-02,0.9823E-03,0.4309E-03,
     +0.1430E-03,0.2684E-04/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1388E-01,0.1463E-01,0.1542E-01,0.1625E-01,0.1712E-01,0.1804E-01,
     +0.1900E-01,0.2002E-01,0.2108E-01,0.2220E-01,0.2338E-01,0.2461E-01,
     +0.2591E-01,0.2727E-01,0.2869E-01,0.3019E-01,0.3176E-01,0.3340E-01,
     +0.3513E-01,0.3693E-01,0.3883E-01,0.4080E-01,0.4288E-01,0.4504E-01,
     +0.4731E-01,0.4967E-01,0.5215E-01,0.5473E-01,0.5742E-01,0.6023E-01,
     +0.6316E-01,0.6620E-01,0.6938E-01,0.7267E-01,0.7610E-01,0.7966E-01,
     +0.8335E-01,0.8718E-01,0.9114E-01,0.9524E-01,0.9947E-01,0.1038E+00,
     +0.1083E+00,0.1130E+00,0.1177E+00,0.1226E+00,0.1276E+00,0.1327E+00,
     +0.1379E+00,0.1431E+00,0.1485E+00,0.1538E+00,0.1593E+00,0.1647E+00,
     +0.1701E+00,0.1755E+00,0.1808E+00,0.1859E+00,0.1910E+00,0.1958E+00,
     +0.2003E+00,0.2046E+00,0.2085E+00,0.2119E+00,0.2149E+00,0.2173E+00,
     +0.2190E+00,0.2199E+00,0.2200E+00,0.2192E+00,0.2174E+00,0.2145E+00,
     +0.2104E+00,0.2050E+00,0.1984E+00,0.1904E+00,0.1812E+00,0.1706E+00,
     +0.1587E+00,0.1458E+00,0.1319E+00,0.1173E+00,0.1022E+00,0.8699E-01,
     +0.7206E-01,0.5779E-01,0.4460E-01,0.3284E-01,0.2284E-01,0.1476E-01,
     +0.1087E-01,0.7848E-02,0.5543E-02,0.3817E-02,0.2550E-02,0.1642E-02,
     +0.1011E-02,0.5876E-03,0.3171E-03,0.1549E-03,0.6562E-04,0.2243E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2880E+03,0.2728E+03,0.2583E+03,0.2444E+03,0.2312E+03,0.2187E+03,
     +0.2067E+03,0.1954E+03,0.1845E+03,0.1743E+03,0.1645E+03,0.1552E+03,
     +0.1464E+03,0.1380E+03,0.1300E+03,0.1225E+03,0.1153E+03,0.1085E+03,
     +0.1021E+03,0.9596E+02,0.9017E+02,0.8468E+02,0.7949E+02,0.7457E+02,
     +0.6992E+02,0.6551E+02,0.6135E+02,0.5742E+02,0.5371E+02,0.5020E+02,
     +0.4689E+02,0.4377E+02,0.4083E+02,0.3805E+02,0.3544E+02,0.3298E+02,
     +0.3066E+02,0.2848E+02,0.2644E+02,0.2451E+02,0.2271E+02,0.2102E+02,
     +0.1943E+02,0.1794E+02,0.1655E+02,0.1524E+02,0.1402E+02,0.1288E+02,
     +0.1182E+02,0.1083E+02,0.9902E+01,0.9041E+01,0.8241E+01,0.7497E+01,
     +0.6806E+01,0.6166E+01,0.5573E+01,0.5024E+01,0.4518E+01,0.4052E+01,
     +0.3622E+01,0.3228E+01,0.2866E+01,0.2535E+01,0.2233E+01,0.1959E+01,
     +0.1710E+01,0.1485E+01,0.1282E+01,0.1100E+01,0.9379E+00,0.7937E+00,
     +0.6664E+00,0.5547E+00,0.4573E+00,0.3732E+00,0.3011E+00,0.2399E+00,
     +0.1885E+00,0.1459E+00,0.1110E+00,0.8286E-01,0.6057E-01,0.4323E-01,
     +0.3003E-01,0.2021E-01,0.1311E-01,0.8138E-02,0.4783E-02,0.2621E-02,
     +0.1748E-02,0.1150E-02,0.7434E-03,0.4699E-03,0.2887E-03,0.1711E-03,
     +0.9686E-04,0.5170E-04,0.2555E-04,0.1137E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.5188E+02,0.4945E+02,0.4713E+02,0.4491E+02,0.4278E+02,0.4075E+02,
     +0.3880E+02,0.3693E+02,0.3515E+02,0.3344E+02,0.3181E+02,0.3025E+02,
     +0.2876E+02,0.2733E+02,0.2597E+02,0.2467E+02,0.2343E+02,0.2224E+02,
     +0.2111E+02,0.2002E+02,0.1899E+02,0.1801E+02,0.1707E+02,0.1617E+02,
     +0.1532E+02,0.1450E+02,0.1373E+02,0.1299E+02,0.1228E+02,0.1161E+02,
     +0.1097E+02,0.1037E+02,0.9788E+01,0.9237E+01,0.8713E+01,0.8214E+01,
     +0.7740E+01,0.7289E+01,0.6860E+01,0.6452E+01,0.6065E+01,0.5696E+01,
     +0.5346E+01,0.5014E+01,0.4698E+01,0.4398E+01,0.4113E+01,0.3842E+01,
     +0.3585E+01,0.3341E+01,0.3110E+01,0.2890E+01,0.2682E+01,0.2484E+01,
     +0.2296E+01,0.2119E+01,0.1950E+01,0.1791E+01,0.1641E+01,0.1499E+01,
     +0.1364E+01,0.1238E+01,0.1119E+01,0.1008E+01,0.9033E+00,0.8059E+00,
     +0.7152E+00,0.6312E+00,0.5536E+00,0.4824E+00,0.4174E+00,0.3584E+00,
     +0.3052E+00,0.2575E+00,0.2153E+00,0.1781E+00,0.1457E+00,0.1178E+00,
     +0.9388E-01,0.7369E-01,0.5681E-01,0.4288E-01,0.3153E-01,0.2247E-01,
     +0.1538E-01,0.1001E-01,0.6104E-02,0.3428E-02,0.1731E-02,0.7614E-03,
     +0.4271E-03,0.2311E-03,0.1203E-03,0.6011E-04,0.2875E-04,0.1314E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.9209E+01,0.8792E+01,0.8391E+01,0.8008E+01,0.7640E+01,0.7289E+01,
     +0.6952E+01,0.6629E+01,0.6320E+01,0.6025E+01,0.5742E+01,0.5472E+01,
     +0.5214E+01,0.4966E+01,0.4730E+01,0.4504E+01,0.4288E+01,0.4081E+01,
     +0.3884E+01,0.3696E+01,0.3516E+01,0.3344E+01,0.3180E+01,0.3023E+01,
     +0.2874E+01,0.2731E+01,0.2595E+01,0.2465E+01,0.2342E+01,0.2223E+01,
     +0.2111E+01,0.2003E+01,0.1901E+01,0.1803E+01,0.1710E+01,0.1621E+01,
     +0.1536E+01,0.1455E+01,0.1378E+01,0.1305E+01,0.1235E+01,0.1168E+01,
     +0.1104E+01,0.1043E+01,0.9848E+00,0.9293E+00,0.8761E+00,0.8254E+00,
     +0.7769E+00,0.7304E+00,0.6860E+00,0.6435E+00,0.6028E+00,0.5638E+00,
     +0.5265E+00,0.4907E+00,0.4564E+00,0.4236E+00,0.3922E+00,0.3621E+00,
     +0.3333E+00,0.3058E+00,0.2796E+00,0.2546E+00,0.2309E+00,0.2084E+00,
     +0.1872E+00,0.1672E+00,0.1485E+00,0.1310E+00,0.1148E+00,0.9990E-01,
     +0.8624E-01,0.7384E-01,0.6266E-01,0.5266E-01,0.4380E-01,0.3601E-01,
     +0.2923E-01,0.2337E-01,0.1836E-01,0.1411E-01,0.1057E-01,0.7656E-02,
     +0.5319E-02,0.3504E-02,0.2156E-02,0.1216E-02,0.6125E-03,0.2662E-03,
     +0.1471E-03,0.7797E-04,0.3944E-04,0.1896E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.9036E+01,0.8618E+01,0.8218E+01,0.7834E+01,0.7467E+01,0.7115E+01,
     +0.6778E+01,0.6456E+01,0.6148E+01,0.5852E+01,0.5570E+01,0.5300E+01,
     +0.5041E+01,0.4794E+01,0.4558E+01,0.4332E+01,0.4117E+01,0.3911E+01,
     +0.3714E+01,0.3526E+01,0.3346E+01,0.3175E+01,0.3011E+01,0.2855E+01,
     +0.2706E+01,0.2564E+01,0.2429E+01,0.2300E+01,0.2177E+01,0.2059E+01,
     +0.1947E+01,0.1841E+01,0.1739E+01,0.1643E+01,0.1551E+01,0.1463E+01,
     +0.1379E+01,0.1300E+01,0.1224E+01,0.1153E+01,0.1084E+01,0.1019E+01,
     +0.9571E+00,0.8982E+00,0.8422E+00,0.7889E+00,0.7382E+00,0.6901E+00,
     +0.6443E+00,0.6008E+00,0.5595E+00,0.5202E+00,0.4829E+00,0.4475E+00,
     +0.4138E+00,0.3820E+00,0.3517E+00,0.3231E+00,0.2960E+00,0.2704E+00,
     +0.2462E+00,0.2234E+00,0.2019E+00,0.1818E+00,0.1629E+00,0.1453E+00,
     +0.1289E+00,0.1137E+00,0.9966E-01,0.8677E-01,0.7501E-01,0.6433E-01,
     +0.5471E-01,0.4611E-01,0.3848E-01,0.3177E-01,0.2594E-01,0.2091E-01,
     +0.1662E-01,0.1300E-01,0.9989E-02,0.7511E-02,0.5504E-02,0.3906E-02,
     +0.2664E-02,0.1728E-02,0.1051E-02,0.5888E-03,0.2969E-03,0.1305E-03,
     +0.7326E-04,0.3970E-04,0.2071E-04,0.1038E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.8920E+01,0.8502E+01,0.8102E+01,0.7718E+01,0.7351E+01,0.7000E+01,
     +0.6663E+01,0.6341E+01,0.6032E+01,0.5737E+01,0.5455E+01,0.5185E+01,
     +0.4927E+01,0.4680E+01,0.4444E+01,0.4218E+01,0.4003E+01,0.3797E+01,
     +0.3600E+01,0.3412E+01,0.3233E+01,0.3062E+01,0.2899E+01,0.2743E+01,
     +0.2595E+01,0.2453E+01,0.2318E+01,0.2189E+01,0.2067E+01,0.1950E+01,
     +0.1838E+01,0.1732E+01,0.1632E+01,0.1536E+01,0.1444E+01,0.1358E+01,
     +0.1275E+01,0.1196E+01,0.1122E+01,0.1051E+01,0.9837E+00,0.9198E+00,
     +0.8591E+00,0.8016E+00,0.7470E+00,0.6953E+00,0.6463E+00,0.5999E+00,
     +0.5559E+00,0.5144E+00,0.4751E+00,0.4380E+00,0.4029E+00,0.3699E+00,
     +0.3387E+00,0.3095E+00,0.2819E+00,0.2561E+00,0.2319E+00,0.2092E+00,
     +0.1881E+00,0.1684E+00,0.1501E+00,0.1332E+00,0.1176E+00,0.1032E+00,
     +0.9003E-01,0.7802E-01,0.6712E-01,0.5729E-01,0.4847E-01,0.4062E-01,
     +0.3369E-01,0.2762E-01,0.2236E-01,0.1785E-01,0.1403E-01,0.1084E-01,
     +0.8212E-02,0.6092E-02,0.4412E-02,0.3110E-02,0.2127E-02,0.1406E-02,
     +0.8936E-03,0.5432E-03,0.3137E-03,0.1706E-03,0.8643E-04,0.4013E-04,
     +0.2402E-04,0.1418E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.8775E+01,0.8361E+01,0.7964E+01,0.7585E+01,0.7221E+01,0.6873E+01,
     +0.6539E+01,0.6220E+01,0.5915E+01,0.5623E+01,0.5344E+01,0.5076E+01,
     +0.4821E+01,0.4577E+01,0.4344E+01,0.4121E+01,0.3908E+01,0.3705E+01,
     +0.3510E+01,0.3325E+01,0.3148E+01,0.2979E+01,0.2818E+01,0.2665E+01,
     +0.2519E+01,0.2379E+01,0.2246E+01,0.2119E+01,0.1999E+01,0.1884E+01,
     +0.1775E+01,0.1671E+01,0.1572E+01,0.1478E+01,0.1388E+01,0.1303E+01,
     +0.1222E+01,0.1146E+01,0.1073E+01,0.1004E+01,0.9380E+00,0.8758E+00,
     +0.8168E+00,0.7609E+00,0.7080E+00,0.6579E+00,0.6105E+00,0.5657E+00,
     +0.5233E+00,0.4833E+00,0.4456E+00,0.4100E+00,0.3764E+00,0.3449E+00,
     +0.3152E+00,0.2874E+00,0.2612E+00,0.2368E+00,0.2139E+00,0.1926E+00,
     +0.1728E+00,0.1544E+00,0.1373E+00,0.1215E+00,0.1070E+00,0.9373E-01,
     +0.8158E-01,0.7053E-01,0.6054E-01,0.5156E-01,0.4353E-01,0.3640E-01,
     +0.3013E-01,0.2465E-01,0.1992E-01,0.1588E-01,0.1246E-01,0.9613E-02,
     +0.7278E-02,0.5396E-02,0.3908E-02,0.2757E-02,0.1888E-02,0.1251E-02,
     +0.7979E-03,0.4876E-03,0.2835E-03,0.1556E-03,0.7966E-04,0.3746E-04,
     +0.2260E-04,0.1345E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.6728E+01,0.6391E+01,0.6068E+01,0.5759E+01,0.5464E+01,0.5183E+01,
     +0.4914E+01,0.4658E+01,0.4413E+01,0.4179E+01,0.3957E+01,0.3744E+01,
     +0.3542E+01,0.3349E+01,0.3165E+01,0.2990E+01,0.2823E+01,0.2664E+01,
     +0.2513E+01,0.2370E+01,0.2233E+01,0.2103E+01,0.1980E+01,0.1862E+01,
     +0.1751E+01,0.1645E+01,0.1545E+01,0.1450E+01,0.1359E+01,0.1274E+01,
     +0.1193E+01,0.1116E+01,0.1044E+01,0.9748E+00,0.9099E+00,0.8485E+00,
     +0.7905E+00,0.7357E+00,0.6840E+00,0.6353E+00,0.5894E+00,0.5461E+00,
     +0.5054E+00,0.4671E+00,0.4311E+00,0.3973E+00,0.3656E+00,0.3359E+00,
     +0.3081E+00,0.2820E+00,0.2576E+00,0.2349E+00,0.2137E+00,0.1940E+00,
     +0.1756E+00,0.1585E+00,0.1427E+00,0.1281E+00,0.1146E+00,0.1022E+00,
     +0.9073E-01,0.8024E-01,0.7066E-01,0.6192E-01,0.5399E-01,0.4682E-01,
     +0.4035E-01,0.3456E-01,0.2938E-01,0.2480E-01,0.2075E-01,0.1721E-01,
     +0.1413E-01,0.1148E-01,0.9220E-02,0.7308E-02,0.5711E-02,0.4394E-02,
     +0.3323E-02,0.2465E-02,0.1791E-02,0.1271E-02,0.8788E-03,0.5899E-03,
     +0.3829E-03,0.2393E-03,0.1429E-03,0.8095E-04,0.4294E-04,0.2094E-04,
     +0.1290E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
