
#include "molmodel/internal/common.h"
#include "molmodel/internal/DuMMForceFieldSubsystem.h"

#include "TinkerAmber99.h"

namespace SimTK {

// Split this into two functions to dodge a compiler problem with gcc 4.4.4.

static void nowDoSecondHalf(DuMMForceFieldSubsystem& dumm);

void populateAmber99Params(DuMMForceFieldSubsystem& dumm)
{
    dumm.defineAtomClass((DuMM::AtomClassIndex)1, "CT", 6, 4, 0.1908, 0.45773);
    dumm.defineAtomClass((DuMM::AtomClassIndex)2, "C", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)3, "CA", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)4, "CM", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)5, "CC", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)6, "CV", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)7, "CW", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)8, "CR", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)9, "CB", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)10, "C*", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)11, "CN", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)12, "CK", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)13, "CQ", 6, 3, 0.1908, 0.359824);
    dumm.defineAtomClass((DuMM::AtomClassIndex)14, "N", 7, 3, 0.1824, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)15, "NA", 7, 3, 0.1824, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)16, "NB", 7, 2, 0.1824, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)17, "NC", 7, 2, 0.1824, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)18, "N*", 7, 3, 0.1824, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)19, "N2", 7, 3, 0.1824, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)20, "N3", 7, 4, 0.1875, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)21, "OW", 8, 2, 0.17683, 0.635968);
    dumm.defineAtomClass((DuMM::AtomClassIndex)22, "OH", 8, 2, 0.1721, 0.880314);
    dumm.defineAtomClass((DuMM::AtomClassIndex)23, "OS", 8, 2, 0.16837, 0.71128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)24, "O", 8, 1, 0.16612, 0.87864);
    dumm.defineAtomClass((DuMM::AtomClassIndex)25, "O2", 8, 1, 0.16612, 0.87864);
    dumm.defineAtomClass((DuMM::AtomClassIndex)26, "S", 16, 2, 0.2, 1.046);
    dumm.defineAtomClass((DuMM::AtomClassIndex)27, "SH", 16, 2, 0.2, 1.046);
    dumm.defineAtomClass((DuMM::AtomClassIndex)28, "P", 15, 4, 0.21, 0.8368);
    dumm.defineAtomClass((DuMM::AtomClassIndex)29, "H", 1, 1, 0.06, 0.0656888);
    dumm.defineAtomClass((DuMM::AtomClassIndex)30, "HW", 1, 1, 1e-005, 0);
    dumm.defineAtomClass((DuMM::AtomClassIndex)31, "HO", 1, 1, 1e-005, 0);
    dumm.defineAtomClass((DuMM::AtomClassIndex)32, "HS", 1, 1, 0.06, 0.0656888);
    dumm.defineAtomClass((DuMM::AtomClassIndex)33, "HA", 1, 1, 0.1459, 0.06276);
    dumm.defineAtomClass((DuMM::AtomClassIndex)34, "HC", 1, 1, 0.1487, 0.0656888);
    dumm.defineAtomClass((DuMM::AtomClassIndex)35, "H1", 1, 1, 0.1387, 0.0656888);
    dumm.defineAtomClass((DuMM::AtomClassIndex)36, "H2", 1, 1, 0.1287, 0.0656888);
    dumm.defineAtomClass((DuMM::AtomClassIndex)38, "HP", 1, 1, 0.11, 0.0656888);
    dumm.defineAtomClass((DuMM::AtomClassIndex)39, "H4", 1, 1, 0.1409, 0.06276);
    dumm.defineAtomClass((DuMM::AtomClassIndex)40, "H5", 1, 1, 0.1359, 0.06276);
    dumm.defineAtomClass((DuMM::AtomClassIndex)41, "Li+", 3, 0, 0.1137, 0.0765672);
    dumm.defineAtomClass((DuMM::AtomClassIndex)42, "Na+", 11, 0, 0.1868, 0.0115897);
    dumm.defineAtomClass((DuMM::AtomClassIndex)43, "K+", 19, 0, 0.2658, 0.00137235);
    dumm.defineAtomClass((DuMM::AtomClassIndex)44, "Rb+", 37, 0, 0.2956, 0.00071128);
    dumm.defineAtomClass((DuMM::AtomClassIndex)45, "Cs+", 55, 0, 0.3395, 0.00033723);
    dumm.defineAtomClass((DuMM::AtomClassIndex)46, "Mg+", 12, 0, 0.07926, 3.74342);
    dumm.defineAtomClass((DuMM::AtomClassIndex)47, "Ca+", 20, 0, 0.17131, 1.92376);
    dumm.defineAtomClass((DuMM::AtomClassIndex)48, "Zn+", 30, 0, 0.11, 0.0523);
    dumm.defineAtomClass((DuMM::AtomClassIndex)49, "Cl-", 17, 0, 0.247, 0.4184);

    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1, "Glycine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2, "Glycine CA", (DuMM::AtomClassIndex)1, -0.0252);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)3, "Glycine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)4, "Glycine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)5, "Glycine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)6, "Glycine HA", (DuMM::AtomClassIndex)35, 0.0698);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)7, "Alanine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)8, "Alanine CA", (DuMM::AtomClassIndex)1, 0.0337);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)9, "Alanine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)10, "Alanine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)11, "Alanine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)12, "Alanine HA", (DuMM::AtomClassIndex)35, 0.0823);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)13, "Alanine CB", (DuMM::AtomClassIndex)1, -0.1825);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)14, "Alanine HB", (DuMM::AtomClassIndex)34, 0.0603);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)15, "Valine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)16, "Valine CA", (DuMM::AtomClassIndex)1, -0.0875);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)17, "Valine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)18, "Valine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)19, "Valine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)20, "Valine HA", (DuMM::AtomClassIndex)35, 0.0969);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)21, "Valine CB", (DuMM::AtomClassIndex)1, 0.2985);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)22, "Valine HB", (DuMM::AtomClassIndex)34, -0.0297);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)23, "Valine CG1", (DuMM::AtomClassIndex)1, -0.3192);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)24, "Valine HG1", (DuMM::AtomClassIndex)34, 0.0791);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)25, "Valine CG2", (DuMM::AtomClassIndex)1, -0.3192);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)26, "Valine HG2", (DuMM::AtomClassIndex)34, 0.0791);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)27, "Leucine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)28, "Leucine CA", (DuMM::AtomClassIndex)1, -0.0518);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)29, "Leucine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)30, "Leucine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)31, "Leucine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)32, "Leucine HA", (DuMM::AtomClassIndex)35, 0.0922);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)33, "Leucine CB", (DuMM::AtomClassIndex)1, -0.1102);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)34, "Leucine HB", (DuMM::AtomClassIndex)34, 0.0457);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)35, "Leucine CG", (DuMM::AtomClassIndex)1, 0.3531);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)36, "Leucine HG", (DuMM::AtomClassIndex)34, -0.0361);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)37, "Leucine CD1", (DuMM::AtomClassIndex)1, -0.4121);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)38, "Leucine HD1", (DuMM::AtomClassIndex)34, 0.1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)39, "Leucine CD2", (DuMM::AtomClassIndex)1, -0.4121);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)40, "Leucine HD2", (DuMM::AtomClassIndex)34, 0.1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)41, "Isoleucine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)42, "Isoleucine CA", (DuMM::AtomClassIndex)1, -0.0597);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)43, "Isoleucine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)44, "Isoleucine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)45, "Isoleucine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)46, "Isoleucine HA", (DuMM::AtomClassIndex)35, 0.0869);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)47, "Isoleucine CB", (DuMM::AtomClassIndex)1, 0.1303);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)48, "Isoleucine HB", (DuMM::AtomClassIndex)34, 0.0187);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)49, "Isoleucine CG1", (DuMM::AtomClassIndex)1, -0.043);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)50, "Isoleucine HG1", (DuMM::AtomClassIndex)34, 0.0236);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)51, "Isoleucine CG2", (DuMM::AtomClassIndex)1, -0.3204);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)52, "Isoleucine HG2", (DuMM::AtomClassIndex)34, 0.0882);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)53, "Isoleucine CD", (DuMM::AtomClassIndex)1, -0.066);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)54, "Isoleucine HD", (DuMM::AtomClassIndex)34, 0.0186);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)55, "Serine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)56, "Serine CA", (DuMM::AtomClassIndex)1, -0.0249);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)57, "Serine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)58, "Serine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)59, "Serine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)60, "Serine HA", (DuMM::AtomClassIndex)35, 0.0843);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)61, "Serine CB", (DuMM::AtomClassIndex)1, 0.2117);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)62, "Serine HB", (DuMM::AtomClassIndex)35, 0.0352);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)63, "Serine OG", (DuMM::AtomClassIndex)22, -0.6546);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)64, "Serine HG", (DuMM::AtomClassIndex)31, 0.4275);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)65, "Threonine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)66, "Threonine CA", (DuMM::AtomClassIndex)1, -0.0389);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)67, "Threonine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)68, "Threonine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)69, "Threonine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)70, "Threonine HA", (DuMM::AtomClassIndex)35, 0.1007);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)71, "Threonine CB", (DuMM::AtomClassIndex)1, 0.3654);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)72, "Threonine HB", (DuMM::AtomClassIndex)35, 0.0043);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)73, "Threonine OG1", (DuMM::AtomClassIndex)22, -0.6761);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)74, "Threonine HG1", (DuMM::AtomClassIndex)31, 0.4102);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)75, "Threonine CG2", (DuMM::AtomClassIndex)1, -0.2438);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)76, "Threonine HG2", (DuMM::AtomClassIndex)34, 0.0642);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)77, "Cysteine (-SH) N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)78, "Cysteine (-SH) CA", (DuMM::AtomClassIndex)1, 0.0213);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)79, "Cysteine (-SH) C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)80, "Cysteine (-SH) HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)81, "Cysteine (-SH) O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)82, "Cysteine (-SH) HA", (DuMM::AtomClassIndex)35, 0.1124);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)83, "Cysteine (-SH) CB", (DuMM::AtomClassIndex)1, -0.1231);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)84, "Cysteine (-SH) HB", (DuMM::AtomClassIndex)35, 0.1112);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)85, "Cysteine (-SH) SG", (DuMM::AtomClassIndex)27, -0.3119);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)86, "Cysteine (-SH) HG", (DuMM::AtomClassIndex)32, 0.1933);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)87, "Cystine (-SS-) N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)88, "Cystine (-SS-) CA", (DuMM::AtomClassIndex)1, 0.0429);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)89, "Cystine (-SS-) C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)90, "Cystine (-SS-) HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)91, "Cystine (-SS-) O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)92, "Cystine (-SS-) HA", (DuMM::AtomClassIndex)35, 0.0766);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)93, "Cystine (-SS-) CB", (DuMM::AtomClassIndex)1, -0.079);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)94, "Cystine (-SS-) HB", (DuMM::AtomClassIndex)35, 0.091);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)95, "Cystine (-SS-) SG", (DuMM::AtomClassIndex)26, -0.1081);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)96, "Proline N", (DuMM::AtomClassIndex)14, -0.2548);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)97, "Proline CA", (DuMM::AtomClassIndex)1, -0.0266);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)98, "Proline C", (DuMM::AtomClassIndex)2, 0.5896);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)99, "Proline O", (DuMM::AtomClassIndex)24, -0.5748);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)100, "Proline HA", (DuMM::AtomClassIndex)35, 0.0641);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)101, "Proline CB", (DuMM::AtomClassIndex)1, -0.007);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)102, "Proline HB", (DuMM::AtomClassIndex)34, 0.0253);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)103, "Proline CG", (DuMM::AtomClassIndex)1, 0.0189);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)104, "Proline HG", (DuMM::AtomClassIndex)34, 0.0213);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)105, "Proline CD", (DuMM::AtomClassIndex)1, 0.0192);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)106, "Proline HD", (DuMM::AtomClassIndex)35, 0.0391);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)107, "Phenylalanine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)108, "Phenylalanine CA", (DuMM::AtomClassIndex)1, -0.0024);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)109, "Phenylalanine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)110, "Phenylalanine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)111, "Phenylalanine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)112, "Phenylalanine HA", (DuMM::AtomClassIndex)35, 0.0978);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)113, "Phenylalanine CB", (DuMM::AtomClassIndex)1, -0.0343);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)114, "Phenylalanine HB", (DuMM::AtomClassIndex)34, 0.0295);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)115, "Phenylalanine CG", (DuMM::AtomClassIndex)3, 0.0118);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)116, "Phenylalanine CD", (DuMM::AtomClassIndex)3, -0.1256);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)117, "Phenylalanine HD", (DuMM::AtomClassIndex)33, 0.133);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)118, "Phenylalanine CE", (DuMM::AtomClassIndex)3, -0.1704);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)119, "Phenylalanine HE", (DuMM::AtomClassIndex)33, 0.143);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)120, "Phenylalanine CZ", (DuMM::AtomClassIndex)3, -0.1072);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)121, "Phenylalanine HZ", (DuMM::AtomClassIndex)33, 0.1297);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)122, "Tyrosine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)123, "Tyrosine CA", (DuMM::AtomClassIndex)1, -0.0014);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)124, "Tyrosine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)125, "Tyrosine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)126, "Tyrosine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)127, "Tyrosine HA", (DuMM::AtomClassIndex)35, 0.0876);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)128, "Tyrosine CB", (DuMM::AtomClassIndex)1, -0.0152);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)129, "Tyrosine HB", (DuMM::AtomClassIndex)34, 0.0295);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)130, "Tyrosine CG", (DuMM::AtomClassIndex)3, -0.0011);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)131, "Tyrosine CD", (DuMM::AtomClassIndex)3, -0.1906);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)132, "Tyrosine HD", (DuMM::AtomClassIndex)33, 0.1699);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)133, "Tyrosine CE", (DuMM::AtomClassIndex)3, -0.2341);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)134, "Tyrosine HE", (DuMM::AtomClassIndex)33, 0.1656);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)135, "Tyrosine CZ", (DuMM::AtomClassIndex)3, 0.3226);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)136, "Tyrosine OH", (DuMM::AtomClassIndex)22, -0.5579);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)137, "Tyrosine HH", (DuMM::AtomClassIndex)31, 0.3992);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)138, "Tryptophan N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)139, "Tryptophan CA", (DuMM::AtomClassIndex)1, -0.0275);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)140, "Tryptophan C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)141, "Tryptophan HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)142, "Tryptophan O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)143, "Tryptophan HA", (DuMM::AtomClassIndex)35, 0.1123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)144, "Tryptophan CB", (DuMM::AtomClassIndex)1, -0.005);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)145, "Tryptophan HB", (DuMM::AtomClassIndex)34, 0.0339);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)146, "Tryptophan CG", (DuMM::AtomClassIndex)10, -0.1415);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)147, "Tryptophan CD1", (DuMM::AtomClassIndex)7, -0.1638);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)148, "Tryptophan HD1", (DuMM::AtomClassIndex)39, 0.2062);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)149, "Tryptophan CD2", (DuMM::AtomClassIndex)9, 0.1243);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)150, "Tryptophan NE1", (DuMM::AtomClassIndex)15, -0.3418);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)151, "Tryptophan HE1", (DuMM::AtomClassIndex)29, 0.3412);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)152, "Tryptophan CE2", (DuMM::AtomClassIndex)11, 0.138);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)153, "Tryptophan CE3", (DuMM::AtomClassIndex)3, -0.2387);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)154, "Tryptophan HE3", (DuMM::AtomClassIndex)33, 0.17);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)155, "Tryptophan CZ2", (DuMM::AtomClassIndex)3, -0.2601);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)156, "Tryptophan HZ2", (DuMM::AtomClassIndex)33, 0.1572);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)157, "Tryptophan CZ3", (DuMM::AtomClassIndex)3, -0.1972);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)158, "Tryptophan HZ3", (DuMM::AtomClassIndex)33, 0.1447);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)159, "Tryptophan CH2", (DuMM::AtomClassIndex)3, -0.1134);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)160, "Tryptophan HH2", (DuMM::AtomClassIndex)33, 0.1417);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)161, "Histidine (+) N", (DuMM::AtomClassIndex)14, -0.3479);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)162, "Histidine (+) CA", (DuMM::AtomClassIndex)1, -0.1354);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)163, "Histidine (+) C", (DuMM::AtomClassIndex)2, 0.7341);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)164, "Histidine (+) HN", (DuMM::AtomClassIndex)29, 0.2747);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)165, "Histidine (+) O", (DuMM::AtomClassIndex)24, -0.5894);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)166, "Histidine (+) HA", (DuMM::AtomClassIndex)35, 0.1212);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)167, "Histidine (+) CB", (DuMM::AtomClassIndex)1, -0.0414);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)168, "Histidine (+) HB", (DuMM::AtomClassIndex)34, 0.081);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)169, "Histidine (+) CG", (DuMM::AtomClassIndex)5, -0.0012);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)170, "Histidine (+) ND1", (DuMM::AtomClassIndex)15, -0.1513);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)171, "Histidine (+) HD1", (DuMM::AtomClassIndex)29, 0.3866);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)172, "Histidine (+) CD2", (DuMM::AtomClassIndex)7, -0.1141);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)173, "Histidine (+) HD2", (DuMM::AtomClassIndex)39, 0.2317);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)174, "Histidine (+) CE1", (DuMM::AtomClassIndex)8, -0.017);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)175, "Histidine (+) HE1", (DuMM::AtomClassIndex)40, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)176, "Histidine (+) NE2", (DuMM::AtomClassIndex)15, -0.1718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)177, "Histidine (+) HE2", (DuMM::AtomClassIndex)29, 0.3911);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)178, "Histidine (HD) N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)179, "Histidine (HD) CA", (DuMM::AtomClassIndex)1, 0.0188);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)180, "Histidine (HD) C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)181, "Histidine (HD) HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)182, "Histidine (HD) O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)183, "Histidine (HD) HA", (DuMM::AtomClassIndex)35, 0.0881);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)184, "Histidine (HD) CB", (DuMM::AtomClassIndex)1, -0.0462);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)185, "Histidine (HD) HB", (DuMM::AtomClassIndex)34, 0.0402);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)186, "Histidine (HD) CG", (DuMM::AtomClassIndex)5, -0.0266);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)187, "Histidine (HD) ND1", (DuMM::AtomClassIndex)15, -0.3811);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)188, "Histidine (HD) HD1", (DuMM::AtomClassIndex)29, 0.3649);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)189, "Histidine (HD) CD2", (DuMM::AtomClassIndex)6, 0.1292);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)190, "Histidine (HD) HD2", (DuMM::AtomClassIndex)39, 0.1147);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)191, "Histidine (HD) CE1", (DuMM::AtomClassIndex)8, 0.2057);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)192, "Histidine (HD) HE1", (DuMM::AtomClassIndex)40, 0.1392);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)193, "Histidine (HD) NE2", (DuMM::AtomClassIndex)16, -0.5727);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)194, "Histidine (HE) N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)195, "Histidine (HE) CA", (DuMM::AtomClassIndex)1, -0.0581);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)196, "Histidine (HE) C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)197, "Histidine (HE) HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)198, "Histidine (HE) O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)199, "Histidine (HE) HA", (DuMM::AtomClassIndex)35, 0.136);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)200, "Histidine (HE) CB", (DuMM::AtomClassIndex)1, -0.0074);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)201, "Histidine (HE) HB", (DuMM::AtomClassIndex)34, 0.0367);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)202, "Histidine (HE) CG", (DuMM::AtomClassIndex)5, 0.1868);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)203, "Histidine (HE) ND1", (DuMM::AtomClassIndex)16, -0.5432);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)204, "Histidine (HE) CD2", (DuMM::AtomClassIndex)7, -0.2207);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)205, "Histidine (HE) HD2", (DuMM::AtomClassIndex)39, 0.1862);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)206, "Histidine (HE) CE1", (DuMM::AtomClassIndex)8, 0.1635);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)207, "Histidine (HE) HE1", (DuMM::AtomClassIndex)40, 0.1435);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)208, "Histidine (HE) NE2", (DuMM::AtomClassIndex)15, -0.2795);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)209, "Histidine (HE) HE2", (DuMM::AtomClassIndex)29, 0.3339);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)210, "Aspartic Acid N", (DuMM::AtomClassIndex)14, -0.5163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)211, "Aspartic Acid CA", (DuMM::AtomClassIndex)1, 0.0381);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)212, "Aspartic Acid C", (DuMM::AtomClassIndex)2, 0.5366);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)213, "Aspartic Acid HN", (DuMM::AtomClassIndex)29, 0.2936);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)214, "Aspartic Acid O", (DuMM::AtomClassIndex)24, -0.5819);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)215, "Aspartic Acid HA", (DuMM::AtomClassIndex)35, 0.088);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)216, "Aspartic Acid CB", (DuMM::AtomClassIndex)1, -0.0303);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)217, "Aspartic Acid HB", (DuMM::AtomClassIndex)34, -0.0122);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)218, "Aspartic Acid CG", (DuMM::AtomClassIndex)2, 0.7994);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)219, "Aspartic Acid OD", (DuMM::AtomClassIndex)25, -0.8014);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)220, "Asparagine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)221, "Asparagine CA", (DuMM::AtomClassIndex)1, 0.0143);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)222, "Asparagine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)223, "Asparagine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)224, "Asparagine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)225, "Asparagine HA", (DuMM::AtomClassIndex)35, 0.1048);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)226, "Asparagine CB", (DuMM::AtomClassIndex)1, -0.2041);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)227, "Asparagine HB", (DuMM::AtomClassIndex)34, 0.0797);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)228, "Asparagine CG", (DuMM::AtomClassIndex)2, 0.713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)229, "Asparagine OD1", (DuMM::AtomClassIndex)24, -0.5931);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)230, "Asparagine ND2", (DuMM::AtomClassIndex)14, -0.9191);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)231, "Asparagine HD2", (DuMM::AtomClassIndex)29, 0.4196);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)232, "Glutamic Acid N", (DuMM::AtomClassIndex)14, -0.5163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)233, "Glutamic Acid CA", (DuMM::AtomClassIndex)1, 0.0397);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)234, "Glutamic Acid C", (DuMM::AtomClassIndex)2, 0.5366);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)235, "Glutamic Acid HN", (DuMM::AtomClassIndex)29, 0.2936);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)236, "Glutamic Acid O", (DuMM::AtomClassIndex)24, -0.5819);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)237, "Glutamic Acid HA", (DuMM::AtomClassIndex)35, 0.1105);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)238, "Glutamic Acid CB", (DuMM::AtomClassIndex)1, 0.056);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)239, "Glutamic Acid HB", (DuMM::AtomClassIndex)34, -0.0173);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)240, "Glutamic Acid CG", (DuMM::AtomClassIndex)1, 0.0136);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)241, "Glutamic Acid HG", (DuMM::AtomClassIndex)34, -0.0425);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)242, "Glutamic Acid CD", (DuMM::AtomClassIndex)2, 0.8054);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)243, "Glutamic Acid OE", (DuMM::AtomClassIndex)25, -0.8188);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)244, "Glutamine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)245, "Glutamine CA", (DuMM::AtomClassIndex)1, -0.0031);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)246, "Glutamine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)247, "Glutamine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)248, "Glutamine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)249, "Glutamine HA", (DuMM::AtomClassIndex)35, 0.085);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)250, "Glutamine CB", (DuMM::AtomClassIndex)1, -0.0036);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)251, "Glutamine HB", (DuMM::AtomClassIndex)34, 0.0171);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)252, "Glutamine CG", (DuMM::AtomClassIndex)1, -0.0645);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)253, "Glutamine HG", (DuMM::AtomClassIndex)34, 0.0352);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)254, "Glutamine CD", (DuMM::AtomClassIndex)2, 0.6951);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)255, "Glutamine OE1", (DuMM::AtomClassIndex)24, -0.6086);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)256, "Glutamine NE2", (DuMM::AtomClassIndex)14, -0.9407);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)257, "Glutamine HE2", (DuMM::AtomClassIndex)29, 0.4251);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)258, "Methionine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)259, "Methionine CA", (DuMM::AtomClassIndex)1, -0.0237);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)260, "Methionine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)261, "Methionine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)262, "Methionine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)263, "Methionine HA", (DuMM::AtomClassIndex)35, 0.088);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)264, "Methionine CB", (DuMM::AtomClassIndex)1, 0.0342);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)265, "Methionine HB", (DuMM::AtomClassIndex)34, 0.0241);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)266, "Methionine CG", (DuMM::AtomClassIndex)1, 0.0018);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)267, "Methionine HG", (DuMM::AtomClassIndex)35, 0.044);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)268, "Methionine SD", (DuMM::AtomClassIndex)26, -0.2737);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)269, "Methionine CE", (DuMM::AtomClassIndex)1, -0.0536);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)270, "Methionine HE", (DuMM::AtomClassIndex)35, 0.0684);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)271, "Lysine N", (DuMM::AtomClassIndex)14, -0.3479);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)272, "Lysine CA", (DuMM::AtomClassIndex)1, -0.24);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)273, "Lysine C", (DuMM::AtomClassIndex)2, 0.7341);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)274, "Lysine HN", (DuMM::AtomClassIndex)29, 0.2747);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)275, "Lysine O", (DuMM::AtomClassIndex)24, -0.5894);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)276, "Lysine HA", (DuMM::AtomClassIndex)35, 0.1426);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)277, "Lysine CB", (DuMM::AtomClassIndex)1, -0.0094);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)278, "Lysine HB", (DuMM::AtomClassIndex)34, 0.0362);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)279, "Lysine CG", (DuMM::AtomClassIndex)1, 0.0187);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)280, "Lysine HG", (DuMM::AtomClassIndex)34, 0.0103);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)281, "Lysine CD", (DuMM::AtomClassIndex)1, -0.0479);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)282, "Lysine HD", (DuMM::AtomClassIndex)34, 0.0621);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)283, "Lysine CE", (DuMM::AtomClassIndex)1, -0.0143);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)284, "Lysine HE", (DuMM::AtomClassIndex)38, 0.1135);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)285, "Lysine NZ", (DuMM::AtomClassIndex)20, -0.3854);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)286, "Lysine HZ", (DuMM::AtomClassIndex)29, 0.34);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)287, "Arginine N", (DuMM::AtomClassIndex)14, -0.3479);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)288, "Arginine CA", (DuMM::AtomClassIndex)1, -0.2637);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)289, "Arginine C", (DuMM::AtomClassIndex)2, 0.7341);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)290, "Arginine HN", (DuMM::AtomClassIndex)29, 0.2747);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)291, "Arginine O", (DuMM::AtomClassIndex)24, -0.5894);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)292, "Arginine HA", (DuMM::AtomClassIndex)35, 0.156);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)293, "Arginine CB", (DuMM::AtomClassIndex)1, -0.0007);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)294, "Arginine HB", (DuMM::AtomClassIndex)34, 0.0327);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)295, "Arginine CG", (DuMM::AtomClassIndex)1, 0.039);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)296, "Arginine HG", (DuMM::AtomClassIndex)34, 0.0285);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)297, "Arginine CD", (DuMM::AtomClassIndex)1, 0.0486);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)298, "Arginine HD", (DuMM::AtomClassIndex)35, 0.0687);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)299, "Arginine NE", (DuMM::AtomClassIndex)19, -0.5295);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)300, "Arginine HE", (DuMM::AtomClassIndex)29, 0.3456);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)301, "Arginine CZ", (DuMM::AtomClassIndex)3, 0.8076);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)302, "Arginine NH", (DuMM::AtomClassIndex)19, -0.8627);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)303, "Arginine HH", (DuMM::AtomClassIndex)29, 0.4478);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)304, "Ornithine N", (DuMM::AtomClassIndex)14, -0.3479);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)305, "Ornithine CA", (DuMM::AtomClassIndex)1, -0.24);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)306, "Ornithine C", (DuMM::AtomClassIndex)2, 0.7341);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)307, "Ornithine HN", (DuMM::AtomClassIndex)29, 0.2747);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)308, "Ornithine O", (DuMM::AtomClassIndex)24, -0.5894);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)309, "Ornithine HA", (DuMM::AtomClassIndex)35, 0.1426);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)310, "Ornithine CB", (DuMM::AtomClassIndex)1, 0.0099);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)311, "Ornithine HB", (DuMM::AtomClassIndex)34, 0.0362);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)312, "Ornithine CG", (DuMM::AtomClassIndex)1, -0.0279);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)313, "Ornithine HG", (DuMM::AtomClassIndex)34, 0.0621);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)314, "Ornithine CD", (DuMM::AtomClassIndex)1, -0.0143);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)315, "Ornithine HD", (DuMM::AtomClassIndex)38, 0.1135);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)316, "Ornithine NE", (DuMM::AtomClassIndex)20, -0.3854);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)317, "Ornithine HE", (DuMM::AtomClassIndex)29, 0.34);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)318, "MethylAlanine N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)319, "MethylAlanine CA", (DuMM::AtomClassIndex)1, 0.1032);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)320, "MethylAlanine C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)321, "MethylAlanine HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)322, "MethylAlanine O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)323, "MethylAlanine CB", (DuMM::AtomClassIndex)1, -0.2503);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)324, "MethylAlanine HB", (DuMM::AtomClassIndex)34, 0.0853);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)325, "Pyroglutamate N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)326, "Pyroglutamate CA", (DuMM::AtomClassIndex)1, -0.0371);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)327, "Pyroglutamate C", (DuMM::AtomClassIndex)2, 0.5973);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)328, "Pyroglutamate HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)329, "Pyroglutamate O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)330, "Pyroglutamate HA", (DuMM::AtomClassIndex)35, 0.085);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)331, "Pyroglutamate CB", (DuMM::AtomClassIndex)1, -0.0036);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)332, "Pyroglutamate HB", (DuMM::AtomClassIndex)34, 0.0171);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)333, "Pyroglutamate CG", (DuMM::AtomClassIndex)1, -0.0645);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)334, "Pyroglutamate HG", (DuMM::AtomClassIndex)34, 0.0352);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)335, "Pyroglutamate CD", (DuMM::AtomClassIndex)2, 0.6);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)336, "Pyroglutamate OE", (DuMM::AtomClassIndex)24, -0.57);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)340, "Acetyl CA", (DuMM::AtomClassIndex)1, -0.3662);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)341, "Acetyl HA", (DuMM::AtomClassIndex)34, 0.1123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)342, "Acetyl C", (DuMM::AtomClassIndex)2, 0.5972);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)343, "Acetyl O", (DuMM::AtomClassIndex)24, -0.5679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)344, "C-Term Amide N", (DuMM::AtomClassIndex)14, -0.84);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)345, "C-Term Amide HN", (DuMM::AtomClassIndex)29, 0.42);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)346, "N-MeAmide N", (DuMM::AtomClassIndex)14, -0.4157);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)347, "N-MeAmide HN", (DuMM::AtomClassIndex)29, 0.2719);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)348, "N-MeAmide C", (DuMM::AtomClassIndex)1, -0.149);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)349, "N-MeAmide HC", (DuMM::AtomClassIndex)35, 0.0976);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)350, "N-Term GLY N", (DuMM::AtomClassIndex)20, 0.2943);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)351, "N-Term GLY CA", (DuMM::AtomClassIndex)1, -0.01);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)352, "N-Term GLY C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)353, "N-Term GLY HN", (DuMM::AtomClassIndex)29, 0.1642);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)354, "N-Term GLY O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)355, "N-Term GLY HA", (DuMM::AtomClassIndex)35, 0.0895);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)356, "N-Term ALA N", (DuMM::AtomClassIndex)20, 0.1414);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)357, "N-Term ALA CA", (DuMM::AtomClassIndex)1, 0.1281);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)358, "N-Term ALA C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)359, "N-Term ALA HN", (DuMM::AtomClassIndex)29, 0.1997);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)360, "N-Term ALA O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)361, "N-Term ALA HA", (DuMM::AtomClassIndex)35, 0.0889);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)362, "N-Term VAL N", (DuMM::AtomClassIndex)20, 0.0577);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)363, "N-Term VAL CA", (DuMM::AtomClassIndex)1, 0.0023);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)364, "N-Term VAL C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)365, "N-Term VAL HN", (DuMM::AtomClassIndex)29, 0.2272);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)366, "N-Term VAL O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)367, "N-Term VAL HA", (DuMM::AtomClassIndex)35, 0.1093);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)368, "N-Term LEU N", (DuMM::AtomClassIndex)20, 0.101);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)369, "N-Term LEU CA", (DuMM::AtomClassIndex)1, 0.0343);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)370, "N-Term LEU C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)371, "N-Term LEU HN", (DuMM::AtomClassIndex)29, 0.2148);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)372, "N-Term LEU O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)373, "N-Term LEU HA", (DuMM::AtomClassIndex)35, 0.1053);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)374, "N-Term ILE N", (DuMM::AtomClassIndex)20, 0.0311);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)375, "N-Term ILE CA", (DuMM::AtomClassIndex)1, 0.0389);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)376, "N-Term ILE C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)377, "N-Term ILE HN", (DuMM::AtomClassIndex)29, 0.2329);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)378, "N-Term ILE O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)379, "N-Term ILE HA", (DuMM::AtomClassIndex)35, 0.1031);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)380, "N-Term SER N", (DuMM::AtomClassIndex)20, 0.1849);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)381, "N-Term SER CA", (DuMM::AtomClassIndex)1, 0.0684);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)382, "N-Term SER C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)383, "N-Term SER HN", (DuMM::AtomClassIndex)29, 0.1898);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)384, "N-Term SER O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)385, "N-Term SER HA", (DuMM::AtomClassIndex)35, 0.0782);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)386, "N-Term THR N", (DuMM::AtomClassIndex)20, 0.1812);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)387, "N-Term THR CA", (DuMM::AtomClassIndex)1, 0.0332);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)388, "N-Term THR C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)389, "N-Term THR HN", (DuMM::AtomClassIndex)29, 0.1934);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)390, "N-Term THR O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)391, "N-Term THR HA", (DuMM::AtomClassIndex)35, 0.1087);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)392, "N-Term CYS (-SH) N", (DuMM::AtomClassIndex)20, 0.1325);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)393, "N-Term CYS (-SH) CA", (DuMM::AtomClassIndex)1, 0.0978);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)394, "N-Term CYS (-SH) C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)395, "N-Term CYS (-SH) HN", (DuMM::AtomClassIndex)29, 0.2023);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)396, "N-Term CYS (-SH) O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)397, "N-Term CYS (-SH) HA", (DuMM::AtomClassIndex)35, 0.1411);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)398, "N-Term CYS (-SS-) N", (DuMM::AtomClassIndex)20, 0.2096);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)399, "N-Term CYS (-SS-) CA", (DuMM::AtomClassIndex)1, 0.1138);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)400, "N-Term CYS (-SS-) C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)401, "N-Term CYS (-SS-) HN", (DuMM::AtomClassIndex)29, 0.1815);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)402, "N-Term CYS (-SS-) O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)403, "N-Term CYS (-SS-) HA", (DuMM::AtomClassIndex)35, 0.0922);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)404, "N-Term PRO N", (DuMM::AtomClassIndex)20, -0.202);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)405, "N-Term PRO CA", (DuMM::AtomClassIndex)1, 0.1589);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)406, "N-Term PRO C", (DuMM::AtomClassIndex)2, 0.526);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)407, "N-Term PRO HN", (DuMM::AtomClassIndex)29, 0.312);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)408, "N-Term PRO O", (DuMM::AtomClassIndex)24, -0.5);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)409, "N-Term PRO HA", (DuMM::AtomClassIndex)35, 0.1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)410, "N-Term PRO CD", (DuMM::AtomClassIndex)1, -0.012);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)411, "N-Term PRO HD", (DuMM::AtomClassIndex)38, 0.1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)412, "N-Term PHE N", (DuMM::AtomClassIndex)20, 0.1737);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)413, "N-Term PHE CA", (DuMM::AtomClassIndex)1, 0.0859);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)414, "N-Term PHE C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)415, "N-Term PHE HN", (DuMM::AtomClassIndex)29, 0.1921);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)416, "N-Term PHE O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)417, "N-Term PHE HA", (DuMM::AtomClassIndex)35, 0.1041);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)418, "N-Term TYR N", (DuMM::AtomClassIndex)20, 0.194);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)419, "N-Term TYR CA", (DuMM::AtomClassIndex)1, 0.0766);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)420, "N-Term TYR C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)421, "N-Term TYR HN", (DuMM::AtomClassIndex)29, 0.1873);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)422, "N-Term TYR O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)423, "N-Term TYR HA", (DuMM::AtomClassIndex)35, 0.0983);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)424, "N-Term TRP N", (DuMM::AtomClassIndex)20, 0.1913);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)425, "N-Term TRP CA", (DuMM::AtomClassIndex)1, 0.0555);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)426, "N-Term TRP C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)427, "N-Term TRP HN", (DuMM::AtomClassIndex)29, 0.1888);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)428, "N-Term TRP O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)429, "N-Term TRP HA", (DuMM::AtomClassIndex)35, 0.1162);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)430, "N-Term HIS (+) N", (DuMM::AtomClassIndex)20, 0.256);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)431, "N-Term HIS (+) CA", (DuMM::AtomClassIndex)1, 0.0653);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)432, "N-Term HIS (+) C", (DuMM::AtomClassIndex)2, 0.7214);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)433, "N-Term HIS (+) HN", (DuMM::AtomClassIndex)29, 0.1704);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)434, "N-Term HIS (+) O", (DuMM::AtomClassIndex)24, -0.6013);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)435, "N-Term HIS (+) HA", (DuMM::AtomClassIndex)35, 0.1047);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)436, "N-Term HIS (HD) N", (DuMM::AtomClassIndex)20, 0.1542);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)437, "N-Term HIS (HD) CA", (DuMM::AtomClassIndex)1, 0.1126);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)438, "N-Term HIS (HD) C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)439, "N-Term HIS (HD) HN", (DuMM::AtomClassIndex)29, 0.1963);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)440, "N-Term HIS (HD) O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)441, "N-Term HIS (HD) HA", (DuMM::AtomClassIndex)35, 0.0958);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)442, "N-Term HIS (HE) N", (DuMM::AtomClassIndex)20, 0.1472);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)443, "N-Term HIS (HE) CA", (DuMM::AtomClassIndex)1, 0.0325);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)444, "N-Term HIS (HE) C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)445, "N-Term HIS (HE) HN", (DuMM::AtomClassIndex)29, 0.2016);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)446, "N-Term HIS (HE) O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)447, "N-Term HIS (HE) HA", (DuMM::AtomClassIndex)35, 0.138);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)448, "N-Term ASP N", (DuMM::AtomClassIndex)20, 0.0782);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)449, "N-Term ASP CA", (DuMM::AtomClassIndex)1, 0.0326);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)450, "N-Term ASP C", (DuMM::AtomClassIndex)2, 0.5621);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)451, "N-Term ASP HN", (DuMM::AtomClassIndex)29, 0.22);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)452, "N-Term ASP O", (DuMM::AtomClassIndex)24, -0.5889);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)453, "N-Term ASP HA", (DuMM::AtomClassIndex)35, 0.1141);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)454, "N-Term ASN N", (DuMM::AtomClassIndex)20, 0.1801);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)455, "N-Term ASN CA", (DuMM::AtomClassIndex)1, 0.0811);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)456, "N-Term ASN C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)457, "N-Term ASN HN", (DuMM::AtomClassIndex)29, 0.1921);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)458, "N-Term ASN O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)459, "N-Term ASN HA", (DuMM::AtomClassIndex)35, 0.1231);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)460, "N-Term GLU N", (DuMM::AtomClassIndex)20, 0.0017);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)461, "N-Term GLU CA", (DuMM::AtomClassIndex)1, 0.0698);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)462, "N-Term GLU C", (DuMM::AtomClassIndex)2, 0.5621);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)463, "N-Term GLU HN", (DuMM::AtomClassIndex)29, 0.2391);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)464, "N-Term GLU O", (DuMM::AtomClassIndex)24, -0.5889);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)465, "N-Term GLU HA", (DuMM::AtomClassIndex)35, 0.1202);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)466, "N-Term GLN N", (DuMM::AtomClassIndex)20, 0.1493);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)467, "N-Term GLN CA", (DuMM::AtomClassIndex)1, 0.0769);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)468, "N-Term GLN C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)469, "N-Term GLN HN", (DuMM::AtomClassIndex)29, 0.1996);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)470, "N-Term GLN O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)471, "N-Term GLN HA", (DuMM::AtomClassIndex)35, 0.1015);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)472, "N-Term MET N", (DuMM::AtomClassIndex)20, 0.1592);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)473, "N-Term MET CA", (DuMM::AtomClassIndex)1, 0.0429);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)474, "N-Term MET C", (DuMM::AtomClassIndex)2, 0.6123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)475, "N-Term MET HN", (DuMM::AtomClassIndex)29, 0.1984);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)476, "N-Term MET O", (DuMM::AtomClassIndex)24, -0.5713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)477, "N-Term MET HA", (DuMM::AtomClassIndex)35, 0.1116);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)478, "N-Term LYS N", (DuMM::AtomClassIndex)20, 0.0966);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)479, "N-Term LYS CA", (DuMM::AtomClassIndex)1, -0.0101);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)480, "N-Term LYS C", (DuMM::AtomClassIndex)2, 0.7214);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)481, "N-Term LYS HN", (DuMM::AtomClassIndex)29, 0.2165);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)482, "N-Term LYS O", (DuMM::AtomClassIndex)24, -0.6013);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)483, "N-Term LYS HA", (DuMM::AtomClassIndex)35, 0.118);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)484, "N-Term ARG N", (DuMM::AtomClassIndex)20, 0.1305);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)485, "N-Term ARG CA", (DuMM::AtomClassIndex)1, -0.0359);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)486, "N-Term ARG C", (DuMM::AtomClassIndex)2, 0.7214);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)487, "N-Term ARG HN", (DuMM::AtomClassIndex)29, 0.2083);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)488, "N-Term ARG O", (DuMM::AtomClassIndex)24, -0.6013);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)489, "N-Term ARG HA", (DuMM::AtomClassIndex)35, 0.1242);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)490, "N-Term ORN N", (DuMM::AtomClassIndex)20, 0.0966);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)491, "N-Term ORN CA", (DuMM::AtomClassIndex)1, -0.0101);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)492, "N-Term ORN C", (DuMM::AtomClassIndex)2, 0.7214);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)493, "N-Term ORN HN", (DuMM::AtomClassIndex)29, 0.2165);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)494, "N-Term ORN O", (DuMM::AtomClassIndex)24, -0.6013);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)495, "N-Term ORN HA", (DuMM::AtomClassIndex)35, 0.118);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)496, "N-Term AIB N", (DuMM::AtomClassIndex)20, 0.1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)497, "N-Term AIB CA", (DuMM::AtomClassIndex)1, 0.2447);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)498, "N-Term AIB C", (DuMM::AtomClassIndex)2, 0.6163);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)499, "N-Term AIB HN", (DuMM::AtomClassIndex)29, 0.2);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)500, "N-Term AIB O", (DuMM::AtomClassIndex)24, -0.5722);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)501, "C-Term GLY N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)502, "C-Term GLY CA", (DuMM::AtomClassIndex)1, -0.2493);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)503, "C-Term GLY C", (DuMM::AtomClassIndex)2, 0.7231);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)504, "C-Term GLY HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)505, "C-Term GLY OXT", (DuMM::AtomClassIndex)25, -0.7855);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)506, "C-Term GLY HA", (DuMM::AtomClassIndex)35, 0.1056);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)507, "C-Term ALA N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)508, "C-Term ALA CA", (DuMM::AtomClassIndex)1, -0.1532);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)509, "C-Term ALA C", (DuMM::AtomClassIndex)2, 0.7731);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)510, "C-Term ALA HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)511, "C-Term ALA OXT", (DuMM::AtomClassIndex)25, -0.8055);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)512, "C-Term ALA HA", (DuMM::AtomClassIndex)35, 0.1067);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)513, "C-Term VAL N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)514, "C-Term VAL CA", (DuMM::AtomClassIndex)1, -0.3352);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)515, "C-Term VAL C", (DuMM::AtomClassIndex)2, 0.835);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)516, "C-Term VAL HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)517, "C-Term VAL OXT", (DuMM::AtomClassIndex)25, -0.8173);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)518, "C-Term VAL HA", (DuMM::AtomClassIndex)35, 0.1438);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)519, "C-Term LEU N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)520, "C-Term LEU CA", (DuMM::AtomClassIndex)1, -0.2874);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)521, "C-Term LEU C", (DuMM::AtomClassIndex)2, 0.8326);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)522, "C-Term LEU HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)523, "C-Term LEU OXT", (DuMM::AtomClassIndex)25, -0.8199);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)524, "C-Term LEU HA", (DuMM::AtomClassIndex)35, 0.1346);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)525, "C-Term ILE N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)526, "C-Term ILE CA", (DuMM::AtomClassIndex)1, -0.307);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)527, "C-Term ILE C", (DuMM::AtomClassIndex)2, 0.8343);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)528, "C-Term ILE HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)529, "C-Term ILE OXT", (DuMM::AtomClassIndex)25, -0.819);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)530, "C-Term ILE HA", (DuMM::AtomClassIndex)35, 0.1375);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)531, "C-Term SER N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)532, "C-Term SER CA", (DuMM::AtomClassIndex)1, -0.2563);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)533, "C-Term SER C", (DuMM::AtomClassIndex)2, 0.8113);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)534, "C-Term SER HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)535, "C-Term SER OXT", (DuMM::AtomClassIndex)25, -0.8132);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)536, "C-Term SER HA", (DuMM::AtomClassIndex)35, 0.1304);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)537, "C-Term THR N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)538, "C-Term THR CA", (DuMM::AtomClassIndex)1, -0.2315);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)539, "C-Term THR C", (DuMM::AtomClassIndex)2, 0.781);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)540, "C-Term THR HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)541, "C-Term THR OXT", (DuMM::AtomClassIndex)25, -0.8044);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)542, "C-Term THR HA", (DuMM::AtomClassIndex)35, 0.1207);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)543, "C-Term CYS (-SH) N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)544, "C-Term CYS (-SH) CA", (DuMM::AtomClassIndex)1, -0.1598);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)545, "C-Term CYS (-SH) C", (DuMM::AtomClassIndex)2, 0.7497);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)546, "C-Term CYS (-SH) HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)547, "C-Term CYS (-SH) OXT", (DuMM::AtomClassIndex)25, -0.7981);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)548, "C-Term CYS (-SH) HA", (DuMM::AtomClassIndex)35, 0.1396);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)549, "C-Term CYS (-SS-) N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)550, "C-Term CYS (-SS-) CA", (DuMM::AtomClassIndex)1, -0.1283);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)551, "C-Term CYS (-SS-) C", (DuMM::AtomClassIndex)2, 0.7618);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)552, "C-Term CYS (-SS-) HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)553, "C-Term CYS (-SS-) OXT", (DuMM::AtomClassIndex)25, -0.8041);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)554, "C-Term CYS (-SS-) HA", (DuMM::AtomClassIndex)35, 0.0938);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)555, "C-Term PRO N", (DuMM::AtomClassIndex)14, -0.2802);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)556, "C-Term PRO CA", (DuMM::AtomClassIndex)1, -0.1236);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)557, "C-Term PRO C", (DuMM::AtomClassIndex)2, 0.6631);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)558, "C-Term PRO OXT", (DuMM::AtomClassIndex)25, -0.7697);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)559, "C-Term PRO HA", (DuMM::AtomClassIndex)35, 0.0776);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)560, "C-Term PHE N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)561, "C-Term PHE CA", (DuMM::AtomClassIndex)1, -0.1756);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)562, "C-Term PHE C", (DuMM::AtomClassIndex)2, 0.766);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)563, "C-Term PHE HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)564, "C-Term PHE OXT", (DuMM::AtomClassIndex)25, -0.8026);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)565, "C-Term PHE HA", (DuMM::AtomClassIndex)35, 0.1098);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)566, "C-Term TYR N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)567, "C-Term TYR CA", (DuMM::AtomClassIndex)1, -0.1911);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)568, "C-Term TYR C", (DuMM::AtomClassIndex)2, 0.7817);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)569, "C-Term TYR HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)570, "C-Term TYR OXT", (DuMM::AtomClassIndex)25, -0.807);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)571, "C-Term TYR HA", (DuMM::AtomClassIndex)35, 0.1092);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)572, "C-Term TRP N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)573, "C-Term TRP CA", (DuMM::AtomClassIndex)1, -0.2064);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)574, "C-Term TRP C", (DuMM::AtomClassIndex)2, 0.7658);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)575, "C-Term TRP HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)576, "C-Term TRP OXT", (DuMM::AtomClassIndex)25, -0.8011);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)577, "C-Term TRP HA", (DuMM::AtomClassIndex)35, 0.1272);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)578, "C-Term HIS (+) N", (DuMM::AtomClassIndex)14, -0.3481);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)579, "C-Term HIS (+) CA", (DuMM::AtomClassIndex)1, -0.1503);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)580, "C-Term HIS (+) C", (DuMM::AtomClassIndex)2, 0.8032);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)581, "C-Term HIS (+) HN", (DuMM::AtomClassIndex)29, 0.2764);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)582, "C-Term HIS (+) OXT", (DuMM::AtomClassIndex)25, -0.8177);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)583, "C-Term HIS (+) HA", (DuMM::AtomClassIndex)35, 0.1115);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)584, "C-Term HIS (HD) N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)585, "C-Term HIS (HD) CA", (DuMM::AtomClassIndex)1, -0.1618);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)586, "C-Term HIS (HD) C", (DuMM::AtomClassIndex)2, 0.7615);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)587, "C-Term HIS (HD) HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)588, "C-Term HIS (HD) OXT", (DuMM::AtomClassIndex)25, -0.8016);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)589, "C-Term HIS (HD) HA", (DuMM::AtomClassIndex)35, 0.11);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)590, "C-Term HIS (HE) N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)591, "C-Term HIS (HE) CA", (DuMM::AtomClassIndex)1, -0.2661);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)592, "C-Term HIS (HE) C", (DuMM::AtomClassIndex)2, 0.7916);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)593, "C-Term HIS (HE) HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)594, "C-Term HIS (HE) OXT", (DuMM::AtomClassIndex)25, -0.8065);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)595, "C-Term HIS (HE) HA", (DuMM::AtomClassIndex)35, 0.165);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)596, "C-Term ASP N", (DuMM::AtomClassIndex)14, -0.5192);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)597, "C-Term ASP CA", (DuMM::AtomClassIndex)1, -0.181);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)598, "C-Term ASP C", (DuMM::AtomClassIndex)2, 0.7256);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)599, "C-Term ASP HN", (DuMM::AtomClassIndex)29, 0.3055);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)600, "C-Term ASP OXT", (DuMM::AtomClassIndex)25, -0.7887);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)601, "C-Term ASP HA", (DuMM::AtomClassIndex)35, 0.1046);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)602, "C-Term ASN N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)603, "C-Term ASN CA", (DuMM::AtomClassIndex)1, -0.1927);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)604, "C-Term ASN C", (DuMM::AtomClassIndex)2, 0.805);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)605, "C-Term ASN HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)606, "C-Term ASN OXT", (DuMM::AtomClassIndex)25, -0.8147);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)607, "C-Term ASN HA", (DuMM::AtomClassIndex)35, 0.1358);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)608, "C-Term GLU N", (DuMM::AtomClassIndex)14, -0.5192);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)609, "C-Term GLU CA", (DuMM::AtomClassIndex)1, -0.2);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)610, "C-Term GLU C", (DuMM::AtomClassIndex)2, 0.742);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)611, "C-Term GLU HN", (DuMM::AtomClassIndex)29, 0.3055);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)612, "C-Term GLU OXT", (DuMM::AtomClassIndex)25, -0.793);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)613, "C-Term GLU HA", (DuMM::AtomClassIndex)35, 0.1399);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)614, "C-Term GLN N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)615, "C-Term GLN CA", (DuMM::AtomClassIndex)1, -0.2108);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)616, "C-Term GLN C", (DuMM::AtomClassIndex)2, 0.7775);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)617, "C-Term GLN HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)618, "C-Term GLN OXT", (DuMM::AtomClassIndex)25, -0.8042);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)619, "C-Term GLN HA", (DuMM::AtomClassIndex)35, 0.1232);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)620, "C-Term MET N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)621, "C-Term MET CA", (DuMM::AtomClassIndex)1, -0.2441);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)622, "C-Term MET C", (DuMM::AtomClassIndex)2, 0.8013);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)623, "C-Term MET HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)624, "C-Term MET OXT", (DuMM::AtomClassIndex)25, -0.8105);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)625, "C-Term MET HA", (DuMM::AtomClassIndex)35, 0.1277);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)626, "C-Term LYS N", (DuMM::AtomClassIndex)14, -0.3481);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)627, "C-Term LYS CA", (DuMM::AtomClassIndex)1, -0.2964);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)628, "C-Term LYS C", (DuMM::AtomClassIndex)2, 0.8488);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)629, "C-Term LYS HN", (DuMM::AtomClassIndex)29, 0.2764);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)630, "C-Term LYS OXT", (DuMM::AtomClassIndex)25, -0.8252);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)631, "C-Term LYS HA", (DuMM::AtomClassIndex)35, 0.1438);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)632, "C-Term ARG N", (DuMM::AtomClassIndex)14, -0.3481);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)633, "C-Term ARG CA", (DuMM::AtomClassIndex)1, -0.3117);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)634, "C-Term ARG C", (DuMM::AtomClassIndex)2, 0.8557);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)635, "C-Term ARG HN", (DuMM::AtomClassIndex)29, 0.2764);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)636, "C-Term ARG OXT", (DuMM::AtomClassIndex)25, -0.8266);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)637, "C-Term ARG HA", (DuMM::AtomClassIndex)35, 0.1447);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)638, "C-Term ORN N", (DuMM::AtomClassIndex)14, -0.3481);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)639, "C-Term ORN CA", (DuMM::AtomClassIndex)1, -0.2964);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)640, "C-Term ORN C", (DuMM::AtomClassIndex)2, 0.8488);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)641, "C-Term ORN HN", (DuMM::AtomClassIndex)29, 0.2764);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)642, "C-Term ORN OXT", (DuMM::AtomClassIndex)25, -0.8252);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)643, "C-Term ORN HA", (DuMM::AtomClassIndex)35, 0.1438);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)644, "C-Term AIB N", (DuMM::AtomClassIndex)14, -0.3821);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)645, "C-Term AIB CA", (DuMM::AtomClassIndex)1, -0.0572);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)646, "C-Term AIB C", (DuMM::AtomClassIndex)2, 0.8);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)647, "C-Term AIB HN", (DuMM::AtomClassIndex)29, 0.2681);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)648, "C-Term AIB OXT", (DuMM::AtomClassIndex)25, -0.82);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1001, "R-Adenosine O5'", (DuMM::AtomClassIndex)23, -0.4989);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1002, "R-Adenosine C5'", (DuMM::AtomClassIndex)1, 0.0558);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1003, "R-Adenosine H5'1", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1004, "R-Adenosine H5'2", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1005, "R-Adenosine C4'", (DuMM::AtomClassIndex)1, 0.1065);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1006, "R-Adenosine H4'", (DuMM::AtomClassIndex)35, 0.1174);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1007, "R-Adenosine O4'", (DuMM::AtomClassIndex)23, -0.3548);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1008, "R-Adenosine C1'", (DuMM::AtomClassIndex)1, 0.0394);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1009, "R-Adenosine H1'", (DuMM::AtomClassIndex)36, 0.2007);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1010, "R-Adenosine C3'", (DuMM::AtomClassIndex)1, 0.2022);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1011, "R-Adenosine H3'", (DuMM::AtomClassIndex)35, 0.0615);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1012, "R-Adenosine C2'", (DuMM::AtomClassIndex)1, 0.067);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1013, "R-Adenosine H2'1", (DuMM::AtomClassIndex)35, 0.0972);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1014, "R-Adenosine O2'", (DuMM::AtomClassIndex)22, -0.6139);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1015, "R-Adenosine HO'2", (DuMM::AtomClassIndex)31, 0.4186);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1016, "R-Adenosine O3'", (DuMM::AtomClassIndex)23, -0.5246);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1017, "R-Adenosine N9", (DuMM::AtomClassIndex)18, -0.0251);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1018, "R-Adenosine C4", (DuMM::AtomClassIndex)9, 0.3053);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1019, "R-Adenosine C5", (DuMM::AtomClassIndex)9, 0.0515);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1020, "R-Adenosine N7", (DuMM::AtomClassIndex)16, -0.6073);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1021, "R-Adenosine C8", (DuMM::AtomClassIndex)12, 0.2006);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1022, "R-Adenosine N3", (DuMM::AtomClassIndex)17, -0.6997);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1023, "R-Adenosine C2", (DuMM::AtomClassIndex)13, 0.5875);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1024, "R-Adenosine N1", (DuMM::AtomClassIndex)17, -0.7615);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1025, "R-Adenosine C6", (DuMM::AtomClassIndex)3, 0.7009);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1026, "R-Adenosine H2", (DuMM::AtomClassIndex)40, 0.0473);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1027, "R-Adenosine N6", (DuMM::AtomClassIndex)19, -0.9019);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1028, "R-Adenosine H61", (DuMM::AtomClassIndex)29, 0.4115);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1029, "R-Adenosine H62", (DuMM::AtomClassIndex)29, 0.4115);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1030, "R-Adenosine H8", (DuMM::AtomClassIndex)40, 0.1553);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1031, "R-Guanosine O5'", (DuMM::AtomClassIndex)23, -0.4989);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1032, "R-Guanosine C5'", (DuMM::AtomClassIndex)1, 0.0558);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1033, "R-Guanosine H5'1", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1034, "R-Guanosine H5'2", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1035, "R-Guanosine C4'", (DuMM::AtomClassIndex)1, 0.1065);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1036, "R-Guanosine H4'", (DuMM::AtomClassIndex)35, 0.1174);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1037, "R-Guanosine O4'", (DuMM::AtomClassIndex)23, -0.3548);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1038, "R-Guanosine C1'", (DuMM::AtomClassIndex)1, 0.0191);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1039, "R-Guanosine H1'", (DuMM::AtomClassIndex)36, 0.2006);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1040, "R-Guanosine C3'", (DuMM::AtomClassIndex)1, 0.2022);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1041, "R-Guanosine H3'", (DuMM::AtomClassIndex)35, 0.0615);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1042, "R-Guanosine C2'", (DuMM::AtomClassIndex)1, 0.067);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1043, "R-Guanosine H2'1", (DuMM::AtomClassIndex)35, 0.0972);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1044, "R-Guanosine O2'", (DuMM::AtomClassIndex)22, -0.6139);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1045, "R-Guanosine HO'2", (DuMM::AtomClassIndex)31, 0.4186);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1046, "R-Guanosine O3'", (DuMM::AtomClassIndex)23, -0.5246);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1047, "R-Guanosine N9", (DuMM::AtomClassIndex)18, 0.0492);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1048, "R-Guanosine C4", (DuMM::AtomClassIndex)9, 0.1222);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1049, "R-Guanosine C5", (DuMM::AtomClassIndex)9, 0.1744);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1050, "R-Guanosine N7", (DuMM::AtomClassIndex)16, -0.5709);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1051, "R-Guanosine C8", (DuMM::AtomClassIndex)12, 0.1374);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1052, "R-Guanosine N3", (DuMM::AtomClassIndex)17, -0.6323);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1053, "R-Guanosine C2", (DuMM::AtomClassIndex)3, 0.7657);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1054, "R-Guanosine N1", (DuMM::AtomClassIndex)15, -0.4787);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1055, "R-Guanosine C6", (DuMM::AtomClassIndex)2, 0.477);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1056, "R-Guanosine H1", (DuMM::AtomClassIndex)29, 0.3424);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1057, "R-Guanosine N2", (DuMM::AtomClassIndex)19, -0.9672);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1058, "R-Guanosine H21", (DuMM::AtomClassIndex)29, 0.4364);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1059, "R-Guanosine H22", (DuMM::AtomClassIndex)29, 0.4364);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1060, "R-Guanosine O6", (DuMM::AtomClassIndex)24, -0.5597);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1061, "R-Guanosine H8", (DuMM::AtomClassIndex)40, 0.164);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1062, "R-Cytosine O5'", (DuMM::AtomClassIndex)23, -0.4989);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1063, "R-Cytosine C5'", (DuMM::AtomClassIndex)1, 0.0558);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1064, "R-Cytosine H5'1", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1065, "R-Cytosine H5'2", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1066, "R-Cytosine C4'", (DuMM::AtomClassIndex)1, 0.1065);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1067, "R-Cytosine H4'", (DuMM::AtomClassIndex)35, 0.1174);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1068, "R-Cytosine O4'", (DuMM::AtomClassIndex)23, -0.3548);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1069, "R-Cytosine C1'", (DuMM::AtomClassIndex)1, 0.0066);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1070, "R-Cytosine H1'", (DuMM::AtomClassIndex)36, 0.2029);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1071, "R-Cytosine C3'", (DuMM::AtomClassIndex)1, 0.2022);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1072, "R-Cytosine H3'", (DuMM::AtomClassIndex)35, 0.0615);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1073, "R-Cytosine C2'", (DuMM::AtomClassIndex)1, 0.067);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1074, "R-Cytosine H2'1", (DuMM::AtomClassIndex)35, 0.0972);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1075, "R-Cytosine O2'", (DuMM::AtomClassIndex)22, -0.6139);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1076, "R-Cytosine HO'2", (DuMM::AtomClassIndex)31, 0.4186);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1077, "R-Cytosine O3'", (DuMM::AtomClassIndex)23, -0.5246);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1078, "R-Cytosine N1", (DuMM::AtomClassIndex)18, -0.0484);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1079, "R-Cytosine C2", (DuMM::AtomClassIndex)2, 0.7538);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1080, "R-Cytosine N3", (DuMM::AtomClassIndex)17, -0.7584);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1081, "R-Cytosine C4", (DuMM::AtomClassIndex)3, 0.8185);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1082, "R-Cytosine C5", (DuMM::AtomClassIndex)4, -0.5215);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1083, "R-Cytosine C6", (DuMM::AtomClassIndex)4, 0.0053);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1084, "R-Cytosine O2", (DuMM::AtomClassIndex)24, -0.6252);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1085, "R-Cytosine N4", (DuMM::AtomClassIndex)19, -0.953);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1086, "R-Cytosine H41", (DuMM::AtomClassIndex)29, 0.4234);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1087, "R-Cytosine H42", (DuMM::AtomClassIndex)29, 0.4234);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1088, "R-Cytosine H5", (DuMM::AtomClassIndex)33, 0.1928);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1089, "R-Cytosine H6", (DuMM::AtomClassIndex)39, 0.1958);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1090, "R-Uracil O5'", (DuMM::AtomClassIndex)23, -0.4989);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1091, "R-Uracil C5'", (DuMM::AtomClassIndex)1, 0.0558);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1092, "R-Uracil H5'1", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1093, "R-Uracil H5'2", (DuMM::AtomClassIndex)35, 0.0679);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1094, "R-Uracil C4'", (DuMM::AtomClassIndex)1, 0.1065);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1095, "R-Uracil H4'", (DuMM::AtomClassIndex)35, 0.1174);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1096, "R-Uracil O4'", (DuMM::AtomClassIndex)23, -0.3548);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1097, "R-Uracil C1'", (DuMM::AtomClassIndex)1, 0.0674);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1098, "R-Uracil H1'", (DuMM::AtomClassIndex)36, 0.1824);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1099, "R-Uracil C3'", (DuMM::AtomClassIndex)1, 0.2022);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1100, "R-Uracil H3'", (DuMM::AtomClassIndex)35, 0.0615);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1101, "R-Uracil C2'", (DuMM::AtomClassIndex)1, 0.067);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1102, "R-Uracil H2'1", (DuMM::AtomClassIndex)35, 0.0972);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1103, "R-Uracil O2'", (DuMM::AtomClassIndex)22, -0.6139);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1104, "R-Uracil HO'2", (DuMM::AtomClassIndex)31, 0.4186);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1105, "R-Uracil O3'", (DuMM::AtomClassIndex)23, -0.5246);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1106, "R-Uracil N1", (DuMM::AtomClassIndex)18, 0.0418);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1107, "R-Uracil C2", (DuMM::AtomClassIndex)2, 0.4687);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1108, "R-Uracil N3", (DuMM::AtomClassIndex)15, -0.3549);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1109, "R-Uracil C4", (DuMM::AtomClassIndex)2, 0.5952);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1110, "R-Uracil C5", (DuMM::AtomClassIndex)4, -0.3635);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1111, "R-Uracil C6", (DuMM::AtomClassIndex)4, -0.1126);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1112, "R-Uracil O2", (DuMM::AtomClassIndex)24, -0.5477);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1113, "R-Uracil H3", (DuMM::AtomClassIndex)29, 0.3154);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1114, "R-Uracil O4", (DuMM::AtomClassIndex)24, -0.5761);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1115, "R-Uracil H5", (DuMM::AtomClassIndex)33, 0.1811);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1116, "R-Uracil H6", (DuMM::AtomClassIndex)39, 0.2188);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1117, "D-Adenosine O5'", (DuMM::AtomClassIndex)23, -0.4954);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1118, "D-Adenosine C5'", (DuMM::AtomClassIndex)1, -0.0069);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1119, "D-Adenosine H5'1", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1120, "D-Adenosine H5'2", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1121, "D-Adenosine C4'", (DuMM::AtomClassIndex)1, 0.1629);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1122, "D-Adenosine H4'", (DuMM::AtomClassIndex)35, 0.1176);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1123, "D-Adenosine O4'", (DuMM::AtomClassIndex)23, -0.3691);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1124, "D-Adenosine C1'", (DuMM::AtomClassIndex)1, 0.0431);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1125, "D-Adenosine H1'", (DuMM::AtomClassIndex)36, 0.1838);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1126, "D-Adenosine C3'", (DuMM::AtomClassIndex)1, 0.0713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1127, "D-Adenosine H3'", (DuMM::AtomClassIndex)35, 0.0985);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1128, "D-Adenosine C2'", (DuMM::AtomClassIndex)1, -0.0854);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1129, "D-Adenosine H2'1", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1130, "D-Adenosine H2'2", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1131, "D-Adenosine O3'", (DuMM::AtomClassIndex)23, -0.5232);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1132, "D-Adenosine N9", (DuMM::AtomClassIndex)18, -0.0268);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1133, "D-Adenosine C4", (DuMM::AtomClassIndex)9, 0.38);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1134, "D-Adenosine C5", (DuMM::AtomClassIndex)9, 0.0725);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1135, "D-Adenosine N7", (DuMM::AtomClassIndex)16, -0.6175);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1136, "D-Adenosine C8", (DuMM::AtomClassIndex)12, 0.1607);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1137, "D-Adenosine N3", (DuMM::AtomClassIndex)17, -0.7417);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1138, "D-Adenosine C2", (DuMM::AtomClassIndex)13, 0.5716);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1139, "D-Adenosine N1", (DuMM::AtomClassIndex)17, -0.7624);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1140, "D-Adenosine C6", (DuMM::AtomClassIndex)3, 0.6897);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1141, "D-Adenosine H2", (DuMM::AtomClassIndex)40, 0.0598);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1142, "D-Adenosine N6", (DuMM::AtomClassIndex)19, -0.9123);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1143, "D-Adenosine H61", (DuMM::AtomClassIndex)29, 0.4167);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1144, "D-Adenosine H62", (DuMM::AtomClassIndex)29, 0.4167);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1145, "D-Adenosine H8", (DuMM::AtomClassIndex)40, 0.1877);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1146, "D-Guanosine O5'", (DuMM::AtomClassIndex)23, -0.4954);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1147, "D-Guanosine C5'", (DuMM::AtomClassIndex)1, -0.0069);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1148, "D-Guanosine H5'1", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1149, "D-Guanosine H5'2", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1150, "D-Guanosine C4'", (DuMM::AtomClassIndex)1, 0.1629);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1151, "D-Guanosine H4'", (DuMM::AtomClassIndex)35, 0.1176);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1152, "D-Guanosine O4'", (DuMM::AtomClassIndex)23, -0.3691);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1153, "D-Guanosine C1'", (DuMM::AtomClassIndex)1, 0.0358);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1154, "D-Guanosine H1'", (DuMM::AtomClassIndex)36, 0.1746);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1155, "D-Guanosine C3'", (DuMM::AtomClassIndex)1, 0.0713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1156, "D-Guanosine H3'", (DuMM::AtomClassIndex)35, 0.0985);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1157, "D-Guanosine C2'", (DuMM::AtomClassIndex)1, -0.0854);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1158, "D-Guanosine H2'1", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1159, "D-Guanosine H2'2", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1160, "D-Guanosine O3'", (DuMM::AtomClassIndex)23, -0.5232);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1161, "D-Guanosine N9", (DuMM::AtomClassIndex)18, 0.0577);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1162, "D-Guanosine C4", (DuMM::AtomClassIndex)9, 0.1814);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1163, "D-Guanosine C5", (DuMM::AtomClassIndex)9, 0.1991);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1164, "D-Guanosine N7", (DuMM::AtomClassIndex)16, -0.5725);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1165, "D-Guanosine C8", (DuMM::AtomClassIndex)12, 0.0736);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1166, "D-Guanosine N3", (DuMM::AtomClassIndex)17, -0.6636);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1167, "D-Guanosine C2", (DuMM::AtomClassIndex)3, 0.7432);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1168, "D-Guanosine N1", (DuMM::AtomClassIndex)15, -0.5053);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1169, "D-Guanosine C6", (DuMM::AtomClassIndex)2, 0.4918);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1170, "D-Guanosine H1", (DuMM::AtomClassIndex)29, 0.352);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1171, "D-Guanosine N2", (DuMM::AtomClassIndex)19, -0.923);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1172, "D-Guanosine H21", (DuMM::AtomClassIndex)29, 0.4235);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1173, "D-Guanosine H22", (DuMM::AtomClassIndex)29, 0.4235);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1174, "D-Guanosine O6", (DuMM::AtomClassIndex)24, -0.5699);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1175, "D-Guanosine H8", (DuMM::AtomClassIndex)40, 0.1997);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1176, "D-Cytosine O5'", (DuMM::AtomClassIndex)23, -0.4954);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1177, "D-Cytosine C5'", (DuMM::AtomClassIndex)1, -0.0069);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1178, "D-Cytosine H5'1", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1179, "D-Cytosine H5'2", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1180, "D-Cytosine C4'", (DuMM::AtomClassIndex)1, 0.1629);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1181, "D-Cytosine H4'", (DuMM::AtomClassIndex)35, 0.1176);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1182, "D-Cytosine O4'", (DuMM::AtomClassIndex)23, -0.3691);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1183, "D-Cytosine C1'", (DuMM::AtomClassIndex)1, -0.0116);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1184, "D-Cytosine H1'", (DuMM::AtomClassIndex)36, 0.1963);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1185, "D-Cytosine C3'", (DuMM::AtomClassIndex)1, 0.0713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1186, "D-Cytosine H3'", (DuMM::AtomClassIndex)35, 0.0985);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1187, "D-Cytosine C2'", (DuMM::AtomClassIndex)1, -0.0854);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1188, "D-Cytosine H2'1", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1189, "D-Cytosine H2'2", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1190, "D-Cytosine O3'", (DuMM::AtomClassIndex)23, -0.5232);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1191, "D-Cytosine N1", (DuMM::AtomClassIndex)18, -0.0339);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1192, "D-Cytosine C2", (DuMM::AtomClassIndex)2, 0.7959);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1193, "D-Cytosine N3", (DuMM::AtomClassIndex)17, -0.7748);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1194, "D-Cytosine C4", (DuMM::AtomClassIndex)3, 0.8439);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1195, "D-Cytosine C5", (DuMM::AtomClassIndex)4, -0.5222);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1196, "D-Cytosine C6", (DuMM::AtomClassIndex)4, -0.0183);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1197, "D-Cytosine O2", (DuMM::AtomClassIndex)24, -0.6548);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1198, "D-Cytosine N4", (DuMM::AtomClassIndex)19, -0.9773);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1199, "D-Cytosine H41", (DuMM::AtomClassIndex)29, 0.4314);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1200, "D-Cytosine H42", (DuMM::AtomClassIndex)29, 0.4314);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1201, "D-Cytosine H5", (DuMM::AtomClassIndex)33, 0.1863);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1202, "D-Cytosine H6", (DuMM::AtomClassIndex)39, 0.2293);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1203, "D-Thymine O5'", (DuMM::AtomClassIndex)23, -0.4954);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1204, "D-Thymine C5'", (DuMM::AtomClassIndex)1, -0.0069);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1205, "D-Thymine H5'1", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1206, "D-Thymine H5'2", (DuMM::AtomClassIndex)35, 0.0754);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1207, "D-Thymine C4'", (DuMM::AtomClassIndex)1, 0.1629);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1208, "D-Thymine H4'", (DuMM::AtomClassIndex)35, 0.1176);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1209, "D-Thymine O4'", (DuMM::AtomClassIndex)23, -0.3691);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1210, "D-Thymine C1'", (DuMM::AtomClassIndex)1, 0.068);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1211, "D-Thymine H1'", (DuMM::AtomClassIndex)36, 0.1804);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1212, "D-Thymine C3'", (DuMM::AtomClassIndex)1, 0.0713);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1213, "D-Thymine H3'", (DuMM::AtomClassIndex)35, 0.0985);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1214, "D-Thymine C2'", (DuMM::AtomClassIndex)1, -0.0854);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1215, "D-Thymine H2'1", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1216, "D-Thymine H2'2", (DuMM::AtomClassIndex)34, 0.0718);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1217, "D-Thymine O3'", (DuMM::AtomClassIndex)23, -0.5232);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1218, "D-Thymine N1", (DuMM::AtomClassIndex)18, -0.0239);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1219, "D-Thymine C2", (DuMM::AtomClassIndex)2, 0.5677);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1220, "D-Thymine N3", (DuMM::AtomClassIndex)15, -0.434);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1221, "D-Thymine C4", (DuMM::AtomClassIndex)2, 0.5194);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1222, "D-Thymine C5", (DuMM::AtomClassIndex)4, 0.0025);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1223, "D-Thymine C6", (DuMM::AtomClassIndex)4, -0.2209);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1224, "D-Thymine O2", (DuMM::AtomClassIndex)24, -0.5881);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1225, "D-Thymine H3", (DuMM::AtomClassIndex)29, 0.342);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1226, "D-Thymine O4", (DuMM::AtomClassIndex)24, -0.5563);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1227, "D-Thymine C7", (DuMM::AtomClassIndex)1, -0.2269);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1228, "D-Thymine H7", (DuMM::AtomClassIndex)34, 0.077);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1229, "D-Thymine H6", (DuMM::AtomClassIndex)39, 0.2607);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1230, "R-Phosphodiester P", (DuMM::AtomClassIndex)28, 1.1662);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1231, "R-Phosphodiester OP", (DuMM::AtomClassIndex)25, -0.776);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1232, "R-5'-Hydroxyl O5'", (DuMM::AtomClassIndex)22, -0.6223);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1233, "R-5'-Hydroxyl H5T", (DuMM::AtomClassIndex)31, 0.4295);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1234, "R-5'-Phosphate O5'", (DuMM::AtomClassIndex)23, -0.6328);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1235, "R-5'-Phosphate P", (DuMM::AtomClassIndex)28, 0.9);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1236, "R-5'-Phosphate OP", (DuMM::AtomClassIndex)25, -0.82);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1237, "R-3'-Hydroxyl O3'", (DuMM::AtomClassIndex)22, -0.6541);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1238, "R-3'-Hydroxyl H3T", (DuMM::AtomClassIndex)31, 0.4376);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1239, "R-3'-Phosphate O3'", (DuMM::AtomClassIndex)23, -0.6565);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1240, "R-3'-Phosphate P", (DuMM::AtomClassIndex)28, 0.9);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1241, "R-3'-Phosphate OP", (DuMM::AtomClassIndex)25, -0.82);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1242, "D-Phosphodiester P", (DuMM::AtomClassIndex)28, 1.1659);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1243, "D-Phosphodiester OP", (DuMM::AtomClassIndex)25, -0.7761);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1244, "D-5'-Hydroxyl O5'", (DuMM::AtomClassIndex)22, -0.6318);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1245, "D-5'-Hydroxyl H5T", (DuMM::AtomClassIndex)31, 0.4422);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1246, "D-5'-Phosphate O5'", (DuMM::AtomClassIndex)23, -0.6296);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1247, "D-5'-Phosphate P", (DuMM::AtomClassIndex)28, 0.9);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1248, "D-5'-Phosphate OP", (DuMM::AtomClassIndex)25, -0.82);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1249, "D-3'-Hydroxyl O3'", (DuMM::AtomClassIndex)22, -0.6549);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1250, "D-3'-Hydroxyl H3T", (DuMM::AtomClassIndex)31, 0.4396);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1251, "D-3'-Phosphate O3'", (DuMM::AtomClassIndex)23, -0.6553);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1252, "D-3'-Phosphate P", (DuMM::AtomClassIndex)28, 0.9);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)1253, "D-3'-Phosphate OP", (DuMM::AtomClassIndex)25, -0.82);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2001, "TIP3P Oxygen", (DuMM::AtomClassIndex)21, -0.834);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2002, "TIP3P Hydrogen", (DuMM::AtomClassIndex)30, 0.417);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2003, "Li+ Lithium Ion", (DuMM::AtomClassIndex)41, 1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2004, "Na+ Sodium Ion", (DuMM::AtomClassIndex)42, 1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2005, "K+ Potassium Ion", (DuMM::AtomClassIndex)43, 1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2006, "Rb+ Rubidium Ion", (DuMM::AtomClassIndex)44, 1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2007, "Cs+ Cesium Ion", (DuMM::AtomClassIndex)45, 1);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2008, "Mg+2 Magnesium Ion", (DuMM::AtomClassIndex)46, 2);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2009, "Ca+2 Calcium Ion", (DuMM::AtomClassIndex)47, 2);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2010, "Zn+2 Zinc Ion", (DuMM::AtomClassIndex)48, 2);
    dumm.defineChargedAtomType((DuMM::ChargedAtomTypeIndex)2011, "Cl- Chloride Ion", (DuMM::AtomClassIndex)49, -1);

    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, 129704, 0.1526);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, 132633, 0.1522);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)3, 132633, 0.151);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)4, 132633, 0.151);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, 132633, 0.1504);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, 132633, 0.1495);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, 141001, 0.1449);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, 141001, 0.1475);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)19, 141001, 0.1463);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 153553, 0.1471);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 133888, 0.141);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 133888, 0.141);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, 94976.8, 0.181);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)27, 99160.8, 0.181);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 142256, 0.109);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 142256, 0.109);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 142256, 0.109);
    dumm.defineBondStretch((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 142256, 0.109);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)3, 196230, 0.1409);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, 171544, 0.1444);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)9, 187025, 0.1419);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, 205016, 0.1335);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, 174891, 0.1388);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)17, 191209, 0.1358);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, 177402, 0.1383);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 238488, 0.1229);
    dumm.defineBondStretch((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)25, 274470, 0.125);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, 196230, 0.14);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, 178657, 0.1433);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, 196230, 0.1404);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, 196230, 0.14);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, 178657, 0.1381);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, 202087, 0.1339);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 201250, 0.134);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)22, 188280, 0.1364);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)39, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, 229702, 0.135);
    dumm.defineBondStretch((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, 187443, 0.1365);
    dumm.defineBondStretch((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)40, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, 214221, 0.1375);
    dumm.defineBondStretch((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, 216731, 0.1371);
    dumm.defineBondStretch((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, 176565, 0.1385);
    dumm.defineBondStretch((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, 171544, 0.1394);
    dumm.defineBondStretch((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)16, 171544, 0.1394);
    dumm.defineBondStretch((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)39, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)10, 228446, 0.1352);
    dumm.defineBondStretch((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, 178657, 0.1381);
    dumm.defineBondStretch((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, 199577, 0.1343);
    dumm.defineBondStretch((DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)16, 204179, 0.1335);
    dumm.defineBondStretch((DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, 217568, 0.137);
    dumm.defineBondStretch((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, 162339, 0.1459);
    dumm.defineBondStretch((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, 187025, 0.1419);
    dumm.defineBondStretch((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, 173218, 0.1391);
    dumm.defineBondStretch((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, 192882, 0.1354);
    dumm.defineBondStretch((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, 182422, 0.1374);
    dumm.defineBondStretch((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)34, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, 179075, 0.138);
    dumm.defineBondStretch((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)16, 221334, 0.1304);
    dumm.defineBondStretch((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)18, 184096, 0.1371);
    dumm.defineBondStretch((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)40, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)17, 210037, 0.1324);
    dumm.defineBondStretch((DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)40, 153553, 0.108);
    dumm.defineBondStretch((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 181586, 0.101);
    dumm.defineBondStretch((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 181586, 0.101);
    dumm.defineBondStretch((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)29, 181586, 0.101);
    dumm.defineBondStretch((DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 181586, 0.101);
    dumm.defineBondStretch((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)29, 181586, 0.101);
    dumm.defineBondStretch((DuMM::AtomClassIndex)21, (DuMM::AtomClassIndex)30, 231375, 0.09572);
    dumm.defineBondStretch((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)28, 96232, 0.161);
    dumm.defineBondStretch((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)31, 231375, 0.096);
    dumm.defineBondStretch((DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)28, 96232, 0.161);
    dumm.defineBondStretch((DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)31, 231375, 0.096);
    dumm.defineBondStretch((DuMM::AtomClassIndex)25, (DuMM::AtomClassIndex)28, 219660, 0.148);
    dumm.defineBondStretch((DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)26, 69454.4, 0.2038);
    dumm.defineBondStretch((DuMM::AtomClassIndex)27, (DuMM::AtomClassIndex)32, 114642, 0.1336);
    dumm.defineBondStretch((DuMM::AtomClassIndex)30, (DuMM::AtomClassIndex)30, 231375, 0.15136);

    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(1), 167.36, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(2), 263.592, 111.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(3), 263.592, 114);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(5), 263.592, 113.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(10), 263.592, 115.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(14), 334.72, 109.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(18), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(19), 334.72, 111.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(20), 334.72, 111.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(22), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(23), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(26), 209.2, 114.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(27), 209.2, 108.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(36), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(38), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(14), 292.88, 116.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 120.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(25), 292.88, 117);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(3), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(2), 292.88, 119.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(4), 292.88, 119.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(6), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(7), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(15), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(16), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(10), DuMM::AtomClassIndex(7), 292.88, 125);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(10), DuMM::AtomClassIndex(9), 292.88, 128.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(14), DuMM::AtomClassIndex(1), 209.2, 118);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(14), DuMM::AtomClassIndex(2), 209.2, 121.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(14), DuMM::AtomClassIndex(29), 209.2, 118.04);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(2), 292.88, 117.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(4), 292.88, 121.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(9), 292.88, 125.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(12), 292.88, 128.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(19), DuMM::AtomClassIndex(3), 209.2, 123.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(19), DuMM::AtomClassIndex(29), 209.2, 118.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(20), DuMM::AtomClassIndex(1), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(20), DuMM::AtomClassIndex(29), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(22), DuMM::AtomClassIndex(31), 230.12, 108.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(23), DuMM::AtomClassIndex(1), 251.04, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(23), DuMM::AtomClassIndex(28), 418.4, 120.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(26), DuMM::AtomClassIndex(1), 259.408, 98.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(26), DuMM::AtomClassIndex(26), 284.512, 103.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)1, DuMM::AtomClassIndex(27), DuMM::AtomClassIndex(32), 179.912, 96);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(14), 263.592, 110.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(20), 334.72, 111.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(38), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(3), 263.592, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(33), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(4), 263.592, 120.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(33), 209.2, 119.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(39), 209.2, 119.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(9), 263.592, 119.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(16), 292.88, 130);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(14), DuMM::AtomClassIndex(29), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(2), 292.88, 126.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(3), 292.88, 125.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(29), 209.2, 116.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(17), DuMM::AtomClassIndex(3), 292.88, 120.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(4), 292.88, 121.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)2, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(29), 209.2, 119.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(3), 263.592, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(3), 263.592, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(9), 263.592, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(11), 263.592, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(22), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(33), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(4), 263.592, 117);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(33), 209.2, 123.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(39), 209.2, 123.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(9), 263.592, 117.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(10), 263.592, 134.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(11), 263.592, 116.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(16), 292.88, 132.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(11), DuMM::AtomClassIndex(9), 263.592, 122.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(11), DuMM::AtomClassIndex(15), 292.88, 132.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(29), 209.2, 118);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(17), DuMM::AtomClassIndex(9), 292.88, 112.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(17), DuMM::AtomClassIndex(13), 292.88, 118.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(19), DuMM::AtomClassIndex(29), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)3, DuMM::AtomClassIndex(22), DuMM::AtomClassIndex(31), 209.2, 113);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(15), 292.88, 114.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 125.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(17), 292.88, 121.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(19), 292.88, 120.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(18), 292.88, 121.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(33), 209.2, 119.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(39), 209.2, 119.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)4, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(29), 209.2, 121.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(6), DuMM::AtomClassIndex(16), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(6), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(7), DuMM::AtomClassIndex(15), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(7), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(8), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(29), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)5, DuMM::AtomClassIndex(16), DuMM::AtomClassIndex(8), 292.88, 117);
    dumm.defineBondBend((DuMM::AtomClassIndex)6, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(15), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)6, DuMM::AtomClassIndex(16), DuMM::AtomClassIndex(8), 292.88, 117);
    dumm.defineBondBend((DuMM::AtomClassIndex)7, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(15), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)7, DuMM::AtomClassIndex(5), DuMM::AtomClassIndex(16), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)7, DuMM::AtomClassIndex(10), DuMM::AtomClassIndex(9), 263.592, 106.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)7, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(8), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)7, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(11), 292.88, 111.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)7, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(29), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)8, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(29), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(15), 292.88, 111.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 128.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(17), 292.88, 117.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(19), 292.88, 123.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(33), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(16), 292.88, 110.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(17), 292.88, 127.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(18), 292.88, 106.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(11), DuMM::AtomClassIndex(15), 292.88, 104.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(16), DuMM::AtomClassIndex(12), 292.88, 103.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(17), DuMM::AtomClassIndex(13), 292.88, 111);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(12), 292.88, 105.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)9, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(29), 209.2, 125.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)10, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)10, DuMM::AtomClassIndex(7), DuMM::AtomClassIndex(15), 292.88, 108.7);
    dumm.defineBondBend((DuMM::AtomClassIndex)10, DuMM::AtomClassIndex(7), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)10, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(11), 263.592, 108.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)11, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(33), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)11, DuMM::AtomClassIndex(15), DuMM::AtomClassIndex(29), 209.2, 123.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)12, DuMM::AtomClassIndex(18), DuMM::AtomClassIndex(29), 209.2, 128.8);
    dumm.defineBondBend((DuMM::AtomClassIndex)14, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)14, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 122.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(18), 292.88, 115.4);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 120.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(17), 292.88, 123.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(19), 292.88, 116);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(7), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(8), DuMM::AtomClassIndex(15), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(8), DuMM::AtomClassIndex(16), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)15, DuMM::AtomClassIndex(8), DuMM::AtomClassIndex(40), 209.2, 120);

    nowDoSecondHalf(dumm);
}


static void nowDoSecondHalf(DuMMForceFieldSubsystem& dumm) {    
    dumm.defineBondBend((DuMM::AtomClassIndex)16, DuMM::AtomClassIndex(6), DuMM::AtomClassIndex(39), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)16, DuMM::AtomClassIndex(8), DuMM::AtomClassIndex(40), 209.2, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)16, DuMM::AtomClassIndex(12), DuMM::AtomClassIndex(18), 292.88, 113.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)16, DuMM::AtomClassIndex(12), DuMM::AtomClassIndex(40), 209.2, 123.05);
    dumm.defineBondBend((DuMM::AtomClassIndex)17, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(18), 292.88, 118.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)17, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 122.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)17, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(19), 292.88, 119.3);
    dumm.defineBondBend((DuMM::AtomClassIndex)17, DuMM::AtomClassIndex(9), DuMM::AtomClassIndex(18), 292.88, 126.2);
    dumm.defineBondBend((DuMM::AtomClassIndex)17, DuMM::AtomClassIndex(13), DuMM::AtomClassIndex(17), 292.88, 129.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)17, DuMM::AtomClassIndex(13), DuMM::AtomClassIndex(40), 209.2, 115.45);
    dumm.defineBondBend((DuMM::AtomClassIndex)18, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(23), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)18, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)18, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(36), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)18, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 120.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)18, DuMM::AtomClassIndex(4), DuMM::AtomClassIndex(39), 209.2, 119.1);
    dumm.defineBondBend((DuMM::AtomClassIndex)18, DuMM::AtomClassIndex(12), DuMM::AtomClassIndex(40), 209.2, 123.05);
    dumm.defineBondBend((DuMM::AtomClassIndex)19, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)19, DuMM::AtomClassIndex(3), DuMM::AtomClassIndex(19), 292.88, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)20, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)20, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(38), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)21, DuMM::AtomClassIndex(30), DuMM::AtomClassIndex(30), 0, 127.74);
    dumm.defineBondBend((DuMM::AtomClassIndex)22, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)22, DuMM::AtomClassIndex(28), DuMM::AtomClassIndex(23), 188.28, 102.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)22, DuMM::AtomClassIndex(28), DuMM::AtomClassIndex(25), 188.28, 108.23);
    dumm.defineBondBend((DuMM::AtomClassIndex)23, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)23, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(36), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)23, DuMM::AtomClassIndex(28), DuMM::AtomClassIndex(23), 188.28, 102.6);
    dumm.defineBondBend((DuMM::AtomClassIndex)23, DuMM::AtomClassIndex(28), DuMM::AtomClassIndex(25), 418.4, 108.23);
    dumm.defineBondBend((DuMM::AtomClassIndex)24, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(24), 334.72, 126);
    dumm.defineBondBend((DuMM::AtomClassIndex)25, DuMM::AtomClassIndex(2), DuMM::AtomClassIndex(25), 334.72, 126);
    dumm.defineBondBend((DuMM::AtomClassIndex)25, DuMM::AtomClassIndex(28), DuMM::AtomClassIndex(25), 585.76, 119.9);
    dumm.defineBondBend((DuMM::AtomClassIndex)26, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)27, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 209.2, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)28, DuMM::AtomClassIndex(22), DuMM::AtomClassIndex(31), 188.28, 108.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)28, DuMM::AtomClassIndex(23), DuMM::AtomClassIndex(28), 418.4, 120.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)29, DuMM::AtomClassIndex(14), DuMM::AtomClassIndex(29), 146.44, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)29, DuMM::AtomClassIndex(19), DuMM::AtomClassIndex(29), 146.44, 120);
    dumm.defineBondBend((DuMM::AtomClassIndex)29, DuMM::AtomClassIndex(20), DuMM::AtomClassIndex(29), 146.44, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)30, DuMM::AtomClassIndex(21), DuMM::AtomClassIndex(30), 418.4, 104.52);
    dumm.defineBondBend((DuMM::AtomClassIndex)32, DuMM::AtomClassIndex(27), DuMM::AtomClassIndex(32), 146.44, 92.07);
    dumm.defineBondBend((DuMM::AtomClassIndex)34, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(34), 146.44, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)35, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(35), 146.44, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)36, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(36), 146.44, 109.5);
    dumm.defineBondBend((DuMM::AtomClassIndex)38, DuMM::AtomClassIndex(1), DuMM::AtomClassIndex(38), 146.44, 109.5);

    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, 1, 0.8368, 180, 2, 1.046, 180, 3, 0.75312, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)19, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.66944, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, 2, 0.29288, 0, 4, 0.4184, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)25, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)9, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, 1, 2.21752, 0, 3, 0.6276, 180, 4, 2.092, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)9, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)3, 3, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 3, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)29, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)31, 1, 0.1046, 0, 3, 0.66944, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, 3, 1.60247, 0, 2, 0.4184, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)2, 3, 1.60247, 0, 1, 3.3472, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)28, 3, 1.60247, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, 3, 1.39327, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)26, 3, 1.39327, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)27, (DuMM::AtomClassIndex)32, 3, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, 2, 10.46, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 2, 10.46, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, 2, 9.1002, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 9.1002, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)1, 1, 7.9496, 180, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)16, 2, 21.5476, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)39, 2, 21.5476, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, 2, 22.489, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 22.489, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, 2, 5.8576, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.8576, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, 2, 27.3006, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 27.3006, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, 2, 7.0082, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, 2, 7.0082, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 10.46, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, 2, 6.0668, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)17, 2, 6.0668, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 6.0668, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, 2, 7.7404, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 7.7404, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, 2, 6.9036, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, 2, 6.9036, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)16, 2, 7.1128, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)40, 2, 7.1128, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)18, 3, 1.60247, 0, 2, 2.7196, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 1, 5.6484, 180, 2, 3.5564, 180, 3, 0.4184, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 1.60247, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 3, 1.60247, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 1, 5.8576, 180, 2, 11.2968, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)28, (DuMM::AtomClassIndex)22, 3, 1.046, 0, 2, 5.0208, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)28, (DuMM::AtomClassIndex)23, 3, 1.046, 0, 2, 5.0208, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)28, (DuMM::AtomClassIndex)25, 3, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 1.39327, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, 2, 14.644, 0, 3, 2.5104, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)3, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)5, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)10, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)27, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, 1, 3.3472, 0, 2, 3.5564, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)29, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, 2, 22.8028, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, 2, 22.8028, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)12, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, 2, 20.0832, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 20.0832, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, 2, 7.7404, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 7.7404, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)22, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)9, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)31, 2, 3.7656, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, 2, 22.8028, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, 2, 22.8028, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, 2, 7.0082, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)3, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)12, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, 2, 6.3806, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 6.3806, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)9, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, 2, 16.736, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 16.736, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, 2, 17.3636, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, 2, 17.3636, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)17, 2, 28.4512, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)40, 2, 28.4512, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 1, 4.8116, 0, 3, 1.58992, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, 2, 9.1002, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 9.1002, 180, 3, 1.2552, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 2, 0, 180, 1, 10.46, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, 2, 6.0668, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)17, 2, 6.0668, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 6.0668, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)16, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, 2, 20.92, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 20.92, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, 2, 5.8576, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.8576, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, 2, 20.92, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 20.92, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, 2, 5.8576, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.8576, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, 2, 7.0082, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)16, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)9, 2, 6.3806, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)39, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, 2, 20.0832, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)12, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, 2, 17.3636, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, 2, 6.9036, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, 2, 27.3006, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 27.3006, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 6.3806, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)18, 2, 41.84, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)40, 2, 41.84, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, 2, 20.0832, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 20.0832, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)17, 2, 28.4512, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)40, 2, 28.4512, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)16, 2, 7.1128, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)40, 2, 7.1128, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)11, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 2, 0, 180, 1, 10.46, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, 2, 6.9036, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 20.0832, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, 2, 17.3636, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)27, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, 1, 7.1128, 180, 2, 8.368, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)25, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)20, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 9.1002, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)16, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)16, 2, 21.5476, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)39, 2, 21.5476, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, 2, 22.489, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 22.489, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, 2, 22.489, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 22.489, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 12.552, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)17, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 14.644, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, 2, 22.8028, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, 2, 22.8028, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 10.6692, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 10.0416, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)26, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)27, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)25, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)22, 3, 0.602496, 0, 2, 4.9162, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 3, 0.602496, 0, 2, 4.9162, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0, 1, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)23, 3, 0.602496, 0, 2, 4.9162, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0, 1, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)28, (DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)31, 3, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)24, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 1, 3.3472, 0, 3, 0.33472, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)24, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 1, 3.3472, 0, 3, 0.33472, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)24, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 9.1002, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)24, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 1, 8.368, 0, 2, 10.46, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)24, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 5.6484, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)24, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)31, 1, 7.9496, 0, 2, 9.6232, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)25, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)25, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)25, (DuMM::AtomClassIndex)28, (DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)31, 3, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)26, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 1.39327, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)27, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)27, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)28, (DuMM::AtomClassIndex)23, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 1.60247, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 2, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 6.276, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 9.7278, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)20, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)31, (DuMM::AtomClassIndex)22, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.698728, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)32, (DuMM::AtomClassIndex)27, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 1.046, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)33, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 15.167, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)33, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 27.8236, 180);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)34, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)34, 3, 0.6276, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)34, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)34, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)34, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)35, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)35, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)35, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)36, 3, 0.652704, 0);
    dumm.defineBondTorsion((DuMM::AtomClassIndex)35, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)38, 3, 0.652704, 0);

    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 43.932, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)25, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)25, 2, 43.932, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)1, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)1, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)1, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)14, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)1, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)22, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)29, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)33, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 43.932, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)39, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)1, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)29, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 43.932, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)10, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)39, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)11, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)33, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)9, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)1, 2, 4.184, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)6, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)7, (DuMM::AtomClassIndex)5, (DuMM::AtomClassIndex)1, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)8, (DuMM::AtomClassIndex)40, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)16, (DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)12, (DuMM::AtomClassIndex)40, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)17, (DuMM::AtomClassIndex)13, (DuMM::AtomClassIndex)40, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)4, (DuMM::AtomClassIndex)39, 2, 4.6024, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)18, (DuMM::AtomClassIndex)15, (DuMM::AtomClassIndex)2, (DuMM::AtomClassIndex)24, 2, 43.932, 180);
    dumm.defineAmberImproperTorsion((DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)19, (DuMM::AtomClassIndex)3, (DuMM::AtomClassIndex)19, 2, 43.932, 180);

    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1), Biotype::get("Glycine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(2), Biotype::get("Glycine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(3), Biotype::get("Glycine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(4), Biotype::get("Glycine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(5), Biotype::get("Glycine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(6), Biotype::get("Glycine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(7), Biotype::get("Alanine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(8), Biotype::get("Alanine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(9), Biotype::get("Alanine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(10), Biotype::get("Alanine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(11), Biotype::get("Alanine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(12), Biotype::get("Alanine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(13), Biotype::get("Alanine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(14), Biotype::get("Alanine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(15), Biotype::get("Valine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(16), Biotype::get("Valine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(17), Biotype::get("Valine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(18), Biotype::get("Valine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(19), Biotype::get("Valine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(20), Biotype::get("Valine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(21), Biotype::get("Valine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(22), Biotype::get("Valine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(23), Biotype::get("Valine", "CG1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(24), Biotype::get("Valine", "HG1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(25), Biotype::get("Valine", "CG2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(26), Biotype::get("Valine", "HG2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(27), Biotype::get("Leucine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(28), Biotype::get("Leucine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(29), Biotype::get("Leucine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(30), Biotype::get("Leucine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(31), Biotype::get("Leucine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(32), Biotype::get("Leucine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(33), Biotype::get("Leucine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(34), Biotype::get("Leucine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(35), Biotype::get("Leucine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(36), Biotype::get("Leucine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(37), Biotype::get("Leucine", "CD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(38), Biotype::get("Leucine", "HD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(39), Biotype::get("Leucine", "CD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(40), Biotype::get("Leucine", "HD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(41), Biotype::get("Isoleucine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(42), Biotype::get("Isoleucine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(43), Biotype::get("Isoleucine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(44), Biotype::get("Isoleucine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(45), Biotype::get("Isoleucine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(46), Biotype::get("Isoleucine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(47), Biotype::get("Isoleucine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(48), Biotype::get("Isoleucine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(49), Biotype::get("Isoleucine", "CG1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(50), Biotype::get("Isoleucine", "HG1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(51), Biotype::get("Isoleucine", "CG2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(52), Biotype::get("Isoleucine", "HG2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(53), Biotype::get("Isoleucine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(54), Biotype::get("Isoleucine", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(55), Biotype::get("Serine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(56), Biotype::get("Serine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(57), Biotype::get("Serine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(58), Biotype::get("Serine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(59), Biotype::get("Serine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(60), Biotype::get("Serine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(61), Biotype::get("Serine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(62), Biotype::get("Serine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(63), Biotype::get("Serine", "OG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(64), Biotype::get("Serine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(65), Biotype::get("Threonine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(66), Biotype::get("Threonine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(67), Biotype::get("Threonine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(68), Biotype::get("Threonine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(69), Biotype::get("Threonine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(70), Biotype::get("Threonine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(71), Biotype::get("Threonine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(72), Biotype::get("Threonine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(73), Biotype::get("Threonine", "OG1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(74), Biotype::get("Threonine", "HG1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(75), Biotype::get("Threonine", "CG2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(76), Biotype::get("Threonine", "HG2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(77), Biotype::get("Cysteine (-SH)", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(78), Biotype::get("Cysteine (-SH)", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(79), Biotype::get("Cysteine (-SH)", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(80), Biotype::get("Cysteine (-SH)", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(81), Biotype::get("Cysteine (-SH)", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(82), Biotype::get("Cysteine (-SH)", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(83), Biotype::get("Cysteine (-SH)", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(84), Biotype::get("Cysteine (-SH)", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(85), Biotype::get("Cysteine (-SH)", "SG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(86), Biotype::get("Cysteine (-SH)", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(87), Biotype::get("Cystine (-SS-)", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(88), Biotype::get("Cystine (-SS-)", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(89), Biotype::get("Cystine (-SS-)", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(90), Biotype::get("Cystine (-SS-)", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(91), Biotype::get("Cystine (-SS-)", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(92), Biotype::get("Cystine (-SS-)", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(93), Biotype::get("Cystine (-SS-)", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(94), Biotype::get("Cystine (-SS-)", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(95), Biotype::get("Cystine (-SS-)", "SG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(96), Biotype::get("Proline", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(97), Biotype::get("Proline", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(98), Biotype::get("Proline", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(99), Biotype::get("Proline", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(100), Biotype::get("Proline", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(101), Biotype::get("Proline", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(102), Biotype::get("Proline", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(103), Biotype::get("Proline", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(104), Biotype::get("Proline", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(105), Biotype::get("Proline", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(106), Biotype::get("Proline", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(107), Biotype::get("Phenylalanine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(108), Biotype::get("Phenylalanine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(109), Biotype::get("Phenylalanine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(110), Biotype::get("Phenylalanine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(111), Biotype::get("Phenylalanine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(112), Biotype::get("Phenylalanine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(113), Biotype::get("Phenylalanine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(114), Biotype::get("Phenylalanine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(115), Biotype::get("Phenylalanine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(116), Biotype::get("Phenylalanine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(117), Biotype::get("Phenylalanine", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(118), Biotype::get("Phenylalanine", "CE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(119), Biotype::get("Phenylalanine", "HE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(120), Biotype::get("Phenylalanine", "CZ", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(121), Biotype::get("Phenylalanine", "HZ", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(122), Biotype::get("Tyrosine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(123), Biotype::get("Tyrosine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(124), Biotype::get("Tyrosine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(125), Biotype::get("Tyrosine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(126), Biotype::get("Tyrosine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(127), Biotype::get("Tyrosine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(128), Biotype::get("Tyrosine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(129), Biotype::get("Tyrosine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(130), Biotype::get("Tyrosine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(131), Biotype::get("Tyrosine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(132), Biotype::get("Tyrosine", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(133), Biotype::get("Tyrosine", "CE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(134), Biotype::get("Tyrosine", "HE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(135), Biotype::get("Tyrosine", "CZ", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(136), Biotype::get("Tyrosine", "OH", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(137), Biotype::get("Tyrosine", "HH", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(138), Biotype::get("Tryptophan", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(139), Biotype::get("Tryptophan", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(140), Biotype::get("Tryptophan", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(141), Biotype::get("Tryptophan", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(142), Biotype::get("Tryptophan", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(143), Biotype::get("Tryptophan", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(144), Biotype::get("Tryptophan", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(145), Biotype::get("Tryptophan", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(146), Biotype::get("Tryptophan", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(147), Biotype::get("Tryptophan", "CD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(148), Biotype::get("Tryptophan", "HD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(149), Biotype::get("Tryptophan", "CD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(150), Biotype::get("Tryptophan", "NE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(151), Biotype::get("Tryptophan", "HE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(152), Biotype::get("Tryptophan", "CE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(153), Biotype::get("Tryptophan", "CE3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(154), Biotype::get("Tryptophan", "HE3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(155), Biotype::get("Tryptophan", "CZ2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(156), Biotype::get("Tryptophan", "HZ2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(157), Biotype::get("Tryptophan", "CZ3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(158), Biotype::get("Tryptophan", "HZ3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(159), Biotype::get("Tryptophan", "CH2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(160), Biotype::get("Tryptophan", "HH2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(161), Biotype::get("Histidine (+)", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(162), Biotype::get("Histidine (+)", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(163), Biotype::get("Histidine (+)", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(164), Biotype::get("Histidine (+)", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(165), Biotype::get("Histidine (+)", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(166), Biotype::get("Histidine (+)", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(167), Biotype::get("Histidine (+)", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(168), Biotype::get("Histidine (+)", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(169), Biotype::get("Histidine (+)", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(170), Biotype::get("Histidine (+)", "ND1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(171), Biotype::get("Histidine (+)", "HD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(172), Biotype::get("Histidine (+)", "CD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(173), Biotype::get("Histidine (+)", "HD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(174), Biotype::get("Histidine (+)", "CE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(175), Biotype::get("Histidine (+)", "HE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(176), Biotype::get("Histidine (+)", "NE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(177), Biotype::get("Histidine (+)", "HE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(178), Biotype::get("Histidine (HD)", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(179), Biotype::get("Histidine (HD)", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(180), Biotype::get("Histidine (HD)", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(181), Biotype::get("Histidine (HD)", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(182), Biotype::get("Histidine (HD)", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(183), Biotype::get("Histidine (HD)", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(184), Biotype::get("Histidine (HD)", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(185), Biotype::get("Histidine (HD)", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(186), Biotype::get("Histidine (HD)", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(187), Biotype::get("Histidine (HD)", "ND1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(188), Biotype::get("Histidine (HD)", "HD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(189), Biotype::get("Histidine (HD)", "CD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(190), Biotype::get("Histidine (HD)", "HD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(191), Biotype::get("Histidine (HD)", "CE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(192), Biotype::get("Histidine (HD)", "HE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(193), Biotype::get("Histidine (HD)", "NE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(194), Biotype::get("Histidine (HE)", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(195), Biotype::get("Histidine (HE)", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(196), Biotype::get("Histidine (HE)", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(197), Biotype::get("Histidine (HE)", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(198), Biotype::get("Histidine (HE)", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(199), Biotype::get("Histidine (HE)", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(200), Biotype::get("Histidine (HE)", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(201), Biotype::get("Histidine (HE)", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(202), Biotype::get("Histidine (HE)", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(203), Biotype::get("Histidine (HE)", "ND1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(204), Biotype::get("Histidine (HE)", "CD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(205), Biotype::get("Histidine (HE)", "HD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(206), Biotype::get("Histidine (HE)", "CE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(207), Biotype::get("Histidine (HE)", "HE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(208), Biotype::get("Histidine (HE)", "NE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(209), Biotype::get("Histidine (HE)", "HE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(210), Biotype::get("Aspartic Acid", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(211), Biotype::get("Aspartic Acid", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(212), Biotype::get("Aspartic Acid", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(213), Biotype::get("Aspartic Acid", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(214), Biotype::get("Aspartic Acid", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(215), Biotype::get("Aspartic Acid", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(216), Biotype::get("Aspartic Acid", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(217), Biotype::get("Aspartic Acid", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(218), Biotype::get("Aspartic Acid", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(219), Biotype::get("Aspartic Acid", "OD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(220), Biotype::get("Asparagine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(221), Biotype::get("Asparagine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(222), Biotype::get("Asparagine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(223), Biotype::get("Asparagine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(224), Biotype::get("Asparagine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(225), Biotype::get("Asparagine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(226), Biotype::get("Asparagine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(227), Biotype::get("Asparagine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(228), Biotype::get("Asparagine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(229), Biotype::get("Asparagine", "OD1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(230), Biotype::get("Asparagine", "ND2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(231), Biotype::get("Asparagine", "HD2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(232), Biotype::get("Glutamic Acid", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(233), Biotype::get("Glutamic Acid", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(234), Biotype::get("Glutamic Acid", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(235), Biotype::get("Glutamic Acid", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(236), Biotype::get("Glutamic Acid", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(237), Biotype::get("Glutamic Acid", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(238), Biotype::get("Glutamic Acid", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(239), Biotype::get("Glutamic Acid", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(240), Biotype::get("Glutamic Acid", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(241), Biotype::get("Glutamic Acid", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(242), Biotype::get("Glutamic Acid", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(243), Biotype::get("Glutamic Acid", "OE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(244), Biotype::get("Glutamine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(245), Biotype::get("Glutamine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(246), Biotype::get("Glutamine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(247), Biotype::get("Glutamine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(248), Biotype::get("Glutamine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(249), Biotype::get("Glutamine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(250), Biotype::get("Glutamine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(251), Biotype::get("Glutamine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(252), Biotype::get("Glutamine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(253), Biotype::get("Glutamine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(254), Biotype::get("Glutamine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(255), Biotype::get("Glutamine", "OE1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(256), Biotype::get("Glutamine", "NE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(257), Biotype::get("Glutamine", "HE2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(258), Biotype::get("Methionine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(259), Biotype::get("Methionine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(260), Biotype::get("Methionine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(261), Biotype::get("Methionine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(262), Biotype::get("Methionine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(263), Biotype::get("Methionine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(264), Biotype::get("Methionine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(265), Biotype::get("Methionine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(266), Biotype::get("Methionine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(267), Biotype::get("Methionine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(268), Biotype::get("Methionine", "SD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(269), Biotype::get("Methionine", "CE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(270), Biotype::get("Methionine", "HE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(271), Biotype::get("Lysine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(272), Biotype::get("Lysine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(273), Biotype::get("Lysine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(274), Biotype::get("Lysine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(275), Biotype::get("Lysine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(276), Biotype::get("Lysine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(277), Biotype::get("Lysine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(278), Biotype::get("Lysine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(279), Biotype::get("Lysine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(280), Biotype::get("Lysine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(281), Biotype::get("Lysine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(282), Biotype::get("Lysine", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(283), Biotype::get("Lysine", "CE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(284), Biotype::get("Lysine", "HE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(285), Biotype::get("Lysine", "NZ", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(286), Biotype::get("Lysine", "HZ", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(287), Biotype::get("Arginine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(288), Biotype::get("Arginine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(289), Biotype::get("Arginine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(290), Biotype::get("Arginine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(291), Biotype::get("Arginine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(292), Biotype::get("Arginine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(293), Biotype::get("Arginine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(294), Biotype::get("Arginine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(295), Biotype::get("Arginine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(296), Biotype::get("Arginine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(297), Biotype::get("Arginine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(298), Biotype::get("Arginine", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(299), Biotype::get("Arginine", "NE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(300), Biotype::get("Arginine", "HE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(301), Biotype::get("Arginine", "CZ", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(302), Biotype::get("Arginine", "NH", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(303), Biotype::get("Arginine", "HH", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(304), Biotype::get("Ornithine", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(305), Biotype::get("Ornithine", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(306), Biotype::get("Ornithine", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(307), Biotype::get("Ornithine", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(308), Biotype::get("Ornithine", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(309), Biotype::get("Ornithine", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(310), Biotype::get("Ornithine", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(311), Biotype::get("Ornithine", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(312), Biotype::get("Ornithine", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(313), Biotype::get("Ornithine", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(314), Biotype::get("Ornithine", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(315), Biotype::get("Ornithine", "HD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(316), Biotype::get("Ornithine", "NE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(317), Biotype::get("Ornithine", "HE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(318), Biotype::get("MethylAlanine (AIB)", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(319), Biotype::get("MethylAlanine (AIB)", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(320), Biotype::get("MethylAlanine (AIB)", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(321), Biotype::get("MethylAlanine (AIB)", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(322), Biotype::get("MethylAlanine (AIB)", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(323), Biotype::get("MethylAlanine (AIB)", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(324), Biotype::get("MethylAlanine (AIB)", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(325), Biotype::get("Pyroglutamic Acid", "N", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(326), Biotype::get("Pyroglutamic Acid", "CA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(327), Biotype::get("Pyroglutamic Acid", "C", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(328), Biotype::get("Pyroglutamic Acid", "HN", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(329), Biotype::get("Pyroglutamic Acid", "O", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(330), Biotype::get("Pyroglutamic Acid", "HA", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(331), Biotype::get("Pyroglutamic Acid", "CB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(332), Biotype::get("Pyroglutamic Acid", "HB", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(333), Biotype::get("Pyroglutamic Acid", "CG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(334), Biotype::get("Pyroglutamic Acid", "HG", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(335), Biotype::get("Pyroglutamic Acid", "CD", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(336), Biotype::get("Pyroglutamic Acid", "OE", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(340), Biotype::get("Acetyl", "CH3", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(341), Biotype::get("Acetyl", "H", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(342), Biotype::get("Acetyl", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(343), Biotype::get("Acetyl", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(344), Biotype::get("Amide", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(345), Biotype::get("Amide", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(346), Biotype::get("N-MeAmide", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(347), Biotype::get("N-MeAmide", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(348), Biotype::get("N-MeAmide", "CH3", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(349), Biotype::get("N-MeAmide", "H", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(350), Biotype::get("GLY", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(351), Biotype::get("GLY", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(352), Biotype::get("GLY", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(353), Biotype::get("GLY", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(354), Biotype::get("GLY", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(355), Biotype::get("GLY", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(356), Biotype::get("ALA", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(357), Biotype::get("ALA", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(358), Biotype::get("ALA", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(359), Biotype::get("ALA", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(360), Biotype::get("ALA", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(361), Biotype::get("ALA", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(362), Biotype::get("VAL", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(363), Biotype::get("VAL", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(364), Biotype::get("VAL", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(365), Biotype::get("VAL", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(366), Biotype::get("VAL", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(367), Biotype::get("VAL", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(368), Biotype::get("LEU", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(369), Biotype::get("LEU", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(370), Biotype::get("LEU", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(371), Biotype::get("LEU", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(372), Biotype::get("LEU", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(373), Biotype::get("LEU", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(374), Biotype::get("ILE", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(375), Biotype::get("ILE", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(376), Biotype::get("ILE", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(377), Biotype::get("ILE", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(378), Biotype::get("ILE", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(379), Biotype::get("ILE", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(380), Biotype::get("SER", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(381), Biotype::get("SER", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(382), Biotype::get("SER", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(383), Biotype::get("SER", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(384), Biotype::get("SER", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(385), Biotype::get("SER", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(386), Biotype::get("THR", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(387), Biotype::get("THR", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(388), Biotype::get("THR", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(389), Biotype::get("THR", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(390), Biotype::get("THR", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(391), Biotype::get("THR", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(392), Biotype::get("CYS (-SH)", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(393), Biotype::get("CYS (-SH)", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(394), Biotype::get("CYS (-SH)", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(395), Biotype::get("CYS (-SH)", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(396), Biotype::get("CYS (-SH)", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(397), Biotype::get("CYS (-SH)", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(398), Biotype::get("CYS (-SS)", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(399), Biotype::get("CYS (-SS)", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(400), Biotype::get("CYS (-SS)", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(401), Biotype::get("CYS (-SS)", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(402), Biotype::get("CYS (-SS)", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(403), Biotype::get("CYS (-SS)", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(404), Biotype::get("PRO", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(405), Biotype::get("PRO", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(406), Biotype::get("PRO", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(407), Biotype::get("PRO", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(408), Biotype::get("PRO", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(409), Biotype::get("PRO", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(410), Biotype::get("PRO", "CD", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(411), Biotype::get("PRO", "HD", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(412), Biotype::get("PHE", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(413), Biotype::get("PHE", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(414), Biotype::get("PHE", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(415), Biotype::get("PHE", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(416), Biotype::get("PHE", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(417), Biotype::get("PHE", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(418), Biotype::get("TYR", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(419), Biotype::get("TYR", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(420), Biotype::get("TYR", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(421), Biotype::get("TYR", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(422), Biotype::get("TYR", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(423), Biotype::get("TYR", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(424), Biotype::get("TRP", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(425), Biotype::get("TRP", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(426), Biotype::get("TRP", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(427), Biotype::get("TRP", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(428), Biotype::get("TRP", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(429), Biotype::get("TRP", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(430), Biotype::get("HIS (+)", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(431), Biotype::get("HIS (+)", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(432), Biotype::get("HIS (+)", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(433), Biotype::get("HIS (+)", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(434), Biotype::get("HIS (+)", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(435), Biotype::get("HIS (+)", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(436), Biotype::get("HIS (HD)", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(437), Biotype::get("HIS (HD)", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(438), Biotype::get("HIS (HD)", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(439), Biotype::get("HIS (HD)", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(440), Biotype::get("HIS (HD)", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(441), Biotype::get("HIS (HD)", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(442), Biotype::get("HIS (HE)", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(443), Biotype::get("HIS (HE)", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(444), Biotype::get("HIS (HE)", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(445), Biotype::get("HIS (HE)", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(446), Biotype::get("HIS (HE)", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(447), Biotype::get("HIS (HE)", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(448), Biotype::get("ASP", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(449), Biotype::get("ASP", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(450), Biotype::get("ASP", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(451), Biotype::get("ASP", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(452), Biotype::get("ASP", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(453), Biotype::get("ASP", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(454), Biotype::get("ASN", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(455), Biotype::get("ASN", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(456), Biotype::get("ASN", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(457), Biotype::get("ASN", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(458), Biotype::get("ASN", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(459), Biotype::get("ASN", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(460), Biotype::get("GLU", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(461), Biotype::get("GLU", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(462), Biotype::get("GLU", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(463), Biotype::get("GLU", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(464), Biotype::get("GLU", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(465), Biotype::get("GLU", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(466), Biotype::get("GLN", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(467), Biotype::get("GLN", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(468), Biotype::get("GLN", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(469), Biotype::get("GLN", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(470), Biotype::get("GLN", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(471), Biotype::get("GLN", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(472), Biotype::get("MET", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(473), Biotype::get("MET", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(474), Biotype::get("MET", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(475), Biotype::get("MET", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(476), Biotype::get("MET", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(477), Biotype::get("MET", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(478), Biotype::get("LYS", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(479), Biotype::get("LYS", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(480), Biotype::get("LYS", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(481), Biotype::get("LYS", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(482), Biotype::get("LYS", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(483), Biotype::get("LYS", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(484), Biotype::get("ARG", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(485), Biotype::get("ARG", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(486), Biotype::get("ARG", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(487), Biotype::get("ARG", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(488), Biotype::get("ARG", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(489), Biotype::get("ARG", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(490), Biotype::get("ORN", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(491), Biotype::get("ORN", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(492), Biotype::get("ORN", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(493), Biotype::get("ORN", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(494), Biotype::get("ORN", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(495), Biotype::get("ORN", "HA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(496), Biotype::get("AIB", "N", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(497), Biotype::get("AIB", "CA", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(498), Biotype::get("AIB", "C", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(499), Biotype::get("AIB", "HN", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(500), Biotype::get("AIB", "O", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(501), Biotype::get("GLY", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(502), Biotype::get("GLY", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(503), Biotype::get("GLY", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(504), Biotype::get("GLY", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(505), Biotype::get("GLY", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(506), Biotype::get("GLY", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(507), Biotype::get("ALA", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(508), Biotype::get("ALA", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(509), Biotype::get("ALA", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(510), Biotype::get("ALA", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(511), Biotype::get("ALA", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(512), Biotype::get("ALA", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(513), Biotype::get("VAL", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(514), Biotype::get("VAL", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(515), Biotype::get("VAL", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(516), Biotype::get("VAL", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(517), Biotype::get("VAL", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(518), Biotype::get("VAL", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(519), Biotype::get("LEU", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(520), Biotype::get("LEU", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(521), Biotype::get("LEU", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(522), Biotype::get("LEU", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(523), Biotype::get("LEU", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(524), Biotype::get("LEU", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(525), Biotype::get("ILE", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(526), Biotype::get("ILE", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(527), Biotype::get("ILE", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(528), Biotype::get("ILE", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(529), Biotype::get("ILE", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(530), Biotype::get("ILE", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(531), Biotype::get("SER", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(532), Biotype::get("SER", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(533), Biotype::get("SER", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(534), Biotype::get("SER", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(535), Biotype::get("SER", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(536), Biotype::get("SER", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(537), Biotype::get("THR", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(538), Biotype::get("THR", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(539), Biotype::get("THR", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(540), Biotype::get("THR", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(541), Biotype::get("THR", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(542), Biotype::get("THR", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(543), Biotype::get("CYS (-SH)", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(544), Biotype::get("CYS (-SH)", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(545), Biotype::get("CYS (-SH)", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(546), Biotype::get("CYS (-SH)", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(547), Biotype::get("CYS (-SH)", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(548), Biotype::get("CYS (-SH)", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(549), Biotype::get("CYS (-SS)", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(550), Biotype::get("CYS (-SS)", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(551), Biotype::get("CYS (-SS)", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(552), Biotype::get("CYS (-SS)", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(553), Biotype::get("CYS (-SS)", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(554), Biotype::get("CYS (-SS)", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(555), Biotype::get("PRO", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(556), Biotype::get("PRO", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(557), Biotype::get("PRO", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(558), Biotype::get("PRO", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(559), Biotype::get("PRO", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(560), Biotype::get("PHE", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(561), Biotype::get("PHE", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(562), Biotype::get("PHE", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(563), Biotype::get("PHE", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(564), Biotype::get("PHE", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(565), Biotype::get("PHE", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(566), Biotype::get("TYR", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(567), Biotype::get("TYR", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(568), Biotype::get("TYR", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(569), Biotype::get("TYR", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(570), Biotype::get("TYR", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(571), Biotype::get("TYR", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(572), Biotype::get("TRP", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(573), Biotype::get("TRP", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(574), Biotype::get("TRP", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(575), Biotype::get("TRP", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(576), Biotype::get("TRP", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(577), Biotype::get("TRP", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(578), Biotype::get("HIS (+)", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(579), Biotype::get("HIS (+)", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(580), Biotype::get("HIS (+)", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(581), Biotype::get("HIS (+)", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(582), Biotype::get("HIS (+)", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(583), Biotype::get("HIS (+)", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(584), Biotype::get("HIS (HD)", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(585), Biotype::get("HIS (HD)", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(586), Biotype::get("HIS (HD)", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(587), Biotype::get("HIS (HD)", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(588), Biotype::get("HIS (HD)", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(589), Biotype::get("HIS (HD)", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(590), Biotype::get("HIS (HE)", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(591), Biotype::get("HIS (HE)", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(592), Biotype::get("HIS (HE)", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(593), Biotype::get("HIS (HE)", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(594), Biotype::get("HIS (HE)", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(595), Biotype::get("HIS (HE)", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(596), Biotype::get("ASP", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(597), Biotype::get("ASP", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(598), Biotype::get("ASP", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(599), Biotype::get("ASP", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(600), Biotype::get("ASP", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(601), Biotype::get("ASP", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(602), Biotype::get("ASN", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(603), Biotype::get("ASN", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(604), Biotype::get("ASN", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(605), Biotype::get("ASN", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(606), Biotype::get("ASN", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(607), Biotype::get("ASN", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(608), Biotype::get("GLU", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(609), Biotype::get("GLU", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(610), Biotype::get("GLU", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(611), Biotype::get("GLU", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(612), Biotype::get("GLU", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(613), Biotype::get("GLU", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(614), Biotype::get("GLN", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(615), Biotype::get("GLN", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(616), Biotype::get("GLN", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(617), Biotype::get("GLN", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(618), Biotype::get("GLN", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(619), Biotype::get("GLN", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(620), Biotype::get("MET", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(621), Biotype::get("MET", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(622), Biotype::get("MET", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(623), Biotype::get("MET", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(624), Biotype::get("MET", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(625), Biotype::get("MET", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(626), Biotype::get("LYS", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(627), Biotype::get("LYS", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(628), Biotype::get("LYS", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(629), Biotype::get("LYS", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(630), Biotype::get("LYS", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(631), Biotype::get("LYS", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(632), Biotype::get("ARG", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(633), Biotype::get("ARG", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(634), Biotype::get("ARG", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(635), Biotype::get("ARG", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(636), Biotype::get("ARG", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(637), Biotype::get("ARG", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(638), Biotype::get("ORN", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(639), Biotype::get("ORN", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(640), Biotype::get("ORN", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(641), Biotype::get("ORN", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(642), Biotype::get("ORN", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(643), Biotype::get("ORN", "HA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(644), Biotype::get("AIB", "N", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(645), Biotype::get("AIB", "CA", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(646), Biotype::get("AIB", "C", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(647), Biotype::get("AIB", "HN", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(648), Biotype::get("AIB", "OXT", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1001), Biotype::get("Adenosine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1002), Biotype::get("Adenosine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1003), Biotype::get("Adenosine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1004), Biotype::get("Adenosine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1005), Biotype::get("Adenosine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1006), Biotype::get("Adenosine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1007), Biotype::get("Adenosine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1008), Biotype::get("Adenosine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1009), Biotype::get("Adenosine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1010), Biotype::get("Adenosine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1011), Biotype::get("Adenosine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1012), Biotype::get("Adenosine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1013), Biotype::get("Adenosine", "H2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1014), Biotype::get("Adenosine", "O2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1015), Biotype::get("Adenosine", "HO'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1016), Biotype::get("Adenosine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1017), Biotype::get("Adenosine", "N9", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1018), Biotype::get("Adenosine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1019), Biotype::get("Adenosine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1020), Biotype::get("Adenosine", "N7", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1021), Biotype::get("Adenosine", "C8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1022), Biotype::get("Adenosine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1023), Biotype::get("Adenosine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1024), Biotype::get("Adenosine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1025), Biotype::get("Adenosine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1026), Biotype::get("Adenosine", "H2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1027), Biotype::get("Adenosine", "N6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1028), Biotype::get("Adenosine", "H61", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1029), Biotype::get("Adenosine", "H62", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1030), Biotype::get("Adenosine", "H8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1031), Biotype::get("Guanosine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1032), Biotype::get("Guanosine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1033), Biotype::get("Guanosine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1034), Biotype::get("Guanosine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1035), Biotype::get("Guanosine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1036), Biotype::get("Guanosine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1037), Biotype::get("Guanosine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1038), Biotype::get("Guanosine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1039), Biotype::get("Guanosine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1040), Biotype::get("Guanosine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1041), Biotype::get("Guanosine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1042), Biotype::get("Guanosine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1043), Biotype::get("Guanosine", "H2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1044), Biotype::get("Guanosine", "O2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1045), Biotype::get("Guanosine", "HO'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1046), Biotype::get("Guanosine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1047), Biotype::get("Guanosine", "N9", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1048), Biotype::get("Guanosine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1049), Biotype::get("Guanosine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1050), Biotype::get("Guanosine", "N7", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1051), Biotype::get("Guanosine", "C8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1052), Biotype::get("Guanosine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1053), Biotype::get("Guanosine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1054), Biotype::get("Guanosine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1055), Biotype::get("Guanosine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1056), Biotype::get("Guanosine", "H1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1057), Biotype::get("Guanosine", "N2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1058), Biotype::get("Guanosine", "H21", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1059), Biotype::get("Guanosine", "H22", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1060), Biotype::get("Guanosine", "O6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1061), Biotype::get("Guanosine", "H8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1062), Biotype::get("Cytidine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1063), Biotype::get("Cytidine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1064), Biotype::get("Cytidine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1065), Biotype::get("Cytidine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1066), Biotype::get("Cytidine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1067), Biotype::get("Cytidine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1068), Biotype::get("Cytidine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1069), Biotype::get("Cytidine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1070), Biotype::get("Cytidine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1071), Biotype::get("Cytidine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1072), Biotype::get("Cytidine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1073), Biotype::get("Cytidine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1074), Biotype::get("Cytidine", "H2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1075), Biotype::get("Cytidine", "O2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1076), Biotype::get("Cytidine", "HO'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1077), Biotype::get("Cytidine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1078), Biotype::get("Cytidine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1079), Biotype::get("Cytidine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1080), Biotype::get("Cytidine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1081), Biotype::get("Cytidine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1082), Biotype::get("Cytidine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1083), Biotype::get("Cytidine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1084), Biotype::get("Cytidine", "O2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1085), Biotype::get("Cytidine", "N4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1086), Biotype::get("Cytidine", "H41", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1087), Biotype::get("Cytidine", "H42", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1088), Biotype::get("Cytidine", "H5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1089), Biotype::get("Cytidine", "H6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1090), Biotype::get("Uridine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1091), Biotype::get("Uridine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1092), Biotype::get("Uridine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1093), Biotype::get("Uridine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1094), Biotype::get("Uridine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1095), Biotype::get("Uridine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1096), Biotype::get("Uridine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1097), Biotype::get("Uridine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1098), Biotype::get("Uridine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1099), Biotype::get("Uridine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1100), Biotype::get("Uridine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1101), Biotype::get("Uridine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1102), Biotype::get("Uridine", "H2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1103), Biotype::get("Uridine", "O2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1104), Biotype::get("Uridine", "HO'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1105), Biotype::get("Uridine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1106), Biotype::get("Uridine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1107), Biotype::get("Uridine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1108), Biotype::get("Uridine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1109), Biotype::get("Uridine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1110), Biotype::get("Uridine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1111), Biotype::get("Uridine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1112), Biotype::get("Uridine", "O2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1113), Biotype::get("Uridine", "H3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1114), Biotype::get("Uridine", "O4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1115), Biotype::get("Uridine", "H5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1116), Biotype::get("Uridine", "H6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1117), Biotype::get("Deoxyadenosine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1118), Biotype::get("Deoxyadenosine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1119), Biotype::get("Deoxyadenosine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1120), Biotype::get("Deoxyadenosine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1121), Biotype::get("Deoxyadenosine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1122), Biotype::get("Deoxyadenosine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1123), Biotype::get("Deoxyadenosine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1124), Biotype::get("Deoxyadenosine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1125), Biotype::get("Deoxyadenosine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1126), Biotype::get("Deoxyadenosine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1127), Biotype::get("Deoxyadenosine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1128), Biotype::get("Deoxyadenosine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1129), Biotype::get("Deoxyadenosine", "H2'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1130), Biotype::get("Deoxyadenosine", "H2'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1131), Biotype::get("Deoxyadenosine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1132), Biotype::get("Deoxyadenosine", "N9", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1133), Biotype::get("Deoxyadenosine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1134), Biotype::get("Deoxyadenosine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1135), Biotype::get("Deoxyadenosine", "N7", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1136), Biotype::get("Deoxyadenosine", "C8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1137), Biotype::get("Deoxyadenosine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1138), Biotype::get("Deoxyadenosine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1139), Biotype::get("Deoxyadenosine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1140), Biotype::get("Deoxyadenosine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1141), Biotype::get("Deoxyadenosine", "H2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1142), Biotype::get("Deoxyadenosine", "N6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1143), Biotype::get("Deoxyadenosine", "H61", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1144), Biotype::get("Deoxyadenosine", "H62", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1145), Biotype::get("Deoxyadenosine", "H8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1146), Biotype::get("Deoxyguanosine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1147), Biotype::get("Deoxyguanosine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1148), Biotype::get("Deoxyguanosine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1149), Biotype::get("Deoxyguanosine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1150), Biotype::get("Deoxyguanosine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1151), Biotype::get("Deoxyguanosine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1152), Biotype::get("Deoxyguanosine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1153), Biotype::get("Deoxyguanosine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1154), Biotype::get("Deoxyguanosine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1155), Biotype::get("Deoxyguanosine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1156), Biotype::get("Deoxyguanosine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1157), Biotype::get("Deoxyguanosine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1158), Biotype::get("Deoxyguanosine", "H2'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1159), Biotype::get("Deoxyguanosine", "H2'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1160), Biotype::get("Deoxyguanosine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1161), Biotype::get("Deoxyguanosine", "N9", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1162), Biotype::get("Deoxyguanosine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1163), Biotype::get("Deoxyguanosine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1164), Biotype::get("Deoxyguanosine", "N7", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1165), Biotype::get("Deoxyguanosine", "C8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1166), Biotype::get("Deoxyguanosine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1167), Biotype::get("Deoxyguanosine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1168), Biotype::get("Deoxyguanosine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1169), Biotype::get("Deoxyguanosine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1170), Biotype::get("Deoxyguanosine", "H1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1171), Biotype::get("Deoxyguanosine", "N2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1172), Biotype::get("Deoxyguanosine", "H21", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1173), Biotype::get("Deoxyguanosine", "H22", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1174), Biotype::get("Deoxyguanosine", "O6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1175), Biotype::get("Deoxyguanosine", "H8", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1176), Biotype::get("Deoxycytidine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1177), Biotype::get("Deoxycytidine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1178), Biotype::get("Deoxycytidine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1179), Biotype::get("Deoxycytidine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1180), Biotype::get("Deoxycytidine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1181), Biotype::get("Deoxycytidine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1182), Biotype::get("Deoxycytidine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1183), Biotype::get("Deoxycytidine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1184), Biotype::get("Deoxycytidine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1185), Biotype::get("Deoxycytidine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1186), Biotype::get("Deoxycytidine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1187), Biotype::get("Deoxycytidine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1188), Biotype::get("Deoxycytidine", "H2'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1189), Biotype::get("Deoxycytidine", "H2'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1190), Biotype::get("Deoxycytidine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1191), Biotype::get("Deoxycytidine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1192), Biotype::get("Deoxycytidine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1193), Biotype::get("Deoxycytidine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1194), Biotype::get("Deoxycytidine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1195), Biotype::get("Deoxycytidine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1196), Biotype::get("Deoxycytidine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1197), Biotype::get("Deoxycytidine", "O2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1198), Biotype::get("Deoxycytidine", "N4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1199), Biotype::get("Deoxycytidine", "H41", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1200), Biotype::get("Deoxycytidine", "H42", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1201), Biotype::get("Deoxycytidine", "H5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1202), Biotype::get("Deoxycytidine", "H6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1203), Biotype::get("Deoxythymidine", "O5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1204), Biotype::get("Deoxythymidine", "C5'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1205), Biotype::get("Deoxythymidine", "H5'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1206), Biotype::get("Deoxythymidine", "H5'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1207), Biotype::get("Deoxythymidine", "C4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1208), Biotype::get("Deoxythymidine", "H4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1209), Biotype::get("Deoxythymidine", "O4'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1210), Biotype::get("Deoxythymidine", "C1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1211), Biotype::get("Deoxythymidine", "H1'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1212), Biotype::get("Deoxythymidine", "C3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1213), Biotype::get("Deoxythymidine", "H3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1214), Biotype::get("Deoxythymidine", "C2'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1215), Biotype::get("Deoxythymidine", "H2'1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1216), Biotype::get("Deoxythymidine", "H2'2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1217), Biotype::get("Deoxythymidine", "O3'", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1218), Biotype::get("Deoxythymidine", "N1", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1219), Biotype::get("Deoxythymidine", "C2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1220), Biotype::get("Deoxythymidine", "N3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1221), Biotype::get("Deoxythymidine", "C4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1222), Biotype::get("Deoxythymidine", "C5", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1223), Biotype::get("Deoxythymidine", "C6", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1224), Biotype::get("Deoxythymidine", "O2", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1225), Biotype::get("Deoxythymidine", "H3", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1226), Biotype::get("Deoxythymidine", "O4", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1227), Biotype::get("Deoxythymidine", "C7", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1228), Biotype::get("Deoxythymidine", "H7", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1229), Biotype::get("Deoxythymidine", "H6", Ordinality::Any).getIndex());

    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1230), Biotype::get("Phosphodiester, RNA", "P", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1231), Biotype::get("Phosphodiester, RNA", "OP", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1232), Biotype::get("Hydroxyl, RNA", "O5'", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1233), Biotype::get("Hydroxyl, RNA", "H5T", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1234), Biotype::get("Phosphate, RNA", "O5'", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1235), Biotype::get("Phosphate, RNA", "P", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1236), Biotype::get("Phosphate, RNA", "OP", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1237), Biotype::get("Hydroxyl, RNA", "O3'", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1238), Biotype::get("Hydroxyl, RNA", "H3T", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1239), Biotype::get("Phosphate, RNA", "O3'", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1240), Biotype::get("Phosphate, RNA", "P", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1241), Biotype::get("Phosphate, RNA", "OP", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1242), Biotype::get("Phosphodiester, DNA", "P", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1243), Biotype::get("Phosphodiester, DNA", "OP", Ordinality::Any).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1244), Biotype::get("Hydroxyl, DNA", "O5'", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1245), Biotype::get("Hydroxyl, DNA", "H5T", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1246), Biotype::get("Phosphate, DNA", "O5'", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1247), Biotype::get("Phosphate, DNA", "P", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1248), Biotype::get("Phosphate, DNA", "OP", Ordinality::Initial).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1249), Biotype::get("Hydroxyl, DNA", "O3'", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1250), Biotype::get("Hydroxyl, DNA", "H3T", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1251), Biotype::get("Phosphate, DNA", "O3'", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1252), Biotype::get("Phosphate, DNA", "P", Ordinality::Final).getIndex());
    dumm.setBiotypeChargedAtomType(DuMM::ChargedAtomTypeIndex(1253), Biotype::get("Phosphate, DNA", "OP", Ordinality::Final).getIndex());

    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2003, Biotype::get("Lithium Ion", "Li+").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2004, Biotype::get("Sodium Ion", "Na+").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2005, Biotype::get("Potassium Ion", "K+").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2006, Biotype::get("Rubidium Ion", "Rb+").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2007, Biotype::get("Cesium Ion", "Cs+").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2008, Biotype::get("Magnesium Ion", "Mg+2").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2009, Biotype::get("Calcium Ion", "Ca+2").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2010, Biotype::get("Zinc Ion", "Zn+2").getIndex());
    dumm.setBiotypeChargedAtomType((DuMM::ChargedAtomTypeIndex)2011, Biotype::get("Chloride Ion", "Cl-").getIndex());

    dumm.setVdwMixingRule(DuMMForceFieldSubsystem::LorentzBerthelot);
    dumm.setVdw12ScaleFactor(0);
    dumm.setVdw13ScaleFactor(0);
    dumm.setVdw14ScaleFactor(0.5);
    dumm.setVdw15ScaleFactor(1);
    dumm.setCoulomb12ScaleFactor(0);
    dumm.setCoulomb13ScaleFactor(0);
    dumm.setCoulomb14ScaleFactor(0.833333);
    dumm.setCoulomb15ScaleFactor(1);

    //dumm.setVdwGlobalScaleFactor(1);
    //dumm.setCoulombGlobalScaleFactor(1);
    //dumm.setBondStretchGlobalScaleFactor(1);
    //dumm.setBondBendGlobalScaleFactor(1);
    //dumm.setBondTorsionGlobalScaleFactor(1);
    //dumm.setAmberImproperTorsionGlobalScaleFactor(1);
}


} // namespace SimTK
