/*
 * Copyright (c) 2008-2014 MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mongodb;

/**
 * This exception is thrown when there is an exception writing a response to a Socket.
 *
 * @since 3.0
 */
public class MongoSocketWriteException extends MongoSocketException {
    private static final long serialVersionUID = 5088061954415484493L;

    /**
     * Construct a new instance.
     *
     * @param message the message
     * @param address the address
     * @param cause the cause
     */
    public MongoSocketWriteException(final String message, final ServerAddress address, final Throwable cause) {
        super(message, address, cause);
    }
}
