/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ClientInformationList.h>
#include <DataNode.h>
#include <ClientInformation.h>

// ****************************************************************************
// Method: ClientInformationList::ClientInformationList
//
// Purpose: 
//   Init utility for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ClientInformationList::Init()
{

    ClientInformationList::SelectAll();
}

// ****************************************************************************
// Method: ClientInformationList::ClientInformationList
//
// Purpose: 
//   Copy utility for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ClientInformationList::Copy(const ClientInformationList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the clients field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = clients.begin(); pos != clients.end(); ++pos)
        delete *pos;
    clients.clear();
    if(obj.clients.size() > 0)
        clients.reserve(obj.clients.size());
    // Duplicate the clients from obj.
    for(pos = obj.clients.begin(); pos != obj.clients.end(); ++pos)
    {
        ClientInformation *oldClientInformation = (ClientInformation *)(*pos);
        ClientInformation *newClientInformation = new ClientInformation(*oldClientInformation);
        clients.push_back(newClientInformation);
    }


    ClientInformationList::SelectAll();
}

// Type map format string
const char *ClientInformationList::TypeMapFormatString = CLIENTINFORMATIONLIST_TMFS;
const AttributeGroup::private_tmfs_t ClientInformationList::TmfsStruct = {CLIENTINFORMATIONLIST_TMFS};


// ****************************************************************************
// Method: ClientInformationList::ClientInformationList
//
// Purpose: 
//   Default constructor for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformationList::ClientInformationList() : 
    AttributeSubject(ClientInformationList::TypeMapFormatString)
{
    ClientInformationList::Init();
}

// ****************************************************************************
// Method: ClientInformationList::ClientInformationList
//
// Purpose: 
//   Constructor for the derived classes of ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformationList::ClientInformationList(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ClientInformationList::Init();
}

// ****************************************************************************
// Method: ClientInformationList::ClientInformationList
//
// Purpose: 
//   Copy constructor for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformationList::ClientInformationList(const ClientInformationList &obj) : 
    AttributeSubject(ClientInformationList::TypeMapFormatString)
{
    ClientInformationList::Copy(obj);
}

// ****************************************************************************
// Method: ClientInformationList::ClientInformationList
//
// Purpose: 
//   Copy constructor for derived classes of the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformationList::ClientInformationList(const ClientInformationList &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ClientInformationList::Copy(obj);
}

// ****************************************************************************
// Method: ClientInformationList::~ClientInformationList
//
// Purpose: 
//   Destructor for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformationList::~ClientInformationList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the clients field.
    for(pos = clients.begin(); pos != clients.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: ClientInformationList::operator = 
//
// Purpose: 
//   Assignment operator for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformationList& 
ClientInformationList::operator = (const ClientInformationList &obj)
{
    if (this == &obj) return *this;

    ClientInformationList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ClientInformationList::operator == 
//
// Purpose: 
//   Comparison operator == for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformationList::operator == (const ClientInformationList &obj) const
{
    bool clients_equal = (obj.clients.size() == clients.size());
    for(size_t i = 0; (i < clients.size()) && clients_equal; ++i)
    {
        // Make references to ClientInformation from AttributeGroup *.
        const ClientInformation &clients1 = *((const ClientInformation *)(clients[i]));
        const ClientInformation &clients2 = *((const ClientInformation *)(obj.clients[i]));
        clients_equal = (clients1 == clients2);
    }

    // Create the return value
    return (clients_equal);
}

// ****************************************************************************
// Method: ClientInformationList::operator != 
//
// Purpose: 
//   Comparison operator != for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformationList::operator != (const ClientInformationList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ClientInformationList::TypeName
//
// Purpose: 
//   Type name method for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ClientInformationList::TypeName() const
{
    return "ClientInformationList";
}

// ****************************************************************************
// Method: ClientInformationList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformationList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ClientInformationList *tmp = (const ClientInformationList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ClientInformationList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ClientInformationList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ClientInformationList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ClientInformationList::NewInstance
//
// Purpose: 
//   NewInstance method for the ClientInformationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ClientInformationList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ClientInformationList(*this);
    else
        retval = new ClientInformationList;

    return retval;
}

// ****************************************************************************
// Method: ClientInformationList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ClientInformationList::SelectAll()
{
    Select(ID_clients, (void *)&clients);
}

// ****************************************************************************
// Method: ClientInformationList::CreateSubAttributeGroup
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
ClientInformationList::CreateSubAttributeGroup(int)
{
    return new ClientInformation;
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
ClientInformationList::GetClients() const
{
    return clients;
}

AttributeGroupVector &
ClientInformationList::GetClients()
{
    return clients;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ClientInformationList::SelectClients()
{
    Select(ID_clients, (void *)&clients);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ClientInformationList::AddClients
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ClientInformationList::AddClients(const ClientInformation &obj)
{
    ClientInformation *newClientInformation = new ClientInformation(obj);
    clients.push_back(newClientInformation);

    // Indicate that things have changed by selecting it.
    Select(ID_clients, (void *)&clients);
}

// ****************************************************************************
// Method: ClientInformationList::ClearClients
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ClientInformationList::ClearClients()
{
    AttributeGroupVector::iterator pos;

    for(pos = clients.begin(); pos != clients.end(); ++pos)
        delete *pos;
    clients.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_clients, (void *)&clients);
}

// ****************************************************************************
// Method: ClientInformationList::RemoveClients
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ClientInformationList::RemoveClients(int index)
{
    AttributeGroupVector::iterator pos = clients.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != clients.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != clients.end())
    {
        delete *pos;
        clients.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_clients, (void *)&clients);
}

// ****************************************************************************
// Method: ClientInformationList::GetNumClients
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
ClientInformationList::GetNumClients() const
{
    return (int)clients.size();
}

// ****************************************************************************
// Method: ClientInformationList::GetClients
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation &
ClientInformationList::GetClients(int i)
{
    return *((ClientInformation *)clients[i]);
}

// ****************************************************************************
// Method: ClientInformationList::GetClients
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const ClientInformation &
ClientInformationList::GetClients(int i) const
{
    return *((ClientInformation *)clients[i]);
}

// ****************************************************************************
// Method: ClientInformationList::operator []
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation &
ClientInformationList::operator [] (int i)
{
    return *((ClientInformation *)clients[i]);
}

// ****************************************************************************
// Method: ClientInformationList::operator []
//
// Purpose: 
//   Contains the information for all connected clients.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const ClientInformation &
ClientInformationList::operator [] (int i) const
{
    return *((ClientInformation *)clients[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ClientInformationList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ClientInformationList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_clients: return "clients";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ClientInformationList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ClientInformationList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_clients: return FieldType_attVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ClientInformationList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ClientInformationList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_clients: return "attVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ClientInformationList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformationList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ClientInformationList &obj = *((const ClientInformationList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_clients:
        {  // new scope
        bool clients_equal = (obj.clients.size() == clients.size());
        for(size_t i = 0; (i < clients.size()) && clients_equal; ++i)
        {
            // Make references to ClientInformation from AttributeGroup *.
            const ClientInformation &clients1 = *((const ClientInformation *)(clients[i]));
            const ClientInformation &clients2 = *((const ClientInformation *)(obj.clients[i]));
            clients_equal = (clients1 == clients2);
        }

        retval = clients_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

