/*	$Id: s_paus.c,v 1.3 2008/02/28 16:48:50 ragge Exp $	*/
/*
 * Copyright(C) Caldera International Inc. 2001-2002. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code and documentation must retain the above
 * copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditionsand the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 * 	This product includes software developed or owned by Caldera
 *	International, Inc.
 * Neither the name of Caldera International, Inc. nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * USE OF THE SOFTWARE PROVIDED FOR UNDER THIS LICENSE BY CALDERA
 * INTERNATIONAL, INC. AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CALDERA INTERNATIONAL, INC. BE LIABLE
 * FOR ANY DIRECT, INDIRECT INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OFLIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#include "f77lib.h"

#define PAUSESIG 15

static void waitpause(int);

void
s_paus(char *s, long int n)
{
	int i;

	fprintf(stderr, "PAUSE ");
	if(n > 0)
		for(i = 0; i<n ; ++i)
			putc(*s++, stderr);
	fprintf(stderr, " statement executed\n");
	if( isatty(fileno(stdin)) ) {
		fprintf(stderr, "To resume execution, type go.  "
		    "Any other input will terminate job.\n");
		if( getchar()!='g' || getchar()!='o' || getchar()!='\n' ) {
			fprintf(stderr, "STOP\n");
			f_exit();
			exit(0);
		}
	} else {
		fprintf(stderr, "To resume execution, execute a "
		    "  kill -%d %d   command\n", PAUSESIG, getpid() );
		signal(PAUSESIG, waitpause);
		pause();
	}
	fprintf(stderr, "Execution resumes after PAUSE.\n");
}

static void
waitpause(int a)
{
	return;
}
