#!/usr/bin/python

from os import environ, path
from sys import stdout

from pocketsphinx.pocketsphinx import *
from sphinxbase.sphinxbase import *

MODELDIR = "../../../model"
DATADIR = "../../../test/data"

# Create a decoder with certain model
config = Decoder.default_config()
config.set_string('-hmm', path.join(MODELDIR, 'en-us/en-us'))
config.set_string('-lm', path.join(DATADIR, 'turtle.lm.bin'))
config.set_string('-dict', path.join(DATADIR, 'turtle.dic'))
decoder = Decoder(config)

# Decode with lm
decoder.start_utt()
stream = open(path.join(DATADIR, 'goforward.raw'), 'rb')
while True:
    buf = stream.read(1024)
    if buf:
         decoder.process_raw(buf, False, False)
    else:
         break
decoder.end_utt()
print ('Decoding with "turtle" language:', decoder.hyp().hypstr)

# Switch to JSGF grammar
jsgf = Jsgf(path.join(DATADIR, 'goforward.gram'))
rule = jsgf.get_rule('goforward.move2')
fsg = jsgf.build_fsg(rule, decoder.get_logmath(), 7.5)
fsg.writefile('goforward.fsg')

decoder.set_fsg("goforward", fsg)
decoder.set_search("goforward")

decoder.start_utt()
stream = open(path.join(DATADIR, 'goforward.raw'), 'rb')
while True:
    buf = stream.read(1024)
    if buf:
         decoder.process_raw(buf, False, False)
    else:
         break
decoder.end_utt()
print ('Decoding with "goforward" grammar:', decoder.hyp().hypstr)
