# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class Baseline(msrest.serialization.Model):
    """The baseline values for a single sensitivity value.

    All required parameters must be populated in order to send to Azure.

    :param sensitivity: Required. the sensitivity of the baseline. Possible values include: "Low",
     "Medium", "High".
    :type sensitivity: str or ~$(python-base-namespace).v2017_11_01_preview.models.Sensitivity
    :param low_thresholds: Required. The low thresholds of the baseline.
    :type low_thresholds: list[float]
    :param high_thresholds: Required. The high thresholds of the baseline.
    :type high_thresholds: list[float]
    """

    _validation = {
        'sensitivity': {'required': True},
        'low_thresholds': {'required': True},
        'high_thresholds': {'required': True},
    }

    _attribute_map = {
        'sensitivity': {'key': 'sensitivity', 'type': 'str'},
        'low_thresholds': {'key': 'lowThresholds', 'type': '[float]'},
        'high_thresholds': {'key': 'highThresholds', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        sensitivity: Union[str, "Sensitivity"],
        low_thresholds: List[float],
        high_thresholds: List[float],
        **kwargs
    ):
        super(Baseline, self).__init__(**kwargs)
        self.sensitivity = sensitivity
        self.low_thresholds = low_thresholds
        self.high_thresholds = high_thresholds


class BaselineMetadataValue(msrest.serialization.Model):
    """Represents a baseline metadata value.

    :param name: the name of the metadata.
    :type name: ~$(python-base-namespace).v2017_11_01_preview.models.LocalizableString
    :param value: the value of the metadata.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["LocalizableString"] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(BaselineMetadataValue, self).__init__(**kwargs)
        self.name = name
        self.value = value


class BaselineResponse(msrest.serialization.Model):
    """The response to a baseline query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: the metric baseline Id.
    :vartype id: str
    :ivar type: the resource type of the baseline resource.
    :vartype type: str
    :ivar name: the name and the display name of the metric, i.e. it is localizable string.
    :vartype name: ~$(python-base-namespace).v2017_11_01_preview.models.LocalizableString
    :param timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested.
    :type timespan: str
    :param interval: The interval (window size) for which the metric data was returned in.  This
     may be adjusted in the future and returned back from what was originally requested.  This is
     not present if a metadata request was made.
    :type interval: ~datetime.timedelta
    :param aggregation: The aggregation type of the metric.
    :type aggregation: str
    :param timestamps: the array of timestamps of the baselines.
    :type timestamps: list[~datetime.datetime]
    :param baseline: the baseline values for each sensitivity.
    :type baseline: list[~$(python-base-namespace).v2017_11_01_preview.models.Baseline]
    :param metadata: the baseline metadata values.
    :type metadata: list[~$(python-base-
     namespace).v2017_11_01_preview.models.BaselineMetadataValue]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'timespan': {'key': 'properties.timespan', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'duration'},
        'aggregation': {'key': 'properties.aggregation', 'type': 'str'},
        'timestamps': {'key': 'properties.timestamps', 'type': '[iso-8601]'},
        'baseline': {'key': 'properties.baseline', 'type': '[Baseline]'},
        'metadata': {'key': 'properties.metadata', 'type': '[BaselineMetadataValue]'},
    }

    def __init__(
        self,
        *,
        timespan: Optional[str] = None,
        interval: Optional[datetime.timedelta] = None,
        aggregation: Optional[str] = None,
        timestamps: Optional[List[datetime.datetime]] = None,
        baseline: Optional[List["Baseline"]] = None,
        metadata: Optional[List["BaselineMetadataValue"]] = None,
        **kwargs
    ):
        super(BaselineResponse, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.timespan = timespan
        self.interval = interval
        self.aggregation = aggregation
        self.timestamps = timestamps
        self.baseline = baseline
        self.metadata = metadata


class CalculateBaselineResponse(msrest.serialization.Model):
    """The response to a calculate baseline call.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. the resource type of the baseline resource.
    :type type: str
    :param timestamps: the array of timestamps of the baselines.
    :type timestamps: list[~datetime.datetime]
    :param baseline: Required. the baseline values for each sensitivity.
    :type baseline: list[~$(python-base-namespace).v2017_11_01_preview.models.Baseline]
    """

    _validation = {
        'type': {'required': True},
        'baseline': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'timestamps': {'key': 'timestamps', 'type': '[iso-8601]'},
        'baseline': {'key': 'baseline', 'type': '[Baseline]'},
    }

    def __init__(
        self,
        *,
        type: str,
        baseline: List["Baseline"],
        timestamps: Optional[List[datetime.datetime]] = None,
        **kwargs
    ):
        super(CalculateBaselineResponse, self).__init__(**kwargs)
        self.type = type
        self.timestamps = timestamps
        self.baseline = baseline


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class TimeSeriesInformation(msrest.serialization.Model):
    """The time series info needed for calculating the baseline.

    All required parameters must be populated in order to send to Azure.

    :param sensitivities: Required. the list of sensitivities for calculating the baseline.
    :type sensitivities: list[str]
    :param values: Required. The metric values to calculate the baseline.
    :type values: list[float]
    :param timestamps: the array of timestamps of the baselines.
    :type timestamps: list[~datetime.datetime]
    """

    _validation = {
        'sensitivities': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'sensitivities': {'key': 'sensitivities', 'type': '[str]'},
        'values': {'key': 'values', 'type': '[float]'},
        'timestamps': {'key': 'timestamps', 'type': '[iso-8601]'},
    }

    def __init__(
        self,
        *,
        sensitivities: List[str],
        values: List[float],
        timestamps: Optional[List[datetime.datetime]] = None,
        **kwargs
    ):
        super(TimeSeriesInformation, self).__init__(**kwargs)
        self.sensitivities = sensitivities
        self.values = values
        self.timestamps = timestamps
