# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storagecache import StorageCacheManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageCacheManagementCachesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageCacheManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_list(self, resource_group):
        response = self.client.caches.list(
            api_version="2025-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_list_by_resource_group(self, resource_group):
        response = self.client.caches.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_delete(self, resource_group):
        response = self.client.caches.begin_delete(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_get(self, resource_group):
        response = self.client.caches.get(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_create_or_update(self, resource_group):
        response = self.client.caches.begin_create_or_update(
            resource_group_name=resource_group.name,
            cache_name="str",
            cache={
                "cacheSizeGB": 0,
                "directoryServicesSettings": {
                    "activeDirectory": {
                        "cacheNetBiosName": "str",
                        "domainName": "str",
                        "domainNetBiosName": "str",
                        "primaryDnsIpAddress": "str",
                        "credentials": {"username": "str", "password": "str"},
                        "domainJoined": "str",
                        "secondaryDnsIpAddress": "str",
                    },
                    "usernameDownload": {
                        "autoDownloadCertificate": False,
                        "caCertificateURI": "str",
                        "credentials": {"bindDn": "str", "bindPassword": "str"},
                        "encryptLdapConnection": False,
                        "extendedGroups": bool,
                        "groupFileURI": "str",
                        "ldapBaseDN": "str",
                        "ldapServer": "str",
                        "requireValidCertificate": False,
                        "userFileURI": "str",
                        "usernameDownloaded": "str",
                        "usernameSource": "None",
                    },
                },
                "encryptionSettings": {
                    "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                    "rotationToLatestKeyVersionEnabled": bool,
                },
                "health": {
                    "conditions": [{"message": "str", "timestamp": "2020-02-20 00:00:00"}],
                    "state": "str",
                    "statusDescription": "str",
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "mountAddresses": ["str"],
                "name": "str",
                "networkSettings": {
                    "dnsSearchDomain": "str",
                    "dnsServers": ["str"],
                    "mtu": 1500,
                    "ntpServer": "time.windows.com",
                    "utilityAddresses": ["str"],
                },
                "primingJobs": [
                    {
                        "primingJobName": "str",
                        "primingManifestUrl": "str",
                        "primingJobDetails": "str",
                        "primingJobId": "str",
                        "primingJobPercentComplete": 0.0,
                        "primingJobState": "str",
                        "primingJobStatus": "str",
                    }
                ],
                "provisioningState": "str",
                "securitySettings": {
                    "accessPolicies": [
                        {
                            "accessRules": [
                                {
                                    "access": "str",
                                    "scope": "str",
                                    "anonymousGID": "str",
                                    "anonymousUID": "str",
                                    "filter": "str",
                                    "rootSquash": bool,
                                    "submountAccess": bool,
                                    "suid": bool,
                                }
                            ],
                            "name": "str",
                        }
                    ]
                },
                "sku": {"name": "str"},
                "spaceAllocation": [{"allocationPercentage": 0, "name": "str"}],
                "subnet": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "upgradeSettings": {"scheduledTime": "2020-02-20 00:00:00", "upgradeScheduleEnabled": bool},
                "upgradeStatus": {
                    "currentFirmwareVersion": "str",
                    "firmwareUpdateDeadline": "2020-02-20 00:00:00",
                    "firmwareUpdateStatus": "str",
                    "lastFirmwareUpdate": "2020-02-20 00:00:00",
                    "pendingFirmwareVersion": "str",
                },
                "zones": ["str"],
            },
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_update(self, resource_group):
        response = self.client.caches.begin_update(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_debug_info(self, resource_group):
        response = self.client.caches.begin_debug_info(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_flush(self, resource_group):
        response = self.client.caches.begin_flush(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_start(self, resource_group):
        response = self.client.caches.begin_start(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_stop(self, resource_group):
        response = self.client.caches.begin_stop(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_start_priming_job(self, resource_group):
        response = self.client.caches.begin_start_priming_job(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_stop_priming_job(self, resource_group):
        response = self.client.caches.begin_stop_priming_job(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_pause_priming_job(self, resource_group):
        response = self.client.caches.begin_pause_priming_job(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_resume_priming_job(self, resource_group):
        response = self.client.caches.begin_resume_priming_job(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_upgrade_firmware(self, resource_group):
        response = self.client.caches.begin_upgrade_firmware(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_caches_begin_space_allocation(self, resource_group):
        response = self.client.caches.begin_space_allocation(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
