#!/bin/sh

set -ex

export TAR_OPTIONS='--owner root --group root --mode a+rX'
export GZIP_OPTIONS='-9n'
pwd=$(pwd)
dfsg_version="$1"
if [ -z "$dfsg_version" ]
then
	printf 'Usage: %s <version>\n' "$0"
	exit 1
fi
upstream_version="${dfsg_version%+dfsg*}"
cd "$(dirname "$0")/../"
tmpdir=$(mktemp -t -d get-orig-source.XXXXXX)
uscan --noconf --force-download --rename --download-version="$upstream_version" --destdir="$tmpdir"
cd "$tmpdir"
tar -xzf python-gdata_*.orig.tar.gz
rm python-gdata_*.orig.tar.gz

rm -rf gdata-*/src/gdata/Crypto/*/*.pyd # http://bugs.debian.org/694336

chmod a-x gdata-*/samples/oauth/oauth_on_appengine/appengine_utilities/*.py
chmod a-x gdata-*/samples/blogger/oauth-appengine/*.py
chmod a-x gdata-*/samples/blogger/app/*.py
chmod a-x gdata-*/samples/apps/marketplace_sample/gdata/tlslite/*.py
chmod a-x gdata-*/samples/apps/marketplace_sample/gdata/tlslite/*/*
chmod a-x gdata-*/samples/apps/marketplace_sample/gdata/oauth/*
chmod a-x gdata-*/samples/apps/marketplace_sample/gdata/apps/client.py
chmod a-x gdata-*/samples/apps/marketplace_sample/gdata/apps/multidomain/__init__.py

mv gdata-*/ "python-gdata-${dfsg_version}.orig"
tar -czf "$pwd/python-gdata_${dfsg_version}.orig.tar.gz" python-gdata-*.orig/
cd ..
rm -rf "$tmpdir"
