#
# PySNMP MIB module DOT3-EPON-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/DOT3-EPON-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:10:33 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, OctetString, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "Integer", "OctetString", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsIntersection")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Gauge32, Unsigned32, ModuleIdentity, NotificationType, iso, IpAddress, ObjectIdentity, Counter64, MibScalar, MibTable, MibTableRow, MibTableColumn, mib_2, Integer32, TimeTicks, MibIdentifier, Bits, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Gauge32", "Unsigned32", "ModuleIdentity", "NotificationType", "iso", "IpAddress", "ObjectIdentity", "Counter64", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "mib-2", "Integer32", "TimeTicks", "MibIdentifier", "Bits", "Counter32")
( MacAddress, TruthValue, TextualConvention, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "MacAddress", "TruthValue", "TextualConvention", "DisplayString")
dot3EponMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 155)).setRevisions(("2007-03-29 00:00",))
if mibBuilder.loadTexts: dot3EponMIB.setLastUpdated('200703290000Z')
if mibBuilder.loadTexts: dot3EponMIB.setOrganization('IETF Ethernet Interfaces and Hub MIB Working\n                 Group')
if mibBuilder.loadTexts: dot3EponMIB.setContactInfo('WG charter:\n              http://www.ietf.org/html.charters/hubmib-charter.html\n                  Mailing Lists:\n                    General Discussion: hubmib@ietf.org\n                    To Subscribe: hubmib-request@ietf.org\n\n\n\n                    In Body: subscribe your_email_address\n                    Chair: Bert Wijnen\n                    Postal: Lucent Technologies\n                            Schagen 33\n                            3461 GL Linschoten\n                            Netherlands\n                    Tel: +31-348-407-775\n                    E-mail: bwijnen@lucent.com\n\n                    Editor: Lior Khermosh\n                    Postal: PMC-SIERRA\n                            Kohav Hertzelia bldg,\n                            4 Hasadnaot St.\n                            Hertzliya Pituach 46120,\n                            ISRAEL\n                            P.O.Box 2089 Hertzliya Pituach 46120 Israel\n                    Tel: +972-9-9628000 Ext: 302\n                    E-mail: lior_khermosh@pmc-sierra.com')
if mibBuilder.loadTexts: dot3EponMIB.setDescription("The objects in this MIB module are used to manage the\n             Ethernet in the First Mile (EFM) Ethernet Passive Optical\n             Network (EPON) Interfaces as defined in IEEE P802.3ah\n             clauses 60, 64, and 65.\n         The following reference is used throughout this MIB module:\n           [802.3ah] refers to:\n             Information technology - Telecommunications and\n             information exchange between systems - Local and\n             metropolitan area networks - Specific requirements -\n             Part 3: Carrier sense multiple access with collision\n             detection (CSMA/CD) access method and physical layer\n             specifications - Media Access Control Parameters,\n             Physical Layers and Management Parameters for subscriber\n             access networks.  IEEE Std 802.3ah-2004, October 2004.\n\n          Of particular interest are clause 64 (Multi-Point Control\n          Protocol - MPCP), clause 65 (Point-to-Multipoint\n          Reconciliation Sublayer - P2MP RS), clause 60 (Ethernet\n          Passive Optical Network Physical Medium Dependent - EPON\n          PMDs), clause 30, 'Management', and clause 45, 'Management\n          Data Input/Output (MDIO) Interface'.\n\n          Copyright (C) The IETF Trust (2007).  This version\n          of this MIB module is part of 4837; see the RFC itself for\n          full legal notices.\n\n          Key abbreviations:\n            BER - Bit Error Rate\n            BW - bandwidth\n\n\n\n            CRC - Cyclic Redundancy Check\n            EFM - Ethernet First Mile\n            EPON - Ethernet Passive Optical Network\n            FEC  - Forward Error Correction\n            LLID - Logical Link Identifier\n            MAC - Media Access Control\n            Mbps - Megabit per second\n            MDIO - Management Data Input/Output\n            MPCP - Multi-Point Control Protocol\n            OLT - Optical Line Terminal (Server unit of the EPON)\n            OMP - Optical Multi-Point\n            ONU - Optical Network Unit (Client unit of the EPON)\n            P2MP - Point-to-Multipoint\n            PHY - Physical Layer\n            PMD - Physical Medium Dependent\n            PON - Passive Optical Network\n            RTT - Round Trip Time\n            SLD - Start of LLID Delimiter\n            TQ - Time Quanta\n          ")
dot3EponObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1))
dot3EponConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 2))
dot3EponMpcpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 1))
dot3MpcpControlTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 1, 1), )
if mibBuilder.loadTexts: dot3MpcpControlTable.setDescription('A Table of dot3 Multi-Point Control Protocol (MPCP)\n             MIB objects.  The entries in the table are control and\n             status objects of the MPCP.\n             Each object has a row for every virtual link denoted by\n             the corresponding ifIndex.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n\n\n\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).')
dot3MpcpControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3MpcpControlEntry.setDescription('An entry in the dot3 MPCP Control table.\n             Rows exist for an OLT interface and an ONU interface.\n             A row in the table is denoted by the ifIndex of the link\n             and it is created when the ifIndex is created.\n             The rows in the table for an ONU interface are created\n             at system initialization.\n             The row in the table corresponding to the OLT ifIndex\n             and the row corresponding to the broadcast virtual link\n             are created at system initialization.\n             A row in the table corresponding to the ifIndex of a\n             virtual links is created when a virtual link is\n             established (ONU registers) and deleted when the virtual\n             link is deleted (ONU deregisters).')
dot3MpcpOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpOperStatus.setDescription('This object reflects the operational state of the\n             Multi-Point MAC Control sublayer as defined in\n\n\n\n             [802.3ah], clause 64.  When the value is true(1), the\n             interface will act as if the Multi-Point Control Protocol\n             is enabled.  When the value is false(2), the interface\n             will act as if the Multi-Point Control Protocol is\n             disabled.  The operational state can be changed using the\n             dot3MpcpAdminState object.\n             This object is applicable for an OLT, with the same\n             value for all virtual interfaces, and for an ONU.')
dot3MpcpAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 2), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3MpcpAdminState.setDescription('This object is used to define the admin state of the\n             Multi-Point MAC Control sublayer, as defined in\n             [802.3ah], clause 64, and to reflect its state.\n             When selecting the value as true(1), the Multi-Point\n             Control Protocol of the interface is enabled.\n             When selecting the value as false(2), the Multi-Point\n             Control Protocol of the interface is disabled.\n             This object reflects the administrative state of the\n             Multi-Point Control Protocol of the interface.\n             The write operation is not restricted in this document\n             and can be done at any time.  Changing\n             dot3MpcpAdminState state can lead to disabling the\n             Multi-Point Control Protocol on the respective interface,\n             leading to the interruption of service for the users\n             connected to the respective EPON interface.\n             This object is applicable for an OLT, with the same\n             value for all virtual interfaces, and for an ONU.')
dot3MpcpMode = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("olt", 1), ("onu", 2),)).clone('olt')).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMode.setDescription('This object is used to identify the operational\n             state of the Multi-Point MAC Control sublayer as\n             defined in [802.3ah], clause 64.  Reading olt(1) for an\n\n\n\n             OLT (server) mode and onu(2) for an ONU (client) mode.\n             This object is used to identify the operational mode\n             for the MPCP tables.\n             This object is applicable for an OLT, with the same\n             value for all virtual interfaces, and for an ONU.')
dot3MpcpSyncTime = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 4), Unsigned32()).setUnits('TQ (16nsec)').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpSyncTime.setDescription("An object that reports the 'sync lock time' of the\n             OLT receiver in increments of Time Quanta (TQ)-16ns\n             as defined in [802.3ah], clauses 60, 64, and 65.  The\n             value returned shall be (sync lock time ns)/16.  If\n             this value exceeds (2^32-1), the value (2^32-1) shall\n             be returned.  This object is applicable for an OLT,\n             with the same value for all virtual interfaces, and\n             for an ONU.")
dot3MpcpLinkID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpLinkID.setDescription('An object that identifies the Logical Link\n             Identifier (LLID) associated with the MAC of the virtual\n             link as specified in [802.3ah], clause 65.1.3.2.2.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             The ONU and the corresponding virtual MAC of the OLT,\n             for the same virtual link, have the same value.\n             Value is assigned when the ONU registers.\n             Value is freed when the ONU deregisters.')
dot3MpcpRemoteMACAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 6), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRemoteMACAddress.setDescription('An object that identifies the source_address\n             parameter of the last MPCPDUs passed to the MAC Control.\n             This value is updated on reception of a valid frame with\n             1) a destination Field equal to the reserved multicast\n             address for MAC Control as specified in [802.3], Annex\n             31A; 2) the lengthOrType field value equal to the reserved\n             Type for MAC Control as specified in [802.3], Annex\n             31A; 3) an MPCP subtype value equal to the subtype\n             reserved for MPCP as specified in [802.3ah], Annex 31A.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             The value reflects the MAC address of the remote entity\n             and therefore the OLT holds a value for each LLID, which\n             is the MAC address of the ONU; the ONU has a single\n             value that is the OLT MAC address.')
dot3MpcpRegistrationState = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unregistered", 1), ("registering", 2), ("registered", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRegistrationState.setDescription('An object that identifies the registration state\n             of the Multi-Point MAC Control sublayer as defined in\n             [802.3ah], clause 64.  When this object has the\n             enumeration unregistered(1), the interface is\n             unregistered and may be used for registering a link\n             partner.  When this object has the enumeration\n             registering(2), the interface is in the process of\n             registering a link-partner.  When this object has the\n             enumeration registered(3), the interface has an\n             established link-partner.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.')
dot3MpcpTransmitElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 8), Unsigned32()).setUnits('TQ (16nsec)').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTransmitElapsed.setDescription('An object that reports the interval from the last\n             MPCP frame transmission in increments of Time Quanta\n             (TQ)-16ns.  The value returned shall be (interval from\n             last MPCP frame transmission in ns)/16.  If this value\n             exceeds (2^32-1), the value (2^32-1) shall be returned.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.')
dot3MpcpReceiveElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 9), Unsigned32()).setUnits('TQ (16nsec)').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpReceiveElapsed.setDescription('An object that reports the interval from last MPCP frame\n             reception in increments of Time Quanta (TQ)-16ns.  The\n             value returned shall be (interval from last MPCP frame\n             reception in ns)/16.  If this value exceeds (2^32-1), the\n             value (2^32-1) shall be returned.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.')
dot3MpcpRoundTripTime = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('TQ (16nsec)').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRoundTripTime.setDescription('An object that reports the MPCP round trip time in\n             increments of Time Quanta (TQ)-16ns.  The value returned\n             shall be (round trip time in ns)/16.  If this value\n             exceeds (2^16-1), the value (2^16-1) shall be returned.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.')
dot3MpcpMaximumPendingGrants = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMaximumPendingGrants.setDescription('An object that reports the maximum number of grants\n             that an ONU can store for handling.  The maximum number\n\n\n\n             of grants that an ONU can store for handling has a\n             range of 0 to 255.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.')
dot3MpcpStatTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 1, 2), )
if mibBuilder.loadTexts: dot3MpcpStatTable.setDescription('This table defines the list of statistics counters of\n             an interface implementing the [802.3ah], clause 64 MPCP.\n             Each object has a row for every virtual link denoted by\n             the corresponding ifIndex.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).')
dot3MpcpStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3MpcpStatEntry.setDescription('An entry in the table of statistics counters of the\n             [802.3ah], clause 64, MPCP interface.\n             Rows exist for an OLT interface and an ONU interface.\n             A row in the table is denoted by the ifIndex of the link\n             and it is created when the ifIndex is created.\n             The rows in the table for an ONU interface are created\n             at system initialization.\n             The row in the table corresponding to the OLT ifIndex\n             and the row corresponding to the broadcast virtual link\n             are created at system initialization.\n             A row in the table corresponding to the ifIndex of a\n             virtual link is created when a virtual link is\n             established (ONU registers) and deleted when the virtual\n             link is deleted (ONU deregisters).')
dot3MpcpMACCtrlFramesTransmitted = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 1), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMACCtrlFramesTransmitted.setDescription('A count of MPCP frames passed to the MAC sublayer for\n             transmission.  This counter is incremented when a\n             MA_CONTROL.request service primitive is generated within\n             the MAC control sublayer with an opcode indicating an\n             MPCP frame.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system, and at other\n             times as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpMACCtrlFramesReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 2), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMACCtrlFramesReceived.setDescription('A count of MPCP frames passed by the MAC sublayer to the\n             MAC Control sublayer.  This counter is incremented when a\n             ReceiveFrame function call returns a valid frame with\n             1) a lengthOrType field value equal to the reserved\n\n\n\n             Type for 802.3_MAC_Control as specified in clause 31.4.1.3,\n             and\n             2) an opcode indicating an MPCP frame.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpDiscoveryWindowsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpDiscoveryWindowsSent.setDescription('A count of discovery windows generated.  The counter is\n             incremented by one for each generated discovery window.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpDiscoveryTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpDiscoveryTimeout.setDescription('A count of the number of times a discovery timeout\n             occurs.  Increment the counter by one for each discovery\n             processing state-machine reset resulting from timeout\n             waiting for message arrival.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpTxRegRequest = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 5), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxRegRequest.setDescription('A count of the number of times a REGISTER_REQ MPCP\n             frame transmission occurs.  Increment the counter by one\n             for each REGISTER_REQ MPCP frame transmitted as defined\n             in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpRxRegRequest = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 6), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxRegRequest.setDescription('A count of the number of times a REGISTER_REQ MPCP\n             frame reception occurs.\n             Increment the counter by one for each REGISTER_REQ MPCP\n             frame received as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpTxRegAck = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 7), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxRegAck.setDescription('A count of the number of times a REGISTER_ACK MPCP\n             frame transmission occurs.  Increment the counter by one\n             for each REGISTER_ACK MPCP frame transmitted as defined\n             in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpRxRegAck = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 8), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxRegAck.setDescription('A count of the number of times a REGISTER_ACK MPCP\n             frame reception occurs.\n             Increment the counter by one for each REGISTER_ACK MPCP\n             frame received as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpTxReport = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 9), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxReport.setDescription('A count of the number of times a REPORT MPCP frame\n             transmission occurs.  Increment the counter by one for\n             each REPORT MPCP frame transmitted as defined in\n             [802.3ah], clause 64.\n\n\n\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpRxReport = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 10), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxReport.setDescription('A count of the number of times a REPORT MPCP frame\n             reception occurs.\n             Increment the counter by one for each REPORT MPCP frame\n             received as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpTxGate = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 11), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxGate.setDescription('A count of the number of times a GATE MPCP frame\n             transmission occurs.\n             Increment the counter by one for each GATE MPCP frame\n             transmitted as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n\n\n\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpRxGate = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 12), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxGate.setDescription('A count of the number of times a GATE MPCP frame\n             reception occurs.\n             Increment the counter by one for each GATE MPCP frame\n             received as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpTxRegister = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 13), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxRegister.setDescription('A count of the number of times a REGISTER MPCP frame\n             transmission occurs.\n             Increment the counter by one for each REGISTER MPCP\n             frame transmitted as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3MpcpRxRegister = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 14), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxRegister.setDescription('A count of the number of times a REGISTER MPCP frame\n             reception occurs.\n             Increment the counter by one for each REGISTER MPCP\n             frame received as defined in [802.3ah], clause 64.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3OmpEmulationObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 2))
dot3OmpEmulationTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 2, 1), )
if mibBuilder.loadTexts: dot3OmpEmulationTable.setDescription('A table of dot3 OmpEmulation MIB objects.  The table\n             contain objects for the management of the OMPEmulation\n             sublayer.\n             Each object has a row for every virtual link denoted by\n             the corresponding ifIndex.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).')
dot3OmpEmulationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 2, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OmpEmulationEntry.setDescription('An entry in the dot3 OmpEmulation table.\n             Rows exist for an OLT interface and an ONU interface.\n             A row in the table is denoted by the ifIndex of the link\n             and it is created when the ifIndex is created.\n             The rows in the table for an ONU interface are created\n             at system initialization.\n             The row in the table corresponding to the OLT ifIndex\n             and the row corresponding to the broadcast virtual link\n             are created at system initialization.\n             A row in the table corresponding to the ifIndex of a\n             virtual links is created when a virtual link is\n             established (ONU registers) and deleted when the virtual\n             link is deleted (ONU deregisters).')
dot3OmpEmulationType = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unknown", 1), ("olt", 2), ("onu", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationType.setDescription('An object that indicates the mode of operation\n             of the Reconciliation Sublayer for Point-to-Point\n             Emulation (see [802.3ah], clause 65.1).  unknown(1) value\n             is assigned in initialization; true state or type is not\n             yet known.  olt(2) value is assigned when the sublayer is\n             operating in OLT mode.  onu(3) value is assigned when the\n             sublayer is operating in ONU mode.\n             This object is applicable for an OLT, with the same\n             value for all virtual interfaces, and for an ONU.')
dot3OmpEmulationStatTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 2, 2), )
if mibBuilder.loadTexts: dot3OmpEmulationStatTable.setDescription('This table defines the list of statistics counters of\n\n\n\n             [802.3ah], clause 65, OMPEmulation sublayer.\n             Each object has a row for every virtual link denoted by\n             the corresponding ifIndex.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).')
dot3OmpEmulationStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OmpEmulationStatEntry.setDescription('An entry in the table of statistics counters of\n             [802.3ah], clause 65, OMPEmulation sublayer.\n             Rows exist for an OLT interface and an ONU interface.\n             A row in the table is denoted by the ifIndex of the link\n             and it is created when the ifIndex is created.\n             The rows in the table for an ONU interface are created\n             at system initialization.\n             The row in the table corresponding to the OLT ifIndex\n             and the row corresponding to the broadcast virtual link\n             are created at system initialization.\n             A row in the table corresponding to the ifIndex of a\n             virtual links is created when a virtual link is\n             established (ONU registers) and deleted when the virtual\n             link is deleted (ONU deregisters).')
dot3OmpEmulationSLDErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 1), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationSLDErrors.setDescription('A count of frames received that do not contain a valid\n             SLD field as defined in [802.3ah], clause 65.1.3.3.1.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3OmpEmulationCRC8Errors = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 2), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationCRC8Errors.setDescription('A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause 65.1.3.3.1, but do\n             not pass the CRC-8 check as defined in [802.3ah], clause\n             65.1.3.3.3.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3OmpEmulationBadLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 3), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationBadLLID.setDescription('A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause 65.1.3.3.1, and\n             pass the CRC-8 check, as defined in [802.3ah], clause\n             65.1.3.3.3, but are discarded due to the LLID check as\n             defined in [802.3ah], clause 65.1.3.3.2.\n\n\n\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3OmpEmulationGoodLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 4), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationGoodLLID.setDescription('A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause 65.1.3.3.1, and\n             pass the CRC-8 check as defined in [802.3ah], clause\n             65.1.3.3.3.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3OmpEmulationOnuPonCastLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 5), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationOnuPonCastLLID.setDescription('A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause 65.1.3.3.1,\n             pass the CRC-8 check, as defined in [802.3ah], clause\n             65.1.3.3.3, and meet the rules of acceptance for an\n             ONU defined in [802.3ah], clause 65.1.3.3.2.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n\n\n\n             module.')
dot3OmpEmulationOltPonCastLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 6), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationOltPonCastLLID.setDescription('A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause 65.1.3.3.1,\n             pass the CRC-8 check, as defined in [802.3ah], clause\n             65.1.3.3.3, and meet the rules of acceptance for an\n             OLT defined in [802.3ah], 65.1.3.3.2.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the ONU, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3OmpEmulationBroadcastBitNotOnuLlid = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 7), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationBroadcastBitNotOnuLlid.setDescription("A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause\n             65.1.3.3.1, pass the CRC-8 check, as defined in\n             [802.3ah], clause 65.1.3.3.3, and contain the broadcast\n             bit in the LLID and not the ONU's LLID (frame accepted)\n             as defined in [802.3ah], clause 65.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.")
dot3OmpEmulationOnuLLIDNotBroadcast = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 8), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationOnuLLIDNotBroadcast.setDescription("A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause\n             65.1.3.3.1, pass the CRC-8 check, as defined in\n             [802.3ah], clause 65.1.3.3.3, and contain the ONU's LLID\n             as defined in [802.3ah], clause 65.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.")
dot3OmpEmulationBroadcastBitPlusOnuLlid = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 9), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationBroadcastBitPlusOnuLlid.setDescription("A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause\n             65.1.3.3.1, pass the CRC-8 check, as defined in\n             [802.3ah], clause 65.1.3.3.3, and contain the broadcast\n             bit in the LLID and match the ONU's LLID (frame\n             reflected) as defined in [802.3ah], clause 65.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.")
dot3OmpEmulationNotBroadcastBitNotOnuLlid = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 10), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationNotBroadcastBitNotOnuLlid.setDescription("A count of frames received that contain a valid SLD\n             field, as defined in [802.3ah], clause\n             65.1.3.3.1, pass the CRC-8 check, as defined in\n             [802.3ah], clause 65.1.3.3.3, and do not contain\n             the ONU's LLID as defined in [802.3ah], clause 65.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             At the OLT, the value should be zero.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.")
dot3EponFecObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 3))
dot3EponFecTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 3, 1), )
if mibBuilder.loadTexts: dot3EponFecTable.setDescription('A table of dot3 EPON FEC management objects.\n             The entries in the table are control and status objects\n             and statistic counters for the FEC layer.\n             Each object has a row for every virtual link denoted by\n             the corresponding ifIndex.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).')
dot3EponFecEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3EponFecEntry.setDescription('An entry in the dot3 EPON FEC table.\n             Rows exist for an OLT interface and an ONU interface.\n             A row in the table is denoted by the ifIndex of the link\n             and it is created when the ifIndex is created.\n             The rows in the table for an ONU interface are created\n\n\n\n             at system initialization.\n             The row in the table corresponding to the OLT ifIndex\n             and the row corresponding to the broadcast virtual link\n             are created at system initialization.\n             A row in the table corresponding to the ifIndex of a\n             virtual links is created when a virtual link is\n             established (ONU registers) and deleted when the virtual\n             link is deleted (ONU deregisters).')
dot3EponFecPCSCodingViolation = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 1), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecPCSCodingViolation.setDescription('For a 100 Mbps operation, it is a count of the number of\n             times an invalid code-group is received, other than the\n             /H/ code-group.  For a 1000 Mbps operation, it is a count\n             of the number of times an invalid codegroup is received,\n             other than the /V/ code-group.  /H/ denotes a special\n             4b5b codeword of [802.3] 100 Mbps PCS layer (clause 24),\n             and /V/ denotes a special 8b10b codeword of the [802.3]\n             1000 Mbps PCS layer (clause 36).\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3EponFecAbility = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unknown", 1), ("supported", 2), ("unsupported", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecAbility.setDescription('An object that indicates the support of operation of the\n             optional FEC sublayer of the 1000BASE-PX PHY specified\n             in [802.3ah], clause 65.2.\n             unknown(1) value is assigned in the initialization, for non\n             FEC support state or type not yet known.  unsupported(3)\n             value is assigned when the sublayer is not supported.\n             supported(2) value is assigned when the sublayer is\n             supported.\n             This object is applicable for an OLT, with the same\n             value for all virtual interfaces, and for an ONU.\n             The FEC counters will have a zero value when the\n             interface is not supporting FEC.\n             The counters:\n              dot3EponFecPCSCodingViolation - not affected by FEC\n              ability.\n              dot3EponFecCorrectedBlocks    - has a zero value when\n               dot3EponFecAbility is unknown(1) and unsupported(3).\n              dot3EponFecUncorrectableBlocks  - has a zero value when\n               dot3EponFecAbility is unknown(1) and unsupported(3).\n              dot3EponFecBufferHeadCodingViolation - has a zero value\n               when dot3EponFecAbility is unknown(1) and\n               unsupported(3).')
dot3EponFecMode = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unknown", 1), ("disabled", 2), ("enabled", 3),)).clone('unknown')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3EponFecMode.setDescription('An object that defines the mode of operation of the\n             optional FEC sublayer of the 1000BASE-PX PHY, specified\n             in [802.3ah], clause 65.2, and reflects its state.\n             A GET operation returns the current mode of operation\n             of the PHY.  A SET operation changes the mode of\n             operation of the PHY to the indicated value.\n             unknown(1) value is assigned in the initialization for non\n               FEC support state or type not yet known.\n\n\n\n             disabled(2) value is assigned when the FEC sublayer is\n               operating in disabled mode.\n             enabled(3) value is assigned when the FEC sublayer is\n               operating in FEC mode.\n             The write operation is not restricted in this document\n             and can be done at any time.  Changing dot3EponFecMode\n             state can lead to disabling the Forward Error Correction\n             on the respective interface, which can lead to a\n             degradation of the optical link, and therefore may lead\n             to an interruption of service for the users connected to\n             the respective EPON interface.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             The counting of\n             the FEC counters will stop when the FEC of the interface\n             is disabled.\n             The counters:\n              dot3EponFecPCSCodingViolation - not affected by FEC\n              mode.\n              dot3EponFecCorrectedBlocks - stops counting when\n              Rx_FEC is not enabled.  (unknown(1) and disabled(2)).\n              dot3EponFecUncorrectableBlocks - stops counting when\n              Rx_FEC is not enabled (unknown(1) and disabled(2)).\n              dot3EponFecBufferHeadCodingViolation - stops counting\n              when Rx_FEC is not enabled (unknown(1) and\n              disabled(2)).\n             The object:\n              dot3EponFecAbility - indicates the FEC ability and\n              is not affected by the dot3EponFecMode object.')
dot3EponFecCorrectedBlocks = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecCorrectedBlocks.setDescription('For 10PASS-TS, 2BASE-TL, and 1000BASE-PX PHYs, it is a\n             count of corrected FEC blocks.  This counter will not\n             increment for other PHY Types.  Increment the counter by\n             one for each received block that is corrected by the FEC\n             function in the PHY.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n\n\n\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3EponFecUncorrectableBlocks = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecUncorrectableBlocks.setDescription('For 10PASS-TS, 2BASE-TL, and 1000BASE-PX PHYs, it is a\n             count of uncorrectable FEC blocks.  This counter will not\n             increment for other PHY Types.  Increment the counter by\n             one for each FEC block that is determined to be\n             uncorrectable by the FEC function in the PHY.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3EponFecBufferHeadCodingViolation = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 6), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecBufferHeadCodingViolation.setDescription('For a 1000 Mbps operation, it is a count of the number of\n             invalid code-group received directly from the link.  The\n             value has a meaning only in 1000 Mbps mode and it is\n             zero otherwise.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             Discontinuities of this counter can occur at\n             re-initialization of the management system and at other\n             times, as indicated by the value of the\n             ifCounterDiscontinuityTime object of the Interface MIB\n             module.')
dot3ExtPkgObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 4))
dot3ExtPkgControlObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 4, 1))
dot3ExtPkgControlTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1), )
if mibBuilder.loadTexts: dot3ExtPkgControlTable.setDescription('A table of Extended package Control management\n             objects.  Entries in the table are control and status\n             indication objects of an EPON interface, which are\n             gathered in an extended package as an addition to the\n             objects based on the [802.3ah], clause 30, attributes.\n             Each object has a row for every virtual link denoted by\n             the corresponding ifIndex.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).')
dot3ExtPkgControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3ExtPkgControlEntry.setDescription('An entry in the Extended package Control table.\n             Rows exist for an OLT interface and an ONU interface.\n             A row in the table is denoted by the ifIndex of the link\n             and it is created when the ifIndex is created.\n             The rows in the table for an ONU interface are created\n             at system initialization.\n             The row in the table corresponding to the OLT ifIndex\n             and the row corresponding to the broadcast virtual link\n             are created at system initialization.\n             A row in the table corresponding to the ifIndex of a\n             virtual links is created when a virtual link is\n             established (ONU registers) and deleted when the virtual\n             link is deleted (ONU deregisters).')
dot3ExtPkgObjectReset = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("running", 1), ("reset", 2),)).clone('running')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectReset.setDescription('This object is used to reset the EPON interface.  The\n             interface may be unavailable while the reset occurs and\n             data may be lost.\n             Setting this object to running(1) will cause the\n             interface to enter into running mode.  Setting this\n             object to reset(2) will cause the interface to go into\n             reset mode.  When getting running(1), the interface is in\n             running mode.  When getting reset(2), the interface is in\n             reset mode.\n             The write operation is not restricted in this document\n             and can be done at any time.  Changing\n             dot3ExtPkgObjectReset state can lead to a reset of the\n             respective interface, leading to an interruption of\n             service for the users connected to the respective EPON\n             interface.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             A reset for a specific virtual interface resets only\n             this virtual interface and not the physical interface.\n             Thus, a virtual link that is malfunctioning can be\n             reset without affecting the operation of other virtual\n             interfaces.\n             The reset can cause Discontinuities in the values of the\n             counters of the interface, similar to re-initialization\n             of the management system.  Discontinuity should be\n             indicated by the ifCounterDiscontinuityTime object of\n             the Interface MIB module.')
dot3ExtPkgObjectPowerDown = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 2), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectPowerDown.setDescription('This object is used to power down the EPON interface.\n             The interface may be unavailable while the power down\n             occurs and data may be lost.\n             Setting this object to true(1) will cause the interface\n             to enter into power down mode.  Setting this object to\n             false(2) will cause the interface to go out of power\n             down mode.  When getting true(1), the interface is in\n             power down mode.  When getting false(2), the interface is\n             not in power down mode.\n             The write operation is not restricted in this document\n             and can be done at any time.  Changing\n             dot3ExtPkgObjectPowerDown state can lead to a power down\n             of the respective interface, leading to an interruption\n             of service of the users connected to the respective EPON\n             interface.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.\n             A power down/up of a specific virtual interface affects\n             only the virtual interface and not the physical\n             interface.  Hence a virtual link, which needs a certain\n             handling, can be powered down and then powered up without\n             disrupting the operation of other virtual interfaces.\n             The object is relevant when the admin state of the\n             interface is active as set by the dot3MpcpAdminState.')
dot3ExtPkgObjectNumberOfLLIDs = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgObjectNumberOfLLIDs.setDescription('A read only object that indicates the number of\n             registered LLIDs.  The initialization value is 0.\n             This object is applicable for an OLT with the same\n             value for all virtual interfaces and for an ONU.\n             The LLID field, as defined in the [802.3ah], is a 2-byte\n             register (15-bit field and a broadcast bit) limiting the\n             number of virtual links to 32768.  Typically the number\n             of expected virtual links in a PON is like the number of\n             ONUs, which is 32-64, plus an additional entry for\n             broadcast LLID (with a value of 0xffff).  At the ONU the\n             number of LLIDs for an interface is one.')
dot3ExtPkgObjectFecEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("noFecEnabled", 1), ("fecTxEnabled", 2), ("fecRxEnabled", 3), ("fecTxRxEnabled", 4),)).clone('noFecEnabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectFecEnabled.setDescription('An object defining the FEC mode of operation of the\n            interface, and indicating its state.  The modes defined in\n            this object are extensions to the FEC modes defined in\n            the dot3EponFecMode object.\n            When noFECEnabled(1), the interface does not enable FEC\n            mode.\n            When fecTxEnabled(2), the interface enables the FEC\n            transmit mode.\n            When fecRxEnabled(3), the interface enables the FEC\n            receive mode.\n            When fecTxRxEnabled(4), the interface enables the FEC\n            transmit and receive mode.\n            This object is applicable for an OLT and an ONU.  At the\n            OLT, it has a distinct value for each virtual interface.\n            The FEC counters are referring to the receive path.  The\n            FEC counters will stop when the FEC receive mode of the\n            interface is disabled, as defined by fecRxEnabled(3)\n            and fecTxRxEnabled(4) values.\n            The counters:\n             dot3EponFecPCSCodingViolation - not affected by FEC\n             mode.\n             dot3EponFecCorrectedBlocks - stops counting when\n             Rx_FEC is not enabled (noFecEnabled(1) and\n             fecTxEnabled(2)).\n             dot3EponFecUncorrectableBlocks - stops counting when\n             Rx_FEC is not enabled (noFecEnabled(1) and\n             fecTxEnabled(2)).\n             dot3EponFecBufferHeadCodingViolation - stops counting\n             when Rx_FEC is not enabled (noFecEnabled(1) and\n             fecTxEnabled(2)).\n            The objects:\n             dot3EponFecAbility - indicates the FEC ability and is\n             not affected by the FEC mode.\n             dot3EponFecMode - indicates the FEC mode for combined RX\n             and TX.\n            The write operation is not restricted in this document\n            and can be done at any time.  Changing\n            dot3ExtPkgObjectFecEnabled state can lead to disabling\n            the Forward Error Correction on the respective interface,\n            which can lead to a degradation of the optical link, and\n            therefore may lead to an interruption of service for the\n\n\n\n            users connected to the respective EPON interface.')
dot3ExtPkgObjectReportMaximumNumQueues = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportMaximumNumQueues.setDescription('An object, that defines the maximal number of queues in\n             the REPORT message as defined in [802.3ah], clause 64.  For\n             further information please see the description of the\n             queue table.\n             This object is applicable for an OLT and an ONU.  At the\n             OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgObjectRegisterAction = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("none", 1), ("register", 2), ("deregister", 3), ("reregister", 4),)).clone('none')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectRegisterAction.setDescription('An object configuring the registration state of an\n           interface, and indicating its registration state.\n            Write operation changes the registration state to its new\n            value.\n            Read operation returns the value of the state.\n            The registration state is reflected in this object and in\n            the dot3MpcpRegistrationState object.\n            none(1) indicates an unknown state,\n            register(2) indicates a registered LLID,\n            deregister(3) indicates a deregistered LLID,\n            reregister(4) indicates an LLID that is reregistering.\n            The following list describes the operation of the\n            interface, as specified in the [802.3ah], when a write\n            operation is setting a value.\n             none(1) - not doing any action.\n             register(2) - registering an LLID that has been requested\n             for registration (The LLID is in registering mode.\n               dot3MpcpRegistrationState - registering(2) ).\n               deregister(3) - deregisters an LLID that is registered\n                 (dot3MpcpRegistrationState - registered(3) ).\n\n\n\n               reregister(4) - reregister an LLID that is registered\n                 (dot3MpcpRegistrationState - registered(3) ).\n               The behavior of an ONU and OLT interfaces, at each one\n               of the detailed operation at each state, is described in\n               the registration state machine of figure 64-22,\n               [802.3ah].\n              This object is applicable for an OLT and an ONU.  At the\n              OLT, it has a distinct value for each virtual interface.\n              The write operation is not restricted in this document\n              and can be done at any time.  Changing\n              dot3ExtPkgObjectRegisterAction state can lead to a change\n              in the registration state of the respective interface\n              leading to a deregistration and an interruption of\n              service of the users connected to the respective EPON\n              interface.')
dot3ExtPkgQueueTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2), )
if mibBuilder.loadTexts: dot3ExtPkgQueueTable.setDescription("A table of the extended package objects for queue\n               management.  The [802.3ah] MPCP defines a report message\n               of the occupancy of the transmit queues for the feedback\n               BW request from the ONUs.  These queues serve the uplink\n               transmission of the ONU and data is gathered there until\n               the ONU is granted for transmission.\n               The management table of the queues is added here mainly\n               to control the reporting and to gather some statistics\n               of their operation.  This table is not duplicating\n               existing management objects of bridging queues,\n               specified in [802.1d], since the existence of a\n               dedicated transmit queuing mechanism is implied in the\n               [802.3ah], and the ONU may be a device that is not a\n               bridge with embedded bridging queues.\n               The format of the REPORT message, as specified\n               in [802.3], is presented below:\n               +-----------------------------------+\n               |          Destination Address      |\n               +-----------------------------------+\n               |          Source Address           |\n               +-----------------------------------+\n               |          Length/Type              |\n               +-----------------------------------+\n               |          OpCode                   |\n               +-----------------------------------+\n\n\n\n               |          TimeStamp                |\n               +-----------------------------------+\n               |          Number of queue Sets     |\n               +-----------------------------------+   /|\\\n               |          Report bitmap            |    |\n               +-----------------------------------+    |\n               |          Queue 0 report           |    |\n               +-----------------------------------+    | repeated for\n               |          Queue 1 report           |    | every\n               +-----------------------------------+    | queue_set\n               |          Queue 2 report           |    |\n               +-----------------------------------+    |\n               |          Queue 3 report           |    |\n               +-----------------------------------+    |\n               |          Queue 4 report           |    |\n               +-----------------------------------+    |\n               |          Queue 5 report           |    |\n               +-----------------------------------+    |\n               |          Queue 6 report           |    |\n               +-----------------------------------+    |\n               |          Queue 7 report           |    |\n               +-----------------------------------+   \\|/\n               |          Pad/reserved             |\n               +-----------------------------------+\n               |          FCS                      |\n               +-----------------------------------+\n\n               The 'Queue report' field reports the occupancy of each\n               uplink transmission queue.\n               The number of queue sets defines the number of the\n               reported sets, as would be explained in the description\n               of the dot3ExtPkgQueueSetsTable table.  For each set the\n               report bitmap defines which queue is present in the\n               report, meaning that although the MPCP REPORT message\n               can report up to 8 queues in a REPORT message, the\n               actual number is flexible.  The Queue table has a\n               variable size that is limited by the\n               dot3ExtPkgObjectReportMaximumNumQueues object, as an\n               ONU can have fewer queues to report.\n               The entries in the table are control and status\n               indication objects for managing the queues of an EPON\n               interface that are gathered in an extended package as\n               an addition to the objects that are based on the\n               [802.3ah] attributes.\n               Each object has a row for every virtual link and for\n               every queue in the report.\n               The LLID field, as defined in the [802.3ah], is a 2-byte\n               register (15-bit field and a broadcast bit) limiting the\n\n\n\n               number of virtual links to 32768.  Typically the number\n               of expected virtual links in a PON is like the number of\n               ONUs, which is 32-64, plus an additional entry for\n               broadcast LLID (with a value of 0xffff).\n               The number of queues is between 0 and 7 and limited by\n               dot3ExtPkgObjectReportMaximumNumQueues.")
dot3ExtPkgQueueEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOT3-EPON-MIB", "dot3QueueIndex"))
if mibBuilder.loadTexts: dot3ExtPkgQueueEntry.setDescription('An entry in the Extended package Queue table.  At the\n               OLT, the rows exist for each ifIndex and dot3QueueIndex.\n               At the ONU, rows exist for the single ifIndex for each\n               dot3QueueIndex.\n               Rows in the table are created when the ifIndex of the\n               link is created.  A set of rows per queue are added for\n               each ifIndex, denoted by the dot3QueueIndex.\n               A set of rows per queue in the table, for an ONU\n               interface, are created at the system initialization.\n               A set of rows per queue in the table, corresponding to\n               the OLT ifIndex and a set of rows per queue\n               corresponding to the broadcast virtual link, are\n               created at the system initialization.\n               A set of rows per queue in the table, corresponding to\n               the ifIndex of a virtual link, are created when the\n               virtual link is established (ONU registers), and deleted\n               when the virtual link is deleted (ONU deregisters).')
dot3QueueIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,7)))
if mibBuilder.loadTexts: dot3QueueIndex.setDescription('An object that identifies an index for the queue table\n               reflecting the queue index of the queues that are\n               reported in the MPCP REPORT message as defined in\n               [802.3ah], clause 64.\n               The number of queues is between 0 and 7, and limited by\n               dot3ExtPkgObjectReportMaximumNumQueues.')
dot3ExtPkgObjectReportNumThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportNumThreshold.setDescription('An object that defines the number of thresholds for each\n               queue in the REPORT message as defined in [802.3ah],\n               clause 64.\n               Each queue_set reporting will provide information on the\n               queue occupancy of frames below the matching Threshold.\n               Read operation reflects the number of thresholds.\n               Write operation sets the number of thresholds for each\n               queue.\n               The write operation is not restricted in this document\n               and can be done at any time.  Value cannot exceed the\n               maximal value defined by the\n               dot3ExtPkgObjectReportMaximumNumThreshold object.\n               Changing dot3ExtPkgObjectReportNumThreshold can lead to\n               a change in the reporting of the ONU interface and\n               therefore to a change in the bandwidth allocation of the\n               respective interface.  This change may lead a degradation\n               or an interruption of service of the users connected to\n               the respective EPON interface.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface\n               and for each queue.  At the ONU, it has a distinct value\n               for each queue.')
dot3ExtPkgObjectReportMaximumNumThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportMaximumNumThreshold.setDescription('An object, that defines the maximal number of thresholds\n               for each queue in the REPORT message as defined in\n               [802.3ah], clause 64.  Each queue_set reporting will\n               provide information on the queue occupancy of frames\n               below the matching Threshold.\n\n\n\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface\n               and for each queue.  At the ONU, it has a distinct value\n               for each queue.')
dot3ExtPkgStatTxFramesQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 4), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgStatTxFramesQueue.setDescription("A count of the number of times a frame transmission\n               occurs from the corresponding 'Queue'.\n               Increment the counter by one for each frame transmitted,\n               which is an output of the 'Queue'.\n               The 'Queue' marking matches the REPORT MPCP message\n               Queue field as defined in [802.3ah], clause 64.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface\n               and for each queue.  At the ONU, it has a distinct value\n               for each queue.\n               At the OLT the value should be zero.\n               Discontinuities of this counter can occur at\n               re-initialization of the management system and at other\n               times, as indicated by the value of the\n               ifCounterDiscontinuityTime object of the Interface MIB\n               module.")
dot3ExtPkgStatRxFramesQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 5), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgStatRxFramesQueue.setDescription("A count of the number of times a frame reception\n               occurs from the corresponding 'Queue'.\n               Increment the counter by one for each frame received,\n               which is an input to the corresponding 'Queue'.\n               The 'Queue' marking matches the REPORT MPCP message\n               Queue field as defined in [802.3ah], clause 64.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface\n               and for each queue.  At the ONU, it has a distinct value\n               for each queue.\n               Discontinuities of this counter can occur at\n\n\n\n               re-initialization of the management system and at other\n               times, as indicated by the value of the\n               ifCounterDiscontinuityTime object of the Interface MIB\n               module.")
dot3ExtPkgStatDroppedFramesQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 6), Counter64()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgStatDroppedFramesQueue.setDescription("A count of the number of times a frame drop\n               occurs from the corresponding 'Queue'.\n               Increment the counter by one for each frame dropped\n               from the corresponding 'Queue'.\n               The 'Queue' marking matches the REPORT MPCP message\n               Queue field as defined in [802.3ah], clause 64.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface\n               and for each queue.  At the ONU, it has a distinct value\n               for each queue.\n               At the OLT, the value should be zero.\n               Discontinuities of this counter can occur at\n               re-initialization of the management system and at other\n               times, as indicated by the value of the\n               ifCounterDiscontinuityTime object of the Interface MIB\n               module.")
dot3ExtPkgQueueSetsTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3), )
if mibBuilder.loadTexts: dot3ExtPkgQueueSetsTable.setDescription("A table of Extended package objects used for the\n               management of the queue_sets.  Entries are control and\n               status indication objects of an EPON interface, which\n               are gathered in an extended package as an addition to\n               the objects based on the [802.3ah] attributes.  The\n               objects in this table are specific for the queue_sets,\n               which are reported in the MPCP REPORT message as defined\n               in [802.3ah], clause 64.\n               The [802.3ah] MPCP defines a report message of the\n               occupancy of the transmit queues for the feedback BW\n               request from the ONUs.  These queues serve the uplink\n               transmission of the ONU and data is gathered there until\n               the ONU is granted for transmission.\n\n\n\n               The management table of the queues_sets is added here\n               mainly to control the reporting and to gather some\n               statistics of their operation.  This table is not\n               duplicating existing management objects of bridging\n               queues, specified in [802.1d], since the existence of a\n               dedicated transmit queuing mechanism is implied in the\n               [802.3ah], and the ONU may be a device that is not a\n               bridge with embedded bridging queues.\n               The format of the REPORT message, as specified\n               in [802.3], is presented below:\n               +-----------------------------------+\n               |          Destination Address      |\n               +-----------------------------------+\n               |          Source Address           |\n               +-----------------------------------+\n               |          Length/Type              |\n               +-----------------------------------+\n               |          OpCode                   |\n               +-----------------------------------+\n               |          TimeStamp                |\n               +-----------------------------------+\n               |          Number of queue Sets     |\n               +-----------------------------------+   /|\\\n               |          Report bitmap            |    |\n               +-----------------------------------+    |\n               |          Queue 0 report           |    |\n               +-----------------------------------+    | repeated for\n               |          Queue 1 report           |    | every\n               +-----------------------------------+    | queue_set\n               |          Queue 2 report           |    |\n               +-----------------------------------+    |\n               |          Queue 3 report           |    |\n               +-----------------------------------+    |\n               |          Queue 4 report           |    |\n               +-----------------------------------+    |\n               |          Queue 5 report           |    |\n               +-----------------------------------+    |\n               |          Queue 6 report           |    |\n               +-----------------------------------+    |\n               |          Queue 7 report           |    |\n               +-----------------------------------+   \\|/\n               |          Pad/reserved             |\n               +-----------------------------------+\n               |          FCS                      |\n               +-----------------------------------+\n\n               As can be seen from the message format, the ONU\n               interface reports of the status of up to 8 queues\n\n\n\n               and it can report in a single MPCP REPORT message\n               of a few sets of queues.\n               The number of queue_sets defines the number of the\n               reported sets, and it can reach a value of up to 8.\n               It means that an ONU can hold a variable number of\n               sets between 0 and 7.\n               The dot3ExtPkgQueueSetsTable table has a variable\n               queue_set size that is limited by the\n               dot3ExtPkgObjectReportMaximumNumThreshold object as an\n               ONU can have fewer queue_sets to report.\n               The 'Queue report' field reports the occupancy of each\n               uplink transmission queue.  The queue_sets can be used to\n               report the occupancy of the queues in a few levels as to\n               allow granting, in an accurate manner, of only part of\n               the data available in the queues.  A Threshold is\n               defined for each queue_set to define the level of the\n               queue that is counted for the report of the occupancy.\n               The threshold is reflected in the queue_set table by the\n               dot3ExtPkgObjectReportThreshold object.\n               For each queue set, the report bitmap defines which\n               queues are present in the report, meaning that\n               although the MPCP REPORT message can report of up to 8\n               queues in a REPORT message, the actual number is\n               flexible.\n               The dot3ExtPkgQueueSetsTable table has a variable queue\n               size that is limited by the\n               dot3ExtPkgObjectReportMaximumNumQueues object as an ONU\n               can have fewer queues to report.\n               Each object has a row for every virtual link, for each\n               queue in the report and for each queue_set in the queue.\n               The LLID field, as defined in the [802.3ah], is a 2-byte\n               register (15-bit field and a broadcast bit) limiting the\n               number of virtual links to 32768.  Typically the number\n               of expected virtual links in a PON is like the number of\n               ONUs, which is 32-64, plus an additional entry for\n               broadcast LLID (with a value of 0xffff).\n               The number of queues is between 0 and 7 and limited by\n               dot3ExtPkgObjectReportMaximumNumQueues.\n               The number of queues_sets is between 0 and 7 and limited\n               by dot3ExtPkgObjectReportMaximumNumThreshold.")
dot3ExtPkgQueueSetsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOT3-EPON-MIB", "dot3QueueSetQueueIndex"), (0, "DOT3-EPON-MIB", "dot3QueueSetIndex"))
if mibBuilder.loadTexts: dot3ExtPkgQueueSetsEntry.setDescription('An entry in the Extended package queue_set table.  At\n\n\n\n               the OLT, the rows exist for each ifIndex,\n               dot3QueueSetQueueIndex and dot3QueueSetIndex.  At the\n               ONU, rows exist for the single ifIndex, for each\n               dot3QueueSetQueueIndex and dot3QueueSetIndex.\n               Rows in the table are created when the ifIndex of the\n               link is created.  A set of rows per queue and per\n               queue_set are added for each ifIndex, denoted by\n               dot3QueueSetIndex and dot3QueueSetQueueIndex.\n               A set of rows per queue and per queue_set in the table,\n               for an ONU interface are created at system\n               initialization.\n               A set of rows per queue and per queue_Set in the table,\n               corresponding to the OLT ifIndex and a set of rows per\n               queue and per queue_set, corresponding to the broadcast\n               virtual link, are created at system initialization.\n               A set of rows per queue and per queue_set in the table,\n               corresponding to the ifIndex of a virtual link are\n               created when the virtual link is established (ONU\n               registers) and deleted when the virtual link is deleted\n               (ONU deregisters).')
dot3QueueSetQueueIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,7)))
if mibBuilder.loadTexts: dot3QueueSetQueueIndex.setDescription('An object that identifies the queue index for the\n               dot3ExtPkgQueueSetsTable table.  The queues are reported\n               in the MPCP REPORT message as defined in [802.3ah],\n               clause 64.\n               The number of queues is between 0 and 7, and limited by\n               dot3ExtPkgObjectReportMaximumNumQueues.\n               Value corresponds to the dot3QueueIndex of the queue\n               table.')
dot3QueueSetIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,7)))
if mibBuilder.loadTexts: dot3QueueSetIndex.setDescription('An object that identifies the queue_set index for the\n               dot3ExtPkgQueueSetsTable table.  The queues are reported\n               in the MPCP REPORT message as defined in [802.3ah],\n               clause 64.\n               The number of queues_sets is between 0 and 7, and\n               limited by dot3ExtPkgObjectReportMaximumNumThreshold.')
dot3ExtPkgObjectReportThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1, 3), Unsigned32()).setUnits('TQ (16nsec)').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportThreshold.setDescription('An object that defines the value of a threshold report\n               for each queue_set in the REPORT message as defined in\n               [802.3ah], clause 64.  The number of sets for each queue\n               is dot3ExtPkgObjectReportNumThreshold.\n               In the REPORT message, each queue_set reporting will\n               provide information on the occupancy of the queues for\n               frames below the matching Threshold.\n               The value returned shall be in Time quanta (TQ), which\n               is 16nsec or 2 octets increments.\n               Read operation provides the threshold value.  Write\n               operation sets the value of the threshold.\n               The write operation is not restricted in this document\n               and can be done at any time.  Changing\n               dot3ExtPkgObjectReportThreshold can lead to a change in\n               the reporting of the ONU interface and therefore to a\n               change in the bandwidth allocation of the respective\n               interface.  This change may lead a degradation or an\n               interruption of service for the users connected to the\n               respective EPON interface.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface,\n               for each queue and for each queue_set.  At the ONU, it has\n               a distinct value for each queue and for each queue_set.')
dot3ExtPkgOptIfTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5), )
if mibBuilder.loadTexts: dot3ExtPkgOptIfTable.setDescription('This table defines the control and status indication\n               objects for the optical interface of the EPON interface.\n               Each object has a row for every virtual link denoted by\n               the corresponding ifIndex.\n               The LLID field, as defined in the [802.3ah], is a 2-byte\n               register (15-bit field and a broadcast bit) limiting the\n               number of virtual links to 32768.  Typically the number\n               of expected virtual links in a PON is like the number of\n               ONUs, which is 32-64, plus an additional entry for\n               broadcast LLID (with a value of 0xffff).\n               Although the optical interface is a physical interface,\n               there is a row in the table for each virtual interface.\n               The reason for having a separate row for each virtual\n               link is that the OLT has a separate link for each one of\n               the ONUs.  For instance, ONUs could be in different\n               distances with different link budgets and different\n               receive powers, therefore having different power alarms.\n               It is quite similar to a case of different physical\n               interfaces.')
dot3ExtPkgOptIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3ExtPkgOptIfEntry.setDescription('An entry in the optical interface table of the EPON\n               interface.\n               Rows exist for an OLT interface and an ONU interface.\n               A row in the table is denoted by the ifIndex of the link\n               and it is created when the ifIndex is created.\n               The rows in the table for an ONU interface are created\n               at system initialization.\n               The row in the table corresponding to the OLT ifIndex\n               and the row corresponding to the broadcast virtual link\n               are created at system initialization.\n               A row in the table corresponding to the ifIndex of a\n               virtual links is created when a virtual link is\n               established (ONU registers) and deleted when the virtual\n               link is deleted (ONU deregisters).')
dot3ExtPkgOptIfSuspectedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfSuspectedFlag.setDescription('This object is a reliability indication.\n       If true, the data in this entry may be unreliable.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfInputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 2), Integer32()).setUnits('0.1 dbm').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfInputPower.setDescription('The optical power monitored at the input.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfLowInputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 3), Integer32()).setUnits('0.1 dbm').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowInputPower.setDescription('The lowest optical power monitored at the input during the\n       current 15-minute interval.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfHighInputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 4), Integer32()).setUnits('0.1 dbm').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfHighInputPower.setDescription('The highest optical power monitored at the input during the\n       current 15-minute interval.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfLowerInputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 5), Integer32()).setUnits('0.1 dbm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowerInputPowerThreshold.setDescription('The lower limit threshold on input power.  If\n       dot3ExtPkgOptIfInputPower drops to this value or below,\n       a Threshold Crossing Alert (TCA) should be sent.\n       Reading will present the threshold value.  Writing will\n       set the value of the threshold.\n       The write operation is not restricted in this document\n       and can be done at any time.  Changing\n       dot3ExtPkgOptIfLowerInputPowerThreshold can lead to a Threshold\n       Crossing Alert (TCA) being sent for the respective interface.\n       This alert may be leading to an interruption of service for the\n       users connected to the respective EPON interface, depending on\n       the system action on such an alert.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfUpperInputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 6), Integer32()).setUnits('0.1 dbm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfUpperInputPowerThreshold.setDescription('The upper limit threshold on input power.  If\n       dot3ExtPkgOptIfInputPower reaches or exceeds this value,\n       a Threshold Crossing Alert (TCA) should be sent.\n       Reading will present the threshold value.  Writing will\n       set the value of the threshold.\n       The write operation is not restricted in this document\n       and can be done at any time.  Changing\n       dot3ExtPkgOptIfUpperInputPowerThreshold can lead to a Threshold\n\n\n\n       Crossing Alert (TCA) being sent for the respective interface.\n       This alert may be leading to an interruption of service for the\n       users connected to the respective EPON interface, depending on\n       the system action on such an alert.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 7), Integer32()).setUnits('0.1 dbm').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfOutputPower.setDescription('The optical power monitored at the output.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfLowOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 8), Integer32()).setUnits('0.1 dbm').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowOutputPower.setDescription('The lowest optical power monitored at the output during the\n       current 15-minute interval.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfHighOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 9), Integer32()).setUnits('0.1 dbm').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfHighOutputPower.setDescription('The highest optical power monitored at the output during the\n       current 15-minute interval.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfLowerOutputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 10), Integer32()).setUnits('0.1 dbm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowerOutputPowerThreshold.setDescription('The lower limit threshold on output power.  If\n       dot3ExtPkgOptIfOutputPower drops to this value or below,\n       a Threshold Crossing Alert (TCA) should be sent.\n       Reading will present the threshold value.  Writing will\n       set the value of the threshold.\n       The write operation is not restricted in this document\n       and can be done at any time.  Changing\n       dot3ExtPkgOptIfLowerOutputPowerThreshold can lead to a Threshold\n       Crossing Alert (TCA) being sent for the respective interface.\n       This alert may be leading to an interruption of service for the\n       users connected to the respective EPON interface, depending on\n       the system action on such an alert.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfUpperOutputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 11), Integer32()).setUnits('0.1 dbm').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfUpperOutputPowerThreshold.setDescription('The upper limit threshold on output power.  If\n       dot3ExtPkgOptIfOutputPower reaches or exceeds this value,\n       a Threshold Crossing Alert (TCA) should be sent.\n       Reading will present the threshold value.  Writing will\n       set the value of the threshold.\n       The write operation is not restricted in this document\n       and can be done at any time.  Changing\n       dot3ExtPkgOptIfUpperOutputPowerThreshold can lead to a Threshold\n       Crossing Alert (TCA) being sent for the respective interface.\n       This alert may be leading to an interruption of service of the\n       users connected to the respective EPON interface, depending on\n       the system action on such an alert.\n       This object is applicable for an OLT and an ONU.  At the\n       OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfSignalDetect = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 12), TruthValue().clone('false')).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfSignalDetect.setDescription('When getting true(1), there is a valid optical signal at\n               the receive that is above the optical power level for\n               signal detection.  When getting false(2) the optical\n               signal at the receive is below the optical power level\n\n\n\n               for signal detection.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfTransmitAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 13), TruthValue().clone('false')).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfTransmitAlarm.setDescription('When getting true(1) there is a non-valid optical signal\n               at the transmit of the interface, either a higher level\n               or lower level than expected.  When getting false(2) the\n               optical signal at the transmit is valid and in the\n               required range.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT, it has a distinct value for each virtual interface.')
dot3ExtPkgOptIfTransmitEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 14), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfTransmitEnable.setDescription('Setting this object to true(1) will cause the optical\n               interface to start transmission (according to the\n               control protocol specified for the logical interface).\n               Setting this object to false(2) will cause the\n               interface to stop the optical transmission.\n               When getting true(1), the optical interface is in\n               transmitting mode (obeying to the logical control\n               protocol).\n               When getting false(2), the optical interface is not in\n               transmitting mode.\n               The write operation is not restricted in this document\n               and can be done at any time.  Changing\n               dot3ExtPkgOptIfTransmitEnable state can lead to a halt\n               in the optical transmission of the respective interface\n               leading to an interruption of service of the users\n               connected to the respective EPON interface.\n               The object is relevant when the admin state of the\n               interface is active as set by the dot3MpcpAdminState.\n               This object is applicable for an OLT and an ONU.  At the\n               OLT it, has a distinct value for each virtual interface.')
dot3EponGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 2, 1))
dot3MpcpGroupBase = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 1)).setObjects(*(("DOT3-EPON-MIB", "dot3MpcpOperStatus"), ("DOT3-EPON-MIB", "dot3MpcpAdminState"), ("DOT3-EPON-MIB", "dot3MpcpMode"), ("DOT3-EPON-MIB", "dot3MpcpSyncTime"), ("DOT3-EPON-MIB", "dot3MpcpLinkID"), ("DOT3-EPON-MIB", "dot3MpcpRemoteMACAddress"), ("DOT3-EPON-MIB", "dot3MpcpRegistrationState"), ("DOT3-EPON-MIB", "dot3MpcpMaximumPendingGrants"), ("DOT3-EPON-MIB", "dot3MpcpTransmitElapsed"), ("DOT3-EPON-MIB", "dot3MpcpReceiveElapsed"), ("DOT3-EPON-MIB", "dot3MpcpRoundTripTime"),))
if mibBuilder.loadTexts: dot3MpcpGroupBase.setDescription('A collection of objects of dot3 Mpcp Control entity state\n              definition.  Objects are per LLID.')
dot3MpcpGroupStat = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 2)).setObjects(*(("DOT3-EPON-MIB", "dot3MpcpMACCtrlFramesTransmitted"), ("DOT3-EPON-MIB", "dot3MpcpMACCtrlFramesReceived"), ("DOT3-EPON-MIB", "dot3MpcpDiscoveryWindowsSent"), ("DOT3-EPON-MIB", "dot3MpcpDiscoveryTimeout"), ("DOT3-EPON-MIB", "dot3MpcpTxRegRequest"), ("DOT3-EPON-MIB", "dot3MpcpRxRegRequest"), ("DOT3-EPON-MIB", "dot3MpcpTxRegAck"), ("DOT3-EPON-MIB", "dot3MpcpRxRegAck"), ("DOT3-EPON-MIB", "dot3MpcpTxReport"), ("DOT3-EPON-MIB", "dot3MpcpRxReport"), ("DOT3-EPON-MIB", "dot3MpcpTxGate"), ("DOT3-EPON-MIB", "dot3MpcpRxGate"), ("DOT3-EPON-MIB", "dot3MpcpTxRegister"), ("DOT3-EPON-MIB", "dot3MpcpRxRegister"),))
if mibBuilder.loadTexts: dot3MpcpGroupStat.setDescription('A collection of objects of dot3 Mpcp Statistics.\n               Objects are per LLID.')
dot3OmpeGroupID = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 3)).setObjects(*(("DOT3-EPON-MIB", "dot3OmpEmulationType"),))
if mibBuilder.loadTexts: dot3OmpeGroupID.setDescription('A collection of objects of dot3 OMP emulation entity\n               state definition.  Objects are per LLID.')
dot3OmpeGroupStat = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 4)).setObjects(*(("DOT3-EPON-MIB", "dot3OmpEmulationSLDErrors"), ("DOT3-EPON-MIB", "dot3OmpEmulationCRC8Errors"), ("DOT3-EPON-MIB", "dot3OmpEmulationBadLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationGoodLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationOnuPonCastLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationOltPonCastLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationBroadcastBitNotOnuLlid"), ("DOT3-EPON-MIB", "dot3OmpEmulationOnuLLIDNotBroadcast"), ("DOT3-EPON-MIB", "dot3OmpEmulationBroadcastBitPlusOnuLlid"), ("DOT3-EPON-MIB", "dot3OmpEmulationNotBroadcastBitNotOnuLlid"),))
if mibBuilder.loadTexts: dot3OmpeGroupStat.setDescription('A collection of objects of dot3 OMP emulation\n               Statistics.  Objects are per LLID.')
dot3EponFecGroupAll = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 5)).setObjects(*(("DOT3-EPON-MIB", "dot3EponFecPCSCodingViolation"), ("DOT3-EPON-MIB", "dot3EponFecAbility"), ("DOT3-EPON-MIB", "dot3EponFecMode"), ("DOT3-EPON-MIB", "dot3EponFecCorrectedBlocks"), ("DOT3-EPON-MIB", "dot3EponFecUncorrectableBlocks"), ("DOT3-EPON-MIB", "dot3EponFecBufferHeadCodingViolation"),))
if mibBuilder.loadTexts: dot3EponFecGroupAll.setDescription('A collection of objects of dot3 FEC group control and\n              statistics.  Objects are per LLID.')
dot3ExtPkgGroupControl = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 6)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgObjectReset"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectPowerDown"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectNumberOfLLIDs"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectFecEnabled"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectReportMaximumNumQueues"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectRegisterAction"),))
if mibBuilder.loadTexts: dot3ExtPkgGroupControl.setDescription('A collection of objects of dot3ExtPkg control\n               definition.  Objects are per LLID.')
dot3ExtPkgGroupQueue = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 7)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgObjectReportNumThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectReportMaximumNumThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgStatTxFramesQueue"), ("DOT3-EPON-MIB", "dot3ExtPkgStatRxFramesQueue"), ("DOT3-EPON-MIB", "dot3ExtPkgStatDroppedFramesQueue"),))
if mibBuilder.loadTexts: dot3ExtPkgGroupQueue.setDescription('A collection of objects of dot3ExtPkg Queue\n               control.  Objects are per LLID, per queue.')
dot3ExtPkgGroupQueueSets = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 8)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgObjectReportThreshold"),))
if mibBuilder.loadTexts: dot3ExtPkgGroupQueueSets.setDescription('A collection of objects of dot3ExtPkg queue_set\n               control.  Objects are per LLID, per queue, per\n               queue_set.')
dot3ExtPkgGroupOptIf = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 9)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgOptIfSuspectedFlag"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfInputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowInputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfHighInputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowerInputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfUpperInputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfOutputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowOutputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfHighOutputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowerOutputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfUpperOutputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfSignalDetect"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfTransmitAlarm"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfTransmitEnable"),))
if mibBuilder.loadTexts: dot3ExtPkgGroupOptIf.setDescription('A collection of objects of control and status indication\n               of the optical interface.\n               Objects are per LLID.')
dot3EponCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 2, 2))
dot3MPCPCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 1)).setObjects(*(("DOT3-EPON-MIB", "dot3MpcpGroupBase"), ("DOT3-EPON-MIB", "dot3MpcpGroupStat"),))
if mibBuilder.loadTexts: dot3MPCPCompliance.setDescription('The compliance statement for Multi-Point\n                   Control Protocol interfaces.')
dot3OmpeCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 2)).setObjects(*(("DOT3-EPON-MIB", "dot3OmpeGroupID"), ("DOT3-EPON-MIB", "dot3OmpeGroupStat"),))
if mibBuilder.loadTexts: dot3OmpeCompliance.setDescription('The compliance statement for OMPEmulation\n                   interfaces.')
dot3EponFecCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 3)).setObjects(*(("DOT3-EPON-MIB", "dot3EponFecGroupAll"),))
if mibBuilder.loadTexts: dot3EponFecCompliance.setDescription('The compliance statement for FEC EPON interfaces.\n\n\n\n                   This group is mandatory for all FEC supporting\n                   interfaces for control and statistics collection.')
dot3ExtPkgCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 4)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgGroupControl"), ("DOT3-EPON-MIB", "dot3ExtPkgGroupQueue"), ("DOT3-EPON-MIB", "dot3ExtPkgGroupQueueSets"), ("DOT3-EPON-MIB", "dot3ExtPkgGroupOptIf"),))
if mibBuilder.loadTexts: dot3ExtPkgCompliance.setDescription('The compliance statement for EPON Interfaces\n                   using the extended package.')
mibBuilder.exportSymbols("DOT3-EPON-MIB", dot3ExtPkgOptIfLowInputPower=dot3ExtPkgOptIfLowInputPower, dot3MpcpReceiveElapsed=dot3MpcpReceiveElapsed, dot3MpcpDiscoveryTimeout=dot3MpcpDiscoveryTimeout, dot3MpcpRxRegAck=dot3MpcpRxRegAck, dot3MpcpTxRegRequest=dot3MpcpTxRegRequest, dot3EponFecBufferHeadCodingViolation=dot3EponFecBufferHeadCodingViolation, dot3MpcpControlTable=dot3MpcpControlTable, dot3OmpEmulationStatTable=dot3OmpEmulationStatTable, dot3ExtPkgOptIfInputPower=dot3ExtPkgOptIfInputPower, dot3QueueSetIndex=dot3QueueSetIndex, dot3ExtPkgQueueTable=dot3ExtPkgQueueTable, dot3MpcpMACCtrlFramesTransmitted=dot3MpcpMACCtrlFramesTransmitted, dot3OmpeGroupStat=dot3OmpeGroupStat, dot3ExtPkgQueueSetsEntry=dot3ExtPkgQueueSetsEntry, dot3ExtPkgCompliance=dot3ExtPkgCompliance, dot3EponFecTable=dot3EponFecTable, dot3OmpEmulationOltPonCastLLID=dot3OmpEmulationOltPonCastLLID, dot3MpcpGroupStat=dot3MpcpGroupStat, dot3ExtPkgGroupQueueSets=dot3ExtPkgGroupQueueSets, dot3QueueIndex=dot3QueueIndex, dot3MpcpSyncTime=dot3MpcpSyncTime, dot3EponGroups=dot3EponGroups, dot3MpcpMode=dot3MpcpMode, dot3ExtPkgObjectNumberOfLLIDs=dot3ExtPkgObjectNumberOfLLIDs, dot3ExtPkgControlObjects=dot3ExtPkgControlObjects, dot3MpcpControlEntry=dot3MpcpControlEntry, dot3EponFecGroupAll=dot3EponFecGroupAll, dot3MpcpRegistrationState=dot3MpcpRegistrationState, dot3MpcpStatTable=dot3MpcpStatTable, dot3OmpEmulationSLDErrors=dot3OmpEmulationSLDErrors, dot3ExtPkgStatTxFramesQueue=dot3ExtPkgStatTxFramesQueue, dot3OmpEmulationStatEntry=dot3OmpEmulationStatEntry, dot3EponFecEntry=dot3EponFecEntry, dot3MpcpTxRegAck=dot3MpcpTxRegAck, dot3MpcpTransmitElapsed=dot3MpcpTransmitElapsed, dot3MpcpRoundTripTime=dot3MpcpRoundTripTime, dot3ExtPkgControlEntry=dot3ExtPkgControlEntry, dot3ExtPkgObjectReportMaximumNumQueues=dot3ExtPkgObjectReportMaximumNumQueues, dot3ExtPkgStatRxFramesQueue=dot3ExtPkgStatRxFramesQueue, dot3ExtPkgOptIfSuspectedFlag=dot3ExtPkgOptIfSuspectedFlag, dot3EponMpcpObjects=dot3EponMpcpObjects, dot3MpcpMaximumPendingGrants=dot3MpcpMaximumPendingGrants, dot3MpcpRxRegister=dot3MpcpRxRegister, dot3EponFecCorrectedBlocks=dot3EponFecCorrectedBlocks, dot3MpcpAdminState=dot3MpcpAdminState, dot3ExtPkgOptIfTransmitEnable=dot3ExtPkgOptIfTransmitEnable, dot3ExtPkgGroupOptIf=dot3ExtPkgGroupOptIf, dot3ExtPkgObjectRegisterAction=dot3ExtPkgObjectRegisterAction, dot3EponConformance=dot3EponConformance, dot3ExtPkgOptIfUpperInputPowerThreshold=dot3ExtPkgOptIfUpperInputPowerThreshold, PYSNMP_MODULE_ID=dot3EponMIB, dot3OmpEmulationObjects=dot3OmpEmulationObjects, dot3OmpEmulationBroadcastBitNotOnuLlid=dot3OmpEmulationBroadcastBitNotOnuLlid, dot3OmpEmulationBroadcastBitPlusOnuLlid=dot3OmpEmulationBroadcastBitPlusOnuLlid, dot3EponFecMode=dot3EponFecMode, dot3ExtPkgObjectReportMaximumNumThreshold=dot3ExtPkgObjectReportMaximumNumThreshold, dot3MpcpMACCtrlFramesReceived=dot3MpcpMACCtrlFramesReceived, dot3MpcpDiscoveryWindowsSent=dot3MpcpDiscoveryWindowsSent, dot3EponMIB=dot3EponMIB, dot3EponFecPCSCodingViolation=dot3EponFecPCSCodingViolation, dot3ExtPkgOptIfLowerInputPowerThreshold=dot3ExtPkgOptIfLowerInputPowerThreshold, dot3OmpEmulationOnuPonCastLLID=dot3OmpEmulationOnuPonCastLLID, dot3EponCompliances=dot3EponCompliances, dot3ExtPkgObjectReportNumThreshold=dot3ExtPkgObjectReportNumThreshold, dot3ExtPkgOptIfTransmitAlarm=dot3ExtPkgOptIfTransmitAlarm, dot3ExtPkgObjectPowerDown=dot3ExtPkgObjectPowerDown, dot3ExtPkgGroupQueue=dot3ExtPkgGroupQueue, dot3ExtPkgObjectReset=dot3ExtPkgObjectReset, dot3ExtPkgOptIfHighInputPower=dot3ExtPkgOptIfHighInputPower, dot3MPCPCompliance=dot3MPCPCompliance, dot3EponFecCompliance=dot3EponFecCompliance, dot3ExtPkgOptIfHighOutputPower=dot3ExtPkgOptIfHighOutputPower, dot3EponFecObjects=dot3EponFecObjects, dot3QueueSetQueueIndex=dot3QueueSetQueueIndex, dot3MpcpTxReport=dot3MpcpTxReport, dot3OmpEmulationNotBroadcastBitNotOnuLlid=dot3OmpEmulationNotBroadcastBitNotOnuLlid, dot3ExtPkgOptIfOutputPower=dot3ExtPkgOptIfOutputPower, dot3EponObjects=dot3EponObjects, dot3MpcpStatEntry=dot3MpcpStatEntry, dot3OmpEmulationBadLLID=dot3OmpEmulationBadLLID, dot3ExtPkgOptIfSignalDetect=dot3ExtPkgOptIfSignalDetect, dot3ExtPkgControlTable=dot3ExtPkgControlTable, dot3ExtPkgQueueSetsTable=dot3ExtPkgQueueSetsTable, dot3OmpEmulationGoodLLID=dot3OmpEmulationGoodLLID, dot3MpcpLinkID=dot3MpcpLinkID, dot3MpcpTxGate=dot3MpcpTxGate, dot3OmpEmulationTable=dot3OmpEmulationTable, dot3OmpEmulationEntry=dot3OmpEmulationEntry, dot3ExtPkgOptIfTable=dot3ExtPkgOptIfTable, dot3MpcpRxGate=dot3MpcpRxGate, dot3MpcpRemoteMACAddress=dot3MpcpRemoteMACAddress, dot3OmpeCompliance=dot3OmpeCompliance, dot3ExtPkgObjects=dot3ExtPkgObjects, dot3ExtPkgOptIfUpperOutputPowerThreshold=dot3ExtPkgOptIfUpperOutputPowerThreshold, dot3EponFecAbility=dot3EponFecAbility, dot3EponFecUncorrectableBlocks=dot3EponFecUncorrectableBlocks, dot3ExtPkgGroupControl=dot3ExtPkgGroupControl, dot3MpcpOperStatus=dot3MpcpOperStatus, dot3OmpEmulationOnuLLIDNotBroadcast=dot3OmpEmulationOnuLLIDNotBroadcast, dot3MpcpGroupBase=dot3MpcpGroupBase, dot3ExtPkgObjectFecEnabled=dot3ExtPkgObjectFecEnabled, dot3ExtPkgOptIfEntry=dot3ExtPkgOptIfEntry, dot3ExtPkgOptIfLowerOutputPowerThreshold=dot3ExtPkgOptIfLowerOutputPowerThreshold, dot3ExtPkgObjectReportThreshold=dot3ExtPkgObjectReportThreshold, dot3MpcpRxReport=dot3MpcpRxReport, dot3OmpEmulationCRC8Errors=dot3OmpEmulationCRC8Errors, dot3ExtPkgQueueEntry=dot3ExtPkgQueueEntry, dot3ExtPkgStatDroppedFramesQueue=dot3ExtPkgStatDroppedFramesQueue, dot3OmpEmulationType=dot3OmpEmulationType, dot3OmpeGroupID=dot3OmpeGroupID, dot3MpcpTxRegister=dot3MpcpTxRegister, dot3MpcpRxRegRequest=dot3MpcpRxRegRequest, dot3ExtPkgOptIfLowOutputPower=dot3ExtPkgOptIfLowOutputPower)
