# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.api.v2010.account.sip.credential_list import CredentialListList
from twilio.rest.api.v2010.account.sip.domain import DomainList
from twilio.rest.api.v2010.account.sip.ip_access_control_list import IpAccessControlListList


class SipList(ListResource):
    """  """

    def __init__(self, version, account_sid):
        """
        Initialize the SipList

        :param Version version: Version that contains the resource
        :param account_sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.api.v2010.account.sip.SipList
        :rtype: twilio.rest.api.v2010.account.sip.SipList
        """
        super(SipList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid,}

        # Components
        self._domains = None
        self._regions = None
        self._ip_access_control_lists = None
        self._credential_lists = None

    @property
    def domains(self):
        """
        Access the domains

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainList
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainList
        """
        if self._domains is None:
            self._domains = DomainList(self._version, account_sid=self._solution['account_sid'],)
        return self._domains

    @property
    def ip_access_control_lists(self):
        """
        Access the ip_access_control_lists

        :returns: twilio.rest.api.v2010.account.sip.ip_access_control_list.IpAccessControlListList
        :rtype: twilio.rest.api.v2010.account.sip.ip_access_control_list.IpAccessControlListList
        """
        if self._ip_access_control_lists is None:
            self._ip_access_control_lists = IpAccessControlListList(
                self._version,
                account_sid=self._solution['account_sid'],
            )
        return self._ip_access_control_lists

    @property
    def credential_lists(self):
        """
        Access the credential_lists

        :returns: twilio.rest.api.v2010.account.sip.credential_list.CredentialListList
        :rtype: twilio.rest.api.v2010.account.sip.credential_list.CredentialListList
        """
        if self._credential_lists is None:
            self._credential_lists = CredentialListList(self._version, account_sid=self._solution['account_sid'],)
        return self._credential_lists

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.SipList>'


class SipPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the SipPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.api.v2010.account.sip.SipPage
        :rtype: twilio.rest.api.v2010.account.sip.SipPage
        """
        super(SipPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SipInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.sip.SipInstance
        :rtype: twilio.rest.api.v2010.account.sip.SipInstance
        """
        return SipInstance(self._version, payload, account_sid=self._solution['account_sid'],)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.SipPage>'


class SipInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, account_sid):
        """
        Initialize the SipInstance

        :returns: twilio.rest.api.v2010.account.sip.SipInstance
        :rtype: twilio.rest.api.v2010.account.sip.SipInstance
        """
        super(SipInstance, self).__init__(version)

        # Context
        self._context = None
        self._solution = {'account_sid': account_sid,}

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.SipInstance>'
