# - Find XML-Security-C
# Find the XML-Security-C includes and library
#
#  XMLSECURITYC_INCLUDE_DIR - Where to find xsec include sub-directory.
#  XMLSECURITYC_LIBRARIES   - List of libraries when using XML-Security-C.
#  XMLSECURITYC_FOUND       - True if XML-Security-C found.


IF (XMLSECURITYC_INCLUDE_DIR)
  # Already in cache, be silent.
  SET(XMLSECURITYC_FIND_QUIETLY TRUE)
ENDIF (XMLSECURITYC_INCLUDE_DIR)

FIND_PATH(XMLSECURITYC_INCLUDE_DIR xsec/utils/XSECPlatformUtils.hpp)

SET(XMLSECURITYC_NAMES xml-security-c xsec_1)
FIND_LIBRARY(XMLSECURITYC_LIBRARY NAMES ${XMLSECURITYC_NAMES} )

# Handle the QUIETLY and REQUIRED arguments and set XMLSECURITYC_FOUND to
# TRUE if all listed variables are TRUE.
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(XmlSecurityC DEFAULT_MSG XMLSECURITYC_LIBRARY XMLSECURITYC_INCLUDE_DIR)

IF(XMLSECURITYC_FOUND)
  SET( XMLSECURITYC_LIBRARIES ${XMLSECURITYC_LIBRARY} )
ELSE(XMLSECURITYC_FOUND)
  SET( XMLSECURITYC_LIBRARIES )
ENDIF(XMLSECURITYC_FOUND)

MARK_AS_ADVANCED( XMLSECURITYC_LIBRARY XMLSECURITYC_INCLUDE_DIR )
