% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-mdt.R
\name{run_mdt}
\alias{run_mdt}
\title{Multivariate Decision Trees (MDT)}
\usage{
run_mdt(
  mat,
  network,
  .source = source,
  .target = target,
  .mor = mor,
  .likelihood = likelihood,
  sparse = FALSE,
  center = FALSE,
  na.rm = FALSE,
  trees = 10,
  min_n = 20,
  nproc = availableCores(),
  seed = 42,
  minsize = 5
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}

\item{sparse}{Deprecated parameter.}

\item{center}{Logical value indicating if \code{mat} must be centered by
\code{\link[base:colSums]{base::rowMeans()}}.}

\item{na.rm}{Should missing values (including NaN) be omitted from the
calculations of \code{\link[base:colSums]{base::rowMeans()}}?}

\item{trees}{An integer for the number of trees contained in the ensemble.}

\item{min_n}{An integer for the minimum number of data points in a node that
are required for the node to be split further.}

\item{nproc}{Number of cores to use for computation.}

\item{seed}{A single value, interpreted as an integer, or NULL for random
number generation.}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
}
}
\description{
Calculates regulatory activities using MDT.
}
\details{
MDT fits a multivariate regression random forest for each sample, where the
observed molecular readouts in mat are the response variable and the
regulator weights in net are the covariates. Target features with no
associated weight are set to zero. The obtained feature importances from the
fitted model are the activities \code{mdt} of the regulators in net.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_mdt(mat, net, minsize=0)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_ulm}()},
\code{\link{run_viper}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
