% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getExpectations}
\alias{getExpectations}
\title{getExpectations}
\usage{
getExpectations(object, variable, as.data.frame = FALSE)
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{variable}{variable name: 'Z' for factors, 'W' for weights, 'Tau' for noise,
'Y' for pseudodata, 'Theta' for feature-wise spike-and-slab sparsity,
 'Alpha' for view and factor-wise ARD sparsity}

\item{as.data.frame}{logical indicating whether to output the result as a long data frame,
default is \code{FALSE}.}
}
\value{
the output varies depending on the variable of interest: \cr
\itemize{
 \item{"Z":} {a matrix with dimensions (samples,factors). 
 If \code{as.data.frame} is \code{TRUE}, a long-formatted data frame with columns (sample,factor,value)}
 \item{"W":} {a list of length (views) where each element is a matrix with dimensions (features,factors).
  If \code{as.data.frame} is \code{TRUE}, a long-formatted data frame with columns (view,feature,factor,value)}
 \item{"Y":} {a list of length (views) where each element is a matrix with dimensions (features,samples).
  If \code{as.data.frame} is \code{TRUE}, a long-formatted data frame with columns (view,feature,sample,value)}
 \item{"Theta":} {a list of length (views) where each element is a vector of containing the values for each factor}
 \item{"Alpha":} {a list of length (views) where each element is a vector of containing the values for each factor}
 \item{"Tau":} {a list of length (views) where each element is a matrix with dimensions (samples, features)}
}
}
\description{
Function to extract the expectations from the (variational) posterior
 distributions of a trained \code{\link{MOFAmodel}} object.
}
\details{
Technical note: MOFA is a Bayesian model where each variable has a prior distribution
 and a posterior distribution. In particular, to achieve scalability we used the 
 variational inference framework, thus true posterior distributions are replaced
  by approximated variational distributions.
This function extracts the expectations of the variational distributions, 
which can be used as final point estimates to analyse the results of the model. \cr 
The priors and variational distributions of each variable are extensively
 described in the supplementary methods of the original paper.
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
# get expectations of Alpha as matrix
getExpectations(MOFAobject, variable="Alpha")
}
