% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_total.R
\name{aw_total}
\alias{aw_total}
\title{Calculate Total Area}
\usage{
aw_total(.data, source, id, areaVar, totalVar, type, weight)
}
\arguments{
\item{.data}{A \code{sf} object that has been intersected using \link{aw_intersect}}

\item{source}{A \code{sf} object with data to be interpolated}

\item{id}{A unique identification number}

\item{areaVar}{The name of the variable measuring a feature's area, which is
created as part of \link{aw_intersect}}

\item{totalVar}{The name of a new total area field to be calculated}

\item{type}{One of \code{"intensive"} or \code{"extensive"}}

\item{weight}{One of \code{"sum"} or \code{"total"}}
}
\value{
A \code{sf} object with the intersected data and new total area field.
}
\description{
\code{aw_total} produces a new total area field that contains
    the total area by \code{source} id. This is the second step in the
    interpolation process after \link{aw_intersect}.
}
\examples{
library(dplyr)

race <- select(ar_stl_race, GEOID, TOTAL_E)
wards <- select(ar_stl_wards, WARD)

wards \%>\%
    aw_intersect(source = race, areaVar = "area") -> intersect

aw_total(intersect, source = race, id = GEOID, areaVar = "area",
         totalVar = "totalArea", weight = "sum", type = "extensive")

}
