\name{conserv}
\alias{conserv}
\title{ Score Residue Conservation At Each Position in an Alignment }
\description{
  Quantifies residue conservation in a given protein sequence alignment
  by calculating the degree of amino acid variability in each column of
  the alignment.
}
\usage{
conserv(x, method = c("similarity","identity","entropy22","entropy10"),
        sub.matrix = c("bio3d", "blosum62", "pam30", "other"),
        matrix.file = NULL, normalize.matrix = TRUE)
}
\arguments{
  \item{x}{ an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}}. }
  \item{method}{ the conservation assesment method. }
  \item{sub.matrix}{ a matrix to score conservation. }
  \item{matrix.file}{ a file name of an arbitary user matrix. }
  \item{normalize.matrix}{ logical, if TRUE the matrix is normalized
    pior to assesing conservation. }
}
\details{
  To assess the level of sequence conservation at each position in an
alignment, the \dQuote{similarity}, \dQuote{identity}, and
\dQuote{entropy} per position can be calculated.

The \dQuote{similarity} is defined as the average of the similarity
scores of all pairwise residue comparisons for that position in the
alignment, where the similarity score between any two residues is the
score value between those residues in the chosen substitution matrix
\dQuote{sub.matrix}.

The \dQuote{identity} i.e. the preference for a specific amino acid to
be found at a certain position, is assessed by averaging the identity
scores resulting from all possible pairwise comparisons at that position
in the alignment, where all identical residue comparisons are given a
score of 1 and all other comparisons are given a value of 0.

\dQuote{Entropy} is based on Shannons information entropy. See the
\code{\link{entropy}} function for further details.

Note that the returned scores are normalized so that conserved columns
score 1 and diverse columns score 0.
}
\value{
  Returns a numeric vector of scores
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
  Grant, B.J. et al. (2007) \emph{J. Mol. Biol.} \bold{368}, 1231--1248.
  
}
\author{ Barry Grant }
\note{
  Each of these conservation scores has particular strengths and
  weaknesses.  For example, entropy elegantly captures amino acid
  diversity but fails to account for stereochemical similarities. By
  employing a combination of scores and taking the union of their
  respective conservation signals we expect to achieve a more
  comprehensive analysis of sequence conservation (Grant, 2007).
}
\seealso{ \code{\link{read.fasta}}, \code{\link{read.fasta.pdb}} }
\examples{
## Read an example alignment
aln <- read.fasta(system.file("examples/hivp_xray.fa",package="bio3d"))

## Score conservation
conserv(x=aln$ali, method="similarity", sub.matrix="bio3d")
##conserv(x=aln$ali,method="entropy22", sub.matrix="other")

}
\keyword{ utilities }
