% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tohtml.R
\name{make_styles}
\alias{make_styles}
\title{Generate CSS Mapping Classes to Colors}
\usage{
make_styles(classes, rgb.mix = diag(3))
}
\arguments{
\item{classes}{a character vector of either 16, 32, or 512 class names.  The
character vectors are described in \code{\link{to_html}}.}

\item{rgb.mix}{3 x 3 numeric matrix to remix color channels.  Given a N x 3
matrix of numeric RGB colors \code{rgb}, the colors used in the style sheet will
be \code{rgb \%*\% rgb.mix}.  Out of range values are clipped to the nearest bound
of the range.}
}
\value{
A character vector that can be used as the contents of a style sheet.
}
\description{
Given a set of class names, produce the CSS that maps them to the default
8-bit colors.  This is a helper function to generate style sheets for use
in examples with either default or remixed \code{fansi} colors.  In practice users
will create their own style sheets mapping their classes to their preferred
styles.
}
\examples{
## Generate some class strings; order matters
classes <- do.call(paste, c(expand.grid(c("fg", "bg"), 0:7), sep="-"))
writeLines(classes[1:4])

## Some Default CSS
css0 <- "span {font-size: 60pt; padding: 10px; display: inline-block}"

## Associated class strings to styles
css1 <- make_styles(classes)
writeLines(css1[1:4])

## Generate SGR-derived HTML, mapping to classes
string <- "\033[43mYellow\033[m\n\033[45mMagenta\033[m\n\033[46mCyan\033[m"
html <- to_html(string, classes=classes)
writeLines(html)

## Combine in a page with styles and display in browser
\dontrun{
in_html(html, css=c(css0, css1))
}

## Change CSS by remixing colors, and apply to exact same HTML
mix <- matrix(
  c(
    0, 1, 0,  # red output is green input
    0, 0, 1,  # green output is blue input
    1, 0, 0   # blue output is red input
  ),
  nrow=3, byrow=TRUE
)
css2 <- make_styles(classes, rgb.mix=mix)
## Display in browser: same HTML but colors changed by CSS
\dontrun{
in_html(html, css=c(css0, css2))
}
}
\seealso{
Other HTML functions: 
\code{\link{html_esc}()},
\code{\link{in_html}()},
\code{\link{to_html}()}
}
\concept{HTML functions}
