% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvnmix.R
\name{mvnmix}
\alias{mvnmix}
\title{Estimate mixture latent variable model}
\usage{
mvnmix(data, k = 2, theta, steps = 500, tol = 1e-16, lambda = 0,
  mu = NULL, silent = TRUE, extra = FALSE, n.start = 1,
  init = "kmpp", ...)
}
\arguments{
\item{data}{\code{data.frame}}

\item{k}{Number of mixture components}

\item{theta}{Optional starting values}

\item{steps}{Maximum number of iterations}

\item{tol}{Convergence tolerance of EM algorithm}

\item{lambda}{Regularisation parameter. Added to diagonal of covariance matrix (to avoid
singularities)}

\item{mu}{Initial centres (if unspecified random centres will be chosen)}

\item{silent}{Turn on/off output messages}

\item{extra}{Extra debug information}

\item{n.start}{Number of restarts}

\item{init}{Function to choose initial centres}

\item{...}{Additional arguments parsed to lower-level functions}
}
\value{
A \code{mixture} object
}
\description{
Estimate mixture latent variable model
}
\details{
Estimate parameters in a mixture of latent variable models via the EM
algorithm.
}
\examples{

data(faithful)
set.seed(1)
M1 <- mvnmix(faithful[,"waiting",drop=FALSE],k=2)
M2 <- mvnmix(faithful,k=2)
if (interactive()) {
    par(mfrow=c(2,1))
    plot(M1,col=c("orange","blue"),ylim=c(0,0.05))
    plot(M2,col=c("orange","blue"))
}

}
\seealso{
\code{mixture}
}
\author{
Klaus K. Holst
}
\keyword{models}
\keyword{regression}
