% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subBoot.R
\name{subBoot}
\alias{subBoot}
\title{Bootstrap a subset of an lme4 model}
\usage{
subBoot(merMod, n = NULL, FUN, R = 100, seed = NULL, warn = FALSE)
}
\arguments{
\item{merMod}{a valid merMod object}

\item{n}{the number of rows to sample from the original data
in the merMod object, by default will resample the entire model frame}

\item{FUN}{the function to apply to each bootstrapped model}

\item{R}{the number of bootstrap replicates, default is 100}

\item{seed}{numeric, optional argument to set seed for simulations}

\item{warn}{logical, if TRUE, warnings from lmer will be issued, otherwise they will be suppressed
default is FALSE}
}
\value{
a data.frame of parameters extracted from each of the R replications.
The original values are appended to the top of the matrix.
}
\description{
Bootstrap a subset of an lme4 model
}
\details{
This function allows users to estimate parameters of a
large merMod object using bootstraps on a subset of the data.
}
\examples{
\donttest{
(fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy))
resultMatrix <- subBoot(fm1, n = 160, FUN = thetaExtract, R = 20)
}
}
